/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.gui;

import io.bioimage.modelrunner.bioimageio.BioimageioRepo;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptor;
import io.bioimage.modelrunner.bioimageio.description.ModelDescriptorFactory;
import io.bioimage.modelrunner.engine.installation.EngineInstall;
import io.bioimage.modelrunner.gui.ContentPanel;
import io.bioimage.modelrunner.gui.DefaultIcon;
import io.bioimage.modelrunner.gui.EnvironmentInstaller;
import io.bioimage.modelrunner.gui.GuiUtils;
import io.bioimage.modelrunner.gui.Header;
import io.bioimage.modelrunner.gui.Layout;
import io.bioimage.modelrunner.gui.ModelSelectionPanel;
import io.bioimage.modelrunner.gui.SearchBar;
import io.bioimage.modelrunner.gui.YesNoDialog;
import io.bioimage.modelrunner.gui.adapter.GuiAdapter;
import io.bioimage.modelrunner.gui.adapter.RunnerAdapter;
import io.bioimage.modelrunner.gui.workers.InstallEnvWorker;
import io.bioimage.modelrunner.tensor.Tensor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class Gui
extends JPanel {
    private static final long serialVersionUID = 1081914206026104187L;
    private RunnerAdapter runner;
    private GuiAdapter guiAdapter;
    private int currentIndex = 1;
    private final String modelsDir;
    private final String enginesDir;
    private final Object lock = new Object();
    private int nParsedModels;
    Thread engineInstallThread;
    Thread trackEngineInstallThread;
    Thread dwnlThread;
    Thread runninThread;
    Thread finderThread;
    Thread updaterThread;
    Thread localModelsThread;
    private SearchBar searchBar;
    private ContentPanel contentPanel;
    private ModelSelectionPanel modelSelectionPanel;
    private Header titlePanel;
    private JPanel footerPanel;
    private JButton runButton;
    private JButton runOnTestButton;
    private JButton cancelButton;
    private Layout layout = Layout.createVertical(LAYOUT_WEIGHTS);
    private static final double FOOTER_VRATIO = 0.06;
    private static final double[] LAYOUT_WEIGHTS = new double[]{0.1, 0.05, 0.8, 0.05};
    protected static final String LOADING_STR = "loading...";
    protected static final String NOT_FOUND_STR = "no models found";
    protected static final String LOCAL_STR = "Local";
    protected static final String BIOIMAGEIO_STR = "Bioimage.io";
    protected static final String RUN_STR = "Run";
    protected static final String CANCEL_STR = "Cancel";
    protected static final String RUN_ON_TEST_STR = "Run on test";
    protected static final String INSTALL_STR = "Install model";
    private static final String MODELS_DEAFULT = "models";
    private static final String ENGINES_DEAFULT = "engines";
    private static final String INSTALL_INSTRUCTIONS_FORMAT = "No models found at: %s" + File.separator + "models<br><br>Please, install manually or download models from the Bioimage.io.<br><br>To download models from the Bioimage.io, click on the Bioimage.io button on the top right.";
    public static String INSTALL_INSTRUCTIONS = "No models found.<br><br>Please, install manually or download models from the Bioimage.io.<br><br>To download models from the Bioimage.io, click on the Bioimage.io button on the top right.";

    public Gui(GuiAdapter guiAdapter) {
        DefaultIcon.setIconPath(guiAdapter.getIconPath());
        INSTALL_INSTRUCTIONS = String.format(INSTALL_INSTRUCTIONS_FORMAT, guiAdapter.getSoftwareName());
        this.guiAdapter = guiAdapter;
        long tt = System.currentTimeMillis();
        this.modelsDir = guiAdapter.getModelsDir() != null ? guiAdapter.getModelsDir() : new File(MODELS_DEAFULT).getAbsolutePath();
        this.enginesDir = guiAdapter.getEnginesDir() != null ? guiAdapter.getEnginesDir() : new File(ENGINES_DEAFULT).getAbsolutePath();
        this.loadLocalModels();
        System.out.println("Model loading: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.installEnginesIfNeeded();
        System.out.println("Engines loading: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.setSize(800, 900);
        this.setLayout(this.layout);
        System.out.println("Set size: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initTitlePanel();
        System.out.println("Title panel: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initSearchBar();
        System.out.println("Search bar: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initMainContentPanel();
        System.out.println("Content panel: " + (System.currentTimeMillis() - tt));
        tt = System.currentTimeMillis();
        this.initFooterPanel();
        System.out.println("Footer: " + (System.currentTimeMillis() - tt));
        this.setVisible(true);
    }

    private void installEnginesIfNeeded() {
        SwingUtilities.invokeLater(() -> {
            this.searchBar.switchButton.setEnabled(false);
            this.runButton.setEnabled(false);
            this.runOnTestButton.setEnabled(false);
        });
        this.engineInstallThread = new Thread(() -> {
            EngineInstall installer = EngineInstall.createInstaller(this.enginesDir);
            installer.checkBasicEngineInstallation();
            while (this.titlePanel == null) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (installer.getMissingEngines().size() != 0) {
                this.titlePanel.setGUIStartInstallation();
                installer.setEngineInstalledConsumer(this.titlePanel.createStringConsumer());
                installer.setProgresConsumer(this.titlePanel.createProgressConsumer());
                try {
                    installer.basicEngineInstallation();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SwingUtilities.invokeLater(() -> {
                System.out.println("done");
                this.searchBar.switchButton.setEnabled(true);
                this.runButton.setEnabled(true);
                this.runOnTestButton.setEnabled(true);
            });
        });
        this.engineInstallThread.start();
    }

    private void loadLocalModels() {
        this.localModelsThread = new Thread(() -> {
            List<ModelDescriptor> models = ModelDescriptorFactory.getModelsAtLocalRepo(new File(this.modelsDir).getAbsolutePath());
            while (this.contentPanel == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setModels(models);
        });
        this.localModelsThread.start();
    }

    private void initTitlePanel() {
        this.titlePanel = new Header(this.guiAdapter.getSoftwareName(), this.guiAdapter.getSoftwareDescription(), this.getWidth(), this.getHeight());
        this.add((Component)this.titlePanel, this.layout.get(0));
    }

    private void initSearchBar() {
        this.searchBar = new SearchBar(this.getWidth(), this.getHeight());
        this.add((Component)this.searchBar, this.layout.get(1));
        this.searchBar.switchButton.addActionListener(ee -> this.switchBtnClicked());
        this.searchBar.searchButton.addActionListener(ee -> this.searchModels());
        this.searchBar.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Gui.this.searchModels();
                }
            }
        });
    }

    private void initMainContentPanel() {
        JPanel mainContentPanel = new JPanel();
        Layout mainPanelLayout = Layout.createVertical(new double[]{0.45, 0.55});
        mainContentPanel.setLayout(mainPanelLayout);
        mainContentPanel.setBackground(Color.WHITE);
        this.modelSelectionPanel = new ModelSelectionPanel(this.getWidth(), this.getHeight());
        mainContentPanel.add((Component)this.modelSelectionPanel, mainPanelLayout.get(0));
        this.contentPanel = new ContentPanel(this.getWidth(), this.getHeight());
        mainContentPanel.add((Component)this.contentPanel, mainPanelLayout.get(1));
        this.add((Component)mainContentPanel, this.layout.get(2));
        this.modelSelectionPanel.prevButton.addActionListener(e -> this.updateCarousel(-1));
        this.modelSelectionPanel.nextButton.addActionListener(e -> this.updateCarousel(1));
    }

    private void initFooterPanel() {
        this.footerPanel = new JPanel(new BorderLayout());
        this.footerPanel.setBackground(new Color(45, 62, 80));
        this.footerPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.footerPanel.setPreferredSize(new Dimension(this.getWidth(), (int)((double)this.getHeight() * 0.06)));
        JPanel runButtonPanel = new JPanel(new FlowLayout(1, 20, 0));
        runButtonPanel.setBackground(new Color(45, 62, 80));
        this.runOnTestButton = new JButton(RUN_ON_TEST_STR);
        this.runOnTestButton.addActionListener(e -> this.runTestOrInstall());
        this.runButton = new JButton(RUN_STR);
        this.runButton.addActionListener(e -> this.runModel());
        this.cancelButton = new JButton(CANCEL_STR);
        this.cancelButton.addActionListener(e -> this.cancel());
        this.styleButton(this.runOnTestButton, "blue");
        this.styleButton(this.runButton, "blue");
        this.styleButton(this.cancelButton, "red");
        runButtonPanel.add(this.cancelButton);
        runButtonPanel.add(this.runOnTestButton);
        runButtonPanel.add(this.runButton);
        JLabel copyrightLabel = new JLabel("\u00a9 2024 " + this.guiAdapter.getSoftwareName() + " and JDLL");
        copyrightLabel.setFont(new Font("SansSerif", 0, 12));
        copyrightLabel.setForeground(Color.WHITE);
        this.footerPanel.add((Component)runButtonPanel, "East");
        this.footerPanel.add((Component)copyrightLabel, "West");
        this.add((Component)this.footerPanel, this.layout.get(3));
    }

    private void cancel() {
        this.onClose();
    }

    private <T extends RealType<T> & NativeType<T>> void runModel() {
        SwingUtilities.invokeLater(() -> this.contentPanel.setProgressIndeterminate(true));
        this.runninThread = new Thread(() -> {
            try {
                if (this.runner == null || this.runner.isClosed()) {
                    SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Loading model..."));
                    this.runner = this.guiAdapter.createRunner(this.modelSelectionPanel.getModels().get(this.currentIndex));
                }
                if (!this.runner.isLoaded() && GuiUtils.isEDTAlive()) {
                    this.runner.load();
                } else if (!GuiUtils.isEDTAlive()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Running the model..."));
                List list = this.guiAdapter.getInputTensors(this.runner.getDescriptor());
                List outs = this.runner.run(list);
                for (Tensor tt : outs) {
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    this.guiAdapter.displayRai(tt.getData(), tt.getAxesOrderString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SwingUtilities.invokeLater(() -> {
                this.contentPanel.setProgressLabelText("");
                this.contentPanel.setProgressIndeterminate(false);
            });
        });
        this.runninThread.start();
    }

    private void runTestOrInstall() {
        if (this.runOnTestButton.getText().equals(INSTALL_STR)) {
            this.installSelectedModel();
        } else if (this.runOnTestButton.getText().equals(RUN_ON_TEST_STR)) {
            this.runModelOnTestImage();
        }
    }

    private <T extends RealType<T> & NativeType<T>> void runModelOnTestImage() {
        SwingUtilities.invokeLater(() -> this.contentPanel.setProgressIndeterminate(true));
        this.runninThread = new Thread(() -> {
            try {
                if (this.runner == null || this.runner.isClosed()) {
                    SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Loading model..."));
                    this.runner = this.guiAdapter.createRunner(this.modelSelectionPanel.getModels().get(this.currentIndex));
                }
                if (!this.runner.isLoaded() && GuiUtils.isEDTAlive()) {
                    this.runner.load();
                } else if (!GuiUtils.isEDTAlive()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.contentPanel.setProgressLabelText("Running the model..."));
                List outs = this.runner.runOnTestImages();
                for (Tensor tt : outs) {
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    if (!GuiUtils.isEDTAlive()) {
                        return;
                    }
                    this.guiAdapter.displayRai(tt.getData(), tt.getAxesOrderString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SwingUtilities.invokeLater(() -> {
                this.contentPanel.setProgressLabelText("");
                this.contentPanel.setProgressIndeterminate(false);
            });
        });
        this.runninThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCarousel(int direction) {
        this.closeModelWhenChanging();
        Object object = this.lock;
        synchronized (object) {
            this.currentIndex = this.getWrappedIndex(this.currentIndex + direction);
            this.updateProgressBar();
            this.modelSelectionPanel.redrawModelCards(this.currentIndex);
            int logoHeight = (int)((double)this.getHeight() * 0.3);
            int logoWidth = this.getWidth() / 3;
            URL coverPath = this.modelSelectionPanel.getCoverPaths().get(this.currentIndex);
            this.contentPanel.update(this.modelSelectionPanel.getModels().get(this.currentIndex), coverPath, logoWidth, logoHeight);
        }
    }

    private void updateProgressBar() {
        if (this.modelSelectionPanel.getModels().get(this.currentIndex) == null) {
            return;
        }
        if (this.searchBar.isBarOnLocal() && this.contentPanel.getProgress() != 0) {
            this.contentPanel.setProgressBarText("");
            this.contentPanel.setDeterminatePorgress(0);
        } else if (!this.searchBar.isBarOnLocal() && this.contentPanel.getProgress() != 100 && this.modelSelectionPanel.getModels().get(this.currentIndex).isModelInLocalRepo()) {
            this.contentPanel.setProgressBarText("100%");
            this.contentPanel.setDeterminatePorgress(100);
        } else if (!this.searchBar.isBarOnLocal() && this.contentPanel.getProgress() != 0 && !this.modelSelectionPanel.getModels().get(this.currentIndex).isModelInLocalRepo()) {
            this.contentPanel.setProgressBarText("");
            this.contentPanel.setDeterminatePorgress(0);
        }
        if (this.searchBar.isBarOnLocal() || !this.searchBar.isBarOnLocal() && !this.modelSelectionPanel.getModels().get(this.currentIndex).isModelInLocalRepo() && !this.contentPanel.getProgressBarText().equals("")) {
            this.contentPanel.setProgressBarText("");
        }
    }

    private int getWrappedIndex(int index) {
        int size = this.modelSelectionPanel.getModelNames().size();
        return (index % size + size) % size;
    }

    private void styleButton(JButton button, String color) {
        button.setFont(new Font("SansSerif", 1, 14));
        if (color.equals("red")) {
            button.setBackground(new Color(255, 20, 20));
        } else {
            button.setBackground(new Color(52, 152, 219));
        }
        button.setForeground(Color.WHITE);
        button.setFocusPainted(false);
        button.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
    }

    public void setModels(List<ModelDescriptor> models) {
        if (models.size() == 0) {
            models = Gui.createArrayOfNulls(1);
        }
        this.modelSelectionPanel.setNotFound();
        this.searchBar.setModels(models);
        this.setModelsInGui(models);
    }

    protected void setModelsInGui(List<ModelDescriptor> models) {
        this.currentIndex = 0;
        this.modelSelectionPanel.setModels(models);
        int logoHeight = (int)((double)this.getHeight() * 0.3);
        int logoWidth = this.getWidth() / 3;
        URL coverPath = this.modelSelectionPanel.getCoverPaths().get(this.currentIndex);
        this.contentPanel.update(this.modelSelectionPanel.getModels().get(this.currentIndex), coverPath, logoWidth, logoHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModelInGuiAt(ModelDescriptor model, int pos) {
        this.modelSelectionPanel.setModelAt(model, pos);
        Object object = this.lock;
        synchronized (object) {
            if (this.currentIndex == pos || this.currentIndex == pos + 1 || this.currentIndex == pos - 1 || this.getWrappedIndex(pos + 1) == this.currentIndex) {
                SwingUtilities.invokeLater(() -> this.updateCarousel(0));
            }
        }
    }

    private void searchModels() {
        List<ModelDescriptor> models = this.searchBar.performSearch();
        if (models.size() == 0) {
            this.modelSelectionPanel.setNotFound();
            models = Gui.createArrayOfNulls(1);
        }
        this.setModelsInGui(models);
    }

    protected void switchBtnClicked() {
        this.closeModelWhenChanging();
        if (this.searchBar.isBarOnLocal()) {
            this.clickedBMZ();
        } else {
            this.clickedLocal();
        }
    }

    private void closeModelWhenChanging() {
        if (this.runner != null && !this.runner.isClosed()) {
            try {
                this.runner.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void clickedBMZ() {
        ArrayList<ModelDescriptor> newModels = Gui.createArrayOfNulls(3);
        this.searchBar.setBarEnabled(false);
        this.searchBar.changeButtonToLocal();
        this.contentPanel.setProgressIndeterminate(true);
        this.contentPanel.setProgressBarText("");
        this.runButton.setVisible(false);
        this.runOnTestButton.setText(INSTALL_STR);
        this.runOnTestButton.setEnabled(false);
        this.modelSelectionPanel.setBMZBorder();
        this.contentPanel.setProgressLabelText("Looking for models at Bioimage.io");
        this.setModelsInGui(newModels);
        ArrayList<ModelDescriptor> oldModels = new ArrayList<ModelDescriptor>(this.searchBar.getBMZModels());
        this.finderThread = new Thread(() -> {
            try {
                this.searchBar.countBMZModels(true);
                this.searchBar.findBMZModels();
            }
            catch (InterruptedException e) {
                return;
            }
        });
        this.updaterThread = new Thread(() -> {
            try {
                this.nParsedModels = 0;
                while (oldModels.equals(this.searchBar.getBMZModels()) && this.finderThread.isAlive()) {
                    Thread.sleep(100L);
                }
                ArrayList<ModelDescriptor> modelsList = Gui.createArrayOfNulls(this.searchBar.countBMZModels(false));
                if (this.finderThread.isAlive()) {
                    SwingUtilities.invokeLater(() -> this.setModelsInGui(modelsList));
                }
                while (this.finderThread.isAlive()) {
                    Thread.sleep(100L);
                    ArrayList<ModelDescriptor> foundModels = new ArrayList<ModelDescriptor>(this.searchBar.getBMZModels());
                    if (foundModels.size() < this.nParsedModels + 5) continue;
                    for (int i = this.nParsedModels; i < foundModels.size(); ++i) {
                        this.setModelInGuiAt((ModelDescriptor)foundModels.get(i), i);
                    }
                    this.nParsedModels = foundModels.size();
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
            List<ModelDescriptor> foundModels = this.searchBar.getBMZModels();
            for (int i = this.nParsedModels; i < foundModels.size(); ++i) {
                int j = 0 + i;
                SwingUtilities.invokeLater(() -> this.setModelInGuiAt((ModelDescriptor)foundModels.get(j), j));
            }
            SwingUtilities.invokeLater(() -> {
                this.contentPanel.setProgressIndeterminate(false);
                this.searchBar.setBarEnabled(true);
                this.runOnTestButton.setEnabled(true);
                this.contentPanel.setProgressLabelText("");
            });
        });
        this.finderThread.start();
        this.updaterThread.start();
    }

    private static ArrayList<ModelDescriptor> createArrayOfNulls(int n) {
        ArrayList<ModelDescriptor> newModels = new ArrayList<ModelDescriptor>();
        for (int i = 0; i < n; ++i) {
            newModels.add(null);
        }
        return newModels;
    }

    protected void clickedLocal() {
        this.modelSelectionPanel.setLoading();
        ArrayList<ModelDescriptor> newModels = Gui.createArrayOfNulls(3);
        this.searchBar.setBarEnabled(false);
        this.searchBar.changeButtonToBMZ();
        this.contentPanel.setProgressIndeterminate(true);
        this.contentPanel.setProgressBarText("");
        this.contentPanel.setProgressLabelText("Looking for models locally");
        this.runButton.setVisible(true);
        this.runButton.setEnabled(false);
        this.runOnTestButton.setText(RUN_ON_TEST_STR);
        this.runOnTestButton.setEnabled(false);
        this.modelSelectionPanel.setLocalBorder();
        this.modelSelectionPanel.setArrowsEnabled(false);
        this.setModelsInGui(newModels);
        Thread finderThread = new Thread(() -> this.searchBar.findLocalModels(new File(this.modelsDir).getAbsolutePath()));
        Thread updaterThread = new Thread(() -> {
            List<ModelDescriptor> foundModels;
            while (finderThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
                foundModels = new ArrayList<ModelDescriptor>(this.searchBar.getBMZModels());
                if (foundModels.size() <= 0) continue;
                SwingUtilities.invokeLater(() -> this.setModelsInGui(foundModels));
            }
            foundModels = this.searchBar.getBMZModels();
            SwingUtilities.invokeLater(() -> {
                if (foundModels.size() > 0) {
                    this.setModelsInGui(foundModels);
                }
                this.contentPanel.setProgressIndeterminate(false);
                this.contentPanel.setDeterminatePorgress(0);
                this.contentPanel.setProgressBarText("");
                this.contentPanel.setProgressLabelText("");
                this.searchBar.setBarEnabled(true);
                this.runOnTestButton.setEnabled(true);
                this.modelSelectionPanel.setArrowsEnabled(true);
                this.runButton.setEnabled(true);
            });
        });
        finderThread.start();
        updaterThread.start();
    }

    private void startModelInstallation(boolean isStarting) {
        SwingUtilities.invokeLater(() -> {
            this.runOnTestButton.setEnabled(!isStarting);
            this.searchBar.setBarEnabled(!isStarting);
            this.modelSelectionPanel.setArrowsEnabled(!isStarting);
            if (isStarting) {
                this.contentPanel.setProgressLabelText("Installing ...");
            } else {
                this.contentPanel.setProgressLabelText("");
            }
        });
    }

    private void checkModelInstallationFinished(CountDownLatch latch) {
        if (latch.getCount() == 0L) {
            this.startModelInstallation(false);
        }
    }

    private void installSelectedModel() {
        ModelDescriptor selectedModel = this.modelSelectionPanel.getModels().get(this.currentIndex);
        Consumer<Double> progress = c -> SwingUtilities.invokeLater(() -> this.contentPanel.setDeterminatePorgress((int)(c * 100.0)));
        this.startModelInstallation(true);
        CountDownLatch latch = new CountDownLatch(2);
        this.dwnlThread = new Thread(() -> {
            try {
                String modelFolder = BioimageioRepo.downloadModel(selectedModel, new File(this.modelsDir).getAbsolutePath(), progress);
                selectedModel.addModelPath(Paths.get(modelFolder, new String[0]));
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
            latch.countDown();
            this.checkModelInstallationFinished(latch);
        });
        this.dwnlThread.start();
        this.installEnv(selectedModel, latch);
    }

    private void installEnv(ModelDescriptor descriptor, CountDownLatch latch) {
        String msg = "Installation of Python environments might take up to 20 minutes.";
        String question = String.format("Install %s Python", descriptor.getModelFamily());
        if (descriptor.areRequirementsInstalled() || !YesNoDialog.askQuestion(question, msg)) {
            latch.countDown();
            this.checkModelInstallationFinished(latch);
            return;
        }
        JDialog installerFrame = new JDialog();
        installerFrame.setTitle("Installing " + descriptor.getName());
        installerFrame.setDefaultCloseOperation(0);
        Runnable callback = () -> {
            this.checkModelInstallationFinished(latch);
            if (installerFrame.isVisible()) {
                installerFrame.dispose();
            }
        };
        InstallEnvWorker worker = new InstallEnvWorker(descriptor, latch, callback);
        EnvironmentInstaller installerPanel = EnvironmentInstaller.create(worker);
        worker.execute();
        installerPanel.addToFrame(installerFrame);
        installerFrame.setSize(600, 300);
    }

    public void onClose() {
        DefaultIcon.closeThreads();
        if (this.dwnlThread != null && this.dwnlThread.isAlive()) {
            this.dwnlThread.interrupt();
        }
        if (this.engineInstallThread != null && this.engineInstallThread.isAlive()) {
            this.engineInstallThread.interrupt();
        }
        if (this.trackEngineInstallThread != null && this.trackEngineInstallThread.isAlive()) {
            this.trackEngineInstallThread.interrupt();
        }
        if (this.finderThread != null && this.finderThread.isAlive()) {
            this.finderThread.interrupt();
        }
        if (this.updaterThread != null && this.updaterThread.isAlive()) {
            this.updaterThread.interrupt();
        }
        if (this.runninThread != null && this.runner != null) {
            try {
                this.runner.close();
                this.runner = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.runninThread != null && this.runninThread.isAlive()) {
            this.runninThread.interrupt();
        }
    }
}

