/*
 * Decompiled with CFR 0.152.
 */
package io.bioimage.modelrunner.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YAMLUtils {
    public static Map<String, Object> load(String yamlFile) throws FileNotFoundException, IOException {
        File initialFile = new File(yamlFile);
        try (FileInputStream targetStream = new FileInputStream(initialFile);){
            Map obj;
            Yaml yaml = new Yaml();
            Map map = obj = (Map)yaml.load((InputStream)targetStream);
            return map;
        }
    }

    public static Map<String, Object> loadFromString(String yamlString) {
        Yaml yaml = new Yaml();
        HashMap yamlElements = (HashMap)yaml.load(yamlString);
        return yamlElements;
    }

    public static String[] castListToStringArray(List<?> list) {
        String[] array = new String[list.size()];
        int c = 0;
        for (Object in : list) {
            array[c++] = (String)in;
        }
        return array;
    }

    public static int[] castListToIntArray(List<?> list) {
        int[] array = new int[list.size()];
        int c = 0;
        for (Object in : list) {
            array[c++] = Integer.parseInt(in.toString());
        }
        return array;
    }

    public static double[] castListToDoubleArray(List<?> list) {
        try {
            double[] array = new double[list.size()];
            int c = 0;
            for (Object in : list) {
                array[c++] = Double.parseDouble(in.toString());
            }
            return array;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static float[] castListToFloatArray(List<?> list) {
        try {
            float[] array = new float[list.size()];
            int c = 0;
            for (Object in : list) {
                if (in instanceof String) {
                    array[c++] = Float.parseFloat((String)in);
                    continue;
                }
                if (in instanceof Integer) {
                    array[c++] = ((Integer)in).floatValue();
                    continue;
                }
                if (in instanceof Double) {
                    array[c++] = ((Double)in).floatValue();
                    continue;
                }
                if (in instanceof Float) {
                    array[c++] = ((Float)in).floatValue();
                    continue;
                }
                if (in instanceof Long) {
                    array[c++] = ((Long)in).floatValue();
                    continue;
                }
                if (in instanceof Number) {
                    array[c++] = ((Number)in).floatValue();
                    continue;
                }
                if (in instanceof Byte) {
                    array[c++] = ((Byte)in).floatValue();
                    continue;
                }
                throw new IllegalArgumentException("Unsupported type for list of Objects:" + in.getClass());
            }
            return array;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static void writeYamlFile(String filePath, Object data) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        Yaml yaml = new Yaml(options);
        try (FileWriter writer = new FileWriter(filePath);){
            yaml.dump(data, (Writer)writer);
        }
    }
}

