/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.math.UnitUtil;
import icy.roi.ROI;
import icy.roi.ROI3D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.util.StringUtil;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;

public class ROIVolumeDescriptor
extends ROIDescriptor {
    public static final String ID = "Volume";

    public ROIVolumeDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public String getUnit(Sequence sequence) {
        if (sequence != null) {
            return String.valueOf(sequence.getBestPixelSizeUnit(3, 3).toString()) + "m3";
        }
        return String.valueOf(UnitUtil.UnitPrefix.MICRO.toString()) + "m3";
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        SequenceEvent.SequenceEventSourceType sourceType = change.getSourceType();
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            return true;
        }
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_META) {
            String metaName = (String)change.getSource();
            return StringUtil.isEmpty(metaName) || StringUtil.equals(metaName, "pixelSizeX") || StringUtil.equals(metaName, "pixelSizeY") || StringUtil.equals(metaName, "pixelSizeZ");
        }
        return false;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIVolumeDescriptor.computeVolume(roi, sequence);
    }

    public static double computeVolume(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIVolumeDescriptor.computeVolume(ROIInteriorDescriptor.computeInterior(roi), roi, sequence);
    }

    public static double computeVolume(double interiorPoints, ROI roi, Sequence sequence) throws UnsupportedOperationException {
        if (!(roi instanceof ROI3D)) {
            throw new UnsupportedOperationException("Can't process Volume calculation for on " + roi.getDimension() + "D ROI: '" + roi.getName() + "'");
        }
        if (sequence == null) {
            throw new UnsupportedOperationException("Can't process Volume calculation with null Sequence parameter !");
        }
        return ROIInteriorDescriptor.computeInterior(interiorPoints, roi, sequence, 3);
    }
}

