/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.MathUtil;
import icy.util.StringUtil;
import java.util.concurrent.TimeUnit;

public class UnitUtil {
    public static final char MICRO_CHAR = 'u';
    public static final String MICRO_STRING = "u";

    public static String getBytesString(double value) {
        double absValue = Math.abs(value);
        if (absValue > 5.24288E11) {
            return String.valueOf(Double.toString(MathUtil.round(value / 1.024E12, 1))) + " TB";
        }
        if (absValue > 5.24288E8) {
            return String.valueOf(Double.toString(MathUtil.round(value / 1.024E9, 1))) + " GB";
        }
        if (absValue > 524288.0) {
            return String.valueOf(Double.toString(MathUtil.round(value / 1024000.0, 1))) + " MB";
        }
        if (absValue > 512.0) {
            return String.valueOf(Double.toString(MathUtil.round(value / 1024.0, 1))) + " KB";
        }
        return String.valueOf(Double.toString(MathUtil.round(value, 1))) + " B";
    }

    public static UnitPrefix getBestUnit(double value, UnitPrefix currentUnit, int dimension) {
        if (value == 0.0) {
            return currentUnit;
        }
        int typeInd = currentUnit.ordinal();
        double v = value;
        int maxInd = UnitPrefix.values().length - 1;
        double factor = Math.pow(1000.0, dimension);
        double midFactor = Math.pow(100.0, dimension);
        while ((int)v == 0 && typeInd < maxInd) {
            v *= factor;
            ++typeInd;
        }
        while ((int)(v / midFactor) != 0 && typeInd > 0) {
            v /= factor;
            --typeInd;
        }
        return UnitPrefix.values()[typeInd];
    }

    public static UnitPrefix getBestUnit(double value, UnitPrefix currentUnit) {
        return UnitUtil.getBestUnit(value, currentUnit, 1);
    }

    public static double getValueInUnit(double value, UnitPrefix currentUnit, UnitPrefix wantedUnit, int dimension) {
        int currentOrdinal = currentUnit.ordinal();
        int wantedOrdinal = wantedUnit.ordinal();
        double result = value;
        double factor = Math.pow(1000.0, dimension);
        while (currentOrdinal < wantedOrdinal) {
            result *= factor;
            ++currentOrdinal;
        }
        while (currentOrdinal > wantedOrdinal) {
            result /= factor;
            --currentOrdinal;
        }
        return result;
    }

    public static double getValueInUnit(double value, UnitPrefix currentUnit, UnitPrefix wantedUnit) {
        return UnitUtil.getValueInUnit(value, currentUnit, wantedUnit, 1);
    }

    public static String getBestUnitInMeters(double value, int decimals, UnitPrefix currentUnit) {
        UnitPrefix unitPxSize = UnitUtil.getBestUnit(value, currentUnit);
        double distanceMeters = UnitUtil.getValueInUnit(value, currentUnit, unitPxSize);
        return String.valueOf(StringUtil.toString(distanceMeters, decimals)) + (Object)((Object)unitPxSize) + "m";
    }

    public static TimeUnit getBestTimeUnit(double valueInMs) {
        if (valueInMs % 1000.0 != 0.0) {
            return TimeUnit.MILLISECONDS;
        }
        if (valueInMs % 60000.0 != 0.0) {
            return TimeUnit.SECONDS;
        }
        if (valueInMs % 3600000.0 != 0.0) {
            return TimeUnit.MINUTES;
        }
        return TimeUnit.HOURS;
    }

    @Deprecated
    public static TimeUnit getBestUnit(double valueInMs) {
        return UnitUtil.getBestTimeUnit(valueInMs);
    }

    public static String displayTimeAsStringWithComma(double valueInMs, int precision, TimeUnit unit) {
        String result;
        double v = valueInMs;
        switch (unit) {
            case DAYS: {
                result = String.valueOf(StringUtil.toString(v /= 8.64E7, precision)) + " d";
                break;
            }
            case HOURS: {
                result = String.valueOf(StringUtil.toString(v /= 3600000.0, precision)) + " h";
                break;
            }
            default: {
                result = String.valueOf(StringUtil.toString(v /= 60000.0, precision)) + " min";
                break;
            }
            case SECONDS: {
                result = String.valueOf(StringUtil.toString(v /= 1000.0, precision)) + " sec";
                break;
            }
            case MILLISECONDS: {
                result = String.valueOf(StringUtil.toString(v, precision)) + " ms";
                break;
            }
            case NANOSECONDS: {
                result = String.valueOf(StringUtil.toString(v *= 1000.0, precision)) + " ns";
            }
        }
        return result;
    }

    public static String displayTimeAsStringWithComma(double valueInMs, int precision) {
        double v = Math.abs(valueInMs);
        if (v >= 8.64E7) {
            return UnitUtil.displayTimeAsStringWithComma(valueInMs, precision, TimeUnit.DAYS);
        }
        if (v >= 3600000.0) {
            return UnitUtil.displayTimeAsStringWithComma(valueInMs, precision, TimeUnit.HOURS);
        }
        if (v >= 60000.0) {
            return UnitUtil.displayTimeAsStringWithComma(valueInMs, precision, TimeUnit.MINUTES);
        }
        if (v >= 1000.0) {
            return UnitUtil.displayTimeAsStringWithComma(valueInMs, precision, TimeUnit.SECONDS);
        }
        if (v < 1.0) {
            return UnitUtil.displayTimeAsStringWithComma(valueInMs, precision, TimeUnit.MILLISECONDS);
        }
        return UnitUtil.displayTimeAsStringWithComma(valueInMs, precision, TimeUnit.NANOSECONDS);
    }

    public static String displayTimeAsStringWithUnits(double valueInMs, boolean displayZero) {
        String result = "";
        double v = Math.abs(valueInMs);
        if (v >= 8.64E7) {
            result = String.valueOf(result) + (int)(v / 8.64E7) + "d ";
            v %= 8.64E7;
        } else if (displayZero) {
            result = String.valueOf(result) + "0d ";
        }
        if (v >= 3600000.0) {
            result = String.valueOf(result) + (int)(v / 3600000.0) + "h ";
            v %= 3600000.0;
        } else if (displayZero) {
            result = String.valueOf(result) + "00h ";
        }
        if (v >= 60000.0) {
            result = String.valueOf(result) + (int)(v / 60000.0) + "min ";
            v %= 60000.0;
        } else if (displayZero) {
            result = String.valueOf(result) + "00min ";
        }
        if (v >= 1000.0) {
            result = String.valueOf(result) + (int)(v / 1000.0) + "sec ";
            v %= 1000.0;
        } else if (displayZero) {
            result = String.valueOf(result) + "00sec ";
        }
        if (v >= 0.0) {
            result = String.valueOf(result) + StringUtil.toString(v, 3) + "ms";
        } else if (displayZero) {
            result = String.valueOf(result) + "000ms";
        }
        return result;
    }

    public static enum UnitPrefix {
        PETA,
        TERA,
        GIGA,
        MEGA,
        KILO,
        NONE,
        MILLI,
        MICRO,
        NANO,
        PICO;


        public String toString() {
            switch (this) {
                case PETA: {
                    return "P";
                }
                case TERA: {
                    return "T";
                }
                case GIGA: {
                    return "G";
                }
                case MEGA: {
                    return "M";
                }
                case KILO: {
                    return "k";
                }
                case NONE: {
                    return "";
                }
                case MILLI: {
                    return "m";
                }
                case MICRO: {
                    return UnitUtil.MICRO_STRING;
                }
                case NANO: {
                    return "n";
                }
                case PICO: {
                    return "p";
                }
            }
            return "x";
        }
    }
}

