/*
 * Decompiled with CFR 0.152.
 */
package icy.type.dimension;

import icy.type.dimension.Dimension2D;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;

public abstract class Dimension3D
implements Cloneable {
    public abstract double getSizeX();

    public abstract double getSizeY();

    public abstract double getSizeZ();

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    public abstract void setSizeZ(double var1);

    public abstract void setSize(double var1, double var3, double var5);

    public void setSize(Dimension3D d) {
        this.setSize(d.getSizeX(), d.getSizeY(), d.getSizeZ());
    }

    public abstract boolean isInfiniteX();

    public abstract boolean isInfiniteY();

    public abstract boolean isInfiniteZ();

    public abstract Dimension2D toDimension2D();

    public Integer toInteger() {
        return new Integer((int)Math.ceil(this.getSizeX()), (int)Math.ceil(this.getSizeY()), (int)Math.ceil(this.getSizeZ()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dimension3D) {
            Dimension3D dim = (Dimension3D)obj;
            return this.getSizeX() == dim.getSizeX() && this.getSizeY() == dim.getSizeY() && this.getSizeZ() == dim.getSizeZ();
        }
        return super.equals(obj);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getSizeX() + "," + this.getSizeY() + "," + this.getSizeZ() + "]";
    }

    public static class Double
    extends Dimension3D {
        public double sizeX;
        public double sizeY;
        public double sizeZ;

        public Double(double sizeX, double sizeY, double sizeZ) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        public Double(double[] sizeXYZ) {
            int len = sizeXYZ.length;
            if (len > 0) {
                this.sizeX = sizeXYZ[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZ[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZ[2];
            }
        }

        public Double() {
            this(0.0, 0.0, 0.0);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = value;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension2D.Double(this.sizeX, this.sizeY);
        }
    }

    public static class Float
    extends Dimension3D {
        public float sizeX;
        public float sizeY;
        public float sizeZ;

        public Float(float sizeX, float sizeY, float sizeZ) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        public Float(float[] sizeXYZ) {
            int len = sizeXYZ.length;
            if (len > 0) {
                this.sizeX = sizeXYZ[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZ[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZ[2];
            }
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (float)value;
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ) {
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
            this.sizeZ = (float)sizeZ;
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension2D.Float(this.sizeX, this.sizeY);
        }
    }

    public static class Integer
    extends Dimension3D {
        public int sizeX;
        public int sizeY;
        public int sizeZ;

        public Integer(int sizeX, int sizeY, int sizeZ) {
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        public Integer(int[] sizeXYZ) {
            int len = sizeXYZ.length;
            if (len > 0) {
                this.sizeX = sizeXYZ[0];
            }
            if (len > 1) {
                this.sizeY = sizeXYZ[1];
            }
            if (len > 2) {
                this.sizeZ = sizeXYZ[2];
            }
        }

        public Integer() {
            this(0, 0, 0);
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (int)Math.ceil(value);
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (int)Math.ceil(value);
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (int)Math.ceil(value);
        }

        @Override
        public void setSize(double sizeX, double sizeY, double sizeZ) {
            this.sizeX = (int)Math.ceil(sizeX);
            this.sizeY = (int)Math.ceil(sizeY);
            this.sizeZ = (int)Math.ceil(sizeZ);
        }

        @Override
        public boolean isInfiniteX() {
            return this.getSizeX() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteY() {
            return this.getSizeY() == 2.147483647E9;
        }

        @Override
        public boolean isInfiniteZ() {
            return this.getSizeZ() == 2.147483647E9;
        }

        @Override
        public Dimension2D toDimension2D() {
            return new Dimension(this.sizeX, this.sizeY);
        }

        @Override
        public Integer toInteger() {
            return (Integer)this.clone();
        }
    }
}

