/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.scripteditor.scriptinghandlers.py;

import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.script.ScriptException;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTraceback;
import org.python.core.__builtin__;
import org.python.util.PythonInterpreter;
import plugins.tprovoost.scripteditor.scriptinghandlers.ScriptEngine;

public class PyScriptEngine
extends ScriptEngine {
    private static boolean initialized = false;
    private PythonInterpreter py;

    public PyScriptEngine() {
        if (!initialized) {
            PyScriptEngine.initializer();
            initialized = true;
        }
        PyStringMap dict = new PyStringMap();
        dict.__setitem__("__name__", (PyObject)new PyString("__main__"));
        PySystemState sys = new PySystemState();
        this.py = new PythonInterpreter((PyObject)dict, sys);
    }

    @Override
    public void eval(String s) throws ScriptException {
        for (String s2 : this.bindings.keySet()) {
            this.py.set(s2, this.bindings.get(s2));
        }
        this.py.setOut((Writer)this.getWriter());
        this.py.setErr((Writer)this.getErrorWriter());
        try {
            this.py.exec(s);
            PyStringMap locals = (PyStringMap)this.py.getLocals();
            Object[] values = locals.values().toArray();
            Object[] keys = locals.keys().toArray();
            this.bindings.clear();
            int i = 0;
            while (i < keys.length) {
                this.bindings.put((String)keys[i], values[i]);
                ++i;
            }
        }
        catch (PyException pe) {
            this.getErrorWriter().write(pe.toString());
            this.getErrorWriter().flush();
            throw PyScriptEngine.scriptException(pe);
        }
    }

    @Override
    public void evalFile(String s) throws ScriptException {
        for (String s2 : this.bindings.keySet()) {
            this.py.set(s2, this.bindings.get(s2));
        }
        this.py.setOut((Writer)this.getWriter());
        this.py.setErr((Writer)this.getErrorWriter());
        try {
            this.py.execfile(s);
            PyStringMap locals = (PyStringMap)this.py.getLocals();
            Object[] values = locals.values().toArray();
            Object[] keys = locals.keys().toArray();
            this.bindings.clear();
            int i = 0;
            while (i < keys.length) {
                this.bindings.put((String)keys[i], values[i]);
                ++i;
            }
        }
        catch (PyException pe) {
            this.getErrorWriter().write(pe.toString());
            this.getErrorWriter().flush();
            throw PyScriptEngine.scriptException(pe);
        }
    }

    public static void initializer() {
        Properties postProps = new Properties();
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("python.")) continue;
            postProps.put(name, System.getProperty(name));
        }
        PythonInterpreter.initialize((Properties)sysProps, (Properties)postProps, null);
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public void clear() {
        HashMap<String, Object> bindings = this.getBindings();
        for (String s : bindings.keySet()) {
            bindings.put(s, null);
            this.py.set(s, null);
        }
        this.py.cleanup();
    }

    @Override
    protected void putInRealEngine(String name, Object value) {
        this.py.set(name, value);
    }

    @Override
    protected void removeFromRealEngine(String name) {
        this.py.set(name, null);
    }

    public PythonInterpreter getPythonInterpreter() {
        return this.py;
    }

    public static ScriptException scriptException(PyException pye) {
        ScriptException se = null;
        try {
            pye.normalize();
            PyObject type = pye.type;
            PyObject value = pye.value;
            PyTraceback tb = pye.traceback;
            if (__builtin__.isinstance((PyObject)value, (PyObject)Py.SyntaxError)) {
                PyObject filename = value.__findattr__("filename");
                PyObject lineno = value.__findattr__("lineno");
                PyObject offset = value.__findattr__("offset");
                value = value.__findattr__("msg");
                se = new ScriptException(Py.formatException((PyObject)type, (PyObject)value), filename == null ? "<script>" : filename.toString(), lineno == null ? 0 : lineno.asInt(), offset == null ? 0 : offset.asInt());
            } else if (tb != null) {
                String filename = tb.tb_frame == null || tb.tb_frame.f_code == null ? null : tb.tb_frame.f_code.co_filename;
                se = new ScriptException(Py.formatException((PyObject)type, (PyObject)value), filename, tb.tb_lineno);
            } else {
                se = new ScriptException(Py.formatException((PyObject)type, (PyObject)value));
            }
            se.initCause(pye);
            return se;
        }
        catch (PyException ee) {
            se = new ScriptException((Exception)((Object)pye));
            return se;
        }
    }
}

