/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BMPReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.Timestamp;

public class FV1000Reader
extends FormatReader {
    public static final String FV1000_MAGIC_STRING_1 = "FileInformation";
    public static final String FV1000_MAGIC_STRING_2 = "Acquisition Parameters";
    public static final String[] OIB_SUFFIX = new String[]{"oib"};
    public static final String[] OIF_SUFFIX = new String[]{"oif"};
    public static final String[] FV1000_SUFFIXES = new String[]{"oib", "oif"};
    public static final String[] PREVIEWNAME_PREFIXES = new String[]{"IniFileName", "PtyFileNameReference"};
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int NUM_DIMENSIONS = 9;
    private static final int POINT = 2;
    private static final int LINE = 3;
    private static final int POLYLINE = 4;
    private static final int RECTANGLE = 5;
    private static final int CIRCLE = 6;
    private static final int ELLIPSE = 7;
    private static final int POLYGON = 8;
    private static final int FREE_SHAPE = 9;
    private static final int FREE_LINE = 10;
    private static final int GRID = 11;
    private static final int ARROW = 12;
    private static final int COLOR_BAR = 13;
    private static final int SCALE = 15;
    private static final String ROTATION = "rotate(%d %f %f)";
    private IniParser parser = new IniParser();
    private List<String> tiffs;
    private String thumbId;
    private BMPReader thumbReader;
    private List<String> usedFiles;
    private boolean isOIB;
    private Map<String, String> oibMapping;
    private String[] code;
    private String[] size;
    private Double[] pixelSize;
    private int imageDepth;
    private List<String> previewNames;
    private String pixelSizeX;
    private String pixelSizeY;
    private int validBits;
    private List<String> illuminations;
    private List<Double> wavelengths;
    private String pinholeSize;
    private String magnification;
    private String lensNA;
    private String objectiveName;
    private String workingDistance;
    private String creationDate;
    private List<ChannelData> channels;
    private List<String> lutNames = new ArrayList<String>();
    private Map<Integer, String> filenames = new HashMap<Integer, String>();
    private Map<Integer, String> roiFilenames = new HashMap<Integer, String>();
    private List<PlaneData> planes;
    private transient POIService poi;
    private short[][][] lut;
    private int lastChannel = 0;
    private double pixelSizeZ = 1.0;
    private double pixelSizeT = 1.0;
    private String ptyStart = null;
    private String ptyEnd = null;
    private String ptyPattern = null;
    private String line = null;
    private ArrayList<IFDList> ifds = new ArrayList();

    public FV1000Reader() {
        super("Olympus FV1000", new String[]{"oib", "oif", "pty", "lut"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "Single .oib file or one .oif file and a similarly-named directory containing .tif/.tiff files";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        RandomAccessInputStream plane = this.getPlane(this.getSeries(), 0);
        if (plane == null) {
            return super.getOptimalTileWidth();
        }
        try (RandomAccessInputStream p = plane;){
            TiffParser tp = new TiffParser(plane);
            IFD ifd = tp.getFirstIFD();
            int n = (int)ifd.getTileWidth();
            return n;
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", e);
            return super.getOptimalTileWidth();
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile width", e);
        }
        return super.getOptimalTileWidth();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        RandomAccessInputStream plane = this.getPlane(this.getSeries(), 0);
        if (plane == null) {
            return super.getOptimalTileHeight();
        }
        try (RandomAccessInputStream p = plane;){
            TiffParser tp = new TiffParser(plane);
            IFD ifd = tp.getFirstIFD();
            int n = (int)ifd.getTileLength();
            return n;
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", e);
            return super.getOptimalTileHeight();
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile height", e);
        }
        return super.getOptimalTileHeight();
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return FV1000Reader.checkSuffix(id, OIB_SUFFIX);
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (FV1000Reader.checkSuffix(name, FV1000_SUFFIXES)) {
            return true;
        }
        if (!open) {
            return false;
        }
        try {
            Location oif = new Location(this.findOIFFile(name));
            return oif.exists() && !oif.isDirectory() && FV1000Reader.checkSuffix(oif.getAbsolutePath(), "oif") && !FV1000Reader.checkSuffix(name, "bmp");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 1024;
        if (!FormatTools.validStream(stream, 1024, false)) {
            return false;
        }
        String s2 = DataTools.stripString(stream.readString(1024));
        return s2.indexOf(FV1000_MAGIC_STRING_1) >= 0 || s2.indexOf(FV1000_MAGIC_STRING_2) >= 0;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        if (FV1000Reader.checkSuffix(id, OIB_SUFFIX)) {
            return 2;
        }
        return 0;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null || !this.isIndexed() ? (short[][])null : this.lut[this.lastChannel];
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int nFiles = this.getSeries() == 0 ? this.tiffs.size() : this.previewNames.size();
        int image = no % (this.getImageCount() / nFiles);
        int file2 = no / (this.getImageCount() / nFiles);
        int[] coords = this.getZCTCoords(image);
        this.lastChannel = coords[1];
        RandomAccessInputStream plane = this.getPlane(this.getSeries(), no);
        if (plane == null) {
            return buf;
        }
        try (RandomAccessInputStream p = plane;){
            TiffParser tp = new TiffParser(plane);
            int index = this.getSeries() == 0 ? file2 : this.tiffs.size() + file2;
            IFDList ifdList = this.ifds.get(index);
            if (image >= ifdList.size()) {
                byte[] byArray = buf;
                return byArray;
            }
            IFD ifd = (IFD)ifdList.get(image);
            if ((long)this.getSizeY() != ifd.getImageLength()) {
                tp.getSamples(ifd, buf, x, this.getIndex(coords[0], 0, coords[2]), w, 1L);
            } else {
                tp.getSamples(ifd, buf, x, y, w, h2);
            }
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isOIB) {
            String[] stringArray;
            if (noPixels) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.currentId;
            }
            return stringArray;
        }
        ArrayList<String> files = new ArrayList<String>();
        if (this.usedFiles != null) {
            for (String file2 : this.usedFiles) {
                String f = file2.toLowerCase();
                if (f.endsWith(".tif") || f.endsWith(".tiff") || f.endsWith(".bmp") || files.contains(file2)) continue;
                files.add(file2);
            }
        }
        if (!noPixels) {
            if (this.getSeries() == 0 && this.tiffs != null) {
                files.addAll(this.tiffs);
            } else if (this.getSeries() == 1 && this.previewNames != null) {
                files.addAll(this.previewNames);
            }
        }
        return files.toArray(new String[0]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.thumbReader != null) {
            this.thumbReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.usedFiles = null;
            this.tiffs = null;
            this.filenames.clear();
            this.roiFilenames.clear();
            this.thumbReader = null;
            this.thumbId = null;
            this.isOIB = false;
            this.previewNames = null;
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.lastChannel = 0;
            this.wavelengths = null;
            this.illuminations = null;
            this.oibMapping = null;
            this.size = null;
            this.code = null;
            this.pixelSize = null;
            this.imageDepth = 0;
            this.pixelSizeY = null;
            this.pixelSizeX = null;
            this.validBits = 0;
            this.pinholeSize = null;
            this.workingDistance = null;
            this.objectiveName = null;
            this.lensNA = null;
            this.magnification = null;
            this.creationDate = null;
            this.lut = null;
            this.channels = null;
            this.planes = null;
            if (this.lutNames != null) {
                this.lutNames.clear();
            }
            this.ifds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String key;
        String[] saveKeys;
        super.initFile(id);
        this.parser.setCommentDelimiter(null);
        this.isOIB = FV1000Reader.checkSuffix(id, OIB_SUFFIX);
        if (this.isOIB) {
            this.initPOIService();
        }
        boolean mappedOIF = !this.isOIB && !new File(id).getAbsoluteFile().exists();
        this.wavelengths = new ArrayList<Double>();
        this.illuminations = new ArrayList<String>();
        this.channels = new ArrayList<ChannelData>();
        this.planes = new ArrayList<PlaneData>();
        String oifName = null;
        if (this.isOIB) {
            oifName = this.mapOIBFiles();
        } else {
            if (!FV1000Reader.checkSuffix(id, OIF_SUFFIX)) {
                this.currentId = this.findOIFFile(id);
                this.initFile(this.currentId);
            }
            oifName = this.currentId;
        }
        String oifPath = new Location(oifName).getAbsoluteFile().getAbsolutePath();
        if (mappedOIF) {
            oifPath = oifName.substring(0, oifName.lastIndexOf(File.separator) + 1);
        }
        String path = this.isOIB ? "" : oifPath.substring(0, oifPath.lastIndexOf(File.separator) + 1);
        try {
            RandomAccessInputStream s2 = this.getFile(oifName);
            s2.close();
        }
        catch (IOException e) {
            oifName = oifName.replaceAll(".oif", ".OIF");
        }
        this.code = new String[9];
        this.size = new String[9];
        this.pixelSize = new Double[9];
        this.previewNames = new ArrayList<String>();
        TreeMap<Integer, String> previewFileNames = new TreeMap<Integer, String>();
        boolean laserEnabled = true;
        IniList f = this.getIniFile(oifName);
        IniTable saveInfo = f.getTable("ProfileSaveInfo");
        for (String key2 : saveKeys = saveInfo.keySet().toArray(new String[saveInfo.size()])) {
            String value = ((String)saveInfo.get(key2)).toString();
            value = this.sanitizeValue(value).trim();
            if (key2.startsWith("IniFileName") && key2.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                this.filenames.put(Integer.parseInt(key2.substring(11)), value);
                continue;
            }
            if (key2.startsWith("RoiFileName") && key2.indexOf("Thumb") == -1 && !this.isPreviewName(value)) {
                try {
                    this.roiFilenames.put(Integer.parseInt(key2.substring(11)), value);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (key2.equals("PtyFileNameS")) {
                this.ptyStart = value;
                continue;
            }
            if (key2.equals("PtyFileNameE")) {
                this.ptyEnd = value;
                continue;
            }
            if (key2.equals("PtyFileNameT2")) {
                this.ptyPattern = value;
                continue;
            }
            if (key2.indexOf("Thumb") != -1) {
                if (this.thumbId != null) continue;
                this.thumbId = value.trim();
                continue;
            }
            if (key2.startsWith("LutFileName")) {
                this.lutNames.add(path + value);
                continue;
            }
            if (!this.isPreviewName(value)) continue;
            try {
                RandomAccessInputStream s3 = this.getFile(path + value.trim());
                if (s3 == null) continue;
                s3.close();
                Integer previewIndex = this.getPreviewNameIndex(key2);
                if (previewIndex != null) {
                    previewFileNames.put(previewIndex, path + value.trim());
                    continue;
                }
                this.previewNames.add(path + value.trim());
            }
            catch (FormatException e) {
                LOGGER.debug("Preview file not found", e);
            }
            catch (IOException e) {
                LOGGER.debug("Preview file not found", e);
            }
        }
        this.previewNames.addAll(previewFileNames.values());
        if (this.filenames.isEmpty()) {
            this.addPtyFiles();
        }
        for (int i = 0; i < 9; ++i) {
            IniTable commonParams = f.getTable("Axis " + i + " Parameters Common");
            this.code[i] = (String)commonParams.get("AxisCode");
            this.size[i] = (String)commonParams.get("MaxSize");
            double end = DataTools.parseDouble((String)commonParams.get("EndPosition"));
            double start = DataTools.parseDouble((String)commonParams.get("StartPosition"));
            this.pixelSize[i] = end - start;
        }
        IniTable referenceParams = f.getTable("Reference Image Parameter");
        this.imageDepth = Integer.parseInt((String)referenceParams.get("ImageDepth"));
        this.pixelSizeX = (String)referenceParams.get("WidthConvertValue");
        this.pixelSizeY = (String)referenceParams.get("HeightConvertValue");
        String ripValidBitCounts = (String)referenceParams.get("ValidBitCounts");
        if (ripValidBitCounts != null) {
            this.validBits = Integer.parseInt(ripValidBitCounts);
        }
        int index = 0;
        IniTable laser = f.getTable("Laser " + index + " Parameters");
        while (laser != null) {
            laserEnabled = ((String)laser.get("Laser Enable")).equals("1");
            if (laserEnabled) {
                this.wavelengths.add(DataTools.parseDouble((String)laser.get("LaserWavelength")));
            }
            this.creationDate = (String)laser.get("ImageCaputreDate");
            if (this.creationDate == null) {
                this.creationDate = (String)laser.get("ImageCaptureDate");
            }
            laser = f.getTable("Laser " + ++index + " Parameters");
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Object channel;
            index = 1;
            IniTable guiChannel = f.getTable("GUI Channel " + index + " Parameters");
            while (guiChannel != null) {
                channel = new ChannelData();
                ((ChannelData)channel).gain = DataTools.parseDouble((String)guiChannel.get("AnalogPMTGain"));
                ((ChannelData)channel).voltage = DataTools.parseDouble((String)guiChannel.get("AnalogPMTVoltage"));
                ((ChannelData)channel).barrierFilter = ((ChannelData)channel).getFilter((String)guiChannel.get("BF Name"));
                ((ChannelData)channel).active = Integer.parseInt((String)guiChannel.get("CH Activate")) != 0;
                ((ChannelData)channel).name = (String)guiChannel.get("CH Name");
                ((ChannelData)channel).dyeName = (String)guiChannel.get("DyeName");
                ((ChannelData)channel).emissionFilter = ((ChannelData)channel).getFilter((String)guiChannel.get("EmissionDM Name"));
                ((ChannelData)channel).emWave = DataTools.parseDouble((String)guiChannel.get("EmissionWavelength"));
                ((ChannelData)channel).excitationFilter = ((ChannelData)channel).getFilter((String)guiChannel.get("ExcitationDM Name"));
                ((ChannelData)channel).exWave = DataTools.parseDouble((String)guiChannel.get("ExcitationWavelength"));
                this.channels.add((ChannelData)channel);
                guiChannel = f.getTable("GUI Channel " + ++index + " Parameters");
            }
            index = 1;
            channel = f.getTable("Channel " + index + " Parameters");
            while (channel != null) {
                String illumination = (String)((HashMap)channel).get("LightType");
                if (illumination != null) {
                    illumination = illumination.toLowerCase();
                }
                if (illumination != null) {
                    illumination = illumination.indexOf("fluorescence") != -1 ? "Epifluorescence" : (illumination.indexOf("transmitted") != -1 ? "Transmitted" : null);
                }
                this.illuminations.add(illumination);
                channel = f.getTable("Channel " + ++index + " Parameters");
            }
            HashMap<String, String> iniMap = f.flattenIntoHashMap();
            this.metadata.putAll(iniMap);
        }
        LOGGER.info("Initializing helper readers");
        if (this.previewNames.size() > 0) {
            ArrayList<String> v = new ArrayList<String>();
            for (int i = 0; i < this.previewNames.size(); ++i) {
                String ss = this.previewNames.get(i);
                if (!(ss = this.replaceExtension(ss, "pty", "tif")).endsWith(".tif")) continue;
                v.add(ss);
            }
            this.previewNames = v;
            if (this.previewNames.size() > 0) {
                this.core.clear();
                this.core.add(new CoreMetadata());
                this.core.add(new CoreMetadata());
                ArrayList ifds = null;
                CoreMetadata ms1 = (CoreMetadata)this.core.get(1);
                for (String previewName : this.previewNames) {
                    try (RandomAccessInputStream preview = this.getFile(previewName);){
                        TiffParser tp = new TiffParser(preview);
                        ifds = tp.getMainIFDs();
                    }
                    ms1.imageCount += ifds.size();
                }
                ms1.sizeX = (int)((IFD)ifds.get(0)).getImageWidth();
                ms1.sizeY = (int)((IFD)ifds.get(0)).getImageLength();
                ms1.sizeZ = 1;
                ms1.sizeT = 1;
                ms1.sizeC = ms1.imageCount;
                ms1.rgb = false;
                int bits = ((IFD)ifds.get(0)).getBitsPerSample()[0];
                while (bits % 8 != 0) {
                    ++bits;
                }
                ms1.pixelType = FormatTools.pixelTypeFromBytes(bits /= 8, false, false);
                ms1.dimensionOrder = "XYCZT";
                ms1.indexed = false;
            }
        }
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.imageCount = this.filenames.size();
        this.tiffs = new ArrayList<String>(this.getImageCount());
        this.thumbReader = new BMPReader();
        if (this.thumbId != null) {
            this.thumbId = this.replaceExtension(this.thumbId, "pty", "bmp");
            this.thumbId = this.sanitizeFile(this.thumbId, path);
        }
        LOGGER.info("Reading additional metadata");
        String tiffPath = null;
        ms0.dimensionOrder = "XY";
        HashMap values = new HashMap();
        ArrayList<String> baseKeys = new ArrayList<String>();
        int i22 = 0;
        for (int ii = 0; ii < this.getImageCount(); ++ii) {
            block129: {
                IniTable axis;
                String file2;
                block130: {
                    Location ptyFile;
                    block127: {
                        Location tiffFile;
                        block128: {
                            file2 = this.filenames.get(i22);
                            while (file2 == null) {
                                file2 = this.filenames.get(++i22);
                            }
                            tiffPath = (file2 = this.sanitizeFile(file2, path)).indexOf(File.separator) != -1 ? file2.substring(0, file2.lastIndexOf(File.separator)) : file2;
                            ptyFile = new Location(file2);
                            if (this.isOIB || ptyFile.exists()) break block127;
                            LOGGER.warn("Could not find .pty file ({}); guessing at the corresponding TIFF file.", (Object)file2);
                            String tiff = this.replaceExtension(file2, "pty", "tif");
                            tiffFile = new Location(tiff);
                            if (!tiffFile.exists()) break block128;
                            this.tiffs.add(ii, tiffFile.getAbsolutePath());
                            break block129;
                        }
                        if (!tiffFile.getParentFile().exists()) {
                            String realOIFName = new Location(this.currentId).getName();
                            String basePath = tiffFile.getParentFile().getParent();
                            if (mappedOIF) {
                                tiffPath = basePath + File.separator + realOIFName + ".files";
                                ptyFile = new Location(tiffPath, ptyFile.getName());
                                file2 = ptyFile.getAbsolutePath();
                            } else {
                                Location newFile = new Location(basePath, realOIFName + ".files");
                                ptyFile = new Location(newFile, ptyFile.getName());
                                file2 = ptyFile.getAbsolutePath();
                                tiffPath = newFile.getAbsolutePath();
                            }
                        }
                        break block130;
                    }
                    if (!this.isOIB) {
                        file2 = ptyFile.getAbsolutePath();
                    }
                }
                IniList pty = this.getIniFile(file2);
                IniTable fileInfo = pty.getTable("File Info");
                file2 = this.sanitizeValue((String)fileInfo.get("DataName"));
                if (!this.isPreviewName(file2)) {
                    while (file2.indexOf("GST") != -1) {
                        file2 = this.removeGST(file2);
                    }
                    file2 = this.isOIB ? tiffPath + File.separator + file2 : new Location(tiffPath, file2).getAbsolutePath();
                    file2 = this.replaceExtension(file2, "pty", "tif");
                    this.tiffs.add(ii, file2);
                }
                PlaneData plane = new PlaneData();
                for (int dim = 0; dim < 9 && (axis = pty.getTable("Axis " + dim + " Parameters")) != null; ++dim) {
                    Double number;
                    boolean addAxis;
                    boolean bl = addAxis = Integer.parseInt((String)axis.get("Number")) > 1;
                    if (dim == 2) {
                        if (!addAxis || this.getDimensionOrder().indexOf(67) != -1) continue;
                        ms0.dimensionOrder = ms0.dimensionOrder + 'C';
                        continue;
                    }
                    if (dim == 3) {
                        if (addAxis && this.getDimensionOrder().indexOf(90) == -1) {
                            ms0.dimensionOrder = ms0.dimensionOrder + 'Z';
                        }
                        Double number2 = Double.valueOf((String)axis.get("AbsPositionValue"));
                        plane.positionZ = new Length(number2, UNITS.REFERENCEFRAME);
                        continue;
                    }
                    if (dim == 4) {
                        if (addAxis && this.getDimensionOrder().indexOf(84) == -1) {
                            ms0.dimensionOrder = ms0.dimensionOrder + 'T';
                        }
                        plane.deltaT = Double.parseDouble((String)axis.get("AbsPositionValue")) / 1000.0;
                        continue;
                    }
                    if (dim != 7) continue;
                    try {
                        String xPos = (String)axis.get("AbsPositionValueX");
                        if (xPos != null) {
                            number = Double.valueOf(xPos);
                            plane.positionX = new Length(number, UNITS.REFERENCEFRAME);
                        }
                    }
                    catch (NumberFormatException xPos) {
                        // empty catch block
                    }
                    try {
                        String yPos = (String)axis.get("AbsPositionValueY");
                        if (yPos == null) continue;
                        number = Double.valueOf(yPos);
                        plane.positionY = new Length(number, UNITS.REFERENCEFRAME);
                        continue;
                    }
                    catch (NumberFormatException yPos) {
                        // empty catch block
                    }
                }
                ms0.bitsPerPixel = this.validBits;
                this.planes.add(plane);
                IniTable acquisition = pty.getTable("Acquisition Parameters Common");
                if (acquisition != null) {
                    this.magnification = (String)acquisition.get("Magnification");
                    this.lensNA = (String)acquisition.get("ObjectiveLens NAValue");
                    this.objectiveName = (String)acquisition.get("ObjectiveLens Name");
                    this.workingDistance = (String)acquisition.get("ObjectiveLens WDValue");
                    this.pinholeSize = (String)acquisition.get("PinholeDiameter");
                    String validBitCounts = (String)acquisition.get("ValidBitCounts");
                    if (validBitCounts != null) {
                        ms0.bitsPerPixel = Integer.parseInt(validBitCounts);
                    }
                }
                if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                    for (IniTable table : pty) {
                        String[] keys;
                        for (String key3 : keys = table.keySet().toArray(new String[table.size()])) {
                            values.put("Image " + ii + " : " + key3, table.get(key3));
                            if (baseKeys.contains(key3)) continue;
                            baseKeys.add(key3);
                        }
                    }
                }
            }
            ++i22;
        }
        Iterator i22 = baseKeys.iterator();
        while (i22.hasNext() && !(key = (String)i22.next()).equals("DataName") && key.indexOf("FileName") < 0) {
            int i;
            boolean equal = true;
            String first = (String)values.get("Image 0 : " + key);
            for (i = 1; i < this.getImageCount(); ++i) {
                if (first.equals(values.get("Image " + i + " : " + key))) continue;
                equal = false;
                break;
            }
            if (equal) {
                this.addGlobalMeta(key, first);
                continue;
            }
            for (i = 0; i < this.getImageCount(); ++i) {
                String k = "Image " + i + " : " + key;
                this.addGlobalMeta(k, values.get(k));
            }
        }
        if (this.tiffs.size() != this.getImageCount()) {
            ms0.imageCount = this.tiffs.size();
        }
        this.usedFiles = new ArrayList<String>();
        if (tiffPath != null) {
            this.usedFiles.add(this.isOIB ? id : oifName);
            if (!this.isOIB) {
                Location dir = new Location(tiffPath);
                if (!mappedOIF && !dir.exists()) {
                    throw new FormatException("Required directory " + tiffPath + " was not found.");
                }
                String[] list = mappedOIF ? Location.getIdMap().keySet().toArray(new String[0]) : dir.list(true);
                for (int i = 0; i < list.length; ++i) {
                    if (mappedOIF) {
                        this.usedFiles.add(list[i]);
                        continue;
                    }
                    String p = new Location(tiffPath, list[i]).getAbsolutePath();
                    String check = p.toLowerCase();
                    if (!check.endsWith(".tif") && !check.endsWith(".pty") && !check.endsWith(".roi") && !check.endsWith(".lut") && !check.endsWith(".bmp")) continue;
                    this.usedFiles.add(p);
                }
            }
        }
        LOGGER.info("Populating metadata");
        int realChannels = 0;
        for (int i = 0; i < 9; ++i) {
            int ss = Integer.parseInt(this.size[i]);
            if (this.pixelSize[i] == null) {
                this.pixelSize[i] = 1.0;
            }
            if (this.code[i].equals("X")) {
                ms0.sizeX = ss;
                continue;
            }
            if (this.code[i].equals("Y") && ss > 1) {
                ms0.sizeY = ss;
                continue;
            }
            if (this.code[i].equals("Z")) {
                if (this.getSizeY() == 0) {
                    ms0.sizeY = ss;
                    continue;
                }
                ms0.sizeZ = ss;
                this.pixelSizeZ = Math.abs(this.pixelSize[i] / (double)(this.getSizeZ() - 1) / 1000.0);
                continue;
            }
            if (this.code[i].equals("T")) {
                if (this.getSizeY() == 0) {
                    ms0.sizeY = ss;
                    continue;
                }
                ms0.sizeT = ss;
                this.pixelSizeT = Math.abs(this.pixelSize[i] / (double)(this.getSizeT() - 1) / 1000.0);
                continue;
            }
            if (ss <= 0) continue;
            ms0.sizeC = this.getSizeC() == 0 ? ss : (ms0.sizeC *= ss);
            if (!this.code[i].equals("C")) continue;
            realChannels = ss;
        }
        if (this.getSizeZ() == 0) {
            ms0.sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            ms0.sizeT = 1;
        }
        if (this.getImageCount() == this.getSizeC() && this.getSizeY() == 1) {
            ms0.imageCount *= this.getSizeZ() * this.getSizeT();
        } else if (this.getImageCount() == this.getSizeC()) {
            ms0.sizeZ = 1;
            ms0.sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeT() * this.getSizeC() != this.getImageCount()) {
            int diff = this.getSizeZ() * this.getSizeC() * this.getSizeT() - this.getImageCount();
            if (diff == this.previewNames.size() || diff < 0) {
                diff /= this.getSizeC();
                if (this.getSizeT() > 1 && this.getSizeZ() == 1) {
                    ms0.sizeT -= diff;
                } else if (this.getSizeZ() > 1 && this.getSizeT() == 1) {
                    ms0.sizeZ -= diff;
                }
            } else {
                ms0.imageCount += diff;
            }
        }
        if (this.getSizeC() > 1 && this.getSizeZ() == 1 && this.getSizeT() == 1 && this.getDimensionOrder().indexOf(67) == -1) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'C';
        }
        if (this.getDimensionOrder().indexOf(90) == -1) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'Z';
        }
        if (this.getDimensionOrder().indexOf(67) == -1) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'C';
        }
        if (this.getDimensionOrder().indexOf(84) == -1) {
            ms0.dimensionOrder = ms0.dimensionOrder + 'T';
        }
        ms0.pixelType = FormatTools.pixelTypeFromBytes(this.imageDepth, false, false);
        try {
            RandomAccessInputStream thumb = this.getFile(this.thumbId);
            byte[] b = new byte[(int)thumb.length()];
            thumb.read(b);
            thumb.close();
            Location.mapFile("thumbnail.bmp", new ByteArrayHandle(b));
            this.thumbReader.setId("thumbnail.bmp");
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                ((CoreMetadata)this.core.get((int)i)).thumbSizeX = this.thumbReader.getSizeX();
                ((CoreMetadata)this.core.get((int)i)).thumbSizeY = this.thumbReader.getSizeY();
            }
            this.thumbReader.close();
            Location.mapFile("thumbnail.bmp", null);
        }
        catch (IOException e) {
            LOGGER.debug("Could not read thumbnail", e);
        }
        catch (FormatException e) {
            LOGGER.debug("Could not read thumbnail", e);
        }
        this.lut = new short[this.getSizeC()][3][65536];
        byte[] buffer = new byte[262144];
        int count = Math.min(this.getSizeC(), this.lutNames.size());
        for (int c = 0; c < count; ++c) {
            Exception exc = null;
            try {
                RandomAccessInputStream stream = this.getFile(this.lutNames.get(c));
                stream.seek(stream.length() - 262144L);
                stream.read(buffer);
                stream.close();
                for (int q = 0; q < buffer.length; q += 4) {
                    this.lut[c][0][q / 4] = (short)((buffer[q + 2] & 0xFF) * 257);
                    this.lut[c][1][q / 4] = (short)((buffer[q + 1] & 0xFF) * 257);
                    this.lut[c][2][q / 4] = (short)((buffer[q] & 0xFF) * 257);
                }
            }
            catch (IOException e) {
                exc = e;
            }
            catch (FormatException e) {
                exc = e;
            }
            if (exc == null) continue;
            LOGGER.debug("Could not read LUT", exc);
            this.lut = null;
            break;
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.rgb = false;
            ms.littleEndian = true;
            ms.interleaved = false;
            ms.metadataComplete = true;
            ms.indexed = this.lut != null;
            ms.falseColor = true;
            int nFiles = i == 0 ? this.tiffs.size() : this.previewNames.size();
            for (int file3 = 0; file3 < nFiles; ++file3) {
                RandomAccessInputStream plane = this.getFile(i == 0 ? this.tiffs.get(file3) : this.previewNames.get(file3));
                if (plane == null) {
                    this.ifds.add(null);
                    continue;
                }
                try {
                    TiffParser tp = new TiffParser(plane);
                    IFDList ifd = tp.getMainIFDs();
                    this.ifds.add(ifd);
                    continue;
                }
                finally {
                    plane.close();
                }
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.creationDate != null) {
            this.creationDate = this.creationDate.replaceAll("'", "");
            this.creationDate = DateTools.formatDate(this.creationDate, DATE_FORMAT);
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            if (this.creationDate == null) continue;
            store.setImageAcquisitionDate(new Timestamp(this.creationDate), i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.populateMetadataStore(store, path);
        }
    }

    private void populateMetadataStore(MetadataStore store, String path) throws FormatException, IOException {
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            Length sizeZ;
            Double sizeY;
            Double sizeX;
            Length size;
            store.setImageInstrumentRef(instrumentID, i);
            if (this.pixelSizeX != null && (size = FormatTools.getPhysicalSizeX(sizeX = DataTools.parseDouble(this.pixelSizeX))) != null) {
                store.setPixelsPhysicalSizeX(size, i);
            }
            if (this.pixelSizeY != null && (size = FormatTools.getPhysicalSizeY(sizeY = DataTools.parseDouble(this.pixelSizeY))) != null) {
                store.setPixelsPhysicalSizeY(size, i);
            }
            if (this.pixelSizeZ == Double.NEGATIVE_INFINITY || this.pixelSizeZ == Double.POSITIVE_INFINITY || this.getSizeZ() == 1) {
                this.pixelSizeZ = 1.0;
            }
            if (this.pixelSizeT == Double.NEGATIVE_INFINITY || this.pixelSizeT == Double.POSITIVE_INFINITY || this.getSizeT() == 1) {
                this.pixelSizeT = 1.0;
            }
            if ((sizeZ = FormatTools.getPhysicalSizeZ(this.pixelSizeZ)) != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, i);
            }
            store.setPixelsTimeIncrement(new Time(this.pixelSizeT, UNITS.SECOND), i);
            for (int p = 0; p < ((CoreMetadata)this.core.get((int)i)).imageCount; ++p) {
                store.setPlaneDeltaT(new Time(this.pixelSizeT * (double)p, UNITS.SECOND), i, p);
            }
            for (int c = 0; c < ((CoreMetadata)this.core.get((int)i)).sizeC; ++c) {
                if (c >= this.illuminations.size()) continue;
                store.setChannelIlluminationType(MetadataTools.getIlluminationType(this.illuminations.get(c)), i, c);
            }
        }
        int channelIndex = 0;
        int filterIndex = 0;
        for (ChannelData channel : this.channels) {
            Length wave;
            if (!channel.active) continue;
            if (channelIndex >= this.getEffectiveSizeC()) break;
            String detectorID = MetadataTools.createLSID("Detector", 0, channelIndex);
            store.setDetectorID(detectorID, 0, channelIndex);
            store.setDetectorSettingsID(detectorID, 0, channelIndex);
            store.setDetectorGain(channel.gain, 0, channelIndex);
            ElectricPotential theVoltage = FormatTools.createElectricPotential(channel.voltage, UNITS.VOLT);
            if (theVoltage != null) {
                store.setDetectorVoltage(theVoltage, 0, channelIndex);
            }
            store.setDetectorType(MetadataTools.getDetectorType("PMT"), 0, channelIndex);
            store.setChannelName(channel.name, 0, channelIndex);
            String lightSourceID = MetadataTools.createLSID("LightSource", 0, channelIndex);
            store.setChannelLightSourceSettingsID(lightSourceID, 0, channelIndex);
            Length wavelength = FormatTools.getWavelength(channel.exWave);
            Length emission = FormatTools.getEmissionWavelength(channel.emWave);
            Length excitation = FormatTools.getExcitationWavelength(channel.exWave);
            if (emission != null) {
                store.setChannelEmissionWavelength(emission, 0, channelIndex);
            }
            if (excitation != null) {
                store.setChannelExcitationWavelength(excitation, 0, channelIndex);
            }
            if (wavelength != null) {
                store.setChannelLightSourceSettingsWavelength(wavelength, 0, channelIndex);
            }
            if (channel.barrierFilter != null) {
                String filterID = MetadataTools.createLSID("Filter", 0, filterIndex);
                store.setFilterID(filterID, 0, filterIndex);
                store.setFilterModel(channel.barrierFilter, 0, filterIndex);
                if (channel.barrierFilter.indexOf(45) != -1) {
                    String[] emValues = channel.barrierFilter.split("-");
                    for (int i = 0; i < emValues.length; ++i) {
                        emValues[i] = emValues[i].replaceAll("\\D", "");
                    }
                    try {
                        Double cutIn = DataTools.parseDouble(emValues[0]);
                        Double cutOut = DataTools.parseDouble(emValues[1]);
                        Length in = FormatTools.getCutIn(cutIn);
                        Length out = FormatTools.getCutOut(cutOut);
                        if (in != null) {
                            store.setTransmittanceRangeCutIn(in, 0, filterIndex);
                        }
                        if (out != null) {
                            store.setTransmittanceRangeCutOut(out, 0, filterIndex);
                        }
                    }
                    catch (NumberFormatException cutIn) {
                        // empty catch block
                    }
                }
                store.setLightPathEmissionFilterRef(filterID, 0, channelIndex, 0);
                ++filterIndex;
            }
            int emIndex = channelIndex * 2;
            int exIndex = channelIndex * 2 + 1;
            String emFilter = MetadataTools.createLSID("Dichroic", 0, emIndex);
            String exFilter = MetadataTools.createLSID("Dichroic", 0, exIndex);
            store.setDichroicID(emFilter, 0, emIndex);
            store.setDichroicModel(channel.emissionFilter, 0, emIndex);
            store.setDichroicID(exFilter, 0, exIndex);
            store.setDichroicModel(channel.excitationFilter, 0, exIndex);
            store.setLightPathDichroicRef(exFilter, 0, channelIndex);
            store.setLaserID(lightSourceID, 0, channelIndex);
            store.setLaserLaserMedium(MetadataTools.getLaserMedium(channel.dyeName), 0, channelIndex);
            if (channelIndex < this.wavelengths.size() && (wave = FormatTools.getWavelength(this.wavelengths.get(channelIndex))) != null) {
                store.setLaserWavelength(wave, 0, channelIndex);
            }
            store.setLaserType(MetadataTools.getLaserType("Other"), 0, channelIndex);
            ++channelIndex;
        }
        if (this.lensNA != null) {
            store.setObjectiveLensNA(DataTools.parseDouble(this.lensNA), 0, 0);
        }
        store.setObjectiveModel(this.objectiveName, 0, 0);
        if (this.magnification != null) {
            Double mag = Double.parseDouble(this.magnification);
            store.setObjectiveNominalMagnification(mag, 0, 0);
        }
        if (this.workingDistance != null) {
            store.setObjectiveWorkingDistance(new Length(DataTools.parseDouble(this.workingDistance), UNITS.MICROMETER), 0, 0);
        }
        store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
        store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        store.setObjectiveSettingsID(objectiveID, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.NO_OVERLAYS) {
            int nextROI = -1;
            for (int i = 0; i < this.roiFilenames.size() && i < this.getImageCount(); ++i) {
                String filename = this.roiFilenames.get(i);
                filename = this.sanitizeFile(filename, path);
                nextROI = this.parseROIFile(filename, store, nextROI, i);
            }
        }
        for (int i = 0; i < this.planes.size(); ++i) {
            PlaneData plane = this.planes.get(i);
            if (plane.deltaT != null) {
                store.setPlaneDeltaT(new Time(plane.deltaT, UNITS.SECOND), 0, i);
            }
            store.setPlanePositionX(plane.positionX, 0, i);
            store.setPlanePositionY(plane.positionY, 0, i);
            store.setPlanePositionZ(plane.positionZ, 0, i);
        }
    }

    private int parseROIFile(String filename, MetadataStore store, int nextROI, int plane) throws FormatException, IOException {
        int[] coordinates = this.getZCTCoords(plane);
        IniList roiFile = null;
        try {
            roiFile = this.getIniFile(filename);
        }
        catch (FormatException e) {
            LOGGER.debug("Could not parse ROI file {}", (Object)filename, (Object)e);
            return nextROI;
        }
        catch (IOException e) {
            LOGGER.debug("Could not parse ROI file {}", (Object)filename, (Object)e);
            return nextROI;
        }
        boolean validROI = false;
        int shape = -1;
        int shapeType = -1;
        String[] xc = null;
        String[] yc = null;
        int divide = 0;
        int fontSize = 0;
        int lineWidth = 0;
        int angle = 0;
        String fontName = null;
        String name = null;
        for (IniTable table : roiFile) {
            int height;
            String tableName = (String)table.get("header");
            if (tableName.equals("ROIBase FileInformation")) {
                try {
                    String roiName = ((String)table.get("Name")).replaceAll("\"", "");
                    validROI = Integer.parseInt(roiName) > 1;
                }
                catch (NumberFormatException e) {
                    validROI = false;
                }
                if (validROI) continue;
                continue;
            }
            if (!tableName.equals("ROIBase Body")) continue;
            shapeType = Integer.parseInt((String)table.get("SHAPE"));
            divide = Integer.parseInt((String)table.get("DIVIDE"));
            String[] fontAttributes = ((String)table.get("FONT")).split(",");
            fontName = fontAttributes[0];
            fontSize = Integer.parseInt(fontAttributes[1]);
            Length font = FormatTools.getFontSize(fontSize);
            lineWidth = Integer.parseInt((String)table.get("LINEWIDTH"));
            name = (String)table.get("NAME");
            angle = Integer.parseInt((String)table.get("ANGLE"));
            xc = ((String)table.get("X")).split(",");
            yc = ((String)table.get("Y")).split(",");
            int x = Integer.parseInt(xc[0]);
            int width = xc.length > 1 ? Integer.parseInt(xc[1]) - x : 0;
            int y = Integer.parseInt(yc[0]);
            int n = height = yc.length > 1 ? Integer.parseInt(yc[1]) - y : 0;
            if (width + x > this.getSizeX() || height + y > this.getSizeY()) continue;
            Integer zIndex = coordinates[0];
            Integer tIndex = coordinates[2];
            if (++shape == 0) {
                ++nextROI;
                if (shapeType == 2 || shapeType == 11 || shapeType == 5 || shapeType == 3 || shapeType == 6 || shapeType == 7 || shapeType == 8 || shapeType == 9 || shapeType == 4 || shapeType == 10) {
                    String roiID = MetadataTools.createLSID("ROI", nextROI);
                    store.setROIID(roiID, nextROI);
                    store.setImageROIRef(roiID, 0, nextROI);
                }
            }
            String shapeID = MetadataTools.createLSID("Shape", nextROI--, shape);
            if (shapeType == 2) {
                store.setPointID(shapeID, nextROI, shape);
                store.setPointTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setPointTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                if (font != null) {
                    store.setPointFontSize(font, nextROI, shape);
                }
                Length l = new Length(lineWidth, UNITS.PIXEL);
                store.setPointStrokeWidth(l, nextROI, shape);
                store.setPointX(DataTools.parseDouble(xc[0]), nextROI, shape);
                store.setPointY(DataTools.parseDouble(yc[0]), nextROI, shape);
                continue;
            }
            if (shapeType == 11 || shapeType == 5) {
                if (shapeType == 5) {
                    divide = 1;
                }
                width /= divide;
                height /= divide;
                for (int row = 0; row < divide; ++row) {
                    for (int col = 0; col < divide; ++col) {
                        double realX = x + col * width;
                        double realY = y + row * height;
                        shapeID = MetadataTools.createLSID("Shape", nextROI, shape);
                        store.setRectangleID(shapeID, nextROI, shape);
                        store.setRectangleX(realX, nextROI, shape);
                        store.setRectangleY(realY, nextROI, shape);
                        store.setRectangleWidth(Double.valueOf(width), nextROI, shape);
                        store.setRectangleHeight(Double.valueOf(height), nextROI, shape);
                        store.setRectangleTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                        store.setRectangleTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                        if (font != null) {
                            store.setRectangleFontSize(font, nextROI, shape);
                        }
                        Length l = new Length(lineWidth, UNITS.PIXEL);
                        store.setRectangleStrokeWidth(l, nextROI, shape);
                        double centerX = realX + (double)(width / 2);
                        double centerY = realY + (double)(height / 2);
                        store.setRectangleTransform(this.getRotationTransform(angle), nextROI, shape);
                        if (row >= divide - 1 && col >= divide - 1) continue;
                        ++shape;
                    }
                }
                continue;
            }
            if (shapeType == 3) {
                store.setLineID(shapeID, nextROI, shape);
                store.setLineX1(Double.valueOf(x), nextROI, shape);
                store.setLineY1(Double.valueOf(y), nextROI, shape);
                store.setLineX2(Double.valueOf(x + width), nextROI, shape);
                store.setLineY2(Double.valueOf(y + height), nextROI, shape);
                store.setLineTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setLineTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                if (font != null) {
                    store.setLineFontSize(font, nextROI, shape);
                }
                Length l = new Length(lineWidth, UNITS.PIXEL);
                store.setLineStrokeWidth(l, nextROI, shape);
                int centerX = x + width / 2;
                int centerY = y + height / 2;
                store.setLineTransform(this.getRotationTransform(angle), nextROI, shape);
                continue;
            }
            if (shapeType == 6 || shapeType == 7) {
                double rx = width / 2;
                double ry = shapeType == 6 ? rx : (double)(height / 2);
                store.setEllipseID(shapeID, nextROI, shape);
                store.setEllipseX((double)x + rx, nextROI, shape);
                store.setEllipseY((double)y + ry, nextROI, shape);
                store.setEllipseRadiusX(rx, nextROI, shape);
                store.setEllipseRadiusY(ry, nextROI, shape);
                store.setEllipseTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setEllipseTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                if (font != null) {
                    store.setEllipseFontSize(font, nextROI, shape);
                }
                Length l = new Length(lineWidth, UNITS.PIXEL);
                store.setEllipseStrokeWidth(l, nextROI, shape);
                store.setEllipseTransform(this.getRotationTransform(angle), nextROI, shape);
                continue;
            }
            if (shapeType == 8 || shapeType == 9 || shapeType == 4 || shapeType == 10) {
                Length l;
                StringBuilder points = new StringBuilder();
                for (int point = 0; point < xc.length; ++point) {
                    points.append(xc[point]);
                    points.append(",");
                    points.append(yc[point]);
                    if (point >= xc.length - 1) continue;
                    points.append(" ");
                }
                if (shapeType == 4 || shapeType == 10) {
                    store.setPolylineID(shapeID, nextROI, shape);
                    store.setPolylinePoints(points.toString(), nextROI, shape);
                    store.setPolylineTransform(this.getRotationTransform(angle), nextROI, shape);
                    store.setPolylineTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                    store.setPolylineTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                    if (font != null) {
                        store.setPolylineFontSize(font, nextROI, shape);
                    }
                    l = new Length(lineWidth, UNITS.PIXEL);
                    store.setPolylineStrokeWidth(l, nextROI, shape);
                    continue;
                }
                store.setPolygonID(shapeID, nextROI, shape);
                store.setPolygonPoints(points.toString(), nextROI, shape);
                store.setPolygonTransform(this.getRotationTransform(angle), nextROI, shape);
                store.setPolygonTheZ(new NonNegativeInteger(zIndex), nextROI, shape);
                store.setPolygonTheT(new NonNegativeInteger(tIndex), nextROI, shape);
                if (font != null) {
                    store.setPolygonFontSize(font, nextROI, shape);
                }
                l = new Length(lineWidth, UNITS.PIXEL);
                store.setPolygonStrokeWidth(l, nextROI, shape);
                continue;
            }
            if (shape == 0) {
                // empty if block
            }
            --shape;
        }
        return nextROI;
    }

    private void addPtyFiles() throws FormatException {
        if (this.ptyStart != null && this.ptyEnd != null) {
            if (this.ptyPattern == null) {
                String dir = this.ptyStart.substring(0, this.ptyStart.indexOf(File.separator) + 1);
                this.ptyPattern = dir + "s_C%03dT%03d.pty";
            }
            String[] prefixes = this.ptyPattern.split("%03d");
            int[] first = FV1000Reader.scanFormat(this.ptyPattern, this.ptyStart);
            int[] last = FV1000Reader.scanFormat(this.ptyPattern, this.ptyEnd);
            int[] lengths = new int[prefixes.length - 1];
            int totalFiles = 1;
            for (int i = 0; i < first.length; ++i) {
                lengths[i] = last[i] - first[i] + 1;
                totalFiles *= lengths[i];
            }
            for (int file2 = 0; file2 < totalFiles; ++file2) {
                int[] pos = FormatTools.rasterToPosition(lengths, file2);
                StringBuilder pty = new StringBuilder();
                for (int block = 0; block < prefixes.length; ++block) {
                    pty.append(prefixes[block]);
                    if (block >= pos.length) continue;
                    String num = String.valueOf(pos[block] + 1);
                    for (int q = 0; q < 3 - num.length(); ++q) {
                        pty.append("0");
                    }
                    pty.append(num);
                }
                this.filenames.put(file2, pty.toString());
            }
        }
    }

    private String findOIFFile(String baseFile) throws FormatException {
        Location current = new Location(baseFile).getAbsoluteFile();
        String parent = current.getParent();
        Location tmp = new Location(parent).getParentFile();
        parent = tmp.getAbsolutePath();
        baseFile = current.getName();
        if (baseFile == null || baseFile.indexOf(95) == -1) {
            return null;
        }
        baseFile = baseFile.substring(0, baseFile.lastIndexOf("_"));
        if (FV1000Reader.checkSuffix(current.getName(), new String[]{"roi", "lut"}) && !new Location(tmp, baseFile + ".oif").exists() && !new Location(tmp, baseFile + ".OIF").exists() && baseFile.indexOf(95) >= 0) {
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("_"));
        }
        baseFile = baseFile + ".oif";
        tmp = new Location(tmp, baseFile);
        String oifFile = tmp.getAbsolutePath();
        if (!tmp.exists() && !(tmp = new Location(oifFile = oifFile.substring(0, oifFile.lastIndexOf(".")) + ".OIF")).exists()) {
            baseFile = current.getParent();
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("."));
            baseFile = baseFile.substring(0, baseFile.lastIndexOf("."));
            tmp = new Location(baseFile + ".oif");
            oifFile = tmp.getAbsolutePath();
            if (!tmp.exists()) {
                tmp = new Location(tmp.getParent(), tmp.getName().toUpperCase());
                oifFile = tmp.getAbsolutePath();
                if (!tmp.exists()) {
                    if (parent.endsWith(File.separator)) {
                        parent = parent.substring(0, parent.length() - 1);
                    }
                    String dir = parent.substring(parent.lastIndexOf(File.separator));
                    tmp = new Location(parent);
                    oifFile = new Location(tmp, dir = dir.substring(0, dir.lastIndexOf("."))).getAbsolutePath();
                    if (!new Location(oifFile).exists()) {
                        throw new FormatException("OIF file not found");
                    }
                }
            }
        }
        return oifFile;
    }

    private String mapOIBFiles() throws FormatException, IOException {
        String oifName = null;
        String infoFile = null;
        Vector<String> list = this.poi.getDocumentList();
        for (String name : list) {
            if (!name.endsWith("OibInfo.txt")) continue;
            infoFile = name;
            break;
        }
        if (infoFile == null) {
            throw new FormatException("OibInfo.txt not found in " + this.currentId);
        }
        RandomAccessInputStream ras = this.poi.getDocumentStream(infoFile);
        this.oibMapping = new HashMap<String, String>();
        String s2 = DataTools.stripString(ras.readString((int)ras.length()));
        ras.close();
        Object[] lines = s2.split("\n");
        Arrays.sort(lines);
        String directoryKey = null;
        String directoryValue = null;
        String key = null;
        String value = null;
        for (Object line : lines) {
            if (((String)(line = ((String)line).trim())).indexOf(61) == -1) continue;
            key = ((String)line).substring(0, ((String)line).indexOf(61));
            value = ((String)line).substring(((String)line).indexOf(61) + 1);
            if (directoryKey != null && directoryValue != null) {
                value = value.replaceAll(directoryKey, directoryValue);
            }
            value = this.removeGST(value);
            if (key.startsWith("Stream")) {
                if (FV1000Reader.checkSuffix(value = this.sanitizeFile(value, ""), OIF_SUFFIX)) {
                    oifName = value;
                }
                if (directoryKey != null && value.startsWith(directoryValue)) {
                    this.oibMapping.put(value, "Root Entry" + File.separator + directoryKey + File.separator + key);
                    continue;
                }
                this.oibMapping.put(value, "Root Entry" + File.separator + key);
                continue;
            }
            if (!key.startsWith("Storage")) continue;
            directoryKey = key;
            directoryValue = value;
        }
        s2 = null;
        return oifName;
    }

    private String sanitizeValue(String value) {
        String f = value.replaceAll("\"", "");
        f = f.replace('\\', File.separatorChar);
        f = f.replace('/', File.separatorChar);
        while (f.indexOf("GST") != -1) {
            f = this.removeGST(f);
        }
        return f;
    }

    private String sanitizeFile(String file2, String path) {
        String f = this.sanitizeValue(file2);
        if (path.equals("")) {
            return f;
        }
        if (path.endsWith(File.separator)) {
            return path + f;
        }
        return path + File.separator + f;
    }

    private String removeGST(String s2) {
        if (s2.indexOf("GST") != -1) {
            String first = s2.substring(0, s2.indexOf("GST"));
            int ndx = s2.indexOf(File.separator) < s2.indexOf("GST") ? s2.length() : s2.indexOf(File.separator);
            String last = s2.substring(s2.lastIndexOf("=", ndx) + 1);
            return first + last;
        }
        return s2;
    }

    private void initPOIService() throws FormatException, IOException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(this.getCurrentFile()));
    }

    private RandomAccessInputStream getFile(String name) throws FormatException, IOException {
        if (this.isOIB) {
            if (this.poi == null) {
                this.initPOIService();
            }
            name = name.replace('\\', File.separatorChar);
            String realName = this.oibMapping.get(name = name.replace('/', File.separatorChar));
            if (realName == null) {
                throw new FormatException("File " + name + " not found.");
            }
            return this.poi.getDocumentStream(realName);
        }
        return new RandomAccessInputStream(name, 16);
    }

    private RandomAccessInputStream getPlane(int seriesIndex, int planeIndex) {
        int file2 = planeIndex;
        file2 = seriesIndex == 0 ? planeIndex / (this.getImageCount() / this.tiffs.size()) : planeIndex / (this.getImageCount() / this.previewNames.size());
        String filename = seriesIndex == 0 ? this.tiffs.get(file2) : this.previewNames.get(file2);
        RandomAccessInputStream plane = null;
        try {
            plane = this.getFile(filename);
        }
        catch (FormatException formatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return plane;
    }

    private Integer getPreviewNameIndex(String key) {
        Integer previewIndex = null;
        for (String prefix : PREVIEWNAME_PREFIXES) {
            if (!key.startsWith(prefix)) continue;
            return DataTools.parseInteger(key.substring(prefix.length()));
        }
        return previewIndex;
    }

    private boolean isPreviewName(String name) {
        int index = name.indexOf("-R");
        return index == name.length() - 9;
    }

    private String replaceExtension(String name, String oldExt, String newExt) {
        if (!name.endsWith("." + oldExt)) {
            return name;
        }
        return name.substring(0, name.length() - oldExt.length()) + newExt;
    }

    private static int[] scanFormat(String pattern, String string) throws FormatException {
        ArrayList<Integer> percentOffsets = new ArrayList<Integer>();
        int offset = -1;
        while ((offset = pattern.indexOf(37, offset + 1)) >= 0 && offset + 1 < pattern.length()) {
            if (pattern.charAt(offset + 1) != '0') continue;
            percentOffsets.add(offset);
        }
        int[] result = new int[percentOffsets.size()];
        int patternOffset = 0;
        offset = 0;
        for (int i = 0; i < result.length; ++i) {
            int endOffset;
            int percent = (Integer)percentOffsets.get(i);
            if (!string.regionMatches(offset, pattern, patternOffset, percent - patternOffset)) {
                throw new FormatException("String '" + string + "' does not match format '" + pattern + "'");
            }
            offset += percent - patternOffset;
            patternOffset = percent;
            for (endOffset = offset; endOffset < string.length() && Character.isDigit(string.charAt(endOffset)); ++endOffset) {
            }
            result[i] = Integer.parseInt(string.substring(offset, endOffset));
            offset = endOffset;
            while (++patternOffset < pattern.length() && pattern.charAt(patternOffset - 1) != 'd') {
            }
        }
        int remaining = pattern.length() - patternOffset;
        if (string.length() - offset != remaining || !string.regionMatches(offset, pattern, patternOffset, remaining)) {
            throw new FormatException("String '" + string + "' does not match format '" + pattern + "'");
        }
        return result;
    }

    private IniList getIniFile(String filename) throws FormatException, IOException {
        LOGGER.debug("getIniFile procession: {}", (Object)filename);
        RandomAccessInputStream stream = this.getFile(filename);
        String data = stream.readString((int)stream.length());
        if (!data.startsWith("[")) {
            data = data.substring(data.indexOf(91), data.length());
        }
        data = DataTools.stripString(data);
        BufferedReader reader = new BufferedReader(new StringReader(data));
        stream.close();
        IniList list = this.parser.parseINI(reader);
        for (IniTable table : list) {
            String[] keys;
            LOGGER.debug("");
            LOGGER.debug("[" + (String)table.get("header") + "]");
            for (String key : keys = table.keySet().toArray(new String[table.size()])) {
                String value = this.sanitizeValue((String)table.get(key));
                LOGGER.debug(key + " = " + value);
                table.put(key, value);
            }
        }
        reader.close();
        return list;
    }

    class PlaneData {
        public Double deltaT;
        public Length positionX;
        public Length positionY;
        public Length positionZ;

        PlaneData() {
        }
    }

    class ChannelData {
        public boolean active;
        public Double gain;
        public Double voltage;
        public String name;
        public String emissionFilter;
        public String excitationFilter;
        public Double emWave;
        public Double exWave;
        public String dyeName;
        public String barrierFilter;

        ChannelData() {
        }

        public String getFilter(String value) {
            if ("---".equals(value)) {
                return null;
            }
            return value;
        }
    }
}

