/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.CFPointWriterUtils;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;

class WriterCFStationProfileCollection
extends WriterCFPointAbstract {
    private static Logger log = LoggerFactory.getLogger(WriterCFStationProfileCollection.class);
    private List<StationFeature> stnList;
    private Structure stationStruct;
    private HashMap<String, Integer> stationIndexMap;
    private boolean useDesc;
    private boolean useWmoId;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private HashSet<String> stationVarMap = new HashSet();
    private Structure profileStruct;
    private HashSet<String> profileVarMap = new HashSet();
    private int stnRecno;
    private int profileRecno;
    private int obsRecno;

    WriterCFStationProfileCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.timeSeriesProfile.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Ragged array representation of time series profiles, H.5.3"));
    }

    void setStations(List<StationFeature> stns) {
        this.stnList = stns.stream().distinct().collect(Collectors.toList());
        for (StationFeature stn : this.stnList) {
            boolean bl = this.useAlt = !Double.isNaN(stn.getAltitude());
            if (stn.getWmoId() != null && !stn.getWmoId().trim().isEmpty()) {
                this.useWmoId = true;
            }
            if (stn.getDescription() != null && !stn.getDescription().trim().isEmpty()) {
                this.useDesc = true;
            }
            this.id_strlen = Math.max(this.id_strlen, stn.getName().length());
            if (stn.getDescription() != null) {
                this.desc_strlen = Math.max(this.desc_strlen, stn.getDescription().length());
            }
            if (stn.getWmoId() == null) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, stn.getWmoId().length());
        }
        this.llbb = CFPointWriterUtils.getBoundingBox(this.stnList);
    }

    int writeProfile(ProfileFeature profile) throws IOException {
        if (this.id_strlen == 0) {
            this.id_strlen = profile.getName().length() * 2;
        }
        int count = 0;
        for (PointFeature pf : profile) {
            this.writeObsData(pf);
            ++count;
        }
        return count;
    }

    protected void writeHeader(List<StationFeature> stations) throws IOException {
        ArrayList<ProfileFeature> coverageCollections = new ArrayList<ProfileFeature>();
        ArrayList<StructureData> stationData = new ArrayList<StructureData>();
        ArrayList<StructureData> profileData = new ArrayList<StructureData>();
        ArrayList<VariableSimpleIF> obsCoords = new ArrayList<VariableSimpleIF>();
        for (StationFeature station : stations) {
            stationData.add(station.getFeatureData());
            for (ProfileFeature profile : (StationProfileFeature)station) {
                profileData.add(profile.getFeatureData());
                coverageCollections.add(profile);
                obsCoords.add(VariableSimpleBuilder.makeScalar(profile.getTimeName(), "nominal time of profile", this.timeUnit.toString(), DataType.DOUBLE).build());
                this.altitudeCoordinateName = profile.getAltName();
                obsCoords.add(VariableSimpleBuilder.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "altitude").addAttribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits)).build());
            }
        }
        super.writeHeader(obsCoords, coverageCollections, stationData, profileData);
        int count = 0;
        this.stationIndexMap = new HashMap(2 * this.stnList.size());
        for (StationFeature sf : this.stnList) {
            this.writeStationData(sf);
            this.stationIndexMap.put(sf.getName(), count);
            for (ProfileFeature p : (StationProfileFeature)sf) {
                int countPoints = 0;
                for (PointFeature pf : p) {
                    ++countPoints;
                }
                this.writeProfileData(count, p, countPoints);
            }
            ++count;
        }
    }

    @Override
    void setFeatureAuxInfo(int nfeatures, int id_strlen) {
        int countProfiles = 0;
        int name_strlen = 0;
        for (StationFeature s2 : this.stnList) {
            name_strlen = Math.max(name_strlen, s2.getName().length());
            if (((StationProfileFeature)s2).size() >= 0) {
                countProfiles += ((StationProfileFeature)s2).size();
                continue;
            }
            countProfiles += Iterables.size((StationProfileFeature)s2);
        }
        this.nfeatures = countProfiles;
        this.id_strlen = name_strlen;
    }

    @Override
    void makeFeatureVariables(List<StructureData> stnDataStructs, boolean isExtended) {
        Dimension stationDim = this.writerb.addDimension("station", this.stnList.size());
        ArrayList<VariableSimpleIF> stnVars = new ArrayList<VariableSimpleIF>();
        stnVars.add(VariableSimpleBuilder.makeScalar("latitude", "station latitude", "degrees_north", DataType.DOUBLE).build());
        stnVars.add(VariableSimpleBuilder.makeScalar("longitude", "station longitude", "degrees_east", DataType.DOUBLE).build());
        if (this.useAlt) {
            stnVars.add(VariableSimpleBuilder.makeScalar("stationAltitude", "station altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "station_altitude").addAttribute("positive", CF1Convention.getZisPositive("stationAltitude", this.altUnits)).build());
        }
        stnVars.add(VariableSimpleBuilder.makeString("station_id", "station identifier", null, this.id_strlen).addAttribute("cf_role", "timeseries_id").build());
        if (this.useDesc) {
            stnVars.add(VariableSimpleBuilder.makeString("station_description", "station description", null, this.desc_strlen).addAttribute("standard_name", "platform_name").build());
        }
        if (this.useWmoId) {
            stnVars.add(VariableSimpleBuilder.makeString("wmo_id", "station WMO id", null, this.wmo_strlen).addAttribute("standard_name", "platform_id").build());
        }
        for (StructureData stnData : stnDataStructs) {
            for (StructureMembers.Member m4 : stnData.getMembers()) {
                if (this.findDataVar(m4.getName()) == null) continue;
                stnVars.add(VariableSimpleBuilder.fromMember(m4).build());
            }
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("station", "station");
            this.addCoordinatesExtended(structb, stnVars);
        } else {
            this.addCoordinatesClassic(stationDim, stnVars, this.stationVarMap);
        }
    }

    private void writeStationData(StationFeature stn) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, stn.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, stn.getLatLon().getLongitude());
        if (this.useAlt) {
            smb.addMemberScalar("stationAltitude", null, null, DataType.DOUBLE, stn.getAltitude());
        }
        smb.addMemberString("station_id", null, null, stn.getName().trim(), this.id_strlen);
        if (this.useDesc) {
            smb.addMemberString("station_description", null, null, stn.getDescription().trim(), this.desc_strlen);
        }
        if (this.useWmoId) {
            smb.addMemberString("wmo_id", null, null, stn.getWmoId().trim(), this.wmo_strlen);
        }
        StructureDataFromMember stnCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(stnCoords, stn.getFeatureData()));
        this.stnRecno = super.writeStructureData(this.stnRecno, this.stationStruct, sdall, this.stationVarMap);
    }

    @Override
    void makeMiddleVariables(List<StructureData> profileDataStructs, boolean isExtended) {
        Dimension profileDim = this.writerb.addDimension("profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleBuilder.makeString("profileId", "profile identifier", null, this.id_strlen).addAttribute("cf_role", "profile_id").addAttribute("missing_value", String.valueOf(-9999)).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("stationIndex", "station index for this profile", null, DataType.INT).addAttribute("instance_dimension", "station").build());
        for (StructureData profileData : profileDataStructs) {
            for (StructureMembers.Member m4 : profileData.getMembers()) {
                VariableSimpleIF dv = this.findDataVar(m4.getName());
                if (dv == null) continue;
                profileVars.add(dv);
            }
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("profile", "profile");
            this.addCoordinatesExtended(structb, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.profileVarMap);
        }
    }

    @Override
    void finishBuilding() throws IOException {
        super.finishBuilding();
        this.stationStruct = this.findStructure("station");
        this.profileStruct = this.findStructure("profile");
    }

    private void writeProfileData(int stnIndex, ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), profile.getTime());
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, profile.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, profile.getLatLon().getLongitude());
        double timeInMyUnits = this.timeUnit.makeOffsetFromRefDate(profile.getTime());
        smb.addMemberScalar("profileTime", null, null, DataType.DOUBLE, timeInMyUnits);
        smb.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        smb.addMemberScalar("stationIndex", null, null, DataType.INT, stnIndex);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(profileCoords, profile.getFeatureData()));
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.profileVarMap);
    }

    protected void resetObsIndex() {
        this.obsRecno = 0;
    }

    private void writeObsData(PointFeature pf) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(pf.getFeatureCollection().getTimeName(), null, null, DataType.DOUBLE, pf.getObservationTime());
        smb.addMemberScalar(pf.getFeatureCollection().getAltName(), null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

