/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.internal.ui.common.ScrollablePanelUI;
import org.pushingpixels.flamingo.internal.utils.DoubleArrowResizableIcon;

public class BasicScrollablePanelUI
extends ScrollablePanelUI {
    protected JScrollablePanel scrollablePanel;
    private JPanel viewport;
    private JCommandButton leadingScroller;
    private JCommandButton trailingScroller;
    private int viewOffset;
    private MouseWheelListener mouseWheelListener;
    private PropertyChangeListener propertyChangeListener;
    private ComponentListener componentListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicScrollablePanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.scrollablePanel = (JScrollablePanel)c;
        super.installUI(this.scrollablePanel);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    protected void installListeners() {
        this.mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() != JScrollablePanel.ScrollType.VERTICALLY) {
                    return;
                }
                int scrollAmount = 8 * e.getScrollAmount() * e.getWheelRotation();
                BasicScrollablePanelUI basicScrollablePanelUI = BasicScrollablePanelUI.this;
                basicScrollablePanelUI.viewOffset = basicScrollablePanelUI.viewOffset + scrollAmount;
                BasicScrollablePanelUI.this.syncScrolling();
            }
        };
        this.scrollablePanel.addMouseWheelListener(this.mouseWheelListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("scrollOnRollover".equals(evt.getPropertyName())) {
                    boolean isScrollOnRollover = (Boolean)evt.getNewValue();
                    BasicScrollablePanelUI.this.leadingScroller.setFireActionOnRollover(isScrollOnRollover);
                    BasicScrollablePanelUI.this.trailingScroller.setFireActionOnRollover(isScrollOnRollover);
                }
            }
        };
        this.scrollablePanel.addPropertyChangeListener(this.propertyChangeListener);
        if (this.scrollablePanel.getView() != null) {
            this.componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    BasicScrollablePanelUI.this.scrollablePanel.doLayout();
                }
            };
            ((Component)this.scrollablePanel.getView()).addComponentListener(this.componentListener);
        }
    }

    protected void installComponents() {
        this.viewport = new JPanel(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(10, 10);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public void layoutContainer(Container parent) {
                Object view = BasicScrollablePanelUI.this.scrollablePanel.getView();
                if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                    int viewWidth = ((JComponent)view).getPreferredSize().width;
                    int availWidth = parent.getWidth();
                    int offsetX = -BasicScrollablePanelUI.this.viewOffset;
                    ((Component)view).setBounds(offsetX, 0, Math.max(viewWidth, availWidth), parent.getHeight());
                } else {
                    int viewHeight = ((JComponent)view).getPreferredSize().height;
                    int availHeight = parent.getHeight();
                    int offsetY = -BasicScrollablePanelUI.this.viewOffset;
                    ((Component)view).setBounds(0, offsetY, parent.getWidth(), Math.max(viewHeight, availHeight));
                }
            }
        });
        Object view = this.scrollablePanel.getView();
        if (view != null) {
            this.viewport.add((Component)view);
        }
        this.scrollablePanel.add(this.viewport);
        this.leadingScroller = this.createLeadingScroller();
        this.configureLeftScrollerButtonAction();
        this.scrollablePanel.add(this.leadingScroller);
        this.trailingScroller = this.createTrailingScroller();
        this.configureRightScrollerButtonAction();
        this.scrollablePanel.add(this.trailingScroller);
    }

    protected void installDefaults() {
        this.scrollablePanel.setLayout(new ScrollablePanelLayout());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(this.scrollablePanel);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
        this.scrollablePanel.remove(this.viewport);
        this.scrollablePanel.remove(this.leadingScroller);
        this.scrollablePanel.remove(this.trailingScroller);
    }

    protected void uninstallListeners() {
        this.scrollablePanel.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.scrollablePanel.removeMouseWheelListener(this.mouseWheelListener);
        this.mouseWheelListener = null;
        if (this.scrollablePanel.getView() != null) {
            ((Component)this.scrollablePanel.getView()).removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected JCommandButton createLeadingScroller() {
        JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 7 : 1));
        b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        b.setFocusable(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
        b.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        return b;
    }

    protected JCommandButton createTrailingScroller() {
        JCommandButton b = new JCommandButton(null, new DoubleArrowResizableIcon(new Dimension(9, 9), this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY ? 3 : 5));
        b.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        b.setFocusable(false);
        b.setCursor(Cursor.getPredefinedCursor(12));
        b.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
        b.putClientProperty("flamingo.internal.commandButton.ui.dontDisposePopups", Boolean.TRUE);
        return b;
    }

    private void syncScrolling() {
        this.scrollablePanel.doLayout();
    }

    public void removeScrollers() {
        if (this.leadingScroller.getParent() == this.scrollablePanel) {
            this.scrollablePanel.remove(this.leadingScroller);
            this.scrollablePanel.remove(this.trailingScroller);
            this.syncScrolling();
            this.scrollablePanel.revalidate();
            this.scrollablePanel.repaint();
        }
    }

    private void addScrollers() {
        this.scrollablePanel.add(this.leadingScroller);
        this.scrollablePanel.add(this.trailingScroller);
        this.scrollablePanel.revalidate();
        Object view = this.scrollablePanel.getView();
        ((JComponent)view).setPreferredSize(((JComponent)view).getMinimumSize());
        ((Component)view).setSize(((JComponent)view).getMinimumSize());
        this.scrollablePanel.doLayout();
        this.scrollablePanel.repaint();
    }

    protected void configureLeftScrollerButtonAction() {
        this.leadingScroller.setAutoRepeatAction(true);
        this.leadingScroller.setAutoRepeatActionIntervals(200, 50);
        this.leadingScroller.setFireActionOnRollover(this.scrollablePanel.isScrollOnRollover());
        this.leadingScroller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicScrollablePanelUI basicScrollablePanelUI = BasicScrollablePanelUI.this;
                basicScrollablePanelUI.viewOffset = basicScrollablePanelUI.viewOffset - 12;
                BasicScrollablePanelUI.this.syncScrolling();
            }
        });
    }

    protected void configureRightScrollerButtonAction() {
        this.trailingScroller.setAutoRepeatAction(true);
        this.trailingScroller.setAutoRepeatActionIntervals(200, 50);
        this.trailingScroller.setFireActionOnRollover(this.scrollablePanel.isScrollOnRollover());
        this.trailingScroller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicScrollablePanelUI basicScrollablePanelUI = BasicScrollablePanelUI.this;
                basicScrollablePanelUI.viewOffset = basicScrollablePanelUI.viewOffset + 12;
                BasicScrollablePanelUI.this.syncScrolling();
            }
        });
    }

    @Override
    public void scrollToIfNecessary(int startPosition, int span) {
        if (this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
            if (this.scrollablePanel.getComponentOrientation().isLeftToRight()) {
                this.revealRightEdge(startPosition, span);
                this.revealLeftEdge(startPosition);
            } else {
                this.revealLeftEdge(startPosition);
                this.revealRightEdge(startPosition, span);
            }
        } else {
            this.revealBottomEdge(startPosition, span);
            this.revealTopEdge(startPosition);
        }
    }

    private void revealLeftEdge(int x) {
        if (x < this.viewOffset) {
            this.viewOffset = x - 5;
            this.syncScrolling();
        }
    }

    private void revealRightEdge(int x, int width) {
        if (x + width > this.viewOffset + this.viewport.getWidth()) {
            this.viewOffset = x + width - this.viewport.getWidth() + 5;
            this.syncScrolling();
        }
    }

    private void revealTopEdge(int y) {
        if (y < this.viewOffset) {
            this.viewOffset = y - 5;
            this.syncScrolling();
        }
    }

    private void revealBottomEdge(int y, int height) {
        if (y + height > this.viewOffset + this.viewport.getHeight()) {
            this.viewOffset = y + height - this.viewport.getHeight() + 5;
            this.syncScrolling();
        }
    }

    @Override
    public boolean isShowingScrollButtons() {
        return this.leadingScroller.isVisible();
    }

    protected class ScrollablePanelLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                return new Dimension(c.getWidth(), 21);
            }
            return new Dimension(21, c.getHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                return new Dimension(10, 21);
            }
            return new Dimension(21, 10);
        }

        @Override
        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            Insets ins = c.getInsets();
            Object view = BasicScrollablePanelUI.this.scrollablePanel.getView();
            Dimension viewPrefSize = ((JComponent)view).getPreferredSize();
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                boolean shouldShowScrollerButtons = viewPrefSize.width > width;
                BasicScrollablePanelUI.this.leadingScroller.setVisible(shouldShowScrollerButtons);
                BasicScrollablePanelUI.this.trailingScroller.setVisible(shouldShowScrollerButtons);
                int scrollPanelWidth = shouldShowScrollerButtons ? width - ins.left - ins.right - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().width - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().width - 4 : width - ins.left - ins.right;
                int x = ins.left;
                if (shouldShowScrollerButtons) {
                    int spw = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().width;
                    BasicScrollablePanelUI.this.leadingScroller.setBounds(x, ins.top, spw, height - ins.top - ins.bottom);
                    x += spw + 2;
                }
                BasicScrollablePanelUI.this.viewport.setBounds(x, ins.top, scrollPanelWidth, height - ins.top - ins.bottom);
                int viewPreferredWidth = ((JComponent)view).getPreferredSize().width;
                if (BasicScrollablePanelUI.this.viewOffset < 0) {
                    BasicScrollablePanelUI.this.viewOffset = 0;
                }
                if (viewPreferredWidth > 0 && BasicScrollablePanelUI.this.viewOffset + scrollPanelWidth > viewPreferredWidth) {
                    BasicScrollablePanelUI.this.viewOffset = Math.max(0, viewPreferredWidth - scrollPanelWidth);
                }
                BasicScrollablePanelUI.this.viewport.doLayout();
                x += scrollPanelWidth + 2;
                if (shouldShowScrollerButtons) {
                    int spw = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().width;
                    BasicScrollablePanelUI.this.trailingScroller.setBounds(x, ins.top, spw, height - ins.top - ins.bottom);
                }
            } else {
                boolean shouldShowScrollerButtons = viewPrefSize.height > height;
                BasicScrollablePanelUI.this.leadingScroller.setVisible(shouldShowScrollerButtons);
                BasicScrollablePanelUI.this.trailingScroller.setVisible(shouldShowScrollerButtons);
                int scrollPanelHeight = shouldShowScrollerButtons ? height - ins.top - ins.bottom - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().height - ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().height - 4 : height - ins.top - ins.bottom;
                int y = ins.top;
                if (shouldShowScrollerButtons) {
                    int sph = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).leadingScroller.getPreferredSize().height;
                    BasicScrollablePanelUI.this.leadingScroller.setBounds(ins.left, y, width - ins.left - ins.right, sph);
                    y += sph + 2;
                }
                BasicScrollablePanelUI.this.viewport.setBounds(ins.left, y, width - ins.left - ins.right, scrollPanelHeight);
                int viewPreferredHeight = ((JComponent)view).getPreferredSize().height;
                if (BasicScrollablePanelUI.this.viewOffset < 0) {
                    BasicScrollablePanelUI.this.viewOffset = 0;
                }
                if (viewPreferredHeight > 0 && BasicScrollablePanelUI.this.viewOffset + scrollPanelHeight > viewPreferredHeight) {
                    BasicScrollablePanelUI.this.viewOffset = Math.max(0, viewPreferredHeight - scrollPanelHeight);
                }
                BasicScrollablePanelUI.this.viewport.doLayout();
                y += scrollPanelHeight + 2;
                if (shouldShowScrollerButtons) {
                    int sph = ((BasicScrollablePanelUI)BasicScrollablePanelUI.this).trailingScroller.getPreferredSize().height;
                    BasicScrollablePanelUI.this.trailingScroller.setBounds(ins.left, y, width - ins.left - ins.right, sph);
                }
            }
            if (BasicScrollablePanelUI.this.scrollablePanel.getScrollType() == JScrollablePanel.ScrollType.HORIZONTALLY) {
                BasicScrollablePanelUI.this.trailingScroller.setEnabled(BasicScrollablePanelUI.this.viewOffset + BasicScrollablePanelUI.this.viewport.getWidth() < ((JComponent)view).getWidth());
            } else {
                BasicScrollablePanelUI.this.trailingScroller.setEnabled(BasicScrollablePanelUI.this.viewOffset + BasicScrollablePanelUI.this.viewport.getHeight() < ((JComponent)view).getHeight());
            }
            BasicScrollablePanelUI.this.leadingScroller.setEnabled(BasicScrollablePanelUI.this.viewOffset > 0);
        }
    }
}

