/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class BasicRibbonBandUI
extends RibbonBandUI {
    protected AbstractRibbonBand<AbstractBandControlPanel> ribbonBand;
    protected JCommandButton collapsedButton;
    protected AbstractCommandButton expandButton;
    protected float rolloverAmount;
    protected Timeline rolloverTimeline;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ActionListener expandButtonActionListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonBandUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.ribbonBand = (AbstractRibbonBand)c;
        this.rolloverTimeline = new Timeline(this);
        this.rolloverTimeline.addPropertyToInterpolate("rolloverAmount", Float.valueOf(0.0f), Float.valueOf(1.0f));
        this.rolloverTimeline.addCallback(new SwingRepaintCallback(this.ribbonBand));
        this.rolloverTimeline.setDuration(250L);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
        AWTRibbonEventListener.install();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        AWTRibbonEventListener.uninstall();
    }

    protected void installDefaults() {
        Border b;
        Color bg = this.ribbonBand.getBackground();
        if (bg == null || bg instanceof UIResource) {
            this.ribbonBand.setBackground(FlamingoUtilities.getColor(Color.lightGray, "RibbonBand.background", "Panel.background"));
        }
        if ((b = this.ribbonBand.getBorder()) == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("RibbonBand.border");
            if (toSet == null) {
                toSet = new BorderUIResource(new RoundBorder(FlamingoUtilities.getBorderColor(), new Insets(2, 2, 2, 2)));
            }
            this.ribbonBand.setBorder(toSet);
        }
    }

    protected void installComponents() {
        this.collapsedButton = new JCommandButton(this.ribbonBand.getTitle(), this.ribbonBand.getIcon());
        this.collapsedButton.setDisplayState(CommandButtonDisplayState.BIG);
        this.collapsedButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        this.collapsedButton.setPopupKeyTip(this.ribbonBand.getCollapsedStateKeyTip());
        this.ribbonBand.add(this.collapsedButton);
        if (this.ribbonBand.getExpandActionListener() != null) {
            this.expandButton = this.createExpandButton();
            this.ribbonBand.add(this.expandButton);
        }
    }

    protected JCommandButton createExpandButton() {
        ResizableIcon icon = FlamingoUtilities.getRibbonBandExpandIcon(this.ribbonBand);
        JCommandButton result = new JCommandButton(null, icon);
        result.setFlat(true);
        result.putClientProperty("flamingo.internal.commandButton.ui.emulateSquare", Boolean.TRUE);
        result.setBorder(new EmptyBorder(3, 2, 3, 2));
        result.setActionKeyTip(this.ribbonBand.getExpandButtonKeyTip());
        result.setActionRichTooltip(this.ribbonBand.getExpandButtonRichTooltip());
        return result;
    }

    protected void syncExpandButtonIcon() {
        this.expandButton.setIcon(FlamingoUtilities.getRibbonBandExpandIcon(this.ribbonBand));
    }

    protected void installListeners() {
        this.mouseListener = new MouseAdapter(){};
        this.ribbonBand.addMouseListener(this.mouseListener);
        this.configureExpandButton();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("title".equals(evt.getPropertyName())) {
                    BasicRibbonBandUI.this.collapsedButton.setText((String)evt.getNewValue());
                    BasicRibbonBandUI.this.ribbonBand.repaint();
                } else if ("icon".equals(evt.getPropertyName())) {
                    BasicRibbonBandUI.this.collapsedButton.setIcon((ResizableIcon)evt.getNewValue());
                    BasicRibbonBandUI.this.ribbonBand.repaint();
                } else if ("expandButtonKeyTip".equals(evt.getPropertyName())) {
                    if (BasicRibbonBandUI.this.expandButton != null) {
                        BasicRibbonBandUI.this.expandButton.setActionKeyTip((String)evt.getNewValue());
                    }
                } else if ("expandButtonRichTooltip".equals(evt.getPropertyName())) {
                    if (BasicRibbonBandUI.this.expandButton != null) {
                        BasicRibbonBandUI.this.expandButton.setActionRichTooltip((RichTooltip)evt.getNewValue());
                    }
                } else if ("collapsedStateKeyTip".equals(evt.getPropertyName())) {
                    if (BasicRibbonBandUI.this.collapsedButton != null) {
                        BasicRibbonBandUI.this.collapsedButton.setPopupKeyTip((String)evt.getNewValue());
                    }
                } else if ("expandActionListener".equals(evt.getPropertyName())) {
                    ActionListener oldListener = (ActionListener)evt.getOldValue();
                    ActionListener newListener = (ActionListener)evt.getNewValue();
                    if (oldListener != null && newListener == null) {
                        BasicRibbonBandUI.this.unconfigureExpandButton();
                        BasicRibbonBandUI.this.ribbonBand.remove(BasicRibbonBandUI.this.expandButton);
                        BasicRibbonBandUI.this.expandButton = null;
                        BasicRibbonBandUI.this.ribbonBand.revalidate();
                    } else if (oldListener == null && newListener != null) {
                        BasicRibbonBandUI.this.expandButton = BasicRibbonBandUI.this.createExpandButton();
                        BasicRibbonBandUI.this.configureExpandButton();
                        BasicRibbonBandUI.this.ribbonBand.add(BasicRibbonBandUI.this.expandButton);
                        BasicRibbonBandUI.this.ribbonBand.revalidate();
                    } else if (oldListener != null && newListener != null) {
                        BasicRibbonBandUI.this.expandButton.removeActionListener(oldListener);
                        BasicRibbonBandUI.this.expandButton.addActionListener(newListener);
                    }
                } else if ("componentOrientation".equals(evt.getPropertyName()) && BasicRibbonBandUI.this.expandButton != null) {
                    BasicRibbonBandUI.this.syncExpandButtonIcon();
                }
            }
        };
        this.ribbonBand.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void configureExpandButton() {
        if (this.expandButton != null) {
            this.expandButton.addActionListener(this.ribbonBand.getExpandActionListener());
            this.expandButtonActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BasicRibbonBandUI.this.trackMouseCrossing(false);
                        }
                    });
                }
            };
            this.expandButton.addActionListener(this.expandButtonActionListener);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.ribbonBand);
    }

    protected void uninstallComponents() {
        if (this.collapsedButton.isVisible()) {
            CollapsedButtonPopupPanel popupPanel;
            CollapsedButtonPopupPanel collapsedButtonPopupPanel = popupPanel = this.collapsedButton.getPopupCallback() == null ? null : (CollapsedButtonPopupPanel)this.collapsedButton.getPopupCallback().getPopupPanel(this.collapsedButton);
            if (popupPanel != null) {
                AbstractRibbonBand bandFromPopup = (AbstractRibbonBand)popupPanel.removeComponent();
                this.ribbonBand.setControlPanel((AbstractBandControlPanel)bandFromPopup.getControlPanel());
                this.ribbonBand.setPopupRibbonBand(null);
                this.collapsedButton.setPopupCallback(null);
            }
        }
        this.ribbonBand.remove(this.collapsedButton);
        this.collapsedButton = null;
        if (this.expandButton != null) {
            this.ribbonBand.remove(this.expandButton);
        }
        this.expandButton = null;
        this.ribbonBand = null;
    }

    protected void uninstallListeners() {
        this.ribbonBand.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.ribbonBand.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.unconfigureExpandButton();
    }

    protected void unconfigureExpandButton() {
        if (this.expandButton != null) {
            this.expandButton.removeActionListener(this.expandButtonActionListener);
            this.expandButtonActionListener = null;
            this.expandButton.removeActionListener(this.ribbonBand.getExpandActionListener());
        }
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonBandLayout();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d);
        super.update(g2d, c);
        g2d.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        Insets ins = this.ribbonBand.getInsets();
        this.paintBandBackground(graphics, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        if (!(this.ribbonBand.getCurrentResizePolicy() instanceof IconRibbonBandResizePolicy)) {
            String title = this.ribbonBand.getTitle();
            int titleHeight = this.getBandTitleHeight();
            int bandTitleTopY = c.getHeight() - titleHeight;
            this.paintBandTitleBackground(graphics, new Rectangle(0, bandTitleTopY, c.getWidth(), titleHeight), title);
            boolean ltr = this.ribbonBand.getComponentOrientation().isLeftToRight();
            int titleWidth = c.getWidth() - 2 * ins.left - 2 * ins.right;
            int titleX = 2 * ins.left;
            if (this.expandButton != null) {
                if (ltr) {
                    titleWidth = this.expandButton.getX() - 2 * ins.right - 2 * ins.left;
                } else {
                    titleWidth = this.ribbonBand.getWidth() - this.expandButton.getX() - this.expandButton.getWidth() - 2 * ins.right - 2 * ins.left;
                    titleX = this.expandButton.getX() + this.expandButton.getWidth() + 2 * ins.left;
                }
            }
            this.paintBandTitle(graphics, new Rectangle(titleX, bandTitleTopY, titleWidth, titleHeight), title);
        }
        graphics.dispose();
    }

    protected void paintBandTitle(Graphics g, Rectangle titleRectangle, String title) {
        if (titleRectangle.width <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setFont(FlamingoUtilities.getFont(this.ribbonBand, "Ribbon.font", "Button.font", "Panel.font"));
        FontMetrics fm = graphics.getFontMetrics();
        int y = titleRectangle.y - 2 + (titleRectangle.height + fm.getAscent()) / 2;
        int currLength = (int)fm.getStringBounds(title, g).getWidth();
        String titleToPaint = title;
        while (currLength > titleRectangle.width) {
            title = title.substring(0, title.length() - 1);
            titleToPaint = String.valueOf(title) + "...";
            currLength = (int)fm.getStringBounds(titleToPaint, g).getWidth();
        }
        int x = titleRectangle.x + (titleRectangle.width - currLength) / 2;
        graphics.setColor(this.ribbonBand.getForeground());
        graphics.drawString(titleToPaint, x, y);
        graphics.dispose();
    }

    protected void paintBandTitleBackground(Graphics g, Rectangle titleRectangle, String title) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.7f + 0.3f * this.rolloverAmount));
        FlamingoUtilities.renderSurface(g2d, this.ribbonBand, titleRectangle, this.rolloverAmount > 0.0f, true, false);
        g2d.dispose();
    }

    public void setRolloverAmount(float rolloverAmount) {
        this.rolloverAmount = rolloverAmount;
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        graphics.setColor(this.ribbonBand.getBackground());
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    @Override
    public float getRolloverAmount() {
        return this.rolloverAmount;
    }

    @Override
    public int getBandTitleHeight() {
        int result;
        Font font = FlamingoUtilities.getFont(this.ribbonBand, "Ribbon.font", "Button.font", "Panel.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        if ((result = font.getSize() + 5) % 2 == 0) {
            ++result;
        }
        return result;
    }

    @Override
    public int getPreferredCollapsedWidth() {
        return this.collapsedButton.getPreferredSize().width + 2;
    }

    @Override
    public void trackMouseCrossing(boolean isMouseIn) {
        if (isMouseIn) {
            this.rolloverTimeline.play();
        } else {
            this.rolloverTimeline.playReverse();
        }
        this.ribbonBand.repaint();
    }

    @Deprecated
    public AbstractCommandButton getExpandButton() {
        return this.expandButton;
    }

    @Deprecated
    public AbstractCommandButton getCollapsedButton() {
        return this.collapsedButton;
    }

    private static class AWTRibbonEventListener
    implements AWTEventListener {
        private static AWTRibbonEventListener instance;
        private int installCount = 0;
        private AbstractRibbonBand lastHovered;

        private AWTRibbonEventListener() {
        }

        public static void install() {
            if (instance == null) {
                instance = new AWTRibbonEventListener();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Toolkit.getDefaultToolkit().addAWTEventListener(instance, 131088L);
                        return null;
                    }
                });
            }
            ++AWTRibbonEventListener.instance.installCount;
        }

        public static boolean uninstall() {
            if (instance != null) {
                --AWTRibbonEventListener.instance.installCount;
                if (AWTRibbonEventListener.instance.installCount == 0) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(instance);
                    instance = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            Component component;
            Object object;
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.getID() == 504) {
                object = event.getSource();
                if (!(object instanceof Component)) {
                    return;
                }
                component = (Component)object;
                AbstractRibbonBand band = component instanceof AbstractRibbonBand ? (AbstractRibbonBand)component : (AbstractRibbonBand)SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, component);
                this.setHoveredBand(band);
            }
            if (mouseEvent.getID() == 507) {
                if (PopupPanelManager.defaultManager().getShownPath().size() > 0) {
                    return;
                }
                object = event.getSource();
                if (!(object instanceof Component)) {
                    return;
                }
                component = (Component)object;
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                Component deepest = SwingUtilities.getDeepestComponentAt(component, mouseWheelEvent.getX(), mouseWheelEvent.getY());
                JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, deepest);
                if (ribbon != null) {
                    ribbon.getUI().handleMouseWheelEvent((MouseWheelEvent)mouseEvent);
                }
            }
        }

        private void setHoveredBand(AbstractRibbonBand band) {
            if (this.lastHovered == band) {
                return;
            }
            if (this.lastHovered != null) {
                this.lastHovered.getUI().trackMouseCrossing(false);
            }
            this.lastHovered = band;
            if (band != null) {
                band.getUI().trackMouseCrossing(true);
            }
        }
    }

    protected static class CollapsedButtonPopupPanel
    extends JPopupPanel {
        protected Component component;

        public CollapsedButtonPopupPanel(Component component, Dimension originalSize) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setPreferredSize(originalSize);
            this.setSize(originalSize);
        }

        public Component removeComponent() {
            this.remove(this.component);
            return this.component;
        }

        public Component getComponent() {
            return this.component;
        }
    }

    private class RibbonBandLayout
    implements LayoutManager {
        private RibbonBandLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            AbstractBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean useCollapsedButton = BasicRibbonBandUI.this.ribbonBand.isCollapsed() || !controlPanel.isVisible();
            int width = useCollapsedButton ? BasicRibbonBandUI.this.collapsedButton.getPreferredSize().width : controlPanel.getPreferredSize().width;
            int height = (useCollapsedButton ? BasicRibbonBandUI.this.collapsedButton.getPreferredSize().height : controlPanel.getPreferredSize().height) + BasicRibbonBandUI.this.getBandTitleHeight();
            return new Dimension(width + 2 + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            AbstractBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean useCollapsedButton = BasicRibbonBandUI.this.ribbonBand.isCollapsed() || !controlPanel.isVisible();
            int width = useCollapsedButton ? BasicRibbonBandUI.this.collapsedButton.getMinimumSize().width : controlPanel.getMinimumSize().width;
            int height = useCollapsedButton ? BasicRibbonBandUI.this.collapsedButton.getMinimumSize().height + BasicRibbonBandUI.this.getBandTitleHeight() : controlPanel.getMinimumSize().height + BasicRibbonBandUI.this.getBandTitleHeight();
            return new Dimension(width + 2 + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container c) {
            if (!c.isVisible()) {
                return;
            }
            Insets ins = c.getInsets();
            int availableHeight = c.getHeight() - ins.top - ins.bottom;
            RibbonBandResizePolicy resizePolicy = ((AbstractRibbonBand)c).getCurrentResizePolicy();
            if (resizePolicy instanceof IconRibbonBandResizePolicy) {
                BasicRibbonBandUI.this.collapsedButton.setVisible(true);
                int w = BasicRibbonBandUI.this.collapsedButton.getPreferredSize().width;
                BasicRibbonBandUI.this.collapsedButton.setBounds((c.getWidth() - w) / 2, ins.top, w, c.getHeight() - ins.top - ins.bottom);
                if (BasicRibbonBandUI.this.collapsedButton.getPopupCallback() == null) {
                    final AbstractRibbonBand<AbstractBandControlPanel> popupBand = BasicRibbonBandUI.this.ribbonBand.cloneBand();
                    popupBand.setControlPanel(BasicRibbonBandUI.this.ribbonBand.getControlPanel());
                    List<RibbonBandResizePolicy> resizePolicies = BasicRibbonBandUI.this.ribbonBand.getResizePolicies();
                    popupBand.setResizePolicies(resizePolicies);
                    RibbonBandResizePolicy largest = resizePolicies.get(0);
                    popupBand.setCurrentResizePolicy(largest);
                    int gap = popupBand.getControlPanel().getUI().getLayoutGap();
                    final Dimension size = new Dimension(ins.left + ins.right + gap + largest.getPreferredWidth(availableHeight, gap), ins.top + ins.bottom + Math.max(c.getHeight(), BasicRibbonBandUI.this.ribbonBand.getControlPanel().getPreferredSize().height + BasicRibbonBandUI.this.getBandTitleHeight()));
                    BasicRibbonBandUI.this.collapsedButton.setPopupCallback(new PopupPanelCallback(){

                        @Override
                        public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                            return new CollapsedButtonPopupPanel(popupBand, size);
                        }
                    });
                    BasicRibbonBandUI.this.ribbonBand.setControlPanel(null);
                    BasicRibbonBandUI.this.ribbonBand.setPopupRibbonBand(popupBand);
                }
                if (BasicRibbonBandUI.this.expandButton != null) {
                    BasicRibbonBandUI.this.expandButton.setBounds(0, 0, 0, 0);
                }
                return;
            }
            if (BasicRibbonBandUI.this.collapsedButton.isVisible()) {
                CollapsedButtonPopupPanel popupPanel;
                CollapsedButtonPopupPanel collapsedButtonPopupPanel = popupPanel = BasicRibbonBandUI.this.collapsedButton.getPopupCallback() != null ? (CollapsedButtonPopupPanel)BasicRibbonBandUI.this.collapsedButton.getPopupCallback().getPopupPanel(BasicRibbonBandUI.this.collapsedButton) : null;
                if (popupPanel != null) {
                    AbstractRibbonBand bandFromPopup = (AbstractRibbonBand)popupPanel.removeComponent();
                    BasicRibbonBandUI.this.ribbonBand.setControlPanel((AbstractBandControlPanel)bandFromPopup.getControlPanel());
                    BasicRibbonBandUI.this.ribbonBand.setPopupRibbonBand(null);
                    BasicRibbonBandUI.this.collapsedButton.setPopupCallback(null);
                }
            }
            BasicRibbonBandUI.this.collapsedButton.setVisible(false);
            AbstractBandControlPanel controlPanel = BasicRibbonBandUI.this.ribbonBand.getControlPanel();
            controlPanel.setVisible(true);
            controlPanel.setBounds(ins.left, ins.top, c.getWidth() - ins.left - ins.right, c.getHeight() - BasicRibbonBandUI.this.getBandTitleHeight() - ins.top - ins.bottom);
            controlPanel.doLayout();
            if (BasicRibbonBandUI.this.expandButton != null) {
                int ebpw = BasicRibbonBandUI.this.expandButton.getPreferredSize().width;
                int ebph = BasicRibbonBandUI.this.expandButton.getPreferredSize().height;
                int maxHeight = BasicRibbonBandUI.this.getBandTitleHeight() - 4;
                if (ebph > maxHeight) {
                    ebph = maxHeight;
                }
                int expandButtonBottomY = c.getHeight() - (BasicRibbonBandUI.this.getBandTitleHeight() - ebph) / 2;
                boolean ltr = BasicRibbonBandUI.this.ribbonBand.getComponentOrientation().isLeftToRight();
                if (ltr) {
                    BasicRibbonBandUI.this.expandButton.setBounds(c.getWidth() - ins.right - ebpw, expandButtonBottomY - ebph, ebpw, ebph);
                } else {
                    BasicRibbonBandUI.this.expandButton.setBounds(ins.left, expandButtonBottomY - ebph, ebpw, ebph);
                }
            }
        }
    }

    protected static class RoundBorder
    implements Border {
        protected Color color;
        protected Insets insets;

        public RoundBorder(Color color, Insets insets) {
            this.color = color;
            this.insets = insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.color);
            g2d.drawRoundRect(x, y, width - 1, height - 1, 3, 3);
            g2d.dispose();
        }
    }
}

