/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.adufour.vars.gui.model.VarEditorModel;

public class ValueSelectionModel<T>
implements VarEditorModel<T> {
    protected final List<T> validValues;
    protected final T defaultValue;
    private final boolean freeInput;

    public ValueSelectionModel() {
        this(null);
    }

    public ValueSelectionModel(T[] validValues) {
        this(validValues, false, validValues == null || validValues.length == 0);
    }

    public ValueSelectionModel(T[] validValues, int defaultValueIndex, boolean freeInput) {
        this.validValues = validValues == null ? new ArrayList() : Arrays.asList(validValues);
        this.defaultValue = this.validValues.size() > defaultValueIndex ? this.validValues.get(defaultValueIndex) : null;
        this.freeInput = freeInput;
    }

    public ValueSelectionModel(T[] validValues, T defaultValue, boolean freeInput) {
        this.validValues = validValues == null ? new ArrayList() : Arrays.asList(validValues);
        this.defaultValue = this.validValues.contains(defaultValue) ? defaultValue : null;
        this.freeInput = freeInput;
    }

    @Override
    public boolean isValid(T value) {
        return this.freeInput || this.validValues.contains(value);
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public List<T> getValidValues() {
        return this.validValues;
    }

    public boolean isFreeInput() {
        return this.freeInput;
    }
}

