/*
 * Decompiled with CFR 0.152.
 */
package plugins.tlecomte.jythonForIcy;

import icy.file.FileUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.python.core.PySystemState;
import plugins.tlecomte.jythonForIcy.ExtractionTimestamps;
import plugins.tlecomte.jythonForIcy.PythonLibraries;

class ExtractionHelper {
    static final String pythonDirName = "PythonLibs";
    static final String extractionDir = "PythonLibs";

    ExtractionHelper() {
    }

    static void extractPyFiles(ExtractionTimestamps timestamps) {
        ArrayList pluginList = PluginLoader.getPlugins();
        String destDir = ExtractionHelper.getPythonLibDir();
        if (destDir == null) {
            System.err.println("Failed to extract python library files because sys.prefix is not set");
            return;
        }
        for (PluginDescriptor plugin : pluginList) {
            if (plugin.getPluginClass().getAnnotation(PythonLibraries.class) == null) continue;
            try {
                ExtractionHelper.extractPyFiles(plugin, destDir, timestamps);
            }
            catch (IOException e) {
                System.err.println("Failed to extract python library files for plugin " + plugin);
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                System.err.println("Failed to extract python library files for plugin " + plugin);
                e.printStackTrace();
            }
        }
    }

    static String getPythonLibDir() {
        String sys_prefix;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() {
                PySystemState sys = new PySystemState();
                String sys_prefix = PySystemState.prefix.asString();
                sys.cleanup();
                return sys_prefix;
            }
        };
        Future<String> future = executor.submit(callable);
        executor.shutdown();
        executor = null;
        try {
            sys_prefix = future.get();
        }
        catch (InterruptedException e) {
            System.err.println("Failed to retrieve Python prefix");
            sys_prefix = null;
        }
        catch (ExecutionException e) {
            System.err.println("Failed to retrieve Python prefix");
            sys_prefix = null;
        }
        String Lib_prefix = null;
        if (sys_prefix == null) {
            System.err.println("Error: sys.prefix is None.");
            System.err.println("If you are developing in Eclipse, please set the 'python.home' property");
            System.err.println("on the Java command-line. For example:");
            System.err.println("\t-Dpython.home=plugins");
        } else {
            Lib_prefix = sys_prefix + File.separator + "Lib";
        }
        return Lib_prefix;
    }

    static void extractPyFiles(PluginDescriptor plugin, String destDir, ExtractionTimestamps timestamps) throws IOException, URISyntaxException {
        Class klass = plugin.getPluginClass();
        URL classUrl = klass.getResource(klass.getSimpleName() + ".class");
        URLConnection connection = classUrl.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarConnection = (JarURLConnection)connection;
            ExtractionHelper.extractPyFilesFromJarIfNewer(jarConnection, plugin, destDir, timestamps);
        } else {
            System.out.println("Extracting Python files from disk for plugin " + plugin);
            String srcDir = ExtractionHelper.findPythonFilesFromDisk(classUrl);
            FileUtil.copy((String)srcDir, (String)destDir, (boolean)true, (boolean)true);
        }
    }

    static void extractPyFilesFromJarIfNewer(JarURLConnection jarConnection, PluginDescriptor plugin, String destDir, ExtractionTimestamps timestamps) throws IOException, URISyntaxException {
        URL jarUrl = jarConnection.getJarFileURL();
        URI jarURI = jarUrl.toURI();
        JarFile jarFile = new JarFile(new File(jarURI));
        long jarLastModified = new File(jarFile.getName()).lastModified();
        Long extractionTimestamp = timestamps.getTimestamp(plugin);
        if (extractionTimestamp == jarLastModified) {
            return;
        }
        System.out.println("Extracting Python files from plugin " + plugin);
        ExtractionHelper.extractPyFilesFromJar(jarFile, destDir);
        timestamps.setTimestamp(plugin, new Long(jarLastModified));
    }

    static void extractPyFilesFromJar(JarFile jarFile, String destDir) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            int bytes;
            FileOutputStream fileOutputStream;
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (jarEntry.isDirectory() || !name.startsWith("PythonLibs")) continue;
            String strippedName = name.substring("PythonLibs".length() + 1);
            String outName = destDir + File.separator + strippedName;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            File destFile = new File(outName);
            try {
                fileOutputStream = new FileOutputStream(destFile);
            }
            catch (FileNotFoundException e) {
                destFile.getParentFile().mkdirs();
                fileOutputStream = new FileOutputStream(destFile);
            }
            byte[] b = new byte[16384];
            while ((bytes = inputStream.read(b)) > 0) {
                fileOutputStream.write(b, 0, bytes);
            }
            fileOutputStream.close();
            inputStream.close();
        }
    }

    static String findPythonFilesFromDisk(URL classUrl) throws URISyntaxException {
        File classFile = new File(classUrl.toURI());
        File pythonParent = null;
        File leaf = classFile;
        while (pythonParent == null) {
            leaf = leaf.getParentFile();
            pythonParent = ExtractionHelper.findPythonFilesInSubDirs(leaf);
        }
        return pythonParent.getAbsolutePath();
    }

    static File findPythonFilesInSubDirs(File root) {
        if (!root.isDirectory()) {
            return null;
        }
        for (File file : root.listFiles()) {
            if (!file.isDirectory()) continue;
            if (file.getName().endsWith("PythonLibs")) {
                return file;
            }
            File res = ExtractionHelper.findPythonFilesInSubDirs(file);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

