/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import icy.math.MathUtil;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.point.Point3D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import plugins.adufour.roi.ROIMeasures;
import plugins.adufour.vars.lang.VarDouble;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;

public class ROIEllipsoidFittingDescriptor
extends Plugin
implements PluginROIDescriptor,
PluginBundled {
    private static final ROIFirstDiameter majorDiameter = new ROIFirstDiameter();
    private static final ROISecondDiameter minorDiameter2D = new ROISecondDiameter();
    private static final ROIThirdDiameter minorDiameter3D = new ROIThirdDiameter();
    private static final ROIFirstAxis majorAxis = new ROIFirstAxis();
    private static final ROISecondAxis minorAxis2D = new ROISecondAxis();
    private static final ROIThirdAxis minorAxis3D = new ROIThirdAxis();
    private static final ROIYawAngle yawAngle = new ROIYawAngle();
    private static final ROIPitchAngle pitchAngle = new ROIPitchAngle();
    private static final ROIRollAngle rollAngle = new ROIRollAngle();
    private static final ROIElongation elongation = new ROIElongation();
    private static final ROIFlatness3D flatness3D = new ROIFlatness3D();

    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> list = new ArrayList<ROIDescriptor>();
        list.add(majorDiameter);
        list.add(minorDiameter2D);
        list.add(minorDiameter3D);
        list.add(majorAxis);
        list.add(minorAxis2D);
        list.add(minorAxis3D);
        list.add(yawAngle);
        list.add(pitchAngle);
        list.add(rollAngle);
        list.add(elongation);
        list.add(flatness3D);
        return list;
    }

    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        double[] ellipse = ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence);
        HashMap<ROIDescriptor, Object> map = new HashMap<ROIDescriptor, Object>(6);
        map.put(majorDiameter, ellipse[0]);
        map.put(minorDiameter2D, ellipse[1]);
        map.put(minorDiameter3D, ellipse[2]);
        Vector3d axis1 = new Vector3d(ellipse[3], ellipse[4], ellipse[5]);
        Vector3d axis2 = new Vector3d(ellipse[6], ellipse[7], ellipse[8]);
        Vector3d axis3 = new Vector3d(ellipse[9], ellipse[10], ellipse[11]);
        map.put(majorAxis, axis1);
        map.put(minorAxis2D, axis2);
        map.put(minorAxis3D, axis3);
        map.put(yawAngle, ROIYawAngle.computeYawAngle(ellipse));
        map.put(pitchAngle, roi instanceof ROI2D ? 0.0 : ROIPitchAngle.computePitchAngle(ellipse));
        map.put(rollAngle, roi instanceof ROI2D ? 0.0 : ROIRollAngle.computeRollAngle(ellipse));
        map.put(elongation, ROIElongation.computeElongation(ellipse));
        map.put(flatness3D, roi instanceof ROI2D ? 0.0 : ROIFlatness3D.computeFlatness3D(ellipse));
        return map;
    }

    private static String getUnit(Sequence sequence) {
        if (sequence == null) {
            return "px";
        }
        return "um";
    }

    public static double[] computeOrientation(ROI roi, Sequence sequence) throws InterruptedException {
        Point2d radii;
        double[] ellipse = new double[12];
        if (roi instanceof ROI2D) {
            try {
                radii = new Point2d();
                Vector2d[] eigenVectors = new Vector2d[2];
                ROIEllipsoidFittingDescriptor.fitEllipse((ROI2D)roi, null, radii, null, eigenVectors, null);
                radii.scale(2.0);
                ellipse[0] = radii.x;
                ellipse[1] = radii.y;
                Vector2d firstAxis = eigenVectors[0];
                ellipse[3] = MathUtil.round((double)firstAxis.x, (int)2);
                ellipse[4] = MathUtil.round((double)firstAxis.y, (int)2);
                Vector2d secondAxis = eigenVectors[1];
                ellipse[6] = MathUtil.round((double)secondAxis.x, (int)2);
                ellipse[7] = MathUtil.round((double)secondAxis.y, (int)2);
                ellipse[11] = 1.0;
            }
            catch (RuntimeException e) {
                Arrays.fill(ellipse, Double.NaN);
            }
        } else if (roi instanceof ROI3D) {
            Vector3d thirdAxis;
            Vector3d secondAxis;
            radii = new Point3d();
            Vector3d[] eigenVectors = new Vector3d[3];
            ROIEllipsoidFittingDescriptor.fitEllipse((ROI3D)roi, null, (Point3d)radii, eigenVectors, null);
            radii.scale(2.0);
            ellipse[0] = radii.x;
            ellipse[1] = radii.y;
            ellipse[2] = radii.z;
            Vector3d firstAxis = eigenVectors[0];
            if (firstAxis != null) {
                ellipse[3] = MathUtil.round((double)firstAxis.x, (int)2);
                ellipse[4] = MathUtil.round((double)firstAxis.y, (int)2);
                ellipse[5] = MathUtil.round((double)firstAxis.z, (int)2);
            }
            if ((secondAxis = eigenVectors[1]) != null) {
                ellipse[6] = MathUtil.round((double)secondAxis.x, (int)2);
                ellipse[7] = MathUtil.round((double)secondAxis.y, (int)2);
                ellipse[8] = MathUtil.round((double)secondAxis.z, (int)2);
            }
            if ((thirdAxis = eigenVectors[2]) != null) {
                ellipse[9] = MathUtil.round((double)thirdAxis.x, (int)2);
                ellipse[10] = MathUtil.round((double)thirdAxis.y, (int)2);
                ellipse[11] = MathUtil.round((double)thirdAxis.z, (int)2);
            }
        } else {
            System.err.println("Cannot compute ellipse dimensions for ROI of type: " + roi.getClassName());
            Arrays.fill(ellipse, Double.NaN);
        }
        if (sequence != null) {
            ellipse[0] = ellipse[0] * sequence.getPixelSizeX();
            ellipse[1] = ellipse[1] * sequence.getPixelSizeY();
            ellipse[2] = ellipse[2] * sequence.getPixelSizeZ();
        }
        Arrays.sort(ellipse, 0, 3);
        double tmp = ellipse[0];
        ellipse[0] = ellipse[2];
        ellipse[2] = tmp;
        return ellipse;
    }

    private static void fitEllipse(ROI3D cc, Point3d center, Point3d radii, Vector3d[] eigenVectors, double[] equation) throws IllegalArgumentException, InterruptedException {
        Point3D.Integer[] points = cc.getBooleanMask(true).getContourPoints();
        if (points.length < 9) {
            return;
        }
        double[][] d = new double[points.length][9];
        for (int i = 0; i < points.length; ++i) {
            double x = points[i].x;
            double y = points[i].y;
            double z = points[i].z;
            d[i][0] = x * x;
            d[i][1] = y * y;
            d[i][2] = z * z;
            d[i][3] = 2.0 * x * y;
            d[i][4] = 2.0 * x * z;
            d[i][5] = 2.0 * y * z;
            d[i][6] = 2.0 * x;
            d[i][7] = 2.0 * y;
            d[i][8] = 2.0 * z;
        }
        Matrix D = new Matrix(d);
        Matrix ones = ROIEllipsoidFittingDescriptor.ones(points.length, 1);
        try {
            Matrix V = D.transpose().times(D).inverse().times(D.transpose().times(ones));
            double[] v = V.getColumnPackedCopy();
            double[][] a = new double[][]{{v[0], v[3], v[4], v[6]}, {v[3], v[1], v[5], v[7]}, {v[4], v[5], v[2], v[8]}, {v[6], v[7], v[8], -1.0}};
            Matrix A = new Matrix((double[][])a);
            Matrix C = A.getMatrix(0, 2, 0, 2).times(-1.0).inverse().times(V.getMatrix(6, 8, 0, 0));
            Matrix T = Matrix.identity((int)4, (int)4);
            T.setMatrix(3, 3, 0, 2, C.transpose());
            Matrix R = T.times(A.times(T.transpose()));
            double r33 = R.get(3, 3);
            Matrix R02 = R.getMatrix(0, 2, 0, 2);
            EigenvalueDecomposition E = new EigenvalueDecomposition(R02.times(-1.0 / r33));
            Matrix eVal = E.getD();
            Matrix eVec = E.getV();
            Matrix diagonal = ROIEllipsoidFittingDescriptor.diag(eVal);
            if (radii != null) {
                radii.set(Math.sqrt(1.0 / diagonal.get(0, 0)), Math.sqrt(1.0 / diagonal.get(1, 0)), Math.sqrt(1.0 / diagonal.get(2, 0)));
            }
            if (center != null) {
                center.set(C.get(0, 0), C.get(1, 0), C.get(2, 0));
            }
            if (eigenVectors != null && eigenVectors.length == 3) {
                eigenVectors[0] = new Vector3d(eVec.get(0, 0), eVec.get(0, 1), eVec.get(0, 2));
                eigenVectors[1] = new Vector3d(eVec.get(1, 0), eVec.get(1, 1), eVec.get(1, 2));
                eigenVectors[2] = new Vector3d(eVec.get(2, 0), eVec.get(2, 1), eVec.get(2, 2));
            }
            if (equation != null && equation.length == 9) {
                System.arraycopy(v, 0, equation, 0, v.length);
            }
        }
        catch (RuntimeException e) {
            return;
        }
    }

    private static void fitEllipse(ROI2D roi, Point2d center, Point2d radii, VarDouble angle, Vector2d[] eigenVectors, double[] equation) throws RuntimeException, InterruptedException {
        Point[] points = roi.getBooleanMask(true).getContourPoints();
        if (points.length < 4) {
            return;
        }
        Point2D ccenter = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi).toPoint2D();
        double cx = ccenter.getX();
        double cy = ccenter.getY();
        double[][] d1 = new double[points.length][3];
        double[][] d2 = new double[points.length][3];
        for (int i = 0; i < d1.length; ++i) {
            double xixC = (double)points[i].x - cx;
            double yiyC = (double)points[i].y - cy;
            d1[i][0] = xixC * xixC;
            d1[i][1] = xixC * yiyC;
            d1[i][2] = yiyC * yiyC;
            d2[i][0] = xixC;
            d2[i][1] = yiyC;
            d2[i][2] = 1.0;
        }
        Matrix D1 = new Matrix(d1);
        Matrix D2 = new Matrix(d2);
        Matrix S1 = D1.transpose().times(D1);
        Matrix S2 = D1.transpose().times(D2);
        Matrix S3 = D2.transpose().times(D2);
        Matrix T = S3.inverse().times(-1.0).times(S2.transpose());
        Matrix M = S1.plus(S2.times(T));
        double[][] m = M.getArray();
        double[][] n = new double[][]{{m[2][0] / 2.0, m[2][1] / 2.0, m[2][2] / 2.0}, {-m[1][0], -m[1][1], -m[1][2]}, {m[0][0] / 2.0, m[0][1] / 2.0, m[0][2] / 2.0}};
        Matrix N = new Matrix((double[][])n);
        EigenvalueDecomposition E = N.eig();
        Matrix eVec = E.getV();
        Matrix R1 = eVec.getMatrix(0, 0, 0, 2);
        Matrix R2 = eVec.getMatrix(1, 1, 0, 2);
        Matrix R3 = eVec.getMatrix(2, 2, 0, 2);
        Matrix cond = R1.times(4.0).arrayTimes(R3).minus(R2.arrayTimes(R2));
        int _f = 0;
        for (int i = 0; i < 3; ++i) {
            if (!(cond.get(0, i) > 0.0)) continue;
            _f = i;
            break;
        }
        Matrix A1 = eVec.getMatrix(0, 2, _f, _f);
        Matrix A = new Matrix(6, 1);
        A.setMatrix(0, 2, 0, 0, A1);
        A.setMatrix(3, 5, 0, 0, T.times(A1));
        double[] ell = A.getColumnPackedCopy();
        double a4 = ell[3] - 2.0 * ell[0] * cx - ell[1] * cy;
        double a5 = ell[4] - 2.0 * ell[2] * cy - ell[1] * cx;
        double a6 = ell[5] + ell[0] * cx * cx + ell[2] * cy * cy + ell[1] * cx * cy - ell[3] * cx - ell[4] * cy;
        A.set(3, 0, a4);
        A.set(4, 0, a5);
        A.set(5, 0, a6);
        A = A.times(1.0 / A.normF());
        ell = A.getColumnPackedCopy();
        if (equation != null && equation.length != 6) {
            System.arraycopy(ell, 0, equation, 0, 6);
        }
        double a = ell[0];
        double b = ell[1] / 2.0;
        double c = ell[2];
        double d = ell[3] / 2.0;
        double f = ell[4] / 2.0;
        double g = ell[5];
        double cX = (c * d - b * f) / (b * b - a * c);
        double cY = (a * f - b * d) / (b * b - a * c);
        double af = 2.0 * (a * f * f + c * d * d + g * b * b - 2.0 * b * d * f - a * c * g);
        double aL = Math.sqrt(af / ((b * b - a * c) * (Math.sqrt((a - c) * (a - c) + 4.0 * b * b) - (a + c))));
        double bL = Math.sqrt(af / ((b * b - a * c) * (-Math.sqrt((a - c) * (a - c) + 4.0 * b * b) - (a + c))));
        double phi = 0.0;
        phi = b == 0.0 ? (Math.abs(a) <= Math.abs(c) ? 0.0 : 1.5707963267948966) : (Math.abs(a) <= Math.abs(c) ? Math.atan(2.0 * b / (a - c)) / 2.0 : Math.atan(2.0 * b / (a - c)) / 2.0 + 1.5707963267948966);
        if (center != null) {
            center.set(cX, cY);
        }
        if (radii != null) {
            radii.set(aL, bL);
        }
        if (angle != null) {
            angle.setValue((Object)phi);
        }
        if (eigenVectors != null) {
            eigenVectors[0] = new Vector2d(Math.cos(phi), Math.sin(phi));
            eigenVectors[1] = new Vector2d(Math.cos(phi + 1.5707963267948966), Math.sin(phi + 1.5707963267948966));
        }
    }

    private static Matrix diag(Matrix matrix) {
        int min = Math.min(matrix.getRowDimension(), matrix.getColumnDimension());
        double[][] diag = new double[min][1];
        for (int i = 0; i < min; ++i) {
            diag[i][0] = matrix.get(i, i);
        }
        return new Matrix(diag);
    }

    private static Matrix ones(int m, int n) {
        double[][] array;
        for (double[] row : array = new double[m][n]) {
            Arrays.fill(row, 1.0);
        }
        return new Matrix(array, m, n);
    }

    public String getMainPluginClassName() {
        return ROIMeasures.class.getName();
    }

    public static class ROIFlatness3D
    extends ROIDescriptor {
        protected ROIFlatness3D() {
            super("Flatness3D", Double.class);
        }

        public String getDescription() {
            return "<html>3D flatness</html>";
        }

        public String getUnit(Sequence sequence) {
            return "";
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIFlatness3D.computeFlatness3D(roi, sequence);
        }

        public static double computeFlatness3D(ROI roi, Sequence sequence) throws InterruptedException {
            return ROIFlatness3D.computeFlatness3D(ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence));
        }

        public static double computeFlatness3D(double[] ellipse) {
            if (ellipse == null) {
                return Double.NaN;
            }
            return ellipse[2] != 0.0 ? ellipse[1] / ellipse[2] : Double.NaN;
        }
    }

    public static class ROIElongation
    extends ROIDescriptor {
        protected ROIElongation() {
            super("Elongation", Double.class);
        }

        public String getDescription() {
            return "<html>Elongation ratio</html>";
        }

        public String getUnit(Sequence sequence) {
            return "";
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIElongation.computeElongation(roi, sequence);
        }

        public static double computeElongation(ROI roi, Sequence sequence) throws InterruptedException {
            return ROIElongation.computeElongation(ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence));
        }

        public static double computeElongation(double[] ellipse) {
            if (ellipse == null) {
                return Double.NaN;
            }
            return ellipse[1] != 0.0 ? ellipse[0] / ellipse[1] : Double.NaN;
        }
    }

    public static class ROIRollAngle
    extends ROIDescriptor {
        protected ROIRollAngle() {
            super("Roll", Double.class);
        }

        public String getDescription() {
            return "<html>Roll angle (counter-clockwise rotation around its first principal axis)</html>";
        }

        public String getUnit(Sequence sequence) {
            return "\u00b0";
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIRollAngle.computeRollAngle(roi, sequence);
        }

        public static double computeRollAngle(ROI roi, Sequence sequence) throws InterruptedException {
            if (roi instanceof ROI2D) {
                return 0.0;
            }
            return ROIRollAngle.computeRollAngle(ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence));
        }

        public static double computeRollAngle(double[] ellipse) {
            if (ellipse == null) {
                return Double.NaN;
            }
            return Math.toDegrees(Math.atan2(ellipse[8], ellipse[11]));
        }
    }

    public static class ROIPitchAngle
    extends ROIDescriptor {
        protected ROIPitchAngle() {
            super("Pitch", Double.class);
        }

        public String getDescription() {
            return "<html>Pitch angle (0 aligns with the X-Y plane, the sign follows the Z axis)</html>";
        }

        public String getUnit(Sequence sequence) {
            return "\u00b0";
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIPitchAngle.computePitchAngle(roi, sequence);
        }

        public static double computePitchAngle(ROI roi, Sequence sequence) throws InterruptedException {
            if (roi instanceof ROI2D) {
                return 0.0;
            }
            return ROIPitchAngle.computePitchAngle(ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence));
        }

        public static double computePitchAngle(double[] ellipse) {
            if (ellipse == null) {
                return Double.NaN;
            }
            return Math.toDegrees(Math.asin(ellipse[5]));
        }
    }

    public static class ROIYawAngle
    extends ROIDescriptor {
        protected ROIYawAngle() {
            super("Yaw", Double.class);
        }

        public String getDescription() {
            return "<html>Yaw angle (counter-clockwise, 0 aligns with the X axis)</html>";
        }

        public String getUnit(Sequence sequence) {
            return "\u00b0";
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIYawAngle.computeYawAngle(roi, sequence);
        }

        public static double computeYawAngle(ROI roi, Sequence sequence) throws InterruptedException {
            return ROIYawAngle.computeYawAngle(ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence));
        }

        public static double computeYawAngle(double[] ellipse) {
            if (ellipse == null) {
                return Double.NaN;
            }
            return Math.toDegrees(Math.acos(-ellipse[3]));
        }
    }

    public static class ROIThirdAxis
    extends ROIDescriptor {
        protected ROIThirdAxis() {
            super("3rd axis", Vector3d.class);
        }

        public String getDescription() {
            return "<html>Third principle axis of the best fitting ellipse</html>";
        }

        public String getUnit(Sequence sequence) {
            return ROIEllipsoidFittingDescriptor.getUnit(sequence);
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIThirdAxis.computeThirdAxis(roi, sequence);
        }

        public static Vector3d computeThirdAxis(ROI roi, Sequence sequence) throws InterruptedException {
            if (roi instanceof ROI2D) {
                return new Vector3d();
            }
            double[] ellipse = ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence);
            return new Vector3d(ellipse[9], ellipse[10], ellipse[11]);
        }
    }

    public static class ROISecondAxis
    extends ROIDescriptor {
        protected ROISecondAxis() {
            super("2nd axis", Vector3d.class);
        }

        public String getDescription() {
            return "<html>Second principle axis of the best fitting ellipse</html>";
        }

        public String getUnit(Sequence sequence) {
            return ROIEllipsoidFittingDescriptor.getUnit(sequence);
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROISecondAxis.computeSecondAxis(roi, sequence);
        }

        public static Vector3d computeSecondAxis(ROI roi, Sequence sequence) throws InterruptedException {
            double[] ellipse = ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence);
            return new Vector3d(ellipse[6], ellipse[7], ellipse[8]);
        }
    }

    public static class ROIFirstAxis
    extends ROIDescriptor {
        protected ROIFirstAxis() {
            super("1st axis", Vector3d.class);
        }

        public String getDescription() {
            return "<html>First principle axis of the best fitting ellipse</html>";
        }

        public String getUnit(Sequence sequence) {
            return ROIEllipsoidFittingDescriptor.getUnit(sequence);
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIFirstAxis.computeFirstAxis(roi, sequence);
        }

        public static Vector3d computeFirstAxis(ROI roi, Sequence sequence) throws InterruptedException {
            double[] ellipse = ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence);
            return new Vector3d(ellipse[3], ellipse[4], ellipse[5]);
        }
    }

    public static class ROIThirdDiameter
    extends ROIDescriptor {
        protected ROIThirdDiameter() {
            super("3rd Diameter", Double.class);
        }

        public String getDescription() {
            return "<html>Diameter of the best fitting ellipse along the third principle axis (0 in 2D)</html>";
        }

        public String getUnit(Sequence sequence) {
            return ROIEllipsoidFittingDescriptor.getUnit(sequence);
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIThirdDiameter.computeThirdDiameter(roi, sequence);
        }

        public static double computeThirdDiameter(ROI roi, Sequence sequence) throws InterruptedException {
            if (roi instanceof ROI2D) {
                return 0.0;
            }
            return ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence)[2];
        }
    }

    public static class ROISecondDiameter
    extends ROIDescriptor {
        protected ROISecondDiameter() {
            super("2nd Diameter", Double.class);
        }

        public String getDescription() {
            return "<html>Diameter of the best fitting ellipse along the second principle axis</html>";
        }

        public String getUnit(Sequence sequence) {
            return ROIEllipsoidFittingDescriptor.getUnit(sequence);
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROISecondDiameter.computeSecondDiameter(roi, sequence);
        }

        public static double computeSecondDiameter(ROI roi, Sequence sequence) throws InterruptedException {
            return ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence)[1];
        }
    }

    public static class ROIFirstDiameter
    extends ROIDescriptor {
        protected ROIFirstDiameter() {
            super("1st Diameter", Double.class);
        }

        public String getDescription() {
            return "<html>Diameter of the best fitting ellipse along the first principle axis</html>";
        }

        public String getUnit(Sequence sequence) {
            return ROIEllipsoidFittingDescriptor.getUnit(sequence);
        }

        public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
            return ROIFirstDiameter.computeFirstDiameter(roi, sequence);
        }

        public static double computeFirstDiameter(ROI roi, Sequence sequence) throws InterruptedException {
            return ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequence)[0];
        }
    }
}

