/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import java.util.ArrayList;
import net.phys2d.math.MathUtil;
import net.phys2d.math.Matrix2f;
import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.AbstractShape;
import net.phys2d.raw.shapes.DynamicShape;
import net.phys2d.raw.shapes.Line;

public strictfp class Box
extends AbstractShape
implements DynamicShape {
    private Vector2f size = new Vector2f();

    public Box(float width, float height) {
        this.size.set(width, height);
        this.bounds = new AABox(this.size.length(), this.size.length());
    }

    public ROVector2f getSize() {
        return this.size;
    }

    @Override
    public float getSurfaceFactor() {
        float x = this.size.getX();
        float y = this.size.getY();
        return x * x + y * y;
    }

    public Vector2f[] getPoints(ROVector2f pos, float rotation) {
        Matrix2f R = new Matrix2f(rotation);
        Vector2f[] pts = new Vector2f[4];
        Vector2f h = MathUtil.scale(this.getSize(), 0.5f);
        pts[0] = MathUtil.mul(R, new Vector2f(-h.getX(), -h.getY()));
        pts[0].add(pos);
        pts[1] = MathUtil.mul(R, new Vector2f(h.getX(), -h.getY()));
        pts[1].add(pos);
        pts[2] = MathUtil.mul(R, new Vector2f(h.getX(), h.getY()));
        pts[2].add(pos);
        pts[3] = MathUtil.mul(R, new Vector2f(-h.getX(), h.getY()));
        pts[3].add(pos);
        return pts;
    }

    @Override
    public boolean contains(Vector2f p, ROVector2f displacement, float rotation) {
        Vector2f[] correctedVertices = this.getPoints(displacement, rotation);
        ArrayList<Line> edges = new ArrayList<Line>();
        float xMin = correctedVertices[0].x;
        float yMin = correctedVertices[0].y;
        float xMax = correctedVertices[0].x;
        float yMax = correctedVertices[0].y;
        int l = correctedVertices.length;
        for (int i = 0; i < correctedVertices.length; ++i) {
            Vector2f vec1 = correctedVertices[i];
            Vector2f vec2 = correctedVertices[(i + 1) % l];
            xMin = Math.min(xMin, vec1.x);
            xMax = Math.max(xMax, vec1.x);
            yMin = Math.min(yMin, vec1.y);
            yMax = Math.max(yMax, vec1.y);
            Line line = new Line(vec1, vec2);
            edges.add(line);
        }
        if (p.x < xMin || p.x > xMax || p.y < yMin || p.y > yMax) {
            return false;
        }
        boolean oddNumberOfLines = false;
        float epsilon = (xMax - xMin) / 100.0f;
        Line ray = new Line(new Vector2f(xMin - epsilon, p.y), p);
        for (Line edge : edges) {
            Vector2f intersection;
            if (edge.getStart().getY() > p.y && edge.getEnd().getY() > p.y || edge.getStart().getY() < p.y && edge.getEnd().getY() < p.y || (intersection = ray.intersect(edge)) == null || !(intersection.x >= ray.getStart().getX()) || !(intersection.x <= ray.getEnd().getX())) continue;
            oddNumberOfLines = !oddNumberOfLines;
        }
        return oddNumberOfLines;
    }
}

