/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking;

import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import plugins.nchenouard.spot.DetectionResult;

public class DetectionChooser
extends JComboBox
implements SwimmingPoolListener {
    private static final long serialVersionUID = -6108163762809540675L;
    private final ArrayList<DetectionResultChooserListener> listeners;
    private DetectionResult previousDetectionResult;

    public DetectionChooser() {
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return new JLabel("Select detection results here");
                }
                if (value instanceof DetectionResult) {
                    return new JLabel(value.toString());
                }
                return new JLabel("");
            }
        });
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
        this.addActionListener(this);
        this.listeners = new ArrayList();
        this.previousDetectionResult = null;
        this.setSelectedItem(null);
        this.refreshDetectionResultList();
    }

    public DetectionResult getSelectedDetectionResult() {
        return (DetectionResult)this.getSelectedItem();
    }

    public void setDetectionResultSelected(DetectionResult detectionResult) {
        if (detectionResult != this.getSelectedDetectionResult()) {
            this.setSelectedItem(detectionResult);
        }
    }

    void refreshDetectionResultList() {
        Object oldSelected = this.getSelectedItem();
        this.setModel(new DetectionComboModel(this.getDetectionResultList()));
        this.setSelectedItem(oldSelected);
    }

    private ArrayList<DetectionResult> getDetectionResultList() {
        ArrayList<DetectionResult> detectionResultList = new ArrayList<DetectionResult>();
        ArrayList objects = Icy.getMainInterface().getSwimmingPool().getObjects();
        for (SwimmingObject so : objects) {
            System.out.println(so.getObject());
            Object o = so.getObject();
            System.out.println(o instanceof DetectionResult);
            if (!(so.getObject() instanceof DetectionResult)) continue;
            detectionResultList.add((DetectionResult)so.getObject());
        }
        return detectionResultList;
    }

    private void detectionResultChanged(DetectionResult detectionResult) {
        this.fireDetectionResultChanged(detectionResult);
    }

    private void fireDetectionResultChanged(DetectionResult detectionResult) {
        ArrayList<DetectionResultChooserListener> listenersCopy = this.getListeners();
        for (DetectionResultChooserListener listener : listenersCopy) {
            listener.DetectionResultChanged(detectionResult);
        }
    }

    public ArrayList<DetectionResultChooserListener> getListeners() {
        return new ArrayList<DetectionResultChooserListener>(this.listeners);
    }

    public void addListener(DetectionResultChooserListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DetectionResultChooserListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DetectionResult detectionResult = this.getSelectedDetectionResult();
        if (this.previousDetectionResult != detectionResult) {
            this.previousDetectionResult = detectionResult;
            this.detectionResultChanged(detectionResult);
        }
    }

    public void swimmingPoolChangeEvent(final SwimmingPoolEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DetectionChooser.this.refreshDetectionResultList();
                if (event.getResult().getObject() instanceof DetectionResult) {
                    DetectionChooser.this.setSelectedItem(event.getResult().getObject());
                }
            }
        });
    }

    private class DetectionComboModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 3064234412504253556L;
        final ArrayList<DetectionResult> detectionResults;

        public DetectionComboModel(ArrayList<DetectionResult> detectionResults) {
            this.detectionResults = detectionResults;
        }

        @Override
        public DetectionResult getElementAt(int index) {
            return this.detectionResults.get(index);
        }

        @Override
        public int getSize() {
            return this.detectionResults.size();
        }
    }

    public static interface DetectionResultChooserListener {
        public void DetectionResultChanged(DetectionResult var1);
    }
}

