/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.util;

import icy.plugin.abstract_.Plugin;
import icy.sequence.Sequence;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarFloat;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarString;

public class BlockAnnotations {
    private final Method method;

    public static Class<?> getInnerType(Class<? extends Var<?>> variableClass) {
        if (variableClass == VarInteger.class) {
            return Integer.class;
        }
        if (variableClass == VarDouble.class) {
            return Double.class;
        }
        if (variableClass == VarFloat.class) {
            return Float.class;
        }
        if (variableClass == VarBoolean.class) {
            return Boolean.class;
        }
        if (variableClass == VarFile.class) {
            return File.class;
        }
        if (variableClass == VarSequence.class) {
            return Sequence.class;
        }
        if (variableClass == VarString.class) {
            return String.class;
        }
        throw new UnsupportedOperationException("Unsupported type: " + variableClass.getSimpleName());
    }

    public static Class<? extends Var<?>> getVariableType(Class<?> clazz) {
        if (clazz == Integer.class) {
            return VarInteger.class;
        }
        if (clazz == Double.class) {
            return VarDouble.class;
        }
        if (clazz == Float.class) {
            return VarFloat.class;
        }
        if (clazz == Boolean.class) {
            return VarBoolean.class;
        }
        if (clazz == File.class) {
            return VarFile.class;
        }
        if (clazz == Sequence.class) {
            return VarSequence.class;
        }
        if (clazz == String.class) {
            return VarString.class;
        }
        throw new UnsupportedOperationException("Unsupported type: " + clazz.getSimpleName());
    }

    public static ArrayList<BlockAnnotations> findBlockMethods(Class<? extends Plugin> clazz) {
        Method[] methods;
        ArrayList<BlockAnnotations> blockDescriptors = new ArrayList<BlockAnnotations>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            BlockMethod blockFunction;
            if (!Modifier.isStatic(method.getModifiers()) || (blockFunction = method.getAnnotation(BlockMethod.class)) == null) continue;
            blockDescriptors.add(new BlockAnnotations(method));
        }
        return blockDescriptors;
    }

    public BlockAnnotations(Method method) {
        this.method = method;
    }

    public String getDescription() {
        return this.method.getAnnotation(BlockMethod.class).value();
    }

    public Block createBlock() {
        return new Block(){
            private Var outputVariable;
            private VarList inputMap;

            @Override
            public void run() {
                try {
                    Object[] arguments = new Object[this.inputMap.size()];
                    Iterator<Var<?>> inputIterator = this.inputMap.iterator();
                    for (int i = 0; i < arguments.length; ++i) {
                        arguments[i] = inputIterator.next().getValue();
                    }
                    Object result = BlockAnnotations.this.method.invoke(null, arguments);
                    if (this.outputVariable != null) {
                        this.outputVariable.setValue(result);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void declareOutput(VarList outputMap) {
                try {
                    Class<?> returnType = BlockAnnotations.this.method.getReturnType();
                    if (returnType == Void.TYPE) {
                        this.outputVariable = null;
                    } else {
                        Class<Var<?>> outputVarClass = BlockAnnotations.getVariableType(returnType);
                        Constructor<Var<?>> outputConstructor = outputVarClass.getDeclaredConstructor(String.class, returnType);
                        this.outputVariable = outputConstructor.newInstance("output (" + returnType.getSimpleName() + ")", null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.outputVariable != null) {
                    outputMap.add("output", this.outputVariable);
                }
            }

            @Override
            public void declareInput(VarList theInputMap) {
                this.inputMap = theInputMap;
                try {
                    Class<?>[] types = BlockAnnotations.this.method.getParameterTypes();
                    Annotation[][] annotations = BlockAnnotations.this.method.getParameterAnnotations();
                    for (int i = 0; i < types.length; ++i) {
                        Class<?> parameterClass = types[i];
                        String parameterName = parameterClass.getSimpleName();
                        for (Annotation annotation : annotations[i]) {
                            if (annotation.annotationType() != BlockInput.class) continue;
                            parameterName = ((BlockInput)annotation).value();
                        }
                        Class<Var<?>> inputVarClass = BlockAnnotations.getVariableType(parameterClass);
                        Constructor<Var<?>> inputConstructor = inputVarClass.getDeclaredConstructor(String.class, parameterClass);
                        Var<?> instance = inputConstructor.newInstance(parameterName, null);
                        theInputMap.add(instance.getName(), instance);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public String getName() {
        return this.method.getName();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    static @interface BlockInput {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface BlockMethod {
        public String value();
    }
}

