/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.Straightener;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public double x1d;
    public double y1d;
    public double x2d;
    public double y2d;
    protected double x1R;
    protected double y1R;
    protected double x2R;
    protected double y2R;
    protected double startxd;
    protected double startyd;
    static boolean widthChanged;
    private boolean dragged;
    private int mouseUpCount;
    private static final double[] PI_SEARCH;
    private static final double[] PI_MULT;

    public Line(int ox1, int oy1, int ox2, int oy2) {
        this((double)ox1, (double)oy1, (double)ox2, (double)oy2);
    }

    public Line(double ox1, double oy1, double ox2, double oy2) {
        super((int)(ox1 + 0.5), (int)(oy1 + 0.5), 0, 0);
        this.type = 5;
        this.updateCoordinates(ox1, oy1, ox2, oy2);
        if (!(this instanceof Arrow) && lineWidth > 1) {
            this.updateWideLine(lineWidth);
        }
        this.updateClipRect();
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.state = 3;
    }

    public static Line create(double x1, double y1, double x2, double y2) {
        return new Line(x1, y1, x2, y2);
    }

    public Line(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.type = 5;
        this.startxd = this.offScreenXD(sx);
        this.startyd = this.offScreenYD(sy);
        if (!this.magnificationForSubPixel()) {
            this.startxd = Math.round(this.startxd);
            this.startyd = Math.round(this.startyd);
        }
        this.updateCoordinates(this.startxd, this.startyd, this.startxd, this.startyd);
        if (!(this instanceof Arrow) && lineWidth > 1) {
            this.updateWideLine(lineWidth);
        }
    }

    public Line(int ox1, int oy1, int ox2, int oy2, ImagePlus imp) {
        this(ox1, oy1, ox2, oy2);
        this.setImage(imp);
    }

    @Override
    protected void grow(int sx, int sy) {
        this.drawLine(sx, sy);
        this.dragged = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.drawLine(e.getX(), e.getY());
    }

    @Override
    protected void handleMouseUp(int screenX, int screenY) {
        ++this.mouseUpCount;
        if (Prefs.enhancedLineTool && this.mouseUpCount == 1 && !this.dragged) {
            return;
        }
        this.state = 3;
        if (this.imp == null) {
            return;
        }
        this.imp.draw(this.clipX - 5, this.clipY - 5, this.clipWidth + 10, this.clipHeight + 10);
        if (Recorder.record) {
            String method = this instanceof Arrow ? "makeArrow" : "makeLine";
            Recorder.record(method, this.x1, this.y1, this.x2, this.y2);
        }
        if (this.getLength() == 0.0) {
            this.imp.deleteRoi();
        }
    }

    protected void drawLine(int sx, int sy) {
        double xend = this.offScreenXD(sx);
        double yend = this.offScreenYD(sy);
        if (xend < 0.0) {
            xend = 0.0;
        }
        if (yend < 0.0) {
            yend = 0.0;
        }
        if (xend > (double)this.xMax) {
            xend = this.xMax;
        }
        if (yend > (double)this.yMax) {
            yend = this.yMax;
        }
        double xstart = this.getXBase() + this.x1R;
        double ystart = this.getYBase() + this.y1R;
        if (this.constrain) {
            int i;
            double dy = Math.abs(yend - ystart);
            double dx = Math.abs(xend - xstart);
            double comp = dy / dx;
            for (i = 0; i < PI_SEARCH.length && !(comp < PI_SEARCH[i]); ++i) {
            }
            if (i < PI_SEARCH.length) {
                yend = yend > ystart ? ystart + dx * PI_MULT[i] : ystart - dx * PI_MULT[i];
            } else {
                xend = xstart;
            }
        }
        if (!this.magnificationForSubPixel() || IJ.controlKeyDown()) {
            xstart = Math.round(xstart);
            ystart = Math.round(ystart);
            xend = Math.round(xend);
            yend = Math.round(yend);
        }
        this.updateCoordinates(xstart, ystart, xend, yend);
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    @Override
    void move(int sx, int sy) {
        int xNew = this.offScreenX(sx);
        int yNew = this.offScreenY(sy);
        this.x = (int)((double)this.x + ((double)xNew - this.startxd));
        this.y = (int)((double)this.y + ((double)yNew - this.startyd));
        this.clipboard = null;
        this.startxd = xNew;
        this.startyd = yNew;
        this.updateClipRect();
        if (this.ignoreClipRect) {
            this.imp.draw();
        } else {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    @Override
    protected void moveHandle(int sx, int sy) {
        double dy;
        double dx;
        if (this.constrain && this.activeHandle == 2) {
            int dx2 = sx - this.previousSX;
            int dy2 = sy - this.previousSY;
            if (Math.abs(dx2) > Math.abs(dy2)) {
                dy2 = 0;
            } else {
                dx2 = 0;
            }
            sx = this.previousSX + dx2;
            sy = this.previousSY + dy2;
        }
        double ox = this.offScreenXD(sx);
        double oy = this.offScreenYD(sy);
        double x1d = this.getXBase() + this.x1R;
        double y1d = this.getYBase() + this.y1R;
        double x2d = this.getXBase() + this.x2R;
        double y2d = this.getYBase() + this.y2R;
        double length = Math.sqrt(Line.sqr(x2d - x1d) + Line.sqr(y2d - y1d));
        switch (this.activeHandle) {
            case 0: {
                dx = ox - x1d;
                dy = oy - y1d;
                x1d = ox;
                y1d = oy;
                if (this.center) {
                    x2d -= dx;
                    y2d -= dy;
                }
                if (!this.aspect) break;
                double ratio = length / Math.sqrt(Line.sqr(x2d - x1d) + Line.sqr(y2d - y1d));
                double xcd = x1d + (x2d - x1d) / 2.0;
                double ycd = y1d + (y2d - y1d) / 2.0;
                if (this.center) {
                    x1d = xcd - ratio * (xcd - x1d);
                    x2d = xcd + ratio * (x2d - xcd);
                    y1d = ycd - ratio * (ycd - y1d);
                    y2d = ycd + ratio * (y2d - ycd);
                    break;
                }
                x1d = x2d - ratio * (x2d - x1d);
                y1d = y2d - ratio * (y2d - y1d);
                break;
            }
            case 1: {
                dx = ox - x2d;
                dy = oy - y2d;
                x2d = ox;
                y2d = oy;
                if (this.center) {
                    x1d -= dx;
                    y1d -= dy;
                }
                if (!this.aspect) break;
                double ratio = length / Math.sqrt((x2d - x1d) * (x2d - x1d) + (y2d - y1d) * (y2d - y1d));
                double xcd = x1d + (x2d - x1d) / 2.0;
                double ycd = y1d + (y2d - y1d) / 2.0;
                if (this.center) {
                    x1d = xcd - ratio * (xcd - x1d);
                    x2d = xcd + ratio * (x2d - xcd);
                    y1d = ycd - ratio * (ycd - y1d);
                    y2d = ycd + ratio * (y2d - ycd);
                    break;
                }
                x2d = x1d + ratio * (x2d - x1d);
                y2d = y1d + ratio * (y2d - y1d);
                break;
            }
            case 2: {
                dx = ox - (x1d + (x2d - x1d) / 2.0);
                dy = oy - (y1d + (y2d - y1d) / 2.0);
                x1d += dx;
                y1d += dy;
                x2d += dx;
                y2d += dy;
            }
        }
        if (this.constrain) {
            dx = Math.abs(x1d - x2d);
            dy = Math.abs(y1d - y2d);
            double xcd = Math.min(x1d, x2d) + dx / 2.0;
            double ycd = Math.min(y1d, y2d) + dy / 2.0;
            if (this.activeHandle == 0) {
                if (dx >= dy) {
                    if (this.aspect) {
                        x1d = x2d > x1d ? x2d - length : x2d + length;
                    }
                    y1d = y2d;
                    if (this.center) {
                        y1d = y2d = ycd;
                        if (this.aspect) {
                            if (xcd > x1d) {
                                x1d = xcd - length / 2.0;
                                x2d = xcd + length / 2.0;
                            } else {
                                x1d = xcd + length / 2.0;
                                x2d = xcd - length / 2.0;
                            }
                        }
                    }
                } else {
                    if (this.aspect) {
                        y1d = y2d > y1d ? y2d - length : y2d + length;
                    }
                    x1d = x2d;
                    if (this.center) {
                        x1d = x2d = xcd;
                        if (this.aspect) {
                            if (ycd > y1d) {
                                y1d = ycd - length / 2.0;
                                y2d = ycd + length / 2.0;
                            } else {
                                y1d = ycd + length / 2.0;
                                y2d = ycd - length / 2.0;
                            }
                        }
                    }
                }
            } else if (this.activeHandle == 1) {
                if (dx >= dy) {
                    if (this.aspect) {
                        x2d = x1d > x2d ? x1d - length : x1d + length;
                    }
                    y2d = y1d;
                    if (this.center) {
                        y1d = y2d = ycd;
                        if (this.aspect) {
                            if (xcd > x1d) {
                                x1d = xcd - length / 2.0;
                                x2d = xcd + length / 2.0;
                            } else {
                                x1d = xcd + length / 2.0;
                                x2d = xcd - length / 2.0;
                            }
                        }
                    }
                } else {
                    if (this.aspect) {
                        y2d = y1d > y2d ? y1d - length : y1d + length;
                    }
                    x2d = x1d;
                    if (this.center) {
                        x1d = x2d = xcd;
                        if (this.aspect) {
                            if (ycd > y1d) {
                                y1d = ycd - length / 2.0;
                                y2d = ycd + length / 2.0;
                            } else {
                                y1d = ycd + length / 2.0;
                                y2d = ycd - length / 2.0;
                            }
                        }
                    }
                }
            }
        }
        if (!this.magnificationForSubPixel()) {
            x1d = Math.round(x1d);
            y1d = Math.round(y1d);
            x2d = Math.round(x2d);
            y2d = Math.round(y2d);
        }
        this.updateCoordinates(x1d, y1d, x2d, y2d);
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    @Override
    protected void mouseDownInHandle(int handle, int sx, int sy) {
        super.mouseDownInHandle(handle, sx, sy);
        if (this.getStrokeWidth() <= 3.0f) {
            this.ic.setCursor(new Cursor(1));
        }
    }

    void updateCoordinates(double x1d, double y1d, double x2d, double y2d) {
        this.x1d = x1d;
        this.y1d = y1d;
        this.x2d = x2d;
        this.y2d = y2d;
        Rectangle2D.Double bounds = this.bounds;
        if (bounds == null) {
            bounds = new Rectangle2D.Double();
        }
        bounds.x = Math.min(x1d, x2d);
        bounds.y = Math.min(y1d, y2d);
        bounds.width = Math.abs(x2d - x1d);
        bounds.height = Math.abs(y2d - y1d);
        this.setIntBounds(bounds);
        this.x1R = x1d - bounds.x;
        this.y1R = y1d - bounds.y;
        this.x2R = x2d - bounds.x;
        this.y2R = y2d - bounds.y;
        this.x1 = (int)x1d;
        this.y1 = (int)y1d;
        this.x2 = (int)x2d;
        this.y2 = (int)y2d;
        this.bounds = bounds;
    }

    @Override
    public void draw(Graphics g) {
        boolean cbar;
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        boolean isActiveOverlayRoi = !this.overlay && this.isActiveOverlayRoi();
        this.mag = this.getMagnification();
        if (isActiveOverlayRoi) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        g.setColor(color);
        this.x1d = this.getXBase() + this.x1R;
        this.y1d = this.getYBase() + this.y1R;
        this.x2d = this.getXBase() + this.x2R;
        this.y2d = this.getYBase() + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        int sx1 = this.screenXD(this.x1d);
        int sy1 = this.screenYD(this.y1d);
        int sx2 = this.screenXD(this.x2d);
        int sy2 = this.screenYD(this.y2d);
        int sx3 = sx1 + (sx2 - sx1) / 2;
        int sy3 = sy1 + (sy2 - sy1) / 2;
        Graphics2D g2d = (Graphics2D)g;
        this.setRenderingHint(g2d);
        boolean bl = cbar = this.overlay && this.mag < 1.0 && Math.abs((double)this.getStrokeWidth() - 1.0001) < 1.0E-4;
        if (this.stroke != null && !isActiveOverlayRoi && !cbar) {
            g2d.setStroke(this.getScaledStroke());
        } else if (cbar) {
            g2d.setStroke(onePixelWide);
        }
        if (this.wideLine && !isActiveOverlayRoi && !cbar) {
            double dx = sx2 - sx1;
            double dy = sy2 - sy1;
            double len = Line.length(dx, dy);
            g2d.draw(new Line2D.Double((double)sx1 - (dx *= 0.5 * this.mag / len), (double)sy1 - (dy *= 0.5 * this.mag / len), (double)sx2 + dx, (double)sy2 + dy));
        } else {
            g.drawLine(sx1, sy1, sx2, sy2);
        }
        if (this.wideLine && !this.overlay) {
            g2d.setStroke(onePixelWide);
            g.setColor(Line.getColor());
            g.drawLine(sx1, sy1, sx2, sy2);
        }
        if (!this.overlay) {
            this.handleColor = this.strokeColor != null ? this.strokeColor : ROIColor;
            this.drawHandle(g, sx1, sy1);
            this.handleColor = Color.white;
            this.drawHandle(g, sx2, sy2);
            this.drawHandle(g, sx3, sy3);
        }
        if (this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    @Override
    public void showStatus() {
        IJ.showStatus(this.imp.getLocationAsString((int)Math.round(this.x2d), (int)Math.round(this.y2d)) + ", angle=" + IJ.d2s(this.getAngle()) + ", length=" + IJ.d2s(this.getLength()));
    }

    @Override
    public double getAngle() {
        return this.getFloatAngle(this.x1d, this.y1d, this.x2d, this.y2d);
    }

    @Override
    public double getLength() {
        if (this.imp == null || IJ.altKeyDown()) {
            return this.getRawLength();
        }
        Calibration cal = this.imp.getCalibration();
        return Math.sqrt(Line.sqr((this.x2d - this.x1d) * cal.pixelWidth) + Line.sqr((this.y2d - this.y1d) * cal.pixelHeight));
    }

    public double getRawLength() {
        return Math.sqrt(Line.sqr(this.x2d - this.x1d) + Line.sqr(this.y2d - this.y1d));
    }

    public double[] getPixels() {
        double[] profile;
        if (this.getStrokeWidth() <= 1.0f) {
            ImageProcessor ip = this.imp.getProcessor();
            profile = ip.getLine(this.x1d, this.y1d, this.x2d, this.y2d);
        } else {
            ImageProcessor ip2 = new Straightener().rotateLine(this.imp, (int)this.getStrokeWidth());
            if (ip2 == null) {
                return new double[0];
            }
            int width = ip2.getWidth();
            int height = ip2.getHeight();
            if (ip2 instanceof FloatProcessor) {
                return ProfilePlot.getColumnAverageProfile(new Rectangle(0, 0, width, height), ip2);
            }
            profile = new double[width];
            ip2.setInterpolate(false);
            for (int y = 0; y < height; ++y) {
                double[] aLine = ip2.getLine(0.0, y, width - 1, y);
                for (int i = 0; i < width; ++i) {
                    int n = i;
                    profile[n] = profile[n] + aLine[i];
                }
            }
            int i = 0;
            while (i < width) {
                int n = i++;
                profile[n] = profile[n] / (double)height;
            }
        }
        return profile;
    }

    public Polygon getPoints() {
        Polygon p = new Polygon();
        p.addPoint((int)Math.round(this.x1d), (int)Math.round(this.y1d));
        p.addPoint((int)Math.round(this.x2d), (int)Math.round(this.y2d));
        return p;
    }

    public FloatPolygon getFloatPoints() {
        FloatPolygon p = new FloatPolygon();
        p.addPoint((float)this.x1d, (float)this.y1d);
        p.addPoint((float)this.x2d, (float)this.y2d);
        return p;
    }

    @Override
    public Polygon getPolygon() {
        FloatPolygon p = this.getFloatPolygon();
        return new Polygon(Line.toIntR(p.xpoints), Line.toIntR(p.ypoints), p.npoints);
    }

    @Override
    public FloatPolygon getFloatPolygon() {
        return this.getFloatPolygon(this.getStrokeWidth());
    }

    public FloatPolygon getFloatPolygon(double strokeWidth) {
        FloatPolygon p = new FloatPolygon();
        if (strokeWidth <= 1.0) {
            p.addPoint((float)this.x1d, (float)this.y1d);
            p.addPoint((float)this.x2d, (float)this.y2d);
        } else {
            double dx = this.x2d - this.x1d;
            double dy = this.y2d - this.y1d;
            double len = Line.length(dx, dy);
            double p1x = this.x1d + 0.5 - (dx *= 0.5 / len) + (dy *= 0.5 / len) * strokeWidth;
            double p1y = this.y1d + 0.5 - dy - dx * strokeWidth;
            double p2x = this.x1d + 0.5 - dx - dy * strokeWidth;
            double p2y = this.y1d + 0.5 - dy + dx * strokeWidth;
            double p3x = this.x2d + 0.5 + dx - dy * strokeWidth;
            double p3y = this.y2d + 0.5 + dy + dx * strokeWidth;
            double p4x = this.x2d + 0.5 + dx + dy * strokeWidth;
            double p4y = this.y2d + 0.5 + dy - dx * strokeWidth;
            p.addPoint((float)p1x, (float)p1y);
            p.addPoint((float)p2x, (float)p2y);
            p.addPoint((float)p3x, (float)p3y);
            p.addPoint((float)p4x, (float)p4y);
        }
        return p;
    }

    @Override
    public int size() {
        return this.getStrokeWidth() <= 1.0f ? 2 : 4;
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(1);
        double x = this.getXBase();
        double y = this.getYBase();
        this.x1d = this.getXBase() + this.x1R;
        this.y1d = this.getYBase() + this.y1R;
        this.x2d = this.getXBase() + this.x2R;
        this.y2d = this.getYBase() + this.y2R;
        if (this.getStrokeWidth() <= 1.0f) {
            ip.moveTo((int)Math.round(this.x1d), (int)Math.round(this.y1d));
            ip.lineTo((int)Math.round(this.x2d), (int)Math.round(this.y2d));
        } else {
            Polygon p = this.getPolygon();
            ip.drawPolygon(p);
            this.updateFullWindow = true;
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getStrokeWidth() > 1.0f) {
            if (x == this.x1 && y == this.y1 || x == this.x2 && y == this.y2) {
                return true;
            }
            return this.getPolygon().contains(x, y);
        }
        return false;
    }

    @Override
    protected void handleMouseDown(int sx, int sy) {
        super.handleMouseDown(sx, sy);
        this.startxd = this.ic.offScreenXD(sx);
        this.startyd = this.ic.offScreenYD(sy);
    }

    @Override
    public int isHandle(int sx, int sy) {
        int size = 10;
        if (this.getStrokeWidth() > 1.0f) {
            size += (int)Math.log(this.getStrokeWidth());
        }
        int halfSize = size / 2;
        int sx1 = this.screenXD(this.getXBase() + this.x1R) - halfSize;
        int sy1 = this.screenYD(this.getYBase() + this.y1R) - halfSize;
        int sx2 = this.screenXD(this.getXBase() + this.x2R) - halfSize;
        int sy2 = this.screenYD(this.getYBase() + this.y2R) - halfSize;
        int sx3 = sx1 + (sx2 - sx1) / 2 - 1;
        int sy3 = sy1 + (sy2 - sy1) / 2 - 1;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy2 && sy <= sy2 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size + 2 && sy >= sy3 && sy <= sy3 + size + 2) {
            return 2;
        }
        return -1;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int w) {
        int max;
        if (w < 1) {
            w = 1;
        }
        if (w > (max = 500)) {
            ImagePlus imp2 = WindowManager.getCurrentImage();
            if (imp2 != null) {
                max = Math.max(max, imp2.getWidth());
                max = Math.max(max, imp2.getHeight());
            }
            if (w > max) {
                w = max;
            }
        }
        lineWidth = w;
        widthChanged = true;
    }

    @Override
    public void setStrokeWidth(float width) {
        super.setStrokeWidth(width);
        if (this.getStrokeColor() == Roi.getColor()) {
            this.wideLine = true;
        }
    }

    @Override
    protected int clipRectMargin() {
        return 4;
    }

    @Override
    public void nudgeCorner(int key) {
        if (this.ic == null) {
            return;
        }
        double inc = 1.0 / this.ic.getMagnification();
        switch (key) {
            case 38: {
                this.y2R -= inc;
                break;
            }
            case 40: {
                this.y2R += inc;
                break;
            }
            case 37: {
                this.x2R -= inc;
                break;
            }
            case 39: {
                this.x2R += inc;
            }
        }
        this.grow(this.screenXD((double)this.x + this.x2R), this.screenYD((double)this.y + this.y2R));
        this.notifyListeners(2);
        this.showStatus();
    }

    @Override
    public boolean subPixelResolution() {
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
        this.setLocation((double)x, (double)y);
    }

    @Override
    public void setLocation(double x, double y) {
        this.updateCoordinates(x + this.x1R, y + this.y1R, x + this.x2R, y + this.y2R);
    }

    @Override
    public FloatPolygon getRotationCenter() {
        double xcenter = this.x1d + (this.x2d - this.x1d) / 2.0;
        double ycenter = this.y1d + (this.y2d - this.y1d) / 2.0;
        FloatPolygon p = new FloatPolygon();
        p.addPoint(xcenter, ycenter);
        return p;
    }

    @Override
    public Iterator<Point> iterator() {
        if ((double)this.getStrokeWidth() <= 1.0) {
            return new PointIterator(this);
        }
        return super.iterator();
    }

    static {
        PI_SEARCH = new double[]{Math.tan(0.39269908169872414), Math.tan(1.1780972450961724)};
        PI_MULT = new double[]{0.0, 1.0};
    }

    public static class PointIterator
    implements Iterator<Point> {
        private double x1;
        private double y1;
        private final int n;
        private final double xinc;
        private final double yinc;
        private double x;
        private double y;
        private int u;
        private int v;
        private int u_prev;
        private int v_prev;
        private int i;

        public PointIterator(Line line) {
            this(line.x1d, line.y1d, line.x2d, line.y2d);
        }

        public PointIterator(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            double dx = x2 - x1;
            double dy = y2 - y1;
            this.n = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy));
            this.xinc = dx / (double)this.n;
            this.yinc = dy / (double)this.n;
            this.x = x1;
            this.y = y1;
            this.u = (int)Math.round(this.x - 0.5);
            this.v = (int)Math.round(this.y - 0.5);
            this.u_prev = Integer.MIN_VALUE;
            this.v_prev = Integer.MIN_VALUE;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i <= this.n;
        }

        @Override
        public Point next() {
            if (this.i > this.n) {
                throw new NoSuchElementException();
            }
            Point p = new Point(this.u, this.v);
            this.moveToNext();
            return p;
        }

        private void moveToNext() {
            do {
                ++this.i;
                this.x = this.x1 + (double)this.i * this.xinc;
                this.y = this.y1 + (double)this.i * this.yinc;
                this.u_prev = this.u;
                this.v_prev = this.v;
                this.u = (int)Math.round(this.x - 0.5);
                this.v = (int)Math.round(this.y - 0.5);
            } while (this.i <= this.n && this.u == this.u_prev && this.v == this.v_prev);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

