/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.ImportDialog;
import ij.io.OpenDialog;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.FolderOpener;
import ij.plugin.PlugIn;
import java.io.File;

public class Raw
implements PlugIn {
    private static String defaultDirectory = null;

    @Override
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open Raw...", arg);
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        ImportDialog d = new ImportDialog(fileName, directory);
        d.openImage();
    }

    public static ImagePlus open(String filePath, FileInfo fi) {
        File f = new File(filePath);
        String parent = f.getParent();
        if (parent != null) {
            fi.directory = parent + "/";
        }
        fi.fileName = f.getName();
        return new FileOpener(fi).open(false);
    }

    public static ImagePlus openAll(String directory, FileInfo fi) {
        ImagePlus imp = Raw.openAllVirtual(directory, fi);
        if (imp != null) {
            return imp.duplicate();
        }
        return null;
    }

    public static ImagePlus openAllVirtual(String directory, FileInfo fi) {
        String[] list = new File(directory).list();
        if (list == null) {
            return null;
        }
        FolderOpener fo = new FolderOpener();
        list = fo.trimFileList(list);
        if ((list = fo.sortFileList(list)) == null) {
            return null;
        }
        directory = IJ.addSeparator(directory);
        FileInfo[] info = new FileInfo[list.length];
        for (int i = 0; i < list.length; ++i) {
            info[i] = (FileInfo)fi.clone();
            info[i].directory = directory;
            info[i].fileName = list[i];
        }
        FileInfoVirtualStack stack = new FileInfoVirtualStack(info);
        ImagePlus imp = new ImagePlus(directory, stack);
        return imp;
    }
}

