/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;

public class TJUnitTest {
    private static final String classname = new TJUnitTest().getClass().getName();
    private static final String[] subNameLong = new String[]{"4:4:4", "4:2:2", "4:2:0", "GRAY", "4:4:0"};
    private static final String[] subName = new String[]{"444", "422", "420", "GRAY", "440"};
    private static final String[] pixFormatStr = new String[]{"RGB", "BGR", "RGBX", "BGRX", "XBGR", "XRGB", "Grayscale", "RGBA", "BGRA", "ABGR", "ARGB"};
    private static final int[] alphaOffset = new int[]{-1, -1, -1, -1, -1, -1, -1, 3, 3, 0, 0};
    private static final int[] _3byteFormats = new int[]{0, 1};
    private static final int[] _3byteFormatsBI = new int[]{5};
    private static final int[] _4byteFormats = new int[]{2, 3, 4, 5};
    private static final int[] _4byteFormatsBI = new int[]{4, 1, 6, 7, 2, 3};
    private static final int[] onlyGray = new int[]{6};
    private static final int[] onlyGrayBI = new int[]{10};
    private static final int[] onlyRGB = new int[]{0};
    private static final int YUVENCODE = 1;
    private static final int YUVDECODE = 2;
    private static int yuv = 0;
    private static boolean bi = false;
    private static int exitStatus = 0;

    private static void usage() {
        System.out.println("\nUSAGE: java " + classname + " [options]\n");
        System.out.println("Options:\n");
        System.out.println("-yuv = test YUV encoding/decoding support\n");
        System.out.println("-bi = test BufferedImage support\n");
        System.exit(1);
    }

    private static int biTypePF(int biType) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        switch (biType) {
            case 5: {
                return 1;
            }
            case 6: 
            case 7: {
                return 4;
            }
            case 10: {
                return 6;
            }
            case 4: {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return 4;
                }
                return 2;
            }
            case 1: {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return 5;
                }
                return 3;
            }
            case 2: 
            case 3: {
                if (byteOrder == ByteOrder.BIG_ENDIAN) {
                    return 10;
                }
                return 8;
            }
        }
        return 0;
    }

    private static String biTypeStr(int biType) {
        switch (biType) {
            case 5: {
                return "3BYTE_BGR";
            }
            case 6: {
                return "4BYTE_ABGR";
            }
            case 7: {
                return "4BYTE_ABGR_PRE";
            }
            case 10: {
                return "BYTE_GRAY";
            }
            case 4: {
                return "INT_BGR";
            }
            case 1: {
                return "INT_RGB";
            }
            case 2: {
                return "INT_ARGB";
            }
            case 3: {
                return "INT_ARGB_PRE";
            }
        }
        return "Unknown";
    }

    private static double getTime() {
        return (double)System.nanoTime() / 1.0E9;
    }

    private static void initBuf(byte[] buf, int w, int pitch, int h2, int pf, int flags) throws Exception {
        int roffset = TJ.getRedOffset(pf);
        int goffset = TJ.getGreenOffset(pf);
        int boffset = TJ.getBlueOffset(pf);
        int aoffset = alphaOffset[pf];
        int ps = TJ.getPixelSize(pf);
        int halfway = 16;
        Arrays.fill(buf, (byte)0);
        if (pf == 6) {
            for (int row = 0; row < h2; ++row) {
                for (int col = 0; col < w; ++col) {
                    int index = (flags & 2) != 0 ? pitch * (h2 - row - 1) + col : pitch * row + col;
                    buf[index] = (row / 8 + col / 8) % 2 == 0 ? (row < halfway ? -1 : 0) : (row < halfway ? 76 : -30);
                }
            }
            return;
        }
        for (int row = 0; row < h2; ++row) {
            for (int col = 0; col < w; ++col) {
                int index = (flags & 2) != 0 ? pitch * (h2 - row - 1) + col * ps : pitch * row + col * ps;
                if ((row / 8 + col / 8) % 2 == 0) {
                    if (row < halfway) {
                        buf[index + roffset] = -1;
                        buf[index + goffset] = -1;
                        buf[index + boffset] = -1;
                    }
                } else {
                    buf[index + roffset] = -1;
                    if (row >= halfway) {
                        buf[index + goffset] = -1;
                    }
                }
                if (aoffset < 0) continue;
                buf[index + aoffset] = -1;
            }
        }
    }

    private static void initIntBuf(int[] buf, int w, int pitch, int h2, int pf, int flags) throws Exception {
        int rshift = TJ.getRedOffset(pf) * 8;
        int gshift = TJ.getGreenOffset(pf) * 8;
        int bshift = TJ.getBlueOffset(pf) * 8;
        int ashift = alphaOffset[pf] * 8;
        int halfway = 16;
        Arrays.fill(buf, 0);
        for (int row = 0; row < h2; ++row) {
            for (int col = 0; col < w; ++col) {
                int index = (flags & 2) != 0 ? pitch * (h2 - row - 1) + col : pitch * row + col;
                if ((row / 8 + col / 8) % 2 == 0) {
                    if (row < halfway) {
                        int n = index;
                        buf[n] = buf[n] | 255 << rshift;
                        int n2 = index;
                        buf[n2] = buf[n2] | 255 << gshift;
                        int n3 = index;
                        buf[n3] = buf[n3] | 255 << bshift;
                    }
                } else {
                    int n = index;
                    buf[n] = buf[n] | 255 << rshift;
                    if (row >= halfway) {
                        int n4 = index;
                        buf[n4] = buf[n4] | 255 << gshift;
                    }
                }
                if (ashift < 0) continue;
                int n = index;
                buf[n] = buf[n] | 255 << ashift;
            }
        }
    }

    private static void initImg(BufferedImage img, int pf, int flags) throws Exception {
        WritableRaster wr = img.getRaster();
        int imgType = img.getType();
        if (imgType == 1 || imgType == 4 || imgType == 2 || imgType == 3) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)img.getSampleModel();
            int pitch = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            int[] buf = db.getData();
            TJUnitTest.initIntBuf(buf, img.getWidth(), pitch, img.getHeight(), pf, flags);
        } else {
            ComponentSampleModel sm = (ComponentSampleModel)img.getSampleModel();
            int pitch = sm.getScanlineStride();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] buf = db.getData();
            TJUnitTest.initBuf(buf, img.getWidth(), pitch, img.getHeight(), pf, flags);
        }
    }

    private static void checkVal(int row, int col, int v, String vname, int cv) throws Exception {
        int n = v = v < 0 ? v + 256 : v;
        if (v < cv - 1 || v > cv + 1) {
            throw new Exception("\nComp. " + vname + " at " + row + "," + col + " should be " + cv + ", not " + v + "\n");
        }
    }

    private static void checkVal0(int row, int col, int v, String vname) throws Exception {
        int n = v = v < 0 ? v + 256 : v;
        if (v > 1) {
            throw new Exception("\nComp. " + vname + " at " + row + "," + col + " should be 0, not " + v + "\n");
        }
    }

    private static void checkVal255(int row, int col, int v, String vname) throws Exception {
        int n = v = v < 0 ? v + 256 : v;
        if (v < 254) {
            throw new Exception("\nComp. " + vname + " at " + row + "," + col + " should be 255, not " + v + "\n");
        }
    }

    private static int checkBuf(byte[] buf, int w, int pitch, int h2, int pf, int subsamp, TJScalingFactor sf, int flags) throws Exception {
        int b;
        int g2;
        int col;
        int row;
        int roffset = TJ.getRedOffset(pf);
        int goffset = TJ.getGreenOffset(pf);
        int boffset = TJ.getBlueOffset(pf);
        int aoffset = alphaOffset[pf];
        int ps = TJ.getPixelSize(pf);
        int retval = 1;
        int halfway = 16 * sf.getNum() / sf.getDenom();
        int blockSize = 8 * sf.getNum() / sf.getDenom();
        try {
            for (row = 0; row < halfway; ++row) {
                for (col = 0; col < w; ++col) {
                    int a;
                    int index = (flags & 2) != 0 ? pitch * (h2 - row - 1) + col * ps : pitch * row + col * ps;
                    byte r = buf[index + roffset];
                    g2 = buf[index + goffset];
                    b = buf[index + boffset];
                    int n = a = aoffset >= 0 ? buf[index + aoffset] : -1;
                    if ((row / blockSize + col / blockSize) % 2 == 0) {
                        if (row < halfway) {
                            TJUnitTest.checkVal255(row, col, r, "R");
                            TJUnitTest.checkVal255(row, col, g2, "G");
                            TJUnitTest.checkVal255(row, col, b, "B");
                        } else {
                            TJUnitTest.checkVal0(row, col, r, "R");
                            TJUnitTest.checkVal0(row, col, g2, "G");
                            TJUnitTest.checkVal0(row, col, b, "B");
                        }
                    } else if (subsamp == 3) {
                        if (row < halfway) {
                            TJUnitTest.checkVal(row, col, r, "R", 76);
                            TJUnitTest.checkVal(row, col, g2, "G", 76);
                            TJUnitTest.checkVal(row, col, b, "B", 76);
                        } else {
                            TJUnitTest.checkVal(row, col, r, "R", 226);
                            TJUnitTest.checkVal(row, col, g2, "G", 226);
                            TJUnitTest.checkVal(row, col, b, "B", 226);
                        }
                    } else {
                        TJUnitTest.checkVal255(row, col, r, "R");
                        if (row < halfway) {
                            TJUnitTest.checkVal0(row, col, g2, "G");
                        } else {
                            TJUnitTest.checkVal255(row, col, g2, "G");
                        }
                        TJUnitTest.checkVal0(row, col, b, "B");
                    }
                    TJUnitTest.checkVal255(row, col, a, "A");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            retval = 0;
        }
        if (retval == 0) {
            System.out.print("\n");
            for (row = 0; row < h2; ++row) {
                for (col = 0; col < w; ++col) {
                    int r = buf[pitch * row + col * ps + roffset];
                    g2 = buf[pitch * row + col * ps + goffset];
                    b = buf[pitch * row + col * ps + boffset];
                    if (r < 0) {
                        r += 256;
                    }
                    if (g2 < 0) {
                        g2 += 256;
                    }
                    if (b < 0) {
                        b += 256;
                    }
                    System.out.format("%3d/%3d/%3d ", r, g2, b);
                }
                System.out.print("\n");
            }
        }
        return retval;
    }

    private static int checkIntBuf(int[] buf, int w, int pitch, int h2, int pf, int subsamp, TJScalingFactor sf, int flags) throws Exception {
        int b;
        int g2;
        int col;
        int row;
        int rshift = TJ.getRedOffset(pf) * 8;
        int gshift = TJ.getGreenOffset(pf) * 8;
        int bshift = TJ.getBlueOffset(pf) * 8;
        int ashift = alphaOffset[pf] * 8;
        int retval = 1;
        int halfway = 16 * sf.getNum() / sf.getDenom();
        int blockSize = 8 * sf.getNum() / sf.getDenom();
        try {
            for (row = 0; row < halfway; ++row) {
                for (col = 0; col < w; ++col) {
                    int a;
                    int index = (flags & 2) != 0 ? pitch * (h2 - row - 1) + col : pitch * row + col;
                    int r = buf[index] >> rshift & 0xFF;
                    g2 = buf[index] >> gshift & 0xFF;
                    b = buf[index] >> bshift & 0xFF;
                    int n = a = ashift >= 0 ? buf[index] >> ashift & 0xFF : 255;
                    if ((row / blockSize + col / blockSize) % 2 == 0) {
                        if (row < halfway) {
                            TJUnitTest.checkVal255(row, col, r, "R");
                            TJUnitTest.checkVal255(row, col, g2, "G");
                            TJUnitTest.checkVal255(row, col, b, "B");
                        } else {
                            TJUnitTest.checkVal0(row, col, r, "R");
                            TJUnitTest.checkVal0(row, col, g2, "G");
                            TJUnitTest.checkVal0(row, col, b, "B");
                        }
                    } else if (subsamp == 3) {
                        if (row < halfway) {
                            TJUnitTest.checkVal(row, col, r, "R", 76);
                            TJUnitTest.checkVal(row, col, g2, "G", 76);
                            TJUnitTest.checkVal(row, col, b, "B", 76);
                        } else {
                            TJUnitTest.checkVal(row, col, r, "R", 226);
                            TJUnitTest.checkVal(row, col, g2, "G", 226);
                            TJUnitTest.checkVal(row, col, b, "B", 226);
                        }
                    } else {
                        TJUnitTest.checkVal255(row, col, r, "R");
                        if (row < halfway) {
                            TJUnitTest.checkVal0(row, col, g2, "G");
                        } else {
                            TJUnitTest.checkVal255(row, col, g2, "G");
                        }
                        TJUnitTest.checkVal0(row, col, b, "B");
                    }
                    TJUnitTest.checkVal255(row, col, a, "A");
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            retval = 0;
        }
        if (retval == 0) {
            System.out.print("\n");
            for (row = 0; row < h2; ++row) {
                for (col = 0; col < w; ++col) {
                    int r = buf[pitch * row + col] >> rshift & 0xFF;
                    g2 = buf[pitch * row + col] >> gshift & 0xFF;
                    b = buf[pitch * row + col] >> bshift & 0xFF;
                    if (r < 0) {
                        r += 256;
                    }
                    if (g2 < 0) {
                        g2 += 256;
                    }
                    if (b < 0) {
                        b += 256;
                    }
                    System.out.format("%3d/%3d/%3d ", r, g2, b);
                }
                System.out.print("\n");
            }
        }
        return retval;
    }

    private static int checkImg(BufferedImage img, int pf, int subsamp, TJScalingFactor sf, int flags) throws Exception {
        WritableRaster wr = img.getRaster();
        int imgType = img.getType();
        if (imgType == 1 || imgType == 4 || imgType == 2 || imgType == 3) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)img.getSampleModel();
            int pitch = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            int[] buf = db.getData();
            return TJUnitTest.checkIntBuf(buf, img.getWidth(), pitch, img.getHeight(), pf, subsamp, sf, flags);
        }
        ComponentSampleModel sm = (ComponentSampleModel)img.getSampleModel();
        int pitch = sm.getScanlineStride();
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] buf = db.getData();
        return TJUnitTest.checkBuf(buf, img.getWidth(), pitch, img.getHeight(), pf, subsamp, sf, flags);
    }

    private static int PAD(int v, int p) {
        return v + p - 1 & ~(p - 1);
    }

    private static int checkBufYUV(byte[] buf, int size, int w, int h2, int subsamp) throws Exception {
        int col;
        int row;
        int hsf = TJ.getMCUWidth(subsamp) / 8;
        int vsf = TJ.getMCUHeight(subsamp) / 8;
        int pw = TJUnitTest.PAD(w, hsf);
        int ph = TJUnitTest.PAD(h2, vsf);
        int cw = pw / hsf;
        int ch = ph / vsf;
        int ypitch = TJUnitTest.PAD(pw, 4);
        int uvpitch = TJUnitTest.PAD(cw, 4);
        int retval = 1;
        int correctsize = ypitch * ph + (subsamp == 3 ? 0 : uvpitch * ch * 2);
        int halfway = 16;
        try {
            if (size != correctsize) {
                throw new Exception("\nIncorrect size " + size + ".  Should be " + correctsize);
            }
            for (row = 0; row < ph; ++row) {
                for (col = 0; col < pw; ++col) {
                    byte y = buf[ypitch * row + col];
                    if ((row / 8 + col / 8) % 2 == 0) {
                        if (row < halfway) {
                            TJUnitTest.checkVal255(row, col, y, "Y");
                            continue;
                        }
                        TJUnitTest.checkVal0(row, col, y, "Y");
                        continue;
                    }
                    if (row < halfway) {
                        TJUnitTest.checkVal(row, col, y, "Y", 76);
                        continue;
                    }
                    TJUnitTest.checkVal(row, col, y, "Y", 226);
                }
            }
            if (subsamp != 3) {
                halfway = 16 / vsf;
                for (row = 0; row < ch; ++row) {
                    for (col = 0; col < cw; ++col) {
                        byte u = buf[ypitch * ph + (uvpitch * row + col)];
                        byte v = buf[ypitch * ph + uvpitch * ch + (uvpitch * row + col)];
                        if ((row * vsf / 8 + col * hsf / 8) % 2 == 0) {
                            TJUnitTest.checkVal(row, col, u, "U", 128);
                            TJUnitTest.checkVal(row, col, v, "V", 128);
                            continue;
                        }
                        if (row < halfway) {
                            TJUnitTest.checkVal(row, col, u, "U", 85);
                            TJUnitTest.checkVal255(row, col, v, "V");
                            continue;
                        }
                        TJUnitTest.checkVal0(row, col, u, "U");
                        TJUnitTest.checkVal(row, col, v, "V", 149);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            retval = 0;
        }
        if (retval == 0) {
            for (row = 0; row < ph; ++row) {
                for (col = 0; col < pw; ++col) {
                    int y = buf[ypitch * row + col];
                    if (y < 0) {
                        y += 256;
                    }
                    System.out.format("%3d ", y);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
            for (row = 0; row < ch; ++row) {
                for (col = 0; col < cw; ++col) {
                    int u = buf[ypitch * ph + (uvpitch * row + col)];
                    if (u < 0) {
                        u += 256;
                    }
                    System.out.format("%3d ", u);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
            for (row = 0; row < ch; ++row) {
                for (col = 0; col < cw; ++col) {
                    int v = buf[ypitch * ph + uvpitch * ch + (uvpitch * row + col)];
                    if (v < 0) {
                        v += 256;
                    }
                    System.out.format("%3d ", v);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
        }
        return retval;
    }

    private static void writeJPEG(byte[] jpegBuf, int jpegBufSize, String filename) throws Exception {
        File file2 = new File(filename);
        FileOutputStream fos = new FileOutputStream(file2);
        fos.write(jpegBuf, 0, jpegBufSize);
        fos.close();
    }

    private static int compTest(TJCompressor tjc, byte[] dstBuf, int w, int h2, int pf, String baseName, int subsamp, int jpegQual, int flags) throws Exception {
        String tempstr;
        String pfStr;
        byte[] srcBuf = null;
        BufferedImage img = null;
        int size = 0;
        int imgType = pf;
        if (bi) {
            pf = TJUnitTest.biTypePF(imgType);
            pfStr = TJUnitTest.biTypeStr(imgType);
        } else {
            pfStr = pixFormatStr[pf];
        }
        int ps = TJ.getPixelSize(pf);
        System.out.print(pfStr + " ");
        if (bi) {
            System.out.print("(" + pixFormatStr[pf] + ") ");
        }
        if ((flags & 2) != 0) {
            System.out.print("Bottom-Up");
        } else {
            System.out.print("Top-Down ");
        }
        System.out.print(" -> " + subNameLong[subsamp] + " ");
        if (yuv == 1) {
            System.out.print("YUV ... ");
        } else {
            System.out.print("Q" + jpegQual + " ... ");
        }
        if (bi) {
            img = new BufferedImage(w, h2, imgType);
            TJUnitTest.initImg(img, pf, flags);
            tempstr = baseName + "_enc_" + pfStr + "_" + ((flags & 2) != 0 ? "BU" : "TD") + "_" + subName[subsamp] + "_Q" + jpegQual + ".png";
            File file2 = new File(tempstr);
            ImageIO.write((RenderedImage)img, "png", file2);
        } else {
            srcBuf = new byte[w * h2 * ps + 1];
            TJUnitTest.initBuf(srcBuf, w, w * ps, h2, pf, flags);
        }
        Arrays.fill(dstBuf, (byte)0);
        double t2 = TJUnitTest.getTime();
        tjc.setSubsamp(subsamp);
        tjc.setJPEGQuality(jpegQual);
        if (bi) {
            if (yuv == 1) {
                tjc.encodeYUV(img, dstBuf, flags);
            } else {
                tjc.compress(img, dstBuf, flags);
            }
        } else {
            tjc.setSourceImage(srcBuf, w, 0, h2, pf);
            if (yuv == 1) {
                tjc.encodeYUV(dstBuf, flags);
            } else {
                tjc.compress(dstBuf, flags);
            }
        }
        size = tjc.getCompressedSize();
        t2 = TJUnitTest.getTime() - t2;
        tempstr = yuv == 1 ? baseName + "_enc_" + pfStr + "_" + ((flags & 2) != 0 ? "BU" : "TD") + "_" + subName[subsamp] + ".yuv" : baseName + "_enc_" + pfStr + "_" + ((flags & 2) != 0 ? "BU" : "TD") + "_" + subName[subsamp] + "_Q" + jpegQual + ".jpg";
        TJUnitTest.writeJPEG(dstBuf, size, tempstr);
        if (yuv == 1) {
            if (TJUnitTest.checkBufYUV(dstBuf, size, w, h2, subsamp) == 1) {
                System.out.print("Passed.");
            } else {
                System.out.print("FAILED!");
                exitStatus = -1;
            }
        } else {
            System.out.print("Done.");
        }
        System.out.format("  %.6f ms\n", t2 * 1000.0);
        System.out.println("  Result in " + tempstr);
        return size;
    }

    private static void decompTest(TJDecompressor tjd, byte[] jpegBuf, int jpegSize, int w, int h2, int pf, String baseName, int subsamp, int flags, TJScalingFactor sf) throws Exception {
        String pfStr;
        int scaledWidth = sf.getScaled(w);
        int scaledHeight = sf.getScaled(h2);
        int imgType = pf;
        BufferedImage img = null;
        byte[] dstBuf = null;
        if (yuv == 1) {
            return;
        }
        if (bi) {
            pf = TJUnitTest.biTypePF(imgType);
            pfStr = TJUnitTest.biTypeStr(imgType);
        } else {
            pfStr = pixFormatStr[pf];
        }
        System.out.print("JPEG -> ");
        if (yuv == 2) {
            System.out.print("YUV " + subName[subsamp] + " ... ");
        } else {
            System.out.print(pfStr + " ");
            if (bi) {
                System.out.print("(" + pixFormatStr[pf] + ") ");
            }
            if ((flags & 2) != 0) {
                System.out.print("Bottom-Up ");
            } else {
                System.out.print("Top-Down  ");
            }
            if (!sf.isOne()) {
                System.out.print(sf.getNum() + "/" + sf.getDenom() + " ... ");
            } else {
                System.out.print("... ");
            }
        }
        double t2 = TJUnitTest.getTime();
        tjd.setJPEGImage(jpegBuf, jpegSize);
        if (tjd.getWidth() != w || tjd.getHeight() != h2 || tjd.getSubsamp() != subsamp) {
            throw new Exception("Incorrect JPEG header");
        }
        int temp1 = scaledWidth;
        int temp2 = scaledHeight;
        temp1 = tjd.getScaledWidth(temp1, temp2);
        temp2 = tjd.getScaledHeight(temp1, temp2);
        if (temp1 != scaledWidth || temp2 != scaledHeight) {
            throw new Exception("Scaled size mismatch");
        }
        if (yuv == 2) {
            dstBuf = tjd.decompressToYUV(flags);
        } else if (bi) {
            img = tjd.decompress(scaledWidth, scaledHeight, imgType, flags);
        } else {
            dstBuf = tjd.decompress(scaledWidth, 0, scaledHeight, pf, flags);
        }
        t2 = TJUnitTest.getTime() - t2;
        if (bi) {
            String tempstr = baseName + "_dec_" + pfStr + "_" + ((flags & 2) != 0 ? "BU" : "TD") + "_" + subName[subsamp] + "_" + (double)sf.getNum() / (double)sf.getDenom() + "x.png";
            File file2 = new File(tempstr);
            ImageIO.write((RenderedImage)img, "png", file2);
        }
        if (yuv == 2) {
            if (TJUnitTest.checkBufYUV(dstBuf, dstBuf.length, w, h2, subsamp) == 1) {
                System.out.print("Passed.");
            } else {
                System.out.print("FAILED!");
                exitStatus = -1;
            }
        } else if (bi && TJUnitTest.checkImg(img, pf, subsamp, sf, flags) == 1 || !bi && TJUnitTest.checkBuf(dstBuf, scaledWidth, scaledWidth * TJ.getPixelSize(pf), scaledHeight, pf, subsamp, sf, flags) == 1) {
            System.out.print("Passed.");
        } else {
            System.out.print("FAILED!");
            exitStatus = -1;
        }
        System.out.format("  %.6f ms\n", t2 * 1000.0);
    }

    private static void decompTest(TJDecompressor tjd, byte[] jpegBuf, int jpegSize, int w, int h2, int pf, String baseName, int subsamp, int flags) throws Exception {
        if ((subsamp == 0 || subsamp == 3) && yuv == 0) {
            TJScalingFactor[] sf = TJ.getScalingFactors();
            for (int i = 0; i < sf.length; ++i) {
                TJUnitTest.decompTest(tjd, jpegBuf, jpegSize, w, h2, pf, baseName, subsamp, flags, sf[i]);
            }
        } else {
            TJUnitTest.decompTest(tjd, jpegBuf, jpegSize, w, h2, pf, baseName, subsamp, flags, new TJScalingFactor(1, 1));
        }
        System.out.print("\n");
    }

    private static void doTest(int w, int h2, int[] formats, int subsamp, String baseName) throws Exception {
        TJCompressor tjc = null;
        TJDecompressor tjd = null;
        byte[] dstBuf = yuv == 1 ? new byte[TJ.bufSizeYUV(w, h2, subsamp)] : new byte[TJ.bufSize(w, h2, subsamp)];
        try {
            tjc = new TJCompressor();
            tjd = new TJDecompressor();
            for (int pf : formats) {
                for (int i = 0; i < 2; ++i) {
                    int flags = 0;
                    if (subsamp == 1 || subsamp == 2 || subsamp == 4) {
                        flags |= 0x100;
                    }
                    if (i == 1) {
                        if (yuv == 2) {
                            tjc.close();
                            tjd.close();
                            return;
                        }
                        flags |= 2;
                    }
                    int size = TJUnitTest.compTest(tjc, dstBuf, w, h2, pf, baseName, subsamp, 100, flags);
                    TJUnitTest.decompTest(tjd, dstBuf, size, w, h2, pf, baseName, subsamp, flags);
                    if (pf < 2 || pf > 5 || bi) continue;
                    TJUnitTest.decompTest(tjd, dstBuf, size, w, h2, pf + 5, baseName, subsamp, flags);
                }
            }
        }
        catch (Exception e) {
            if (tjc != null) {
                tjc.close();
            }
            if (tjd != null) {
                tjd.close();
            }
            throw e;
        }
        if (tjc != null) {
            tjc.close();
        }
        if (tjd != null) {
            tjd.close();
        }
    }

    private static void bufSizeTest() throws Exception {
        TJCompressor tjc = null;
        Random r = new Random();
        try {
            tjc = new TJCompressor();
            System.out.println("Buffer size regression test");
            for (int subsamp = 0; subsamp < 5; ++subsamp) {
                for (int w = 1; w < 48; ++w) {
                    int maxh = w == 1 ? 2048 : 48;
                    for (int h2 = 1; h2 < maxh; ++h2) {
                        int i;
                        if (h2 % 100 == 0) {
                            System.out.format("%04d x %04d\b\b\b\b\b\b\b\b\b\b\b", w, h2);
                        }
                        byte[] srcBuf = new byte[w * h2 * 4];
                        byte[] jpegBuf = new byte[TJ.bufSize(w, h2, subsamp)];
                        for (i = 0; i < w * h2 * 4; ++i) {
                            srcBuf[i] = (byte)(r.nextInt(2) * 255);
                        }
                        tjc.setSourceImage(srcBuf, w, 0, h2, 3);
                        tjc.setSubsamp(subsamp);
                        tjc.setJPEGQuality(100);
                        tjc.compress(jpegBuf, 0);
                        srcBuf = new byte[h2 * w * 4];
                        jpegBuf = new byte[TJ.bufSize(h2, w, subsamp)];
                        for (i = 0; i < h2 * w * 4; ++i) {
                            srcBuf[i] = (byte)(r.nextInt(2) * 255);
                        }
                        tjc.setSourceImage(srcBuf, h2, 0, w, 3);
                        tjc.compress(jpegBuf, 0);
                    }
                }
            }
            System.out.println("Done.      ");
        }
        catch (Exception e) {
            if (tjc != null) {
                tjc.close();
            }
            throw e;
        }
        if (tjc != null) {
            tjc.close();
        }
    }

    public static void main(String[] argv) {
        try {
            String testName = "javatest";
            boolean doyuv = false;
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equalsIgnoreCase("-yuv")) {
                    doyuv = true;
                }
                if (argv[i].substring(0, 1).equalsIgnoreCase("-h") || argv[i].equalsIgnoreCase("-?")) {
                    TJUnitTest.usage();
                }
                if (!argv[i].equalsIgnoreCase("-bi")) continue;
                bi = true;
                testName = "javabitest";
            }
            if (doyuv) {
                yuv = 1;
            }
            TJUnitTest.doTest(35, 39, bi ? _3byteFormatsBI : _3byteFormats, 0, testName);
            TJUnitTest.doTest(39, 41, bi ? _4byteFormatsBI : _4byteFormats, 0, testName);
            TJUnitTest.doTest(41, 35, bi ? _3byteFormatsBI : _3byteFormats, 1, testName);
            TJUnitTest.doTest(35, 39, bi ? _4byteFormatsBI : _4byteFormats, 1, testName);
            TJUnitTest.doTest(39, 41, bi ? _3byteFormatsBI : _3byteFormats, 2, testName);
            TJUnitTest.doTest(41, 35, bi ? _4byteFormatsBI : _4byteFormats, 2, testName);
            TJUnitTest.doTest(35, 39, bi ? _3byteFormatsBI : _3byteFormats, 4, testName);
            TJUnitTest.doTest(39, 41, bi ? _4byteFormatsBI : _4byteFormats, 4, testName);
            TJUnitTest.doTest(35, 39, bi ? onlyGrayBI : onlyGray, 3, testName);
            TJUnitTest.doTest(39, 41, bi ? _3byteFormatsBI : _3byteFormats, 3, testName);
            TJUnitTest.doTest(41, 35, bi ? _4byteFormatsBI : _4byteFormats, 3, testName);
            if (!doyuv && !bi) {
                TJUnitTest.bufSizeTest();
            }
            if (doyuv && !bi) {
                yuv = 2;
                TJUnitTest.doTest(48, 48, onlyRGB, 0, "javatest_yuv0");
                TJUnitTest.doTest(35, 39, onlyRGB, 0, "javatest_yuv1");
                TJUnitTest.doTest(48, 48, onlyRGB, 1, "javatest_yuv0");
                TJUnitTest.doTest(39, 41, onlyRGB, 1, "javatest_yuv1");
                TJUnitTest.doTest(48, 48, onlyRGB, 2, "javatest_yuv0");
                TJUnitTest.doTest(41, 35, onlyRGB, 2, "javatest_yuv1");
                TJUnitTest.doTest(48, 48, onlyRGB, 4, "javatest_yuv0");
                TJUnitTest.doTest(35, 39, onlyRGB, 4, "javatest_yuv1");
                TJUnitTest.doTest(48, 48, onlyRGB, 3, "javatest_yuv0");
                TJUnitTest.doTest(35, 39, onlyRGB, 3, "javatest_yuv1");
                TJUnitTest.doTest(48, 48, onlyGray, 3, "javatest_yuv0");
                TJUnitTest.doTest(39, 41, onlyGray, 3, "javatest_yuv1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            exitStatus = -1;
        }
        System.exit(exitStatus);
    }
}

