/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.meta.MetadataStore;

public class APNGReader
extends FormatReader {
    private static final int GRAYSCALE = 0;
    private static final int TRUE_COLOR = 2;
    private static final int INDEXED = 3;
    private static final int GRAY_ALPHA = 4;
    private static final int TRUE_ALPHA = 6;
    private static final int NONE = 0;
    private static final int SUB = 1;
    private static final int UP = 2;
    private static final int AVERAGE = 3;
    private static final int PAETH = 4;
    private static final int[] PASS_WIDTHS = new int[]{1, 1, 2, 2, 4, 4, 8};
    private static final int[] PASS_HEIGHTS = new int[]{1, 1, 1, 2, 2, 4, 4};
    private Vector<PNGBlock> blocks;
    private Vector<int[]> frameCoordinates;
    private byte[][] lut;
    private byte[] lastImage;
    private int lastImageIndex = -1;
    private int lastImageRow = -1;
    private int compression;
    private int interlace;
    private int idatCount = 0;

    public APNGReader() {
        super("Animated PNG", "png");
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        byte[] signature = new byte[8];
        stream.read(signature);
        return signature[0] == -119 && signature[1] == 80 && signature[2] == 78 && signature[3] == 71 && signature[4] == 13 && signature[5] == 10 && signature[6] == 26 && signature[7] == 10;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (no == this.lastImageIndex && this.lastImage != null && y + h2 <= this.lastImageRow) {
            try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.lastImage);){
                this.readPlane(s2, x, y, w, h2, buf);
            }
            return buf;
        }
        if (no == 0) {
            this.lastImage = null;
            try (PNGInputStream stream = new PNGInputStream("IDAT");){
                int decodeHeight = y + h2;
                if (decodeHeight < this.getSizeY() && decodeHeight % 8 != 0) {
                    decodeHeight += Math.min(8 - decodeHeight % 8, this.getSizeY() - decodeHeight);
                }
                this.lastImage = this.decode(stream, this.getSizeX(), decodeHeight);
            }
            this.lastImageIndex = 0;
            this.lastImageRow = y + h2;
            var8_11 = null;
            try (RandomAccessInputStream pix = new RandomAccessInputStream(this.lastImage);){
                this.readPlane(pix, x, y, w, h2, buf);
            }
            catch (Throwable decodeHeight) {
                var8_11 = decodeHeight;
                throw decodeHeight;
            }
            if (y + h2 < this.getSizeY()) {
                this.lastImage = null;
            }
            return buf;
        }
        int[] coords = this.frameCoordinates.get(no);
        this.lastImage = this.openBytes(0);
        this.lastImageRow = this.getSizeY();
        byte[] newImage = null;
        try (PNGInputStream stream = new PNGInputStream("fdAT", no);){
            newImage = this.decode(stream, coords[2], coords[3]);
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int len = coords[2] * bpp;
        int plane = this.getSizeX() * this.getSizeY() * bpp;
        int newPlane = len * coords[3];
        if (!this.isInterleaved()) {
            for (int c = 0; c < this.getRGBChannelCount(); ++c) {
                for (int row = 0; row < coords[3]; ++row) {
                    System.arraycopy(newImage, c * newPlane + row * len, this.lastImage, c * plane + (coords[1] + row) * this.getSizeX() * bpp + coords[0] * bpp, len);
                }
            }
        } else {
            len *= this.getRGBChannelCount();
            for (int row = 0; row < coords[3]; ++row) {
                System.arraycopy(newImage, row * len, this.lastImage, (coords[1] + row) * this.getSizeX() * bpp * this.getRGBChannelCount() + coords[0] * bpp * this.getRGBChannelCount(), len);
            }
        }
        this.lastImageIndex = no;
        try (RandomAccessInputStream pix = new RandomAccessInputStream(this.lastImage);){
            this.readPlane(pix, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.frameCoordinates = null;
            this.blocks = null;
            this.lastImage = null;
            this.lastImageIndex = -1;
            this.lastImageRow = -1;
            this.compression = 0;
            this.interlace = 0;
            this.idatCount = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        byte[] signature = new byte[8];
        this.in.read(signature);
        if (signature[0] != -119 || signature[1] != 80 || signature[2] != 78 || signature[3] != 71 || signature[4] != 13 || signature[5] != 10 || signature[6] != 26 || signature[7] != 10) {
            throw new FormatException("Invalid PNG signature.");
        }
        this.blocks = new Vector();
        this.frameCoordinates = new Vector();
        while (this.in.getFilePointer() < this.in.length()) {
            int length = this.in.readInt();
            String type = this.in.readString(4);
            PNGBlock block = new PNGBlock();
            block.length = length;
            block.type = type;
            block.offset = this.in.getFilePointer();
            this.blocks.add(block);
            if (type.equals("acTL")) {
                m4.imageCount = this.in.readInt();
                int loop = this.in.readInt();
                this.addGlobalMeta("Loop count", loop);
            } else if (type.equals("fcTL")) {
                this.in.skipBytes(4);
                int w = this.in.readInt();
                int h2 = this.in.readInt();
                int x = this.in.readInt();
                int y = this.in.readInt();
                this.frameCoordinates.add(new int[]{x, y, w, h2});
                this.in.skipBytes(length - 20);
            } else if (type.equals("IDAT")) {
                ++this.idatCount;
            } else if (type.equals("PLTE")) {
                m4.indexed = true;
                this.lut = new byte[3][256];
                for (int i = 0; i < length / 3; ++i) {
                    for (int c = 0; c < 3; ++c) {
                        this.lut[c][i] = this.in.readByte();
                    }
                }
            } else if (type.equals("IHDR")) {
                m4.sizeX = this.in.readInt();
                m4.sizeY = this.in.readInt();
                m4.bitsPerPixel = this.in.read();
                int colorType = this.in.read();
                this.compression = this.in.read();
                int filter = this.in.read();
                this.interlace = this.in.read();
                if (filter != 0) {
                    throw new FormatException("Invalid filter mode: " + filter);
                }
                switch (colorType) {
                    case 0: 
                    case 3: {
                        m4.sizeC = 1;
                        break;
                    }
                    case 4: {
                        m4.sizeC = 2;
                        break;
                    }
                    case 2: {
                        m4.sizeC = 3;
                        break;
                    }
                    case 6: {
                        m4.sizeC = 4;
                    }
                }
                m4.pixelType = this.getBitsPerPixel() <= 8 ? 1 : 3;
                m4.rgb = this.getSizeC() > 1;
            } else if (type.equals("IEND")) break;
            this.in.seek(block.offset + (long)length);
            if (this.in.getFilePointer() >= this.in.length() - 4L) continue;
            this.in.skipBytes(4);
        }
        if (m4.imageCount == 0) {
            m4.imageCount = 1;
        }
        m4.sizeZ = 1;
        m4.sizeT = this.getImageCount();
        m4.dimensionOrder = "XYCTZ";
        m4.interleaved = this.isRGB();
        m4.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private byte[] decode(PNGInputStream bytes) throws FormatException, IOException {
        return this.decode(bytes, this.getSizeX(), this.getSizeY());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decode(PNGInputStream bytes, int width, int height) throws FormatException, IOException {
        int row;
        Throwable throwable;
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int rowLen = width * this.getRGBChannelCount() * bpp;
        if (width > this.getSizeX()) {
            throw new FormatException("Width (" + width + ") exceeds image width (" + this.getSizeX() + ")");
        }
        if (height > this.getSizeY()) {
            throw new FormatException("Height (" + height + ") exceeds image height (" + this.getSizeY() + ")");
        }
        if (this.getBitsPerPixel() < bpp * 8) {
            int div = bpp * 8 / this.getBitsPerPixel();
            if (div < rowLen) {
                int originalRowLen;
                if ((rowLen /= div) * div < (originalRowLen = rowLen)) {
                    ++rowLen;
                }
            } else {
                rowLen = 1;
            }
        }
        byte[] image = null;
        if (this.compression == 0 && this.interlace == 0) {
            byte[] filters = new byte[height];
            image = new byte[rowLen * height];
            throwable = null;
            try (InflaterInputStream decompressor = new InflaterInputStream(bytes);){
                int n = 0;
                for (row = 0; row < height; ++row) {
                    n = 0;
                    while (n < 1) {
                        n = decompressor.read(filters, row, 1);
                    }
                    for (n = 0; n < rowLen; n += decompressor.read(image, row * rowLen + n, rowLen - n)) {
                    }
                }
            }
            catch (Throwable n) {
                throwable = n;
                throw n;
            }
            this.unfilter(filters, image, width, height);
        } else {
            if (this.compression != 0) {
                throw new UnsupportedCompressionException("Compression type " + this.compression + " not supported");
            }
            boolean byteCount = false;
            byte[][] passImages = new byte[7][];
            int nRowBlocks = this.getSizeY() / 8;
            int nColBlocks = this.getSizeX() / 8;
            if (8 * nRowBlocks != this.getSizeY()) {
                ++nRowBlocks;
            }
            if (8 * nColBlocks != this.getSizeX()) {
                ++nColBlocks;
            }
            if (nRowBlocks <= 0) {
                nRowBlocks = 1;
            }
            if (nColBlocks <= 0) {
                nColBlocks = 1;
            }
            image = new byte[FormatTools.getPlaneSize(this)];
            try (InflaterInputStream decompressor = new InflaterInputStream(bytes);){
                for (int i = 0; i < passImages.length; ++i) {
                    int passWidth = PASS_WIDTHS[i] * nColBlocks;
                    int passHeight = PASS_HEIGHTS[i] * nRowBlocks;
                    if (nColBlocks * 8 != width) {
                        int extraCols = this.getSizeX() - (nColBlocks - 1) * 8;
                        switch (extraCols) {
                            case 1: {
                                if (i == 1 || i == 3 || i == 5) {
                                    passWidth -= PASS_WIDTHS[i];
                                }
                                if (i != 2 && i != 4 && i != 6) break;
                                passWidth -= PASS_WIDTHS[i] - 1;
                                break;
                            }
                            case 2: {
                                if (i == 1 || i == 3) {
                                    passWidth -= PASS_WIDTHS[i];
                                }
                                if (i == 2 || i == 4 || i == 5) {
                                    passWidth -= PASS_WIDTHS[i] - 1;
                                }
                                if (i != 6) break;
                                passWidth -= PASS_WIDTHS[i] - 2;
                                break;
                            }
                            case 3: {
                                if (i == 1) {
                                    passWidth -= PASS_WIDTHS[i];
                                }
                                if (i == 2 || i == 3 || i == 5) {
                                    passWidth -= PASS_WIDTHS[i] - 1;
                                }
                                if (i == 4) {
                                    passWidth -= PASS_WIDTHS[i] - 2;
                                }
                                if (i != 6) break;
                                passWidth -= PASS_WIDTHS[i] - 3;
                                break;
                            }
                            case 4: {
                                if (i == 1) {
                                    passWidth -= PASS_WIDTHS[i];
                                }
                                if (i == 2 || i == 3) {
                                    passWidth -= PASS_WIDTHS[i] - 1;
                                }
                                if (i == 4 || i == 5) {
                                    passWidth -= PASS_WIDTHS[i] - 2;
                                }
                                if (i != 6) break;
                                passWidth -= PASS_WIDTHS[i] - 4;
                                break;
                            }
                            case 5: {
                                if (i == 3) {
                                    passWidth -= PASS_WIDTHS[i] - 1;
                                }
                                if (i == 5) {
                                    passWidth -= PASS_WIDTHS[i] - 2;
                                }
                                if (i == 4) {
                                    passWidth -= PASS_WIDTHS[i] - 3;
                                }
                                if (i != 6) break;
                                passWidth -= PASS_WIDTHS[i] - 5;
                                break;
                            }
                            case 6: {
                                if (i == 3) {
                                    passWidth -= PASS_WIDTHS[i] - 1;
                                }
                                if (i == 4 || i == 5) {
                                    passWidth -= PASS_WIDTHS[i] - 3;
                                }
                                if (i != 6) break;
                                passWidth -= PASS_WIDTHS[i] - 6;
                                break;
                            }
                            case 7: {
                                if (i != 5 && i != 6) break;
                                --passWidth;
                                break;
                            }
                        }
                    }
                    int rowSize = passWidth * bpp * this.getRGBChannelCount();
                    byte[] filters = new byte[passHeight];
                    passImages[i] = new byte[rowSize * passHeight];
                    block49: for (int row2 = 0; row2 < passHeight; ++row2) {
                        if (passWidth == 0) continue;
                        if (nRowBlocks * 8 != this.getSizeY() && row2 >= PASS_HEIGHTS[i] * (nRowBlocks - 1)) {
                            int extraRows = this.getSizeY() - (nRowBlocks - 1) * 8;
                            switch (extraRows) {
                                case 1: {
                                    if (i != 2 && i != 4 && i != 6 && (i != 3 && i != 5 || row2 % PASS_HEIGHTS[i] <= 0)) break;
                                    continue block49;
                                }
                                case 2: {
                                    if (i != 4 && i != 2 && (i != 3 && i != 5 && i != 6 || row2 % PASS_HEIGHTS[i] <= 0)) break;
                                    continue block49;
                                }
                                case 3: {
                                    if (i != 2 && (i != 3 && i != 4 && i != 6 || row2 % PASS_HEIGHTS[i] <= 0) && (i != 5 || row2 % PASS_HEIGHTS[i] <= 1)) break;
                                    continue block49;
                                }
                                case 4: {
                                    if (i != 2 && (i != 3 && i != 4 || row2 % PASS_HEIGHTS[i] <= 0) && (i != 5 && i != 6 || row2 % PASS_HEIGHTS[i] <= 1)) break;
                                    continue block49;
                                }
                                case 5: {
                                    if (!(i == 4 && row2 % PASS_HEIGHTS[i] > 0 || i == 6 && row2 % PASS_HEIGHTS[i] > 1) && (i != 5 || row2 % PASS_HEIGHTS[i] <= 2)) break;
                                    continue block49;
                                }
                                case 6: {
                                    if ((i != 4 || row2 % PASS_HEIGHTS[i] <= 0) && (i != 5 && i != 6 || row2 % PASS_HEIGHTS[i] <= 2)) break;
                                    continue block49;
                                }
                                case 7: {
                                    if (i == 6 && row2 % PASS_HEIGHTS[i] > 2) continue block49;
                                }
                            }
                        }
                        int n = 0;
                        while (n < 1) {
                            n = decompressor.read(filters, row2, 1);
                        }
                        for (n = 0; n < rowSize; n += decompressor.read(passImages[i], row2 * rowSize + n, rowSize - n)) {
                        }
                    }
                    this.unfilter(filters, passImages[i], passWidth, passHeight);
                }
            }
            int chunk = bpp * this.getRGBChannelCount();
            int[] passOffset = new int[7];
            for (int row3 = 0; row3 < 8 * (height / 8); ++row3) {
                int rowOffset = row3 * width * chunk;
                for (int col = 0; col < width; ++col) {
                    int blockRow = row3 % 8;
                    int blockCol = col % 8;
                    int pass = -1;
                    pass = blockRow % 2 == 1 ? 6 : (blockRow == 0 || blockRow == 4 ? (blockCol % 2 == 1 ? 5 : (blockCol == 0 ? (blockRow == 0 ? 0 : 2) : (blockCol == 4 ? (blockRow == 0 ? 1 : 2) : 3))) : 4 + blockCol % 2);
                    int colOffset = col * chunk;
                    for (int c = 0; c < chunk; ++c) {
                        if (passOffset[pass] >= passImages[pass].length) continue;
                        int n = pass;
                        int n2 = passOffset[n];
                        passOffset[n] = n2 + 1;
                        image[rowOffset + colOffset + c] = passImages[pass][n2];
                    }
                }
            }
        }
        if (this.getBitsPerPixel() >= 8) return image;
        byte[] expandedImage = new byte[FormatTools.getPlaneSize(this)];
        throwable = null;
        try (RandomAccessInputStream bits = new RandomAccessInputStream(image);){
            int skipBits = rowLen * 8 - this.getSizeX() * this.getBitsPerPixel();
            row = 0;
            while (row < this.getSizeY()) {
                for (int col = 0; col < this.getSizeX(); ++col) {
                    int index = row * this.getSizeX() + col;
                    expandedImage[index] = (byte)(bits.readBits(this.getBitsPerPixel()) & 0xFF);
                }
                bits.skipBits(skipBits);
                ++row;
            }
            return expandedImage;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void unfilter(byte[] filters, byte[] image, int width, int height) throws FormatException {
        int bpp = this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.getPixelType());
        int rowLen = width * bpp;
        for (int row = 0; row < height; ++row) {
            byte filter = filters[row];
            if (filter == 0) continue;
            block7: for (int col = 0; col < rowLen; ++col) {
                int q = row * rowLen + col;
                int xx = image[q] & 0xFF;
                int a = col >= bpp ? image[q - bpp] & 0xFF : 0;
                int b = row > 0 ? image[q - bpp * width] & 0xFF : 0;
                int c = row > 0 && col >= bpp ? image[q - bpp * (width + 1)] & 0xFF : 0;
                switch (filter) {
                    case 1: {
                        image[q] = (byte)(xx + a & 0xFF);
                        continue block7;
                    }
                    case 2: {
                        image[q] = (byte)(xx + b & 0xFF);
                        continue block7;
                    }
                    case 3: {
                        image[q] = (byte)(xx + (int)Math.floor(a + b) / 2 & 0xFF);
                        continue block7;
                    }
                    case 4: {
                        int p = a + b - c;
                        int pa = Math.abs(p - a);
                        int pb = Math.abs(p - b);
                        int pc = Math.abs(p - c);
                        if (pa <= pb && pa <= pc) {
                            image[q] = (byte)(xx + a & 0xFF);
                            continue block7;
                        }
                        if (pb <= pc) {
                            image[q] = (byte)(xx + b & 0xFF);
                            continue block7;
                        }
                        image[q] = (byte)(xx + c & 0xFF);
                        continue block7;
                    }
                    default: {
                        throw new FormatException("Unknown filter: " + filter);
                    }
                }
            }
        }
    }

    class PNGInputStream
    extends InputStream {
        private int currentBlock = -1;
        private int blockPointer = 0;
        private int blockLength = 0;
        private String blockType;
        private int imageNumber;
        private int fctlCount = 0;
        private boolean fdatValid = false;

        public PNGInputStream(String blockType) throws IOException {
            this(blockType, 0);
        }

        public PNGInputStream(String blockType, int imageNumber) throws IOException {
            this.imageNumber = imageNumber;
            this.blockType = blockType;
            this.fctlCount = 0;
            this.fdatValid = false;
            this.advanceBlock();
        }

        @Override
        public int available() throws IOException {
            if (this.blockPointer == this.blockLength) {
                this.advanceBlock();
            }
            if (this.currentBlock < 0 || APNGReader.this.in.getFilePointer() == APNGReader.this.in.length()) {
                return -1;
            }
            return (int)Math.min((long)(this.blockLength - this.blockPointer), APNGReader.this.in.length() - APNGReader.this.in.getFilePointer());
        }

        @Override
        public int read() throws IOException {
            if (this.blockPointer < this.blockLength) {
                ++this.blockPointer;
                return APNGReader.this.in.read();
            }
            this.advanceBlock();
            if (this.currentBlock < 0) {
                throw new EOFException();
            }
            ++this.blockPointer;
            return APNGReader.this.in.read();
        }

        public byte readByte() throws IOException {
            if (this.blockPointer < this.blockLength) {
                ++this.blockPointer;
                return APNGReader.this.in.readByte();
            }
            this.advanceBlock();
            if (this.currentBlock < 0) {
                throw new EOFException();
            }
            ++this.blockPointer;
            return APNGReader.this.in.readByte();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = 0;
            for (int i = 0; i < len && this.available() > 0; ++i) {
                b[off + i] = this.readByte();
                ++read;
            }
            return read;
        }

        private void advanceBlock() throws IOException {
            if (this.currentBlock < APNGReader.this.blocks.size() - 1) {
                while (this.currentBlock < APNGReader.this.blocks.size()) {
                    ++this.currentBlock;
                    if (this.currentBlock == APNGReader.this.blocks.size()) {
                        this.currentBlock = -1;
                        break;
                    }
                    if (this.blockType.equals("fdAT") && ((PNGBlock)((APNGReader)APNGReader.this).blocks.get((int)this.currentBlock)).type.equals("fcTL")) {
                        this.fdatValid = this.fctlCount == this.imageNumber;
                        ++this.fctlCount;
                        if (this.fctlCount <= this.imageNumber + 1) continue;
                        this.currentBlock = -1;
                        break;
                    }
                    if (!this.blockType.equals(((PNGBlock)((APNGReader)APNGReader.this).blocks.get((int)this.currentBlock)).type) || !this.fdatValid && this.blockType.equals("fdAT")) continue;
                }
                if (this.currentBlock >= 0) {
                    this.blockPointer = 0;
                    this.blockLength = ((PNGBlock)((APNGReader)APNGReader.this).blocks.get((int)this.currentBlock)).length;
                    APNGReader.this.in.seek(((PNGBlock)((APNGReader)APNGReader.this).blocks.get((int)this.currentBlock)).offset);
                    if (((PNGBlock)((APNGReader)APNGReader.this).blocks.get((int)this.currentBlock)).type.equals("fdAT")) {
                        this.blockLength -= 4;
                        APNGReader.this.in.skipBytes(4);
                    }
                }
            } else {
                this.currentBlock = -1;
                this.blockPointer = 0;
                this.blockLength = 0;
            }
        }
    }

    class PNGBlock {
        public long offset;
        public int length;
        public String type;

        PNGBlock() {
        }
    }
}

