/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class FitsReader
extends FormatReader {
    private static final int LINE_LENGTH = 80;
    private long pixelOffset;

    public FitsReader() {
        super("Flexible Image Transport System", new String[]{"fits", "fts"});
        this.domains = new String[]{"Astronomy", "Unknown"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.pixelOffset + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int planeSize;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        String line = this.in.readString(80);
        if (!line.startsWith("SIMPLE")) {
            throw new FormatException("Unsupported FITS file.");
        }
        String key = "";
        String value = "";
        while (true) {
            int ndx;
            int comment;
            if ((comment = (line = this.in.readString(80)).indexOf("/", ndx = line.indexOf(61))) < 0) {
                comment = line.length();
            }
            if (ndx >= 0) {
                key = line.substring(0, ndx).trim();
                value = line.substring(ndx + 1, comment).trim();
            } else {
                key = line.trim();
            }
            if (key.equals("END") && this.getSizeX() > 0) break;
            if (key.equals("BITPIX")) {
                int bits = Integer.parseInt(value);
                boolean fp = bits < 0;
                boolean signed = bits != 8;
                bits = Math.abs(bits) / 8;
                m4.pixelType = FormatTools.pixelTypeFromBytes(bits, signed, fp);
            } else if (key.equals("NAXIS1")) {
                m4.sizeX = Integer.parseInt(value);
            } else if (key.equals("NAXIS2")) {
                m4.sizeY = Integer.parseInt(value);
            } else if (key.equals("NAXIS3")) {
                m4.sizeZ = Integer.parseInt(value);
            }
            this.addGlobalMeta(key, value);
        }
        while (this.in.read() == 32) {
        }
        this.pixelOffset = this.in.getFilePointer() - 1L;
        m4.sizeC = 1;
        m4.sizeT = 1;
        if (this.getSizeZ() == 0) {
            m4.sizeZ = 1;
        }
        if (DataTools.safeMultiply64(planeSize = this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()), this.getSizeZ()) > this.in.length() - this.pixelOffset) {
            m4.sizeZ = (int)((this.in.length() - this.pixelOffset) / (long)planeSize);
        }
        m4.imageCount = m4.sizeZ;
        m4.rgb = false;
        m4.littleEndian = false;
        m4.interleaved = false;
        m4.dimensionOrder = "XYZCT";
        m4.indexed = false;
        m4.falseColor = false;
        m4.metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

