/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.RungeKuttaStepInterpolator;
import org.apache.commons.math.ode.StepInterpolator;

class DormandPrince54StepInterpolator
extends RungeKuttaStepInterpolator {
    private double[] v1;
    private double[] v2;
    private double[] v3;
    private double[] v4;
    private boolean vectorsInitialized;
    private static final double a70 = 0.09114583333333333;
    private static final double a72 = 0.44923629829290207;
    private static final double a73 = 0.6510416666666666;
    private static final double a74 = -0.322376179245283;
    private static final double a75 = 0.13095238095238096;
    private static final double d0 = -1.1270175653862835;
    private static final double d2 = 2.675424484351598;
    private static final double d3 = -5.685526961588504;
    private static final double d4 = 3.5219323679207912;
    private static final double d5 = -1.7672812570757455;
    private static final double d6 = 2.382468931778144;
    private static final long serialVersionUID = 4104157279605906956L;

    public DormandPrince54StepInterpolator() {
        this.v1 = null;
        this.v2 = null;
        this.v3 = null;
        this.v4 = null;
        this.vectorsInitialized = false;
    }

    public DormandPrince54StepInterpolator(DormandPrince54StepInterpolator interpolator) {
        super(interpolator);
        if (interpolator.v1 == null) {
            this.v1 = null;
            this.v2 = null;
            this.v3 = null;
            this.v4 = null;
            this.vectorsInitialized = false;
        } else {
            this.v1 = (double[])interpolator.v1.clone();
            this.v2 = (double[])interpolator.v2.clone();
            this.v3 = (double[])interpolator.v3.clone();
            this.v4 = (double[])interpolator.v4.clone();
            this.vectorsInitialized = interpolator.vectorsInitialized;
        }
    }

    protected StepInterpolator doCopy() {
        return new DormandPrince54StepInterpolator(this);
    }

    public void reinitialize(FirstOrderDifferentialEquations equations, double[] y, double[][] yDotK, boolean forward) {
        super.reinitialize(equations, y, yDotK, forward);
        this.v1 = null;
        this.v2 = null;
        this.v3 = null;
        this.v4 = null;
        this.vectorsInitialized = false;
    }

    public void storeTime(double t2) {
        super.storeTime(t2);
        this.vectorsInitialized = false;
    }

    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        if (!this.vectorsInitialized) {
            if (this.v1 == null) {
                this.v1 = new double[this.interpolatedState.length];
                this.v2 = new double[this.interpolatedState.length];
                this.v3 = new double[this.interpolatedState.length];
                this.v4 = new double[this.interpolatedState.length];
            }
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.v1[i] = this.h * (0.09114583333333333 * this.yDotK[0][i] + 0.44923629829290207 * this.yDotK[2][i] + 0.6510416666666666 * this.yDotK[3][i] + -0.322376179245283 * this.yDotK[4][i] + 0.13095238095238096 * this.yDotK[5][i]);
                this.v2[i] = this.h * this.yDotK[0][i] - this.v1[i];
                this.v3[i] = this.v1[i] - this.v2[i] - this.h * this.yDotK[6][i];
                this.v4[i] = this.h * (-1.1270175653862835 * this.yDotK[0][i] + 2.675424484351598 * this.yDotK[2][i] + -5.685526961588504 * this.yDotK[3][i] + 3.5219323679207912 * this.yDotK[4][i] + -1.7672812570757455 * this.yDotK[5][i] + 2.382468931778144 * this.yDotK[6][i]);
            }
            this.vectorsInitialized = true;
        }
        double eta = oneMinusThetaH / this.h;
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] - eta * (this.v1[i] - theta * (this.v2[i] + theta * (this.v3[i] + eta * this.v4[i])));
        }
    }
}

