/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class Checksum32
extends Filter {
    private static final int nbytes = 4;
    private final CType type;

    public Checksum32(CType type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.type.name;
    }

    @Override
    public int getId() {
        return this.type.id;
    }

    @Override
    public byte[] encode(byte[] dataIn) {
        int checksum = (int)this.getChecksum(dataIn);
        byte[] dataOut = new byte[dataIn.length + 4];
        int dataStart = this.type == CType.FLETCHER ? 0 : 4;
        System.arraycopy(dataIn, 0, dataOut, dataStart, dataIn.length);
        int checksumStart = this.type == CType.FLETCHER ? dataOut.length - 4 : 0;
        System.arraycopy(Ints.toByteArray(Integer.reverseBytes(checksum)), 0, dataOut, checksumStart, 4);
        return dataOut;
    }

    @Override
    public byte[] decode(byte[] dataIn) {
        byte[] dataOut = new byte[dataIn.length - 4];
        int dataStart = this.type == CType.FLETCHER ? 0 : 4;
        System.arraycopy(dataIn, dataStart, dataOut, 0, dataOut.length);
        int checksum = (int)this.getChecksum(dataOut);
        byte[] bytes = new byte[4];
        int checksumStart = this.type == CType.FLETCHER ? dataIn.length - 4 : 0;
        System.arraycopy(dataIn, checksumStart, bytes, 0, 4);
        int i = Integer.reverseBytes(Ints.fromByteArray(bytes));
        if (i != checksum) {
            throw new RuntimeException("Checksum invalid");
        }
        return dataOut;
    }

    private long getChecksum(byte[] data) {
        Checksum checksum;
        switch (this.type) {
            case ADLER: {
                checksum = new Adler32();
                break;
            }
            case CRC: {
                checksum = new CRC32();
                break;
            }
            default: {
                checksum = new Fletcher32();
            }
        }
        checksum.update(data, 0, data.length);
        return checksum.getValue();
    }

    public static class CRC32Provider
    implements FilterProvider {
        @Override
        public String getName() {
            return CType.CRC.name;
        }

        @Override
        public int getId() {
            return CType.CRC.id;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Checksum32(CType.CRC);
        }
    }

    public static class Adler32Provider
    implements FilterProvider {
        @Override
        public String getName() {
            return CType.ADLER.name;
        }

        @Override
        public int getId() {
            return CType.ADLER.id;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Checksum32(CType.ADLER);
        }
    }

    public static class Fletcher32Provider
    implements FilterProvider {
        @Override
        public String getName() {
            return CType.FLETCHER.name;
        }

        @Override
        public int getId() {
            return CType.FLETCHER.id;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Checksum32(CType.FLETCHER);
        }
    }

    private class Fletcher32
    extends Adler32 {
        private long sum1 = 0L;
        private long sum2 = 0L;

        private Fletcher32() {
        }

        @Override
        public void update(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off > b.length - len) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int i = 0;
            int end = len / 2;
            while (end > 0) {
                int blocklen = end > 360 ? 360 : end;
                end -= blocklen;
                do {
                    this.sum1 += (long)((b[i] & 0xFF) << 8 | b[i + 1] & 0xFF);
                    this.sum2 += this.sum1;
                    i += 2;
                } while (--blocklen > 0);
                this.sum1 = (this.sum1 & 0xFFFFL) + (this.sum1 >>> 16);
                this.sum2 = (this.sum2 & 0xFFFFL) + (this.sum2 >>> 16);
            }
            if (len % 2 > 0) {
                this.sum1 += (long)((b[len - 1] & 0xFF) << 8);
                this.sum2 += this.sum1;
                this.sum1 = (this.sum1 & 0xFFFFL) + (this.sum1 >>> 16);
                this.sum2 = (this.sum2 & 0xFFFFL) + (this.sum2 >>> 16);
            }
            this.sum1 = (this.sum1 & 0xFFFFL) + (this.sum1 >>> 16);
            this.sum2 = (this.sum2 & 0xFFFFL) + (this.sum2 >>> 16);
        }

        @Override
        public long getValue() {
            return this.sum2 << 16 | this.sum1;
        }
    }

    public static enum CType {
        FLETCHER("fletcher32", 3),
        ADLER("adler32", -1),
        CRC("crc32", -1);

        private final String name;
        private final int id;

        private CType(String name, int id) {
            this.name = name;
            this.id = id;
        }
    }
}

