/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileFactory;

@Deprecated
public class AggregationTiled
extends Aggregation
implements ProxyReader {
    private List<String> dimNames = new ArrayList<String>();
    private List<Dimension> dims = new ArrayList<Dimension>();
    private Section section;
    private boolean debug;

    public AggregationTiled(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.tiled, recheckS);
        StringTokenizer stoke = new StringTokenizer(dimName);
        while (stoke.hasMoreTokens()) {
            this.dimNames.add(stoke.nextToken());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        Aggregation.Dataset typicalDataset = this.getTypicalDataset();
        NetcdfFile typical = typicalDataset.acquireFile(null);
        DatasetConstructor.transferDataset(typical, this.ncDataset, null);
        for (String string : this.dimNames) {
            Dimension dim = this.ncDataset.getRootGroup().findDimension(string);
            if (null != dim) {
                this.dims.add(dim);
                continue;
            }
            throw new IllegalArgumentException("Unknown dimension = " + string);
        }
        Section result = null;
        for (Aggregation.Dataset d : this.datasets) {
            DatasetTiled dt = (DatasetTiled)d;
            try {
                dt.section = dt.section.addRangeNames(this.dimNames);
                result = result == null ? dt.section : result.union(dt.section);
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        assert (result != null);
        assert (result.getRank() == this.dims.size());
        for (Range r : result.getRanges()) {
            assert (r.first() == 0);
            assert (r.stride() == 1);
        }
        this.section = result;
        boolean bl = false;
        for (Range r : this.section.getRanges()) {
            void var5_9;
            Dimension dim = this.dims.get((int)(++var5_9));
            dim.setLength(r.length());
        }
        for (Variable v : typical.getVariables()) {
            if (this.isTiled(v)) {
                Group newGroup = DatasetConstructor.findGroup(this.ncDataset, v.getParentGroupOrRoot());
                VariableDS vagg = new VariableDS(this.ncDataset, newGroup, null, v.getShortName(), v.getDataType(), v.getDimensionsString(), null, null);
                vagg.setProxyReader(this);
                DatasetConstructor.transferVariableAttributes(v, vagg);
                newGroup.removeVariable(v.getShortName());
                newGroup.addVariable(vagg);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        this.setDatasetAcquireProxy(typicalDataset, this.ncDataset);
        typicalDataset.close(typical);
        this.ncDataset.finish();
    }

    private boolean isTiled(Variable v) {
        for (Dimension d : v.getDimensions()) {
            for (Range r : this.section.getRanges()) {
                if (!d.getShortName().equals(r.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void rebuildDataset() throws IOException {
        this.ncDataset.empty();
        this.dims = new ArrayList<Dimension>();
        this.buildNetcdfDataset(null);
    }

    @Override
    public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array allData = Array.factory(dtype, mainv.getShape());
        Section wantSection = mainv.getShapeAsSection();
        if (this.debug) {
            System.out.println("wantSection: " + wantSection + " for var " + mainv.getFullName());
        }
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset vnested : nestedDatasets) {
            TileLayout index;
            Array varData;
            DatasetTiled dtiled = (DatasetTiled)vnested;
            Section tiledSection = dtiled.makeVarSection(mainv);
            try {
                varData = dtiled.read(mainv, cancelTask);
                if (varData == null) {
                    throw new IOException("cant read " + mainv.getFullName());
                }
                index = new TileLayout(tiledSection, wantSection);
                if (this.debug) {
                    System.out.println(" varData read: " + new Section(varData.getShape()));
                }
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            while (index.hasNext()) {
                try {
                    Array.arraycopy(varData, index.srcPos, allData, index.resultPos, index.nelems);
                }
                catch (RuntimeException e) {
                    logger.error("reallyRead {} ", (Object)index, (Object)e);
                    throw e;
                }
            }
            if (varData.getSize() == mainv.getSize()) break;
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        return allData;
    }

    @Override
    public Array reallyRead(Variable mainv, Section wantSection, CancelTask cancelTask) throws IOException {
        long size = wantSection.computeSize();
        if (size == mainv.getSize()) {
            return this.reallyRead(mainv, cancelTask);
        }
        DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
        Array allData = Array.factory(dtype, wantSection.getShape());
        if (this.debug) {
            System.out.println((Object)((Object)dtype) + " allData allocated: " + new Section(allData.getShape()));
        }
        List<Aggregation.Dataset> nestedDatasets = this.getDatasets();
        for (Aggregation.Dataset vnested : nestedDatasets) {
            TileLayout index;
            Array varData;
            DatasetTiled dtiled = (DatasetTiled)vnested;
            Section tiledSection = dtiled.makeVarSection(mainv);
            try {
                Section localNeed;
                if (!tiledSection.intersects(wantSection)) continue;
                Section needToRead = tiledSection.intersect(wantSection);
                if (this.debug) {
                    System.out.println(" tiledSection: " + tiledSection + " from file " + dtiled.getLocation());
                }
                if (this.debug) {
                    System.out.println(" intersection: " + needToRead);
                }
                if ((varData = dtiled.read(mainv, cancelTask, (localNeed = needToRead.shiftOrigin(tiledSection)).getRanges())) == null) {
                    throw new IOException("cant read " + mainv.getFullName());
                }
                index = new TileLayout(needToRead, wantSection);
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            while (index.hasNext()) {
                try {
                    Array.arraycopy(varData, index.srcPos, allData, index.resultPos, index.nelems);
                }
                catch (RuntimeException e) {
                    logger.error("tiledSection {} {} ", index, tiledSection, e);
                    throw e;
                }
            }
            if (varData.getSize() == mainv.getSize()) break;
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return null;
        }
        return allData;
    }

    @Override
    protected Aggregation.Dataset makeDataset(String cacheName, String location, String id, String ncoordS, String coordValueS, String sectionSpec, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
        return new DatasetTiled(cacheName, location, id, sectionSpec, enhance, reader);
    }

    class DatasetTiled
    extends Aggregation.Dataset {
        protected String sectionSpec;
        protected Section section;

        protected DatasetTiled(String cacheName, String location, String id, String sectionSpec, EnumSet<NetcdfDataset.Enhance> enhance, FileFactory reader) {
            super(AggregationTiled.this, cacheName, location, id, enhance, reader);
            this.sectionSpec = sectionSpec;
            try {
                this.section = new Section(sectionSpec);
            }
            catch (InvalidRangeException e) {
                throw new IllegalArgumentException(e);
            }
        }

        boolean isNeeded(Section wantSection) throws InvalidRangeException {
            return this.section.intersects(wantSection);
        }

        Section makeVarSection(Variable mainv) {
            Section vSection = mainv.getShapeAsSection();
            Section.Builder dataSection = Section.builder();
            for (Range r : vSection.getRanges()) {
                Range rr = this.section.find(r.getName());
                dataSection.appendRange(rr != null ? rr : r);
            }
            return dataSection.build();
        }
    }

    private class TileLayout {
        private int srcPos;
        private int resultPos;
        private int nelems;
        private int total;
        private int startElem;
        Index index;
        boolean first = true;

        TileLayout(Section localSection, Section wantSection) throws InvalidRangeException {
            Section dataSection = localSection.compact();
            Section resultSection = wantSection.compact();
            if (AggregationTiled.this.debug) {
                System.out.println(" resultSection: " + resultSection);
                System.out.println(" dataSection: " + dataSection);
            }
            int rank = dataSection.getRank();
            this.total = (int)dataSection.computeSize();
            long product = 1L;
            this.startElem = 0;
            for (int ii = rank - 1; ii >= 0; --ii) {
                int d = dataSection.getOrigin(ii) - resultSection.getOrigin(ii);
                if (d > 0) {
                    this.startElem = (int)((long)this.startElem + product * (long)d);
                }
                product *= (long)resultSection.getShape(ii);
            }
            this.resultPos = this.startElem;
            this.nelems = localSection.getShape(rank - 1);
            int[] stride = new int[rank - 1];
            int[] shape = new int[rank - 1];
            product = resultSection.getShape(rank - 1);
            for (int ii = rank - 2; ii >= 0; --ii) {
                stride[ii] = (int)product;
                shape[ii] = dataSection.getShape(ii);
                product *= (long)resultSection.getShape(ii);
            }
            this.index = new Index(shape, stride);
        }

        boolean hasNext() {
            if (this.first) {
                this.first = false;
                return true;
            }
            this.srcPos += this.nelems;
            if (this.srcPos >= this.total) {
                return false;
            }
            this.index.incr();
            this.resultPos = this.startElem + this.index.currentElement();
            return true;
        }

        public String toString() {
            return "  nElems: " + this.nelems + " srcPos: " + this.srcPos + " resultPos: " + this.resultPos;
        }
    }
}

