/*
 * Decompiled with CFR 0.152.
 */
package vtk.sample;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkNativeLibrary;
import vtk.vtkPanel;
import vtk.vtkPolyDataMapper;

public class SimpleVTK
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private vtkPanel renWin;
    private JButton exitButton;

    public SimpleVTK() {
        super(new BorderLayout());
        vtkConeSource cone = new vtkConeSource();
        cone.SetResolution(8);
        vtkPolyDataMapper coneMapper = new vtkPolyDataMapper();
        coneMapper.SetInputConnection(cone.GetOutputPort());
        vtkActor coneActor = new vtkActor();
        coneActor.SetMapper(coneMapper);
        this.renWin = new vtkPanel();
        this.renWin.GetRenderer().AddActor(coneActor);
        this.exitButton = new JButton("Exit");
        this.exitButton.addActionListener(this);
        this.add((Component)this.renWin, "Center");
        this.add((Component)this.exitButton, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.exitButton)) {
            System.exit(0);
        }
    }

    public static void main(String[] s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("SimpleVTK");
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)new SimpleVTK(), "Center");
                frame.setSize(400, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }
}

