/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI3D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.rectangle.Rectangle3D;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.w3c.dom.Node;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.activecontours.SlidingWindow;
import plugins.adufour.activecontours.TopologyException;
import plugins.adufour.roi.mesh.MeshTopologyException;
import plugins.adufour.roi.mesh.ROI3DMesh;
import plugins.adufour.roi.mesh.Vertex3D;
import plugins.adufour.roi.mesh.polygon.ROI3DTriangularMesh;
import plugins.adufour.vars.lang.Var;
import plugins.kernel.roi.descriptor.intensity.ROIMeanIntensityDescriptor;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class Mesh3D
extends ActiveContour {
    final ActiveMesh mesh;
    final Tuple3d pixelSize;
    final Map<IcyCanvas, Overlay> overlays;
    boolean isRemoving;

    public Mesh3D() {
        this.mesh = new ActiveMesh();
        this.pixelSize = new Point3d();
        this.overlays = new HashMap<IcyCanvas, Overlay>();
        this.isRemoving = false;
    }

    public Mesh3D(Mesh3D contour) {
        super((Var<Double>)contour.sampling, new SlidingWindow(contour.convergence.getSize()));
        this.mesh = (ActiveMesh)contour.mesh.clone();
        this.pixelSize = new Point3d();
        this.setName(contour.getName());
        this.overlays = new HashMap<IcyCanvas, Overlay>();
        this.isRemoving = false;
        this.setColor(contour.getColor());
        this.updateMetaData();
    }

    public Mesh3D(Var<Double> sampling, Tuple3d pixelSize, ROI3D roi, SlidingWindow convergenceWindow) {
        super(sampling, convergenceWindow);
        this.mesh = new ActiveMesh((Double)sampling.getValue(), roi);
        this.mesh.setColor(this.getColor());
        this.setName(roi.getName());
        this.pixelSize = pixelSize;
        this.overlays = new HashMap<IcyCanvas, Overlay>();
        this.isRemoving = false;
        this.updateMetaData();
    }

    @Override
    void computeAxisForces(double weight) {
        Vector3d axis = this.mesh.getMajorAxis(null);
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            double colinearity = Math.abs(v.normal.dot(axis));
            double threshold = Math.max(colinearity, 1.0 - weight);
            av.imageForces.scale(threshold);
        }
    }

    @Override
    void computeBalloonForces(double weight) {
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            av.imageForces.scaleAdd(weight, (Tuple3d)v.normal, (Tuple3d)((ActiveVertex)v).imageForces);
        }
    }

    @Override
    void computeEdgeForces(Sequence edgeData, int channel, double weight) {
        Vector3d grad = new Vector3d();
        Point3d prev = new Point3d();
        Point3d p = new Point3d();
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            p.set((Tuple3d)v.position);
            grad.x = Mesh3D.getPixelValue(edgeData, p.x + 0.5, p.y, p.z);
            grad.y = Mesh3D.getPixelValue(edgeData, p.x, p.y + 0.5, p.z);
            grad.z = Mesh3D.getPixelValue(edgeData, p.x, p.y, p.z + 0.5);
            prev.x = Mesh3D.getPixelValue(edgeData, p.x - 0.5, p.y, p.z);
            prev.y = Mesh3D.getPixelValue(edgeData, p.x, p.y - 0.5, p.z);
            prev.z = Mesh3D.getPixelValue(edgeData, p.x, p.y, p.z - 0.5);
            grad.sub((Tuple3d)prev);
            grad.scale(weight);
            av.imageForces.add((Tuple3d)grad);
        }
    }

    @Override
    void computeRegionForces(Sequence imageData, int channel, double weight, double sensitivity, double cin, double cout) {
        Vector3d regionForce = new Vector3d();
        double adjWeight = weight * this.sampling.getValue();
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            Point3d p = v.position;
            double val = Mesh3D.getPixelValue(imageData, p.x, p.y, p.z);
            double inDiff = val - cin;
            inDiff *= inDiff;
            double outDiff = val - cout;
            outDiff *= outDiff;
            regionForce.set((Tuple3d)v.normal);
            regionForce.scale(adjWeight * (sensitivity * outDiff) - inDiff / sensitivity);
            av.imageForces.add((Tuple3d)regionForce);
        }
    }

    @Override
    void computeInternalForces(double weight) {
        Vector3d internalForce = new Vector3d();
        double adjWeight = weight / this.sampling.getValue();
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            internalForce.scale((double)(-v.neighbors.size()), (Tuple3d)v.position);
            for (Integer nn : v.neighbors) {
                internalForce.add((Tuple3d)this.mesh.getVertex((int)nn.intValue()).position);
            }
            internalForce.scale(adjWeight);
            av.internalForces.add((Tuple3d)internalForce);
        }
    }

    @Override
    void computeVolumeConstraint(double targetVolume, double weight) {
        double volumeDiff = targetVolume - this.getDimension(2);
        Vector3d avgFeedback = new Vector3d();
        int cpt = 0;
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            Vector3d feedbackForce = av.feedbackForces;
            double forceNorm = av.imageForces.dot(v.normal);
            if (!(forceNorm > 0.0) || !(volumeDiff < 0.0)) continue;
            avgFeedback.add((Tuple3d)feedbackForce);
            ++cpt;
        }
        if (avgFeedback.length() > 0.0) {
            avgFeedback.scale(1.0 / (double)cpt);
            avgFeedback.scale(Math.abs(volumeDiff / targetVolume) / 1.5);
            for (Vertex3D v : this.mesh.getVertices()) {
                if (v == null) continue;
                ((ActiveVertex)v).volumeConstraint.add((Tuple3d)avgFeedback);
            }
        }
    }

    @Override
    int computeFeedbackForces(ActiveContour target) {
        Vector3d feedbackForce = new Vector3d();
        int tests = 0;
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null || !target.boundingBox.intersect(v.position) || !target.boundingSphere.intersect(v.position)) continue;
            ActiveVertex av = (ActiveVertex)v;
            ++tests;
            double feedback = target.getDistanceToEdge(v.position);
            if (!(feedback > 0.0)) continue;
            feedbackForce.set((Tuple3d)v.normal);
            feedbackForce.scale(-feedback * 10.0);
            av.feedbackForces.add((Tuple3d)feedbackForce);
        }
        return tests;
    }

    public double getCurvature(Point3d pt) {
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null || !v.position.equals((Tuple3d)pt)) continue;
            Vector3d sum = new Vector3d();
            Vector3d diff = new Vector3d();
            for (Integer n : v.neighbors) {
                Point3d neighbor = this.mesh.getVertex((int)n.intValue()).position;
                diff.sub((Tuple3d)neighbor, (Tuple3d)pt);
                sum.add((Tuple3d)diff);
            }
            sum.scale(1.0 / (double)v.neighbors.size());
            return sum.length() * Math.signum(sum.dot(v.normal));
        }
        return 0.0;
    }

    @Override
    public double getDimension(int order) {
        switch (order) {
            case 0: {
                return this.mesh.getNumberOfVertices(true);
            }
            case 1: {
                return this.mesh.getNumberOfContourPoints();
            }
            case 2: {
                return this.mesh.getNumberOfPoints();
            }
        }
        return Double.NaN;
    }

    Point3d getMassCenter() {
        return this.mesh.getMassCenter(this.pixelSize);
    }

    public Vector3d getMajorAxis() {
        return this.mesh.getMajorAxis(this.pixelSize);
    }

    private static double getPixelValue(Sequence data, double x, double y, double z) {
        return data.getDataInterpolated(0, z, 0, y, x);
    }

    public double getX() {
        return this.mesh.getMassCenter(null).x;
    }

    public double getY() {
        return this.mesh.getMassCenter(null).y;
    }

    public double getZ() {
        return this.mesh.getMassCenter(null).z;
    }

    public void setT(int t) {
        super.setT(t);
        this.mesh.setT(t);
    }

    @Override
    public Iterator<Point3d> iterator() {
        return new Iterator<Point3d>(){
            final Iterator<Vertex3D> vertexIterator;
            Vertex3D next;
            boolean nextFetched;
            {
                this.vertexIterator = Mesh3D.this.mesh.getVertices().iterator();
                this.next = null;
                this.nextFetched = false;
            }

            @Override
            public void remove() {
                this.vertexIterator.remove();
            }

            private void fetchNext() {
                if (this.nextFetched) {
                    return;
                }
                do {
                    this.next = this.vertexIterator.next();
                } while (this.next == null && this.vertexIterator.hasNext());
                this.nextFetched = true;
            }

            @Override
            public Point3d next() {
                this.fetchNext();
                this.nextFetched = false;
                return this.next.position;
            }

            @Override
            public boolean hasNext() {
                if (!this.vertexIterator.hasNext()) {
                    this.next = null;
                } else {
                    this.fetchNext();
                }
                return this.next != null;
            }
        };
    }

    @Override
    void move(ROI boundField, double timeStep) {
        Vector3d force = new Vector3d();
        double maxDisp = this.sampling.getValue() * timeStep;
        Point3d p = new Point3d();
        for (Vertex3D v : this.mesh.getVertices()) {
            if (v == null) continue;
            ActiveVertex av = (ActiveVertex)v;
            p.set((Tuple3d)v.position);
            if (boundField != null && p.z >= 0.0 && boundField.contains(p.x, p.y, p.z, 0.0, 0.0)) {
                if (av.volumeConstraint.length() > 0.0) {
                    av.position.add((Tuple3d)av.volumeConstraint);
                }
                force.set((Tuple3d)av.imageForces);
                force.add((Tuple3d)av.internalForces);
                force.add((Tuple3d)av.feedbackForces);
            } else {
                force.set((Tuple3d)av.imageForces);
                force.add((Tuple3d)av.internalForces);
                force.add((Tuple3d)av.feedbackForces);
                force.scale(0.1);
            }
            force.scale(timeStep);
            double disp = force.length();
            if (disp > maxDisp) {
                force.scale(maxDisp / disp);
            }
            v.position.add((Tuple3d)force);
            av.imageForces.set(0.0, 0.0, 0.0);
            av.internalForces.set(0.0, 0.0, 0.0);
            av.feedbackForces.set(0.0, 0.0, 0.0);
            av.volumeConstraint.set(0.0, 0.0, 0.0);
        }
        this.updateMetaData();
        if (this.convergence != null) {
            this.convergence.push(this.mesh.getNumberOfPoints());
        }
    }

    @Override
    public boolean hasConverged(SlidingWindow.Operation operation, double epsilon) {
        Double value = this.convergence.computeCriterion(operation);
        return value != null && value <= epsilon / 10.0;
    }

    @Override
    protected void updateMetaData() {
        super.updateMetaData();
        this.mesh.roiChanged(true);
    }

    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        return this.mesh.saveToXML(node);
    }

    public boolean loadFromXML(Node node) {
        if (!super.loadFromXML(node)) {
            return false;
        }
        boolean success = this.mesh.loadFromXML(node);
        this.mesh.setT(this.getT());
        return success;
    }

    @Override
    public void reSample(double minFactor, double maxFactor) throws TopologyException {
        try {
            this.mesh.resample(this.sampling.getValue(), 0.4);
        }
        catch (MeshTopologyException e) {
            if (e.children == null) {
                throw new TopologyException(this, null);
            }
            ActiveContour[] children = new Mesh3D[e.children.length];
            for (int i = 0; i < children.length; ++i) {
                children[i] = new Mesh3D((Var<Double>)this.sampling, this.pixelSize, (ROI3D)e.children[i], this.convergence);
            }
            throw new TopologyException(this, children);
        }
    }

    @Override
    public ActiveContour clone() {
        return new Mesh3D(this);
    }

    @Override
    protected void addPoint(Point3d p) {
        this.mesh.addVertex(this.mesh.createVertex(p));
    }

    @Override
    protected ActiveContour[] checkSelfIntersection(double minDistance) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double computeAverageIntensity(Sequence regionData, BooleanMask3D mask) throws TopologyException {
        if (mask != null) {
            ROI3DArea localROIMask = this.mesh.getROIMask();
            BooleanMask3D localMask = this.mesh.getMask();
            ArrayList zIndexes = new ArrayList(mask.mask.keySet());
            for (Integer z : zIndexes) {
                BooleanMask2D localMask2D = localMask.getMask2D(z.intValue());
                if (localMask2D == null) continue;
                mask.mask.put(z, (BooleanMask2D)localMask2D.clone());
            }
            int c = localROIMask.getC();
            localROIMask.setC(0);
            try {
                double d = ROIMeanIntensityDescriptor.computeMeanIntensity((ROI)localROIMask, (Sequence)regionData);
                return d;
            }
            finally {
                localROIMask.setC(c);
            }
        }
        return 0.0;
    }

    @Override
    public double computeBackgroundIntensity(Sequence imageData, BooleanMask3D mask) {
        Rectangle3D.Integer b3 = mask.bounds;
        Point3d min = new Point3d();
        Point3d max = new Point3d();
        this.boundingBox.getLower(min);
        this.boundingBox.getUpper(max);
        double zExtent = max.z - min.z;
        int minZ = Math.max(0, (int)Math.round(min.z - zExtent / 2.0));
        int maxZ = Math.min(b3.sizeZ, (int)Math.round(max.z + zExtent / 2.0));
        double yExtent = max.y - min.y;
        int minY = Math.max(0, (int)Math.round(min.y - yExtent / 2.0));
        int maxY = Math.min(b3.sizeY, (int)Math.round(max.y + yExtent / 2.0));
        double xExtent = max.x - min.x;
        int minX = Math.max(0, (int)Math.round(min.x - xExtent / 2.0));
        int maxX = Math.min(b3.sizeX, (int)Math.round(max.x + xExtent / 2.0));
        double outSum = 0.0;
        double outCpt = 0.0;
        for (int zSlice = minZ; zSlice < maxZ; ++zSlice) {
            boolean[] _mask = ((BooleanMask2D)mask.mask.get((Object)Integer.valueOf((int)zSlice))).mask;
            float[] _data = imageData.getDataXYAsFloat(0, zSlice, 0);
            for (int j = minY; j < maxY; ++j) {
                int offset = minX + j * b3.sizeX;
                int i = minX;
                while (i < maxX) {
                    if (!_mask[offset]) {
                        outSum += (double)_data[i];
                        outCpt += 1.0;
                    }
                    ++i;
                    ++offset;
                }
            }
        }
        return outCpt == 0.0 ? 0.0 : outSum / outCpt;
    }

    @Override
    public double getDistanceToEdge(Point3d p) {
        return this.mesh.getPenetrationDepth(p);
    }

    @Override
    public ROI toROI() {
        return this.toROI(ActiveContours.ROIType.POLYGON, null);
    }

    @Override
    public ROI toROI(ActiveContours.ROIType type, Sequence sequence) throws UnsupportedOperationException {
        ROI3DMesh roi;
        switch (type) {
            case POLYGON: {
                roi = this.mesh.clone();
                break;
            }
            case AREA: {
                roi = new ROI3DArea(this.mesh.getMask());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot export a ROI of type: " + (Object)((Object)type));
            }
        }
        ROIUtil.copyROIProperties((ROI)this.mesh, (ROI)roi, (boolean)false);
        roi.setT(this.t);
        roi.setName(this.name);
        return roi;
    }

    @Override
    public void toSequence(Sequence output, double value) {
    }

    @Override
    protected void updateNormals() {
        this.mesh.updateNormals();
    }

    @Override
    protected void clean() {
        this.isRemoving = true;
        for (Overlay overlay : this.overlays.values()) {
            overlay.remove();
        }
        this.overlays.clear();
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (this.isRemoving) {
            return;
        }
        if (this.overlays.containsKey(canvas)) {
            return;
        }
        ROI.ROIPainter overlay = this.mesh.getOverlay();
        overlay.setCanBeRemoved(true);
        overlay.setName("Active Mesh overlay");
        this.overlays.put(canvas, (Overlay)overlay);
        sequence.addOverlay((Overlay)overlay);
        overlay.paint(g, sequence, canvas);
    }

    public static class ActiveMesh
    extends ROI3DTriangularMesh {
        public ActiveMesh() {
        }

        public ActiveMesh(double sampling, ROI3D roi) {
            super(sampling, roi);
            this.setName(roi.getName());
        }

        public ActiveVertex createVertex(Point3d position) {
            return new ActiveVertex(position);
        }
    }

    private static class ActiveVertex
    extends Vertex3D {
        public final Vector3d imageForces = new Vector3d();
        public final Vector3d internalForces = new Vector3d();
        public final Vector3d feedbackForces = new Vector3d();
        public final Vector3d volumeConstraint = new Vector3d();

        public ActiveVertex(ActiveVertex v) {
            super(v.position, v.neighbors);
        }

        public ActiveVertex(Point3d position) {
            this(position, 0);
        }

        public ActiveVertex(Point3d position, int nbNeighbors) {
            super(position, nbNeighbors);
        }

        public Vertex3D clone() {
            return new ActiveVertex(this);
        }
    }
}

