/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.CursorFunc;
import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyConnection;
import com.ziclix.python.sql.PyStatement;
import com.ziclix.python.sql.WarningEvent;
import com.ziclix.python.sql.WarningListener;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.python.core.ClassDictInit;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;

public class PyCursor
extends PyObject
implements ClassDictInit,
WarningListener,
ContextManager {
    protected Fetch fetch;
    private boolean closed = false;
    protected int arraysize = 1;
    protected int softspace = 0;
    protected PyObject rsType = Py.None;
    protected PyObject rsConcur = Py.None;
    protected PyObject warnings;
    protected PyObject lastrowid;
    protected PyObject updatecount;
    protected boolean dynamicFetch;
    protected PyConnection connection;
    protected DataHandler datahandler;
    protected PyStatement statement;
    private static final DataHandler DATAHANDLER = DataHandler.getSystemDataHandler();
    protected static PyList __methods__;
    protected static PyList __members__;

    PyCursor(PyConnection connection) {
        this(connection, false);
    }

    PyCursor(PyConnection connection, boolean dynamicFetch) {
        this.connection = connection;
        this.datahandler = DATAHANDLER;
        this.dynamicFetch = dynamicFetch;
        this.clear();
    }

    PyCursor(PyConnection connection, boolean dynamicFetch, PyObject rsType, PyObject rsConcur) {
        this(connection, dynamicFetch);
        this.rsType = rsType;
        this.rsConcur = rsConcur;
    }

    @Override
    public String toString() {
        return String.format("<PyCursor object at %s>", Py.idstr(this));
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        if ("arraysize".equals(name)) {
            this.arraysize = value.asInt();
        } else if ("softspace".equals(name)) {
            this.softspace = value.asInt();
        } else if ("datahandler".equals(name)) {
            this.datahandler = (DataHandler)value.__tojava__(DataHandler.class);
        } else {
            super.__setattr__(name, value);
        }
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        if ("arraysize".equals(name)) {
            return Py.newInteger(this.arraysize);
        }
        if ("softspace".equals(name)) {
            return Py.newInteger(this.softspace);
        }
        if ("__methods__".equals(name)) {
            return __methods__;
        }
        if ("__members__".equals(name)) {
            return __members__;
        }
        if ("description".equals(name)) {
            return this.fetch.description;
        }
        if ("rowcount".equals(name)) {
            return Py.newInteger(this.fetch.rowcount);
        }
        if ("rownumber".equals(name)) {
            int rn = this.fetch.rownumber;
            return rn < 0 ? Py.None : Py.newInteger(rn);
        }
        if ("warnings".equals(name)) {
            return this.warnings;
        }
        if ("lastrowid".equals(name)) {
            return this.lastrowid;
        }
        if ("updatecount".equals(name)) {
            return this.updatecount;
        }
        if ("datahandler".equals(name)) {
            return Py.java2py(this.datahandler);
        }
        if ("dynamic".equals(name)) {
            return this.dynamicFetch ? Py.One : Py.Zero;
        }
        if ("connection".equals(name)) {
            return this.connection;
        }
        if ("closed".equals(name)) {
            return Py.newBoolean(this.closed);
        }
        if ("callproc".equals(name)) {
            try {
                if (!this.getMetaData().supportsStoredProcedures()) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__findattr_ex__(name);
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("fetchmany", (PyObject)new CursorFunc("fetchmany", 0, 0, 1, "fetch specified number of rows"));
        dict.__setitem__("close", (PyObject)new CursorFunc("close", 1, 0, "close the cursor"));
        dict.__setitem__("fetchall", (PyObject)new CursorFunc("fetchall", 2, 0, "fetch all results"));
        dict.__setitem__("fetchone", (PyObject)new CursorFunc("fetchone", 3, 0, "fetch the next result"));
        dict.__setitem__("nextset", (PyObject)new CursorFunc("nextset", 4, 0, "return next set or None"));
        dict.__setitem__("execute", (PyObject)new CursorFunc("execute", 5, 1, 4, "execute the sql expression"));
        dict.__setitem__("setinputsizes", (PyObject)new CursorFunc("setinputsizes", 6, 1, "not implemented"));
        dict.__setitem__("setoutputsize", (PyObject)new CursorFunc("setoutputsize", 7, 1, 2, "not implemented"));
        dict.__setitem__("callproc", (PyObject)new CursorFunc("callproc", 8, 1, 4, "executes a stored procedure"));
        dict.__setitem__("executemany", (PyObject)new CursorFunc("executemany", 9, 1, 3, "execute sql with the parameter list"));
        dict.__setitem__("scroll", (PyObject)new CursorFunc("scroll", 10, 1, 2, "scroll the cursor in the result set to a new position according to mode"));
        dict.__setitem__("write", (PyObject)new CursorFunc("write", 11, 1, "execute the sql written to this file-like object"));
        dict.__setitem__("prepare", (PyObject)new CursorFunc("prepare", 12, 1, "prepare the sql statement for later execution"));
        dict.__setitem__("__enter__", (PyObject)new CursorFunc("__enter__", 13, 0, 0, "__enter__"));
        dict.__setitem__("__exit__", (PyObject)new CursorFunc("__exit__", 14, 3, 3, "__exit__"));
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("getDataHandler", null);
        dict.__setitem__("warning", null);
        dict.__setitem__("fetch", null);
        dict.__setitem__("statement", null);
        dict.__setitem__("dynamicFetch", null);
        dict.__setitem__("getPyClass", null);
        dict.__setitem__("rsConcur", null);
        dict.__setitem__("rsType", null);
    }

    public void __del__() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.clear();
            this.connection.remove(this);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public PyObject __iter__() {
        return this;
    }

    public PyObject next() {
        PyObject row = this.__iternext__();
        if (row == null) {
            throw Py.StopIteration("");
        }
        return row;
    }

    @Override
    public PyObject __iternext__() {
        PyObject row = this.fetchone();
        return row.__nonzero__() ? row : null;
    }

    protected DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.connection.getMetaData();
    }

    public DataHandler getDataHandler() {
        return this.datahandler;
    }

    private PyStatement prepareStatement(PyObject sql, PyObject maxRows, boolean prepared) {
        PyStatement stmt2 = null;
        if (sql == Py.None) {
            return null;
        }
        try {
            if (sql instanceof PyStatement) {
                stmt2 = (PyStatement)sql;
            } else {
                boolean normal;
                String sqlString;
                Statement sqlStatement = null;
                String string = sqlString = sql instanceof PyUnicode ? sql.toString() : sql.__str__().toString();
                if (sqlString.trim().length() == 0) {
                    return null;
                }
                boolean bl = normal = this.rsType == Py.None && this.rsConcur == Py.None;
                if (normal) {
                    sqlStatement = prepared ? this.connection.connection.prepareStatement(sqlString) : this.connection.connection.createStatement();
                } else {
                    int t = this.rsType.asInt();
                    int c = this.rsConcur.asInt();
                    sqlStatement = prepared ? this.connection.connection.prepareStatement(sqlString, t, c) : this.connection.connection.createStatement(t, c);
                }
                int style = prepared ? 4 : 2;
                stmt2 = new PyStatement(sqlStatement, sqlString, style);
            }
            if (maxRows != Py.None) {
                stmt2.statement.setMaxRows(maxRows.asInt());
            }
        }
        catch (AbstractMethodError e) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
        return stmt2;
    }

    public void callproc(PyObject name, PyObject params, PyObject bindings, PyObject maxRows) {
        this.clear();
        try {
            PyDictionary callableBindings;
            CallableStatement stmt2;
            Procedure procedure;
            if (this.getMetaData().supportsStoredProcedures()) {
                if (PyCursor.isSeqSeq(params)) {
                    throw zxJDBC.makeException(zxJDBC.NotSupportedError, "sequence of sequences is not supported");
                }
                procedure = this.datahandler.getProcedure(this, name);
                stmt2 = procedure.prepareCall(this.rsType, this.rsConcur);
                if (maxRows != Py.None) {
                    stmt2.setMaxRows(maxRows.asInt());
                }
                callableBindings = new PyDictionary();
                procedure.normalizeInput(params, callableBindings);
                if (bindings instanceof PyDictionary) {
                    callableBindings.update(bindings);
                }
            } else {
                throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("noStoredProc"));
            }
            this.statement = new PyStatement(stmt2, procedure);
            this.execute(params, callableBindings);
        }
        catch (Throwable t) {
            if (this.statement != null) {
                this.statement.close();
            }
            throw zxJDBC.makeException(t);
        }
    }

    public void executemany(PyObject sql, PyObject params, PyObject bindings, PyObject maxRows) {
        if (PyCursor.isSeq(params) && params.__len__() == 0) {
            return;
        }
        this.execute(sql, params, bindings, maxRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PyObject sql, PyObject params, PyObject bindings, PyObject maxRows) {
        int rowIndex = -1;
        this.clear();
        boolean hasParams = PyCursor.hasParams(params);
        PyStatement stmt2 = this.prepareStatement(sql, maxRows, hasParams);
        if (stmt2 == null) {
            return;
        }
        this.statement = stmt2;
        try {
            PyStatement pyStatement = this.statement;
            synchronized (pyStatement) {
                if (hasParams) {
                    if (PyCursor.isSeqSeq(params)) {
                        rowIndex = 0;
                        int len = params.__len__();
                        for (int i = 0; i < len; ++i) {
                            PyObject param = params.__getitem__(i);
                            this.execute(param, bindings);
                            ++rowIndex;
                        }
                    } else {
                        this.execute(params, bindings);
                    }
                } else {
                    this.execute(Py.None, Py.None);
                }
            }
        }
        catch (Throwable t) {
            if (this.statement != null && !(sql instanceof PyStatement)) {
                this.statement.close();
            }
            throw zxJDBC.makeException(zxJDBC.Error, t, rowIndex);
        }
    }

    protected void execute(PyObject params, PyObject bindings) {
        try {
            Statement stmt2 = this.statement.statement;
            this.datahandler.preExecute(stmt2);
            this.statement.execute(this, params, bindings);
            this.updateAttributes(stmt2.getUpdateCount());
            this.warning(new WarningEvent(this, stmt2.getWarnings()));
            this.datahandler.postExecute(stmt2);
        }
        catch (PyException e) {
            throw e;
        }
        catch (Throwable e) {
            throw zxJDBC.makeException(e);
        }
    }

    private void updateAttributes(int updateCount) throws SQLException {
        this.lastrowid = this.datahandler.getRowId(this.statement.statement);
        this.updatecount = updateCount < 0 ? Py.None : Py.newInteger(updateCount);
    }

    public PyObject fetchone() {
        this.ensureOpen();
        return this.fetch.fetchone();
    }

    public PyObject fetchall() {
        this.ensureOpen();
        return this.fetch.fetchall();
    }

    public PyObject fetchmany(int size) {
        this.ensureOpen();
        return this.fetch.fetchmany(size);
    }

    public PyObject nextset() {
        this.ensureOpen();
        PyObject nextset = this.fetch.nextset();
        if (!nextset.__nonzero__() && this.connection.supportsMultipleResultSets && !this.dynamicFetch) {
            Statement stmt2 = this.statement.statement;
            try {
                int hasMoreResults;
                int n = -1;
                boolean updateCount = stmt2.getMoreResults();
                if (updateCount || (hasMoreResults = stmt2.getUpdateCount()) != -1) {
                    this.updateAttributes(!updateCount ? hasMoreResults : stmt2.getUpdateCount());
                    this.fetch.add(stmt2.getResultSet());
                    nextset = Py.One;
                }
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(sQLException);
            }
        }
        return nextset;
    }

    public PyStatement prepare(PyObject sql) {
        PyStatement s = this.prepareStatement(sql, Py.None, true);
        this.connection.add(s);
        return s;
    }

    public void scroll(int value, String mode) {
        this.ensureOpen();
        this.fetch.scroll(value, mode);
    }

    @Override
    public void warning(WarningEvent event) {
        if (this.warnings == Py.None) {
            this.warnings = new PyList();
        }
        for (SQLWarning warning = event.getWarning(); warning != null; warning = warning.getNextWarning()) {
            PyObject[] warn = Py.javas2pys(warning.getMessage(), warning.getSQLState(), warning.getErrorCode());
            ((PyList)this.warnings).append(new PyTuple(warn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.ensureOpen();
        this.warnings = Py.None;
        this.lastrowid = Py.None;
        this.updatecount = Py.newInteger(-1);
        try {
            this.fetch.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            this.fetch = Fetch.newFetch(this.datahandler, this.dynamicFetch);
            this.fetch.addWarningListener(this);
        }
        if (this.statement != null) {
            try {
                if (!this.connection.contains(this.statement)) {
                    this.statement.close();
                }
            }
            finally {
                this.statement = null;
            }
        }
    }

    public static boolean isSeq(PyObject object) {
        if (object == null || object == Py.None) {
            return false;
        }
        if (object.__tojava__(List.class) != Py.NoConversion) {
            return true;
        }
        return object instanceof PyList || object instanceof PyTuple;
    }

    public static boolean hasParams(PyObject params) {
        if (Py.None == params) {
            return false;
        }
        boolean isSeq = PyCursor.isSeq(params);
        if (!isSeq) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("optionalSecond"));
        }
        return params.__len__() > 0;
    }

    public static boolean isSeqSeq(PyObject object) {
        if (PyCursor.isSeq(object) && object.__len__() > 0) {
            for (int i = 0; i < object.__len__(); ++i) {
                if (PyCursor.isSeq(object.__finditem__(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "cursor is closed");
        }
    }

    @Override
    public PyObject __enter__(ThreadState ts) {
        return this;
    }

    public PyObject __enter__() {
        return this;
    }

    @Override
    public boolean __exit__(ThreadState ts, PyException exception) {
        this.close();
        return false;
    }

    public boolean __exit__(PyObject type, PyObject value, PyObject traceback) {
        this.close();
        return false;
    }

    static {
        PyObject[] m = new PyObject[]{new PyString("close"), new PyString("execute"), new PyString("executemany"), new PyString("fetchone"), new PyString("fetchall"), new PyString("fetchmany"), new PyString("callproc"), new PyString("next"), new PyString("write")};
        __methods__ = new PyList(m);
        m = new PyObject[]{new PyString("arraysize"), new PyString("rowcount"), new PyString("rownumber"), new PyString("description"), new PyString("datahandler"), new PyString("warnings"), new PyString("lastrowid"), new PyString("updatecount"), new PyString("softspace"), new PyString("closed"), new PyString("connection")};
        __members__ = new PyList(m);
    }
}

