/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.gui.PlotMaker;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugIn,
Measurements,
PlotMaker {
    private static String[] choices = new String[]{"time", "z-axis"};
    private static String choice = choices[0];
    private boolean showingDialog;
    private ImagePlus imp;
    private boolean isPlotMaker;
    private boolean timeProfile;
    private boolean firstTime = true;
    private String options;

    public static Plot getPlot(ImagePlus imp) {
        return ZAxisProfiler.getPlot(imp, "time");
    }

    public static Plot getPlot(ImagePlus imp, String options) {
        ZAxisProfiler zap = new ZAxisProfiler();
        zap.imp = imp;
        zap.options = options;
        zap.isPlotMaker = true;
        Plot plot = zap.getPlot();
        return plot;
    }

    @Override
    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp.getStackSize() < 2) {
            IJ.error("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        this.isPlotMaker = true;
        Plot plot = this.getPlot();
        if (plot != null) {
            if (this.isPlotMaker) {
                plot.setPlotMaker(this);
            }
            plot.show();
        }
    }

    @Override
    public Plot getPlot() {
        String title;
        Roi roi = this.imp.getRoi();
        ImageProcessor ip = this.imp.getProcessor();
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        boolean hyperstack = this.imp.isHyperStack();
        float[] y = hyperstack ? this.getHyperstackProfile(roi, minThreshold, maxThreshold) : this.getZAxisProfile(roi, minThreshold, maxThreshold);
        if (y == null) {
            return null;
        }
        float[] x = new float[y.length];
        String xAxisLabel = this.showingDialog && choice.equals(choices[0]) ? "Frame" : "Slice";
        Calibration cal = this.imp.getCalibration();
        if (cal.scaled()) {
            double c = 1.0;
            double origin = 0.0;
            if (this.timeProfile) {
                String timeUnit;
                boolean zeroInterval;
                c = (float)cal.frameInterval;
                boolean bl = zeroInterval = c == 0.0;
                if (zeroInterval) {
                    c = 1.0;
                }
                xAxisLabel = timeUnit = zeroInterval ? "Frame" : "[" + cal.getTimeUnit() + "]";
            } else {
                String depthUnit;
                boolean zeroDepth;
                c = (float)cal.pixelDepth;
                boolean bl = zeroDepth = c == 0.0;
                if (zeroDepth) {
                    c = 1.0;
                }
                origin = cal.zOrigin;
                xAxisLabel = depthUnit = zeroDepth ? "Slice" : "[" + cal.getZUnit() + "]";
            }
            for (int i = 0; i < x.length; ++i) {
                x[i] = (float)(((double)i - cal.zOrigin) * c);
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                x[i] = i + 1;
            }
        }
        if (roi != null) {
            Rectangle r = roi.getBounds();
            title = this.imp.getTitle() + "-" + r.x + "-" + r.y;
        } else {
            title = this.imp.getTitle() + "-0-0";
        }
        Plot plot = new Plot(title, xAxisLabel, "Mean", x, y);
        if (x.length <= 60) {
            plot.setColor(Color.red);
            plot.addPoints(x, y, 0);
            plot.setColor(Color.black);
        }
        double ymin = ProfilePlot.getFixedMin();
        double ymax = ProfilePlot.getFixedMax();
        if (ymin != 0.0 || ymax != 0.0) {
            double[] a = Tools.getMinMax(x);
            double xmin = a[0];
            double xmax = a[1];
            plot.setLimits(xmin, xmax, ymin, ymax);
        }
        if (!this.firstTime) {
            double xx;
            int pos = this.imp.getCurrentSlice();
            int size = this.imp.getStackSize();
            if (hyperstack) {
                if (this.timeProfile) {
                    pos = this.imp.getT();
                    size = this.imp.getNFrames();
                } else {
                    pos = this.imp.getZ();
                    size = this.imp.getNSlices();
                }
            }
            if ((xx = ((double)pos - 1.0) / ((double)size - 1.0)) == 0.0) {
                plot.setLineWidth(2);
            }
            plot.setColor(Color.blue);
            plot.drawNormalizedLine(xx, 0.0, xx, 1.0);
            plot.setColor(Color.black);
            plot.setLineWidth(1);
        }
        this.firstTime = false;
        return plot;
    }

    @Override
    public ImagePlus getSourceImage() {
        return this.imp;
    }

    private float[] getHyperstackProfile(Roi roi, double minThreshold, double maxThreshold) {
        int slices = this.imp.getNSlices();
        int frames = this.imp.getNFrames();
        int c = this.imp.getC();
        int z = this.imp.getZ();
        int t = this.imp.getT();
        int size = slices;
        if (this.firstTime) {
            boolean bl = this.timeProfile = slices == 1 && frames > 1;
        }
        if (this.options == null && slices > 1 && frames > 1 && (!this.isPlotMaker || this.firstTime)) {
            this.showingDialog = true;
            GenericDialog gd = new GenericDialog("Profiler");
            gd.addChoice("Profile", choices, choice);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            choice = gd.getNextChoice();
            this.timeProfile = choice.equals(choices[0]);
        }
        if (this.options != null) {
            this.timeProfile = frames > 1 && !this.options.contains("z");
        }
        size = this.timeProfile ? frames : slices;
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(this.imp, rt);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = !this.isPlotMaker && measurements != 0 && measurements != 256;
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        ImageStack stack = this.imp.getStack();
        boolean showProgress = size > 400 || stack.isVirtual();
        for (int i = 1; i <= size; ++i) {
            if (showProgress) {
                IJ.showProgress(i, size);
            }
            int index = 1;
            index = this.timeProfile ? this.imp.getStackIndex(c, z, i) : this.imp.getStackIndex(c, i, t);
            ImageProcessor ip = stack.getProcessor(index);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            values[i - 1] = (float)stats.mean;
        }
        if (showResults) {
            rt.show("Results");
        }
        return values;
    }

    private float[] getZAxisProfile(Roi roi, double minThreshold, double maxThreshold) {
        int size;
        ImageStack stack = this.imp.getStack();
        if (this.firstTime) {
            int slices = this.imp.getNSlices();
            int frames = this.imp.getNFrames();
            this.timeProfile = slices == 1 && frames > 1;
        }
        boolean showProgress = (size = stack.size()) > 400 || stack.isVirtual();
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(this.imp, rt);
        int measurements = Analyzer.getMeasurements();
        boolean showResults = !this.isPlotMaker && measurements != 0 && measurements != 256;
        boolean showingLabels = this.firstTime && showResults && ((measurements & 0x400) != 0 || (measurements & 0x100000) != 0);
        measurements |= 2;
        if (showResults && !Analyzer.resetCounter()) {
            return null;
        }
        boolean isLine = roi != null && roi.isLine();
        int current = this.imp.getCurrentSlice();
        for (int i = 1; i <= size; ++i) {
            if (showProgress) {
                IJ.showProgress(i, size);
            }
            if (showingLabels) {
                this.imp.setSlice(i);
            }
            ImageProcessor ip = stack.getProcessor(i);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = null;
            stats = isLine ? this.getLineStatistics(roi, ip, measurements, cal) : ImageStatistics.getStatistics(ip, measurements, cal);
            analyzer.saveResults(stats, roi);
            values[i - 1] = (float)stats.mean;
        }
        if (showResults) {
            rt.show("Results");
        }
        if (showingLabels) {
            this.imp.setSlice(current);
        }
        return values;
    }

    private ImageStatistics getLineStatistics(Roi roi, ImageProcessor ip, int measurements, Calibration cal) {
        ImagePlus imp = new ImagePlus("", ip);
        imp.setRoi(roi);
        ProfilePlot profile = new ProfilePlot(imp);
        double[] values = profile.getProfile();
        FloatProcessor ip2 = new FloatProcessor(values.length, 1, values);
        return ImageStatistics.getStatistics(ip2, measurements, cal);
    }
}

