/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.convert;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class ROIToRectangle
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected final VarROIArray input = new VarROIArray("Roi(s)");
    protected final VarDouble width = new VarDouble("Width", 1.0);
    protected final VarDouble height = new VarDouble("Height", 1.0);
    protected final VarROIArray output = new VarROIArray("Rectangle roi(s)");

    public void run() {
        ROI[] rois = (ROI[])this.input.getValue();
        ROI[] result = new ROI[rois != null ? rois.length : 0];
        double w = this.width.getValue();
        double h = this.height.getValue();
        try {
            if (rois != null) {
                for (int r = 0; r < rois.length; ++r) {
                    result[r] = ROIUtil.convertToRectangle((ROI)rois[r], (double)w, (double)h);
                }
            }
        }
        catch (InterruptedException e) {
            System.err.println("ROIToRectangle process interrupted !");
            this.output.setValue(null);
            return;
        }
        this.output.setValue((Object)result);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input", (Var)this.input);
        inputMap.add("width", (Var)this.width);
        inputMap.add("height", (Var)this.height);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

