/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.gui.dialog.MessageDialog;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.plugin.interface_.PluginBundled;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.collection.CollectionUtil;
import icy.util.StringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.stef.roi.bloc.RoiBlocks;
import plugins.tprovoost.sequenceblocks.infos.EzVarColormap;

public class ColorROI
extends EzPlug
implements ROIBlock,
PluginBundled {
    protected final VarROIArray roiSet;
    protected final VarSequence sequence;
    protected final EzVarText descriptors;
    protected final EzVarColormap colormap;
    protected final EzVarBoolean reverse;

    public ColorROI() {
        ArrayList roiDescriptors = new ArrayList(ROIDescriptor.getDescriptors().keySet());
        ArrayList<String> descriptorsId = new ArrayList<String>();
        String sizeDescriptorId = null;
        for (ROIDescriptor descriptor : roiDescriptors) {
            String id = descriptor.getId();
            if (StringUtil.equals((String)"Interior", (String)id)) {
                sizeDescriptorId = id;
            }
            descriptorsId.add(id);
        }
        Collections.sort(descriptorsId);
        this.roiSet = new VarROIArray("ROI(s)", null);
        this.sequence = new VarSequence("Sequence", null);
        this.descriptors = new EzVarText("Filter on", descriptorsId.toArray(new String[descriptorsId.size()]), descriptorsId.indexOf(sizeDescriptorId), Boolean.FALSE);
        this.colormap = new EzVarColormap("Color map", (IcyColorMap)LinearColorMap.gray_);
        this.reverse = new EzVarBoolean("Reverse", false);
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.descriptors);
        this.addEzComponent((EzComponent)this.colormap);
        this.addEzComponent((EzComponent)this.reverse);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("roi", (Var)this.roiSet);
        inputMap.add("sequence", (Var)this.sequence);
        inputMap.add("descriptors", this.descriptors.getVariable());
        inputMap.add("colormap", this.colormap.getVariable());
        inputMap.add("reverse", this.reverse.getVariable());
    }

    public void declareOutput(VarList outputMap) {
    }

    public void clean() {
    }

    protected void execute() {
        Sequence seq;
        List rois = null;
        if (this.isHeadLess()) {
            seq = (Sequence)this.sequence.getValue();
            rois = CollectionUtil.asList((Object[])((ROI[])this.roiSet.getValue()));
        } else {
            seq = this.getActiveSequence();
            if (seq != null && (rois = seq.getROIs()).isEmpty()) {
                MessageDialog.showDialog((String)"The selected Sequence doesn't contain any ROI", (int)1);
            }
        }
        try {
            if (rois != null) {
                ColorROI.colorROIs(rois, seq, (String)this.descriptors.getValue(), (IcyColorMap)this.colormap.getValue(), (Boolean)this.reverse.getValue());
            }
        }
        catch (IllegalArgumentException e) {
            if (this.isHeadLess()) {
                throw new VarException(this.descriptors.getVariable(), e.getMessage());
            }
            throw e;
        }
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }

    public static void colorROIs(Collection<ROI> rois, Sequence sequence, String descriptorId, IcyColorMap colormap, boolean reverse) throws IllegalArgumentException {
        ROIDescriptor roiDescriptor = ROIDescriptor.getDescriptor(ROIDescriptor.getDescriptors().keySet(), (String)descriptorId);
        if (roiDescriptor == null) {
            throw new IllegalArgumentException("Cannot found '" + descriptorId + "' ROI descriptor !");
        }
        HashMap<ROI, Number> results = new HashMap<ROI, Number>();
        double minValue = Double.MAX_VALUE;
        double maxValue = -1.7976931348623157E308;
        for (ROI roi : rois) {
            if (roi == null) continue;
            try {
                double value;
                Object res = roiDescriptor.compute(roi, sequence);
                if (!(res instanceof Number) || Double.isNaN(value = ((Number)res).doubleValue()) || Double.isInfinite(value)) continue;
                if (value < minValue) {
                    minValue = value;
                }
                if (value > maxValue) {
                    maxValue = value;
                }
                results.put(roi, (Number)res);
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)false, (boolean)true);
            }
        }
        double range = maxValue - minValue;
        for (ROI roi : rois) {
            Color color;
            if (roi == null) continue;
            Number res = (Number)results.get(roi);
            if (res != null) {
                double value = res.doubleValue();
                int index = (int)Math.round((value - minValue) / range * 255.0);
                if (reverse) {
                    index = 255 - index;
                }
                color = colormap.getColor(index);
            } else {
                color = Color.black;
            }
            roi.setColor(color);
        }
    }
}

