/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import org.jtransforms.fft.DoubleFFT_2D;

@Deprecated
public class MathUtils {
    public static final int COLORMAP_GRAYSCALE = 0;
    public static final int COLORMAP_JET = 1;
    public static final int GAUSSIAN = 2;
    public static final int AVERAGE = 3;
    public static final int PREWITT = 4;
    public static final int SOBEL = 5;
    public static final int KIRSH = 6;
    public static final int DISK = 7;

    public static boolean even(int x) {
        return x % 2 == 0;
    }

    public static long factorial(long n) {
        if (n == 0L) {
            return 1L;
        }
        return n * MathUtils.factorial(n - 1L);
    }

    public static double[][] cartesDist2D(int W, int H) {
        double[][] R = new double[H][W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2, 1.0);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2, 1.0);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                R[i][j] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
            }
        }
        return R;
    }

    public static double[] cartesDist1D(int W, int H) {
        double[] R = new double[H * W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                R[j * H + i] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
            }
        }
        return R;
    }

    public static double[] cartesAngle1D(int W, int H) {
        double[] THETA = new double[H * W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                THETA[j * H + i] = Math.atan2(y[i], x[j]);
            }
        }
        return THETA;
    }

    public static double[][] cartesAngle2D(int W, int H) {
        double[][] THETA = new double[H][W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                THETA[i][j] = Math.atan2(y[i], x[j]);
            }
        }
        return THETA;
    }

    public static double[] catArray(double[] a, double[] b) {
        int i;
        int L = a.length + b.length;
        double[] out = new double[L];
        for (i = 0; i < a.length; ++i) {
            out[i] = a[i];
        }
        for (i = b.length; i < L; ++i) {
            out[i] = b[i - b.length];
        }
        return out;
    }

    public static double[] create3DSquare(int nxy, int nz, int sizeSquare) {
        double[] out = new double[nxy * nxy * nz];
        for (int k = 0; k < nz; ++k) {
            for (int j = nxy / 2 - sizeSquare / 2; j < nxy / 2 + sizeSquare / 2; ++j) {
                for (int i = nxy / 2 - sizeSquare / 2; i < nxy / 2 + sizeSquare / 2; ++i) {
                    out[k * nxy * nxy + j * nxy + i] = 1.0;
                }
            }
        }
        return out;
    }

    public static double[][] fftAngle(int W, int H) {
        double[][] THETA = new double[H][W];
        double[] x = MathUtils.fftIndgen(W);
        double[] y = MathUtils.fftIndgen(H);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                THETA[i][j] = Math.atan2(y[i], x[j]);
            }
        }
        return THETA;
    }

    public static double[] fftAngle1D(int W, int H) {
        double[] THETA = new double[W * H];
        double[] x = MathUtils.fftIndgen(W);
        double[] y = MathUtils.fftIndgen(H);
        for (int j = 0; j < H; ++j) {
            for (int i = 0; i < W; ++i) {
                THETA[i + j * W] = Math.atan2(y[j], x[i]);
            }
        }
        return THETA;
    }

    public static double[] fftIndgen(int L) {
        double[] k = new double[L];
        double[] u = MathUtils.indgen(0, L - 1);
        for (int i = 0; i < L; ++i) {
            k[i] = u[i] > (double)(L / 2) ? u[i] - (double)L : u[i];
        }
        return k;
    }

    public static double[] fftDist(int L) {
        double[] x = new double[L];
        double[] R = new double[L];
        x = MathUtils.fftIndgen(L);
        for (int i = 0; i < L; ++i) {
            R[i] = Math.sqrt(x[i] * x[i] + x[i] * x[i]);
        }
        return R;
    }

    public static double[][] fftDist(int W, int H) {
        double[] x = new double[W];
        double[] y = new double[H];
        double[][] R = new double[H][W];
        x = MathUtils.fftIndgen(W);
        y = MathUtils.fftIndgen(H);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                R[i][j] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
            }
        }
        return R;
    }

    public static double[] fftDist1D(int W, int H) {
        double[] R = new double[H * W];
        double[] x = MathUtils.fftIndgen(W);
        double[] y = MathUtils.fftIndgen(H);
        for (int j = 0; j < H; ++j) {
            for (int i = 0; i < W; ++i) {
                R[i + j * W] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
            }
        }
        return R;
    }

    public static double[][][] gram_schmidt_orthonormalization(double[][][] A) {
        int D = A.length;
        int H = A[0].length;
        int W = A[0][0].length;
        double[][] Ai = new double[H][W];
        double[][] Aj = new double[H][W];
        double[][] s = new double[H][W];
        for (int i = 0; i < D; ++i) {
            double SAii;
            int x;
            int y;
            int x2;
            for (x2 = 0; x2 < W; ++x2) {
                for (y = 0; y < H; ++y) {
                    Ai[y][x2] = A[i][y][x2];
                }
            }
            if (i > 0) {
                for (x2 = 0; x2 < W; ++x2) {
                    for (y = 0; y < H; ++y) {
                        Aj[y][x2] = A[0][y][x2];
                    }
                }
                double SAij = MathUtils.sum(MathUtils.hadamardProd(Ai, Aj, 0));
                for (x = 0; x < W; ++x) {
                    for (int y2 = 0; y2 < H; ++y2) {
                        s[y2][x] = SAij * Aj[y2][x];
                    }
                }
                for (int j = 1; j < i; ++j) {
                    for (int x3 = 0; x3 < W; ++x3) {
                        for (int y3 = 0; y3 < H; ++y3) {
                            Aj[y3][x3] = A[j][y3][x3];
                        }
                    }
                    double SAij2 = MathUtils.sum(MathUtils.hadamardProd(Ai, Aj, 0));
                    for (int x4 = 0; x4 < W; ++x4) {
                        for (int y4 = 0; y4 < H; ++y4) {
                            double[] dArray = s[y4];
                            int n = x4;
                            dArray[n] = dArray[n] + SAij2 * Aj[y4][x4];
                        }
                    }
                }
                for (x = 0; x < W; ++x) {
                    for (int y5 = 0; y5 < H; ++y5) {
                        double[] dArray = Ai[y5];
                        int n = x;
                        dArray[n] = dArray[n] - s[y5][x];
                    }
                }
            }
            if ((SAii = MathUtils.sum(MathUtils.hadamardProd(Ai, Ai, 0))) > 0.0) {
                for (x = 0; x < W; ++x) {
                    for (int y6 = 0; y6 < H; ++y6) {
                        A[i][y6][x] = 1.0 / Math.sqrt(SAii) * Ai[y6][x];
                    }
                }
                continue;
            }
            for (x = 0; x < W; ++x) {
                for (int y7 = 0; y7 < H; ++y7) {
                    A[i][y7][x] = 0.0;
                }
            }
        }
        return A;
    }

    public static double[] gram_schmidt_orthonormalization(double[] A, int dim1, int dim2, int dim3) {
        double[] Ak = new double[dim1 * dim2];
        double[] Al = new double[dim1 * dim2];
        double[] s = new double[dim1 * dim2];
        for (int k = 0; k < dim3; ++k) {
            double SA_kl;
            int i1;
            int i2;
            for (i2 = 0; i2 < dim2; ++i2) {
                for (i1 = 0; i1 < dim1; ++i1) {
                    Ak[i1 + dim1 * i2] = A[i1 + dim1 * i2 + k * dim1 * dim2];
                }
            }
            if (k > 0) {
                int i12;
                for (i2 = 0; i2 < dim2; ++i2) {
                    for (i1 = 0; i1 < dim1; ++i1) {
                        Al[i1 + dim1 * i2] = A[i1 + dim1 * i2];
                    }
                }
                SA_kl = MathUtils.innerProd(Ak, Al);
                for (i12 = 0; i12 < dim1 * dim2; ++i12) {
                    s[i12] = SA_kl * Al[i12];
                }
                for (int l = 1; l < k; ++l) {
                    for (int i22 = 0; i22 < dim2; ++i22) {
                        for (int i13 = 0; i13 < dim1; ++i13) {
                            Al[i13 + dim1 * i22] = A[i13 + dim1 * i22 + l * dim1 * dim2];
                        }
                    }
                    SA_kl = MathUtils.innerProd(Ak, Al);
                    for (int i122 = 0; i122 < dim1 * dim2; ++i122) {
                        int n = i122;
                        s[n] = s[n] + SA_kl * Al[i122];
                    }
                }
                for (i12 = 0; i12 < dim1 * dim2; ++i12) {
                    int n = i12;
                    Ak[n] = Ak[n] - s[i12];
                }
            }
            if ((SA_kl = MathUtils.innerProd(Ak, Ak)) > 0.0) {
                for (i2 = 0; i2 < dim2; ++i2) {
                    for (i1 = 0; i1 < dim1; ++i1) {
                        A[i1 + dim1 * i2 + k * dim1 * dim2] = 1.0 / Math.sqrt(SA_kl) * Ak[i1 + dim1 * i2];
                    }
                }
                continue;
            }
            for (i2 = 0; i2 < dim2; ++i2) {
                for (i1 = 0; i1 < dim1; ++i1) {
                    A[i1 + dim1 * i2 + k * dim1 * dim2] = 0.0;
                }
            }
        }
        return A;
    }

    public static double[] span(double begin, double end, double scale) {
        double a = begin;
        int L = 0;
        while (a <= end) {
            a += scale;
            ++L;
        }
        double[] tab = new double[L];
        a = begin;
        int b = 0;
        for (double i = begin; i <= end; i += scale) {
            tab[b] = i;
            ++b;
        }
        return tab;
    }

    public static double[] indgen(int n) {
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = i + 1;
        }
        return out;
    }

    public static double[] indgen(int start, int stop) {
        int L = stop - start + 1;
        double[] out = new double[L];
        for (int i = start; i <= stop; ++i) {
            out[i - start] = i;
        }
        return out;
    }

    public static double[] indgen(int start, int stop, double scale) {
        double a = start;
        int L = 0;
        while (a <= (double)stop) {
            a += scale;
            ++L;
        }
        double[] tab = new double[L];
        a = start;
        int b = 0;
        for (double i = (double)start; i <= (double)stop; i += scale) {
            tab[b] = i;
            ++b;
        }
        return tab;
    }

    public static double[] span(double start, double stop, int n) {
        double[] out = new double[n];
        double c1 = (stop - start) / (double)(n - 1);
        double c2 = (double)(n + 1) / 2.0;
        double c3 = (start + stop) / 2.0;
        for (int i = 0; i < n; ++i) {
            out[i] = c1 * ((double)(i + 1) - c2) + c3;
        }
        return out;
    }

    public static double[] scaleArrayTo8bit(double[] A) {
        int L = A.length;
        double[] scaleA = new double[L];
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        for (int i = 0; i < L; ++i) {
            scaleA[i] = (A[i] - minScaleA) * 255.0 / deltaScaleA;
        }
        return scaleA;
    }

    public static double[][] scaleArrayTo8bit(double[][] A) {
        int H = A.length;
        int W = A[0].length;
        double[][] scaleA = new double[H][W];
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                scaleA[i][j] = (A[i][j] - minScaleA) * 255.0 / deltaScaleA;
            }
        }
        return scaleA;
    }

    public static void uint8(double[][] A) {
        int H = A.length;
        int W = A[0].length;
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                A[i][j] = (A[i][j] - minScaleA) * 255.0 / deltaScaleA;
            }
        }
    }

    public static double[] uint16(double[] A) {
        int L = A.length;
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        for (int i = 0; i < L; ++i) {
            A[i] = (A[i] - minScaleA) * 65535.0 / deltaScaleA;
        }
        return A;
    }

    public static void normalise(double[] A) {
        int L = A.length;
        double N = MathUtils.sum(MathUtils.abs2(A, 0));
        for (int i = 0; i < L; ++i) {
            A[i] = A[i] / N;
        }
    }

    public static void im2double(double[][] a) {
        int H = a.length;
        int W = a[0].length;
        double minA = MathUtils.min(a);
        double maxA = MathUtils.max(a);
        double delta = maxA - minA;
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                a[i][j] = (a[i][j] - minA) / delta;
            }
        }
    }

    public static double[][] conj1(double[][] A) {
        int H = A.length;
        int W = A[0].length;
        double[][] conjA = new double[H][W];
        for (int j = 0; j < W / 2; ++j) {
            for (int i = 0; i < H; ++i) {
                conjA[i][2 * j] = A[i][2 * j];
                conjA[i][2 * j + 1] = -A[i][2 * j + 1];
            }
        }
        return conjA;
    }

    public static void conj2(double[] A) {
        for (int i = 0; i < A.length / 2; ++i) {
            A[2 * i + 1] = -A[2 * i + 1];
        }
    }

    public static double[][] abs2(double[][] IN) {
        int H = IN.length;
        int W = IN[0].length / 2;
        double[][] OUT = new double[H][W];
        for (int i = 0; i < H; ++i) {
            OUT[i] = MathUtils.abs2(IN[i], 1);
        }
        return OUT;
    }

    public static double[] abs2(double[] x, int isComplex) {
        if (isComplex == 1) {
            int L = x.length / 2;
            double[] y = new double[L];
            for (int i = 0; i < L; ++i) {
                y[i] = x[2 * i] * x[2 * i] + x[2 * i + 1] * x[2 * i + 1];
            }
            return y;
        }
        int L = x.length;
        double[] y = new double[L];
        for (int i = 0; i < L; ++i) {
            y[i] = x[i] * x[i];
        }
        return y;
    }

    public static double[] abs2(double[] x, int begin, int end, int isComplex) {
        if (isComplex == 1) {
            int L = x.length / 2;
            double[] y = new double[L];
            for (int i = begin; i < end; ++i) {
                y[i] = x[2 * i] * x[2 * i] + x[2 * i + 1] * x[2 * i + 1];
            }
            return y;
        }
        int L = end - begin + 1;
        double[] y = new double[L];
        for (int i = 0; i < L; ++i) {
            y[i] = x[i + begin] * x[i + begin];
        }
        return y;
    }

    public static double min(double[] matrix) {
        double min = matrix[0];
        for (int i = 0; i < matrix.length; ++i) {
            if (!(min > matrix[i])) continue;
            min = matrix[i];
        }
        return min;
    }

    public static double min(double[][] matrix) {
        double min = matrix[0][0];
        for (int col = 0; col < matrix.length; ++col) {
            for (int row = 0; row < matrix[col].length; ++row) {
                if (!(min > matrix[col][row])) continue;
                min = matrix[col][row];
            }
        }
        return min;
    }

    public static double max(double[] matrix) {
        double max = matrix[0];
        for (int i = 0; i < matrix.length; ++i) {
            if (!(max < matrix[i])) continue;
            max = matrix[i];
        }
        return max;
    }

    public static double max(double[][] matrix) {
        double max = matrix[0][0];
        for (int col = 0; col < matrix.length; ++col) {
            for (int row = 0; row < matrix[col].length; ++row) {
                if (!(max < matrix[col][row])) continue;
                max = matrix[col][row];
            }
        }
        return max;
    }

    public static void printArray(int[] A) {
        System.out.println(Arrays.toString(A));
    }

    public static void printArray(double[] A) {
        System.out.println(Arrays.toString(A));
    }

    public static void printArray(double[] A, int begin, int end, int decimal) {
        if (decimal == 0) {
            for (int k = begin; k <= end; ++k) {
                System.out.printf("%f ", A[k]);
            }
        } else {
            for (int k = begin; k <= end; ++k) {
                System.out.printf("%.4E ", A[k]);
            }
        }
    }

    public static void printArray(double[] A, int width, int height, int deepth, int decimal) {
        if (decimal == 0) {
            for (int k = 0; k < deepth; ++k) {
                System.out.println("k = " + k);
                for (int j = 0; j < height; ++j) {
                    for (int i = 0; i < width; ++i) {
                        System.out.printf("%.2f ", A[i + j * width + k * width * height]);
                    }
                    System.out.println();
                }
            }
        } else {
            for (int k = 0; k < deepth; ++k) {
                System.out.println("k = " + k);
                for (int j = 0; j < height; ++j) {
                    for (int i = 0; i < width; ++i) {
                        System.out.printf("%.4E ", A[i + j * width + k * width * height]);
                    }
                    System.out.println();
                }
            }
        }
        System.out.println();
    }

    public static void printArray(double[][] A) {
        int H = A.length;
        for (int i = 0; i < H; ++i) {
            System.out.println(Arrays.toString(A[i]));
        }
    }

    public static double[][] fftShift(double[][] A) {
        int i;
        int j;
        int H = A.length;
        int W = A[0].length;
        double[][] A_shift = new double[H][W];
        for (j = 0; j < W / 2; ++j) {
            for (i = 0; i < H / 2; ++i) {
                A_shift[H - H / 2 + i][W - W / 2 + j] = A[i][j];
            }
        }
        for (j = 0; j < W / 2; ++j) {
            for (i = 0; i < H / 2; ++i) {
                A_shift[H - H / 2 + i][j] = A[i][j + W / 2];
            }
        }
        for (j = 0; j < W / 2; ++j) {
            for (i = 0; i < H / 2; ++i) {
                A_shift[i][W - W / 2 + j] = A[i + H / 2][j];
            }
        }
        for (j = 0; j < W / 2; ++j) {
            for (i = 0; i < H / 2; ++i) {
                A_shift[i][j] = A[i + H / 2][j + W / 2];
            }
        }
        return A_shift;
    }

    public static double[] fftShift1D(double[] A, int w, int h, int d) {
        double[] A_shift = new double[w * h * d];
        for (int k = 0; k < d; ++k) {
            for (int j = 0; j < h / 2; ++j) {
                for (int i = 0; i < w / 2; ++i) {
                    A_shift[w * (h - h / 2 + j) + w - w / 2 + i] = A[i + w * j];
                    A_shift[w * (h - h / 2 + j) + i] = A[w * j + i + w / 2];
                    A_shift[w * j + w - w / 2 + i] = A[w * (j + h / 2) + i];
                    A_shift[i + w * j] = A[w * (j + h / 2) + i + w / 2];
                }
            }
        }
        return A_shift;
    }

    public static double[] fftShift1D(double[] A, int w, int h) {
        double[] A_shift = new double[w * h];
        for (int j = 0; j < h / 2; ++j) {
            for (int i = 0; i < w / 2; ++i) {
                A_shift[w * (h - h / 2 + j) + w - w / 2 + i] = A[i + w * j];
                A_shift[w * (h - h / 2 + j) + i] = A[w * j + i + w / 2];
                A_shift[w * j + w - w / 2 + i] = A[w * (j + h / 2) + i];
                A_shift[i + w * j] = A[w * (j + h / 2) + i + w / 2];
            }
        }
        return A_shift;
    }

    public static double[] fftShift3D(double[] A, int w, int h, int d) {
        double[] A_shift = new double[w * h * d];
        int wh = w * h;
        for (int k = 0; k < d / 2; ++k) {
            for (int j = 0; j < h / 2; ++j) {
                for (int i = 0; i < w / 2; ++i) {
                    A_shift[w - w / 2 + i + w * (h - h / 2 + j) + wh * (d - d / 2 + k)] = A[i + w * j + k * wh];
                    A_shift[i + w * (h - h / 2 + j) + wh * (d - d / 2 + k)] = A[i + w / 2 + w * j + k * wh];
                    A_shift[w - w / 2 + i + w * j + wh * (d - d / 2 + k)] = A[i + w * (j + h / 2) + k * wh];
                    A_shift[i + w * j + wh * (d - d / 2 + k)] = A[i + w / 2 + w * (j + h / 2) + k * wh];
                    A_shift[w - w / 2 + i + w * (h - h / 2 + j) + k * wh] = A[i + w * j + wh * (d - d / 2 + k)];
                    A_shift[i + w * (h - h / 2 + j) + k * wh] = A[i + w / 2 + w * j + wh * (d - d / 2 + k)];
                    A_shift[w - w / 2 + i + w * j + k * wh] = A[i + w * (j + h / 2) + wh * (d - d / 2 + k)];
                    A_shift[i + w * j + k * wh] = A[i + w / 2 + w * (j + h / 2) + wh * (d - d / 2 + k)];
                }
            }
        }
        return A_shift;
    }

    public static double[][] fftConv(double[][] img, double[][] h) {
        int H = img.length;
        int W = img[0].length;
        DoubleFFT_2D FFT2D = new DoubleFFT_2D(H, W);
        double[][] res = new double[H][W];
        double[][] hC = MathUtils.real2complex(h);
        double[][] imgC = MathUtils.real2complex(img);
        FFT2D.complexForward(hC);
        FFT2D.complexForward(imgC);
        double[][] fft_img_h = MathUtils.hadamardProd(hC, imgC, 1);
        FFT2D.complexInverse(fft_img_h, true);
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                res[i][j] = fft_img_h[i][2 * j];
            }
        }
        return res;
    }

    public static double[][] real2complex(double[][] a) {
        int H = a.length;
        int W = a[0].length;
        double[][] c = new double[H][2 * W];
        for (int j = 0; j < W; ++j) {
            for (int i = 0; i < H; ++i) {
                c[i][2 * j] = a[i][j];
            }
        }
        return c;
    }

    public static double avg(double[] a) {
        return MathUtils.sum(a) / (double)a.length;
    }

    public static double avg(long[] a) {
        return MathUtils.sum(a) / (long)a.length;
    }

    public static double avg(double[][] a) {
        int H = a.length;
        int W = a[0].length;
        return MathUtils.sum(a) / (double)(H * W);
    }

    public static double avg(double[][][] a) {
        int W = a.length;
        int H = a[0].length;
        int D = a[0][0].length;
        return MathUtils.sum(a) / (double)(D * H * W);
    }

    public static double sum(double[] a) {
        int size = a.length;
        double sum = 0.0;
        for (int i = 0; i < size; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static double sum(double[] a, int begin, int end) {
        double sum = 0.0;
        for (int i = begin; i <= end; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static long sum(long[] array) {
        int size = array.length;
        long sum = 0L;
        for (int i = 0; i < size; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double sum(double[][] array) {
        int H = array.length;
        double sum = 0.0;
        for (int i = 0; i < H; ++i) {
            sum += MathUtils.sum(array[i]);
        }
        return sum;
    }

    public static double sum(double[][][] array) {
        int D = array.length;
        double sum = 0.0;
        for (int k = 0; k < D; ++k) {
            sum += MathUtils.sum(array[k]);
        }
        return sum;
    }

    public static double innerProd(double[] a, double[] b) {
        int L = a.length;
        double out = 0.0;
        for (int i = 0; i < L; ++i) {
            out += a[i] * b[i];
        }
        return out;
    }

    public static double[] im2array(String imageName) {
        File fileI = new File(imageName);
        BufferedImage I = null;
        try {
            I = ImageIO.read(fileI);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int H = I.getHeight();
        int W = I.getWidth();
        double[] ImArray = new double[H * W];
        WritableRaster raster = I.getRaster();
        for (int j = 0; j < H; ++j) {
            for (int i = 0; i < W; ++i) {
                int[] pixels = raster.getPixel(j, i, (int[])null);
                ImArray[i + j * W] = pixels[0];
            }
        }
        return ImArray;
    }

    public static double[][] img_pad(double[][] img, int newW, int newH, int just) {
        int oldH = img.length;
        int oldW = img[0].length;
        double[][] New = new double[newH][newW];
        switch (just) {
            case 0: {
                for (int i = 0; i < oldH; ++i) {
                    for (int j = 0; j < oldW; ++j) {
                        New[i][j] = img[i][j];
                    }
                }
                break;
            }
            case 1: {
                int i1 = (newW - oldW) / 2;
                int i2 = (newH - oldH) / 2;
                for (int i = 0; i < oldH; ++i) {
                    for (int j = 0; j < oldW; ++j) {
                        New[i2 + i][j + i1] = img[i][j];
                    }
                }
                break;
            }
            case -1: {
                int j;
                int i;
                int oldW2 = oldW / 2;
                int oldH2 = oldH / 2;
                if (oldW2 != 0 || oldH2 != 0) {
                    for (i = 0; i < oldH2; ++i) {
                        for (j = 0; j < oldW2; ++j) {
                            New[newH - oldH2 + i][newW - oldW2 + j] = img[i][j];
                        }
                    }
                }
                if (oldW2 != 0) {
                    for (i = 0; i < oldH2; ++i) {
                        for (j = 0; j < oldW - oldW2; ++j) {
                            New[newH - oldH2 + i][j] = img[i][j + oldW2];
                        }
                    }
                }
                if (oldH2 != 0) {
                    for (i = 0; i < oldH - oldH2; ++i) {
                        for (j = 0; j < oldW2; ++j) {
                            New[i][newW - oldW2 + j] = img[i + oldH2][j];
                        }
                    }
                }
                for (i = 0; i < oldH - oldH2; ++i) {
                    for (j = 0; j < oldW - oldW2; ++j) {
                        New[i][j] = img[i + oldH2][j + oldW2];
                    }
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return New;
    }

    public static double[] img_pad1d(double[] img, int oldW, int oldH, int newW, int newH, int just) {
        double[] New = new double[newH * newW];
        switch (just) {
            case 0: {
                for (int j = 0; j < oldH; ++j) {
                    for (int i = 0; i < oldW; ++i) {
                        New[i + j * newW] = img[i + j * oldW];
                    }
                }
                break;
            }
            case 1: {
                int i1 = (newW - oldW) / 2;
                int i2 = (newH - oldH) / 2;
                for (int j = 0; j < oldH; ++j) {
                    for (int i = 0; i < oldW; ++i) {
                        New[i2 + j + (i + i1) * newW] = img[i * oldW + j];
                    }
                }
                break;
            }
            case -1: {
                int i;
                int j;
                int oldW2 = oldW / 2;
                int oldH2 = oldH / 2;
                if (oldW2 != 0 || oldH2 != 0) {
                    for (j = 0; j < oldH2; ++j) {
                        for (i = 0; i < oldW2; ++i) {
                            New[newH - oldH2 + j + (newW - oldW2 + i) * newW] = img[i * oldW + j];
                        }
                    }
                }
                if (oldW2 != 0) {
                    for (j = 0; j < oldH2; ++j) {
                        for (i = 0; i < oldW - oldW2; ++i) {
                            New[(newH - oldH2 + j) * newW + i] = img[j * oldW + i + oldW2];
                        }
                    }
                }
                if (oldH2 != 0) {
                    for (j = 0; j < oldH - oldH2; ++j) {
                        for (i = 0; i < oldW2; ++i) {
                            New[j * newW + newW - oldW2 + i] = img[(j + oldH2) * oldW + i];
                        }
                    }
                }
                for (j = 0; j < oldH - oldH2; ++j) {
                    for (i = 0; i < oldW - oldW2; ++i) {
                        New[i + j * newW] = img[(j + oldH2) * oldW + i + oldW2];
                    }
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return New;
    }

    public static double[] img_pad(double[] img, int oldW, int oldH, int oldD, int newW, int newH, int newD, int just) {
        double[] New = new double[newH * newW * newD];
        int newWH = newW * newH;
        int oldWH = oldW * oldH;
        switch (just) {
            case 0: {
                for (int k = 0; k < oldD; ++k) {
                    for (int j = 0; j < oldH; ++j) {
                        for (int i = 0; i < oldW; ++i) {
                            New[i + j * newW] = img[i + j * oldW];
                        }
                    }
                }
                break;
            }
            case 1: {
                int i2 = (newW - oldW) / 2;
                int j2 = (newH - oldH) / 2;
                int k2 = (newD - oldD) / 2;
                for (int k = 0; k < oldD; ++k) {
                    for (int j = 0; j < oldH; ++j) {
                        for (int i = 0; i < oldW; ++i) {
                            New[i2 + i + (j + j2) * newW + (k + k2) * newWH] = img[i + j * oldW + k * oldWH];
                        }
                    }
                }
                break;
            }
            case -1: {
                int i;
                int j;
                int oldW2 = oldW / 2;
                int oldH2 = oldH / 2;
                if (oldW2 != 0 || oldH2 != 0) {
                    for (j = 0; j < oldH2; ++j) {
                        for (i = 0; i < oldW2; ++i) {
                            New[newH - oldH2 + j + (newW - oldW2 + i) * newW] = img[i * oldW + j];
                        }
                    }
                }
                if (oldW2 != 0) {
                    for (j = 0; j < oldH2; ++j) {
                        for (i = 0; i < oldW - oldW2; ++i) {
                            New[(newH - oldH2 + j) * newW + i] = img[j * oldW + i + oldW2];
                        }
                    }
                }
                if (oldH2 != 0) {
                    for (j = 0; j < oldH - oldH2; ++j) {
                        for (i = 0; i < oldW2; ++i) {
                            New[j * newW + newW - oldW2 + i] = img[(j + oldH2) * oldW + i];
                        }
                    }
                }
                for (j = 0; j < oldH - oldH2; ++j) {
                    for (i = 0; i < oldW - oldW2; ++i) {
                        New[i + j * newW] = img[(j + oldH2) * oldW + i + oldW2];
                    }
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return New;
    }

    public static double[][] hadamardProd(double[][] a, double[][] b, int isComplex) {
        int H = a.length;
        int W = a[0].length;
        double[][] out = new double[H][W];
        if (isComplex == 0) {
            for (int j = 0; j < W; ++j) {
                for (int i = 0; i < H; ++i) {
                    out[i][j] = a[i][j] * b[i][j];
                }
            }
        } else {
            for (int j = 0; j < W; ++j) {
                for (int i = 0; i < H; ++i) {
                    out[i][2 * j] = a[i][2 * j] * b[i][2 * j] - a[i][2 * j + 1] * b[i][2 * j + 1];
                    out[i][2 * j + 1] = a[i][2 * j] * b[i][2 * j + 1] + a[i][2 * j + 1] * b[i][2 * j];
                }
            }
        }
        return out;
    }

    public static double[][] sumArrays(double[][] a, double[][] b, String sign) {
        int H = a.length;
        int W = a[0].length;
        double[][] out = new double[H][W];
        if (sign == "+") {
            for (int j = 0; j < W; ++j) {
                for (int i = 0; i < H; ++i) {
                    out[i][j] = a[i][j] + b[i][j];
                }
            }
        } else {
            for (int j = 0; j < W; ++j) {
                for (int i = 0; i < H; ++i) {
                    out[i][j] = a[i][j] - b[i][j];
                }
            }
        }
        return out;
    }

    public static double std(double[] a) {
        double V = MathUtils.var(a);
        return Math.sqrt(V);
    }

    public static double std(double[][] a) {
        double V = MathUtils.var(a);
        return Math.sqrt(V);
    }

    public static double std(double[][][] a) {
        double V = MathUtils.var(a);
        return Math.sqrt(V);
    }

    public static double var(double[] a) {
        double mean = MathUtils.avg(a);
        double out = 0.0;
        for (int k = 0; k < a.length; ++k) {
            out += a[k] * a[k];
        }
        return out / (double)a.length - mean * mean;
    }

    public static double var(double[][] a) {
        double mean = MathUtils.avg(a);
        double out = MathUtils.avg(MathUtils.hadamardProd(a, a, 0)) - mean * mean;
        return out;
    }

    public static double var(double[][][] a) {
        double x = 0.0;
        double mean = MathUtils.avg(a);
        double N = 0.0;
        double tmp = 0.0;
        for (int k = 0; k < a[0][0].length; ++k) {
            for (int j = 0; j < a[0].length; ++j) {
                for (int i = 0; i < a.length; ++i) {
                    tmp = a[i][j][k] - mean;
                    x += tmp * tmp;
                    N += 1.0;
                }
            }
        }
        return x / N;
    }

    public static void stat(double[][] a) {
        System.out.println("H " + a.length + " W " + a[0].length);
        System.out.println("min " + MathUtils.min(a) + " max " + MathUtils.max(a));
        System.out.println("avg " + MathUtils.avg(a) + " var " + MathUtils.var(a) + " std " + MathUtils.std(a));
    }

    public static void stat(double[] a) {
        System.out.println("size " + a.length);
        System.out.println("min " + MathUtils.min(a) + " max " + MathUtils.max(a));
        System.out.println("avg " + MathUtils.avg(a) + " var " + MathUtils.var(a) + " std " + MathUtils.std(a));
    }

    public static void statC(double[] a) {
        int L = a.length;
        System.out.println("size " + a.length);
        double[] realA = new double[L / 2];
        double[] imgA = new double[L / 2];
        for (int i = 0; i < L / 2; ++i) {
            realA[i] = a[2 * i];
            imgA[i] = a[2 * i + 1];
        }
        System.out.println("Real part");
        System.out.println("min " + MathUtils.min(realA) + " max " + MathUtils.max(realA));
        System.out.println("avg " + MathUtils.avg(realA) + " var " + MathUtils.var(realA) + " std " + MathUtils.std(realA));
        System.out.println("Imaginary part");
        System.out.println("min " + MathUtils.min(imgA) + " max " + MathUtils.max(imgA));
        System.out.println("avg " + MathUtils.avg(imgA) + " var " + MathUtils.var(imgA) + " std " + MathUtils.std(imgA));
    }

    public static void stat(double[] a, int begin, int end) {
        double[] b = new double[end - begin + 1];
        for (int k = begin; k <= end; ++k) {
            b[k - begin] = a[k];
        }
        System.out.println("size " + b.length);
        System.out.println("min " + MathUtils.min(b) + " max " + MathUtils.max(b));
        System.out.println("avg " + MathUtils.avg(b) + " var " + MathUtils.var(b) + " std " + MathUtils.std(b));
    }

    public static double[][] imnoise(double[][] img, int type, double arg1, double arg2) {
        int H = img.length;
        int W = img[0].length;
        double[][] imnoise = new double[H][W];
        switch (type) {
            case 2: {
                Random rand = new Random();
                double std = Math.sqrt(arg1);
                double mean = arg2;
                MathUtils.im2double(img);
                for (int j = 0; j < W; ++j) {
                    for (int i = 0; i < H; ++i) {
                        imnoise[i][j] = img[i][j] + std * rand.nextGaussian() + mean;
                    }
                }
                MathUtils.uint8(imnoise);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type does not exist");
            }
        }
        return imnoise;
    }

    public static double[][] fspecialAverage(int[] arg1) {
        double[][] ha = new double[arg1[0]][arg1[1]];
        double coef = 1.0 / (double)(arg1[0] * arg1[1]);
        int H = arg1[0];
        int W = arg1[1];
        for (int k2 = 0; k2 < H; ++k2) {
            for (int k1 = 0; k1 < W; ++k1) {
                ha[k2][k1] = coef;
            }
        }
        return ha;
    }

    public static double[][] fspecial(int type, int arg1) {
        switch (type) {
            case 7: {
                int i;
                int j;
                int radius = arg1;
                int diameter = 2 * radius;
                double[][] r = MathUtils.cartesDist2D(diameter, diameter);
                double[][] mask = new double[diameter][diameter];
                double[][] hd = new double[diameter][diameter];
                for (j = 0; j < r.length; ++j) {
                    for (i = 0; i < r.length; ++i) {
                        if (!(r[i][j] <= (double)radius)) continue;
                        mask[i][j] = 1.0;
                    }
                }
                double cd = MathUtils.sum(mask);
                for (j = 0; j < r.length; ++j) {
                    for (i = 0; i < r.length; ++i) {
                        if (mask[i][j] != 1.0) continue;
                        hd[i][j] = 1.0 / cd;
                    }
                }
                return hd;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[][] fspecial(int type, int[] arg1, double arg2) {
        switch (type) {
            case 3: {
                double[][] ha = new double[arg1[0]][arg1[1]];
                double coef = 1.0 / (double)(arg1[0] * arg1[1]);
                int H = arg1[0];
                int W = arg1[1];
                for (int k2 = 0; k2 < H; ++k2) {
                    for (int k1 = 0; k1 < W; ++k1) {
                        ha[k2][k1] = coef;
                    }
                }
                return ha;
            }
            case 2: {
                double[][] hg = new double[arg1[0]][arg1[1]];
                double A = 2.0 * arg2 * arg2;
                double B = 1.0 / Math.sqrt(Math.PI * A);
                int bk1 = (-arg1[1] + 1) / 2;
                int ek1 = arg1[1] / 2;
                int bk2 = (-arg1[0] + 1) / 2;
                int ek2 = arg1[0] / 2;
                for (int k2 = bk2; k2 <= ek2; ++k2) {
                    for (int k1 = bk1; k1 <= ek1; ++k1) {
                        hg[k2 - bk2][k1 - bk1] = B * Math.exp((double)(-(k1 * k1 + k2 * k2)) / A);
                    }
                }
                return hg;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] fspecial1D(int type, int[] arg1, double arg2) {
        int L = arg1[0] * arg1[1];
        switch (type) {
            case 3: {
                double[] ha = new double[L];
                double coef = 1.0 / (double)L;
                for (int i = 0; i < L; ++i) {
                    ha[i] = coef;
                }
                return ha;
            }
            case 2: {
                double[] hg = new double[L];
                int bk1 = (-arg1[1] + 1) / 2;
                int ek1 = arg1[1] / 2;
                int bk2 = (-arg1[0] + 1) / 2;
                int ek2 = arg1[0] / 2;
                for (int k2 = bk2; k2 <= ek2; ++k2) {
                    for (int k1 = bk1; k1 <= ek1; ++k1) {
                    }
                }
                return hg;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] fspecial1D(int type) {
        switch (type) {
            case 3: {
                double ca = 0.1111111111111111;
                double[] ha = new double[]{ca, ca, ca, ca, ca, ca, ca, ca, ca};
                return ha;
            }
            case 7: {
                int i;
                int radius = 5;
                int diameter = 2 * radius;
                double[] r = MathUtils.cartesDist1D(diameter, diameter);
                double[] mask = new double[diameter * diameter];
                double[] hd = new double[diameter * diameter];
                for (i = 0; i < r.length; ++i) {
                    if (!(r[i] <= (double)radius)) continue;
                    mask[i] = 1.0;
                }
                double cd = MathUtils.sum(mask);
                for (i = 0; i < r.length; ++i) {
                    if (mask[i] != 1.0) continue;
                    hd[i] = 1.0 / cd;
                }
                return hd;
            }
            case 5: {
                double[] hs = new double[]{1.0, 2.0, 1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -1.0};
                return hs;
            }
            case 4: {
                double[] hp = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0};
                return hp;
            }
            case 6: {
                double[] hk = new double[]{3.0, 3.0, 3.0, 3.0, 0.0, 3.0, -5.0, -5.0, -5.0};
                return hk;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[][] fspecial(int type) {
        switch (type) {
            case 3: {
                double ca = 0.1111111111111111;
                double[][] ha = new double[][]{{ca, ca, ca}, {ca, ca, ca}, {ca, ca, ca}};
                return ha;
            }
            case 7: {
                int i;
                int j;
                int radius = 5;
                int diameter = 2 * radius;
                double[][] r = MathUtils.cartesDist2D(diameter, diameter);
                double[][] mask = new double[diameter][diameter];
                double[][] hd = new double[diameter][diameter];
                for (j = 0; j < r.length; ++j) {
                    for (i = 0; i < r.length; ++i) {
                        if (!(r[i][j] <= (double)radius)) continue;
                        mask[i][j] = 1.0;
                    }
                }
                double cd = MathUtils.sum(mask);
                for (j = 0; j < r.length; ++j) {
                    for (i = 0; i < r.length; ++i) {
                        if (mask[i][j] != 1.0) continue;
                        hd[i][j] = 1.0 / cd;
                    }
                }
                return hd;
            }
            case 5: {
                double[][] hs = new double[][]{{1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -2.0, -1.0}};
                return hs;
            }
            case 4: {
                double[][] hp = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -1.0, -1.0}};
                return hp;
            }
            case 6: {
                double[][] hk = new double[][]{{3.0, 3.0, 3.0}, {3.0, 0.0, 3.0}, {-5.0, -5.0, -5.0}};
                return hk;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] getArray(double[] In, int width, int height, int depth) {
        int L = width * height;
        double[] Out = new double[L];
        for (int i = 0; i < L; ++i) {
            Out[i] = In[depth * L + i];
        }
        return Out;
    }

    public static double[] transpose(double[] array, int W, int H, int D) {
        int L = array.length;
        double[] out = new double[L];
        for (int k = 0; k < D; ++k) {
            for (int j = 0; j < H; ++j) {
                for (int i = 0; i < W; ++i) {
                    out[j + H * i + k * W * H] = array[i + W * j + k * W * H];
                }
            }
        }
        return out;
    }

    public static void writeStat(double[][] a, String name) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File("temp"), true));
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i <= 5; ++i) {
                sb.append(name);
            }
            sb.append("H " + a.length + " W " + a[0].length + "\n min " + MathUtils.min(a) + " max " + MathUtils.max(a) + "\n avg " + MathUtils.avg(a) + " var " + MathUtils.var(a) + " std " + MathUtils.std(a));
            bw.write(sb.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double[][][] XY2XZ(double[][][] inXY) {
        int Nz = inXY.length;
        int Ny = inXY[0].length;
        int Nx = inXY[0][0].length;
        double[][][] outXZ = new double[Ny][Nz][Nx];
        for (int j = 0; j < Nx; ++j) {
            for (int z = Nz - 1; z >= 0; --z) {
                for (int i = 0; i < Nx; ++i) {
                    outXZ[j][Math.abs((int)(z - 1))][i] = inXY[z][i][j];
                }
            }
        }
        return outXZ;
    }

    public static double[] cumSum(double[] tab) {
        int L = tab.length;
        double[] out = new double[L];
        out[0] = tab[0];
        for (int i = 1; i < L; ++i) {
            out[i] = out[i - 1] + tab[i];
        }
        return out;
    }

    public static double mse(double[] yEstimate, double[] yTrue) {
        int n = yTrue.length;
        double tmp1 = 0.0;
        double out = 0.0;
        for (int i = 0; i < n; ++i) {
            tmp1 = yTrue[i] - yEstimate[i];
            out += tmp1 * tmp1;
        }
        return out / (double)n;
    }
}

