/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.sequence;

import icy.gui.frame.ActionFrame;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ActiveSequenceActionFrame
extends ActionFrame
implements ActiveSequenceListener {
    private final List<SourceChangeListener> sourceChangeListeners = new ArrayList<SourceChangeListener>();
    JPanel sourcePanel;
    JLabel sequenceLabel;

    public ActiveSequenceActionFrame(String title, boolean resizable, boolean iconifiable) {
        super(title, resizable, iconifiable);
        this.buildGUI();
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            this.sequenceLabel.setText(sequence.getName());
        } else {
            this.sequenceLabel.setText("no sequence");
        }
        Icy.getMainInterface().addActiveSequenceListener(this);
    }

    public ActiveSequenceActionFrame(String title, boolean resizable) {
        this(title, resizable, false);
    }

    public ActiveSequenceActionFrame(String title) {
        this(title, false);
    }

    @Override
    public void onClosed() {
        Icy.getMainInterface().removeActiveSequenceListener(this);
        super.onClosed();
    }

    protected void buildGUI() {
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.sourcePanel = new JPanel();
        this.sourcePanel.setBorder(BorderFactory.createTitledBorder("Selected sequence"));
        this.sourcePanel.setLayout(new BoxLayout(this.sourcePanel, 2));
        this.sequenceLabel = new JLabel();
        this.sequenceLabel.setMinimumSize(new Dimension(100, 24));
        this.sourcePanel.add(Box.createHorizontalStrut(10));
        this.sourcePanel.add(this.sequenceLabel);
        this.sourcePanel.add(Box.createHorizontalGlue());
        ComponentUtil.setFixedHeight(this.sourcePanel, 54);
        this.mainPanel.add(this.sourcePanel);
    }

    public JPanel getSourcePanel() {
        return this.sourcePanel;
    }

    @Deprecated
    public Sequence getSeqIn() {
        return this.getSequence();
    }

    public Sequence getSequence() {
        return Icy.getMainInterface().getActiveSequence();
    }

    public void addSourceChangeListener(SourceChangeListener listener) {
        if (!this.sourceChangeListeners.contains(listener)) {
            this.sourceChangeListeners.add(listener);
        }
    }

    public void removeSourceChangeListener(SourceChangeListener listener) {
        this.sourceChangeListeners.remove(listener);
    }

    private void fireSequenceChangeEvent(Sequence seq) {
        for (SourceChangeListener listener : this.sourceChangeListeners) {
            listener.sourceSequenceChanged(seq);
        }
    }

    @Override
    public void sequenceActivated(Sequence sequence) {
        if (sequence != null) {
            this.sequenceLabel.setText(sequence.getName());
        } else {
            this.sequenceLabel.setText("no sequence");
        }
        this.fireSequenceChangeEvent(sequence);
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
    }

    public static interface SourceChangeListener {
        public void sourceSequenceChanged(Sequence var1);
    }
}

