/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.dialog.ConfirmDialog;
import icy.gui.preferences.PluginListPreferencePanel;
import icy.gui.preferences.PreferenceFrame;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.preferences.RepositoryPreferences;
import icy.system.thread.ThreadUtil;
import java.util.ArrayList;
import java.util.List;

public class PluginOnlinePreferencePanel
extends PluginListPreferencePanel
implements PluginRepositoryLoader.PluginRepositoryLoaderListener,
PluginInstaller.PluginInstallerListener {
    private static final long serialVersionUID = 7737976340704271890L;
    public static final String NODE_NAME = "Online Plugin";

    PluginOnlinePreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Plugin");
        PluginRepositoryLoader.addListener(this);
        PluginInstaller.addListener(this);
        this.table.removeColumn(this.table.getColumn(columnIds[4]));
        this.repositoryPanel.setVisible(true);
        this.action1Button.setText("Delete");
        this.action1Button.setVisible(true);
        this.action2Button.setText("Install");
        this.action2Button.setVisible(true);
        this.updateButtonsState();
        this.updateRepositories();
    }

    @Override
    protected void closed() {
        super.closed();
        PluginRepositoryLoader.removeListener(this);
        PluginInstaller.removeListener(this);
    }

    private PluginOnlineState getPluginOnlineState(PluginDescriptor plugin) {
        if (plugin == null) {
            return PluginOnlineState.NULL;
        }
        if (PluginInstaller.isInstallingPlugin(plugin)) {
            return PluginOnlineState.INSTALLING;
        }
        if (PluginInstaller.isDesinstallingPlugin(plugin)) {
            return PluginOnlineState.REMOVING;
        }
        if (plugin.isInstalled()) {
            PluginDescriptor localPlugin = PluginLoader.getPlugin(plugin.getClassName());
            if (localPlugin != null) {
                if (plugin.equals(localPlugin)) {
                    return PluginOnlineState.INSTALLED;
                }
                if (plugin.isOlder(localPlugin)) {
                    return PluginOnlineState.OLDER;
                }
                if (plugin.isNewer(localPlugin)) {
                    return PluginOnlineState.NEWER;
                }
            }
            return PluginOnlineState.INSTALLED_FAULTY;
        }
        return PluginOnlineState.HAS_INSTALL;
    }

    @Override
    protected void doAction1() {
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        ArrayList<PluginDescriptor> toRemove = new ArrayList<PluginDescriptor>();
        for (PluginDescriptor plugin : selectedPlugins) {
            PluginOnlineState state = this.getPluginOnlineState(plugin);
            if (state != PluginOnlineState.INSTALLED && state != PluginOnlineState.INSTALLED_FAULTY) continue;
            toRemove.add(plugin);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        List<PluginDescriptor> dependants = PluginInstaller.getLocalDependenciesFrom(toRemove);
        dependants.removeAll(toRemove);
        String message = "<html>";
        if (!dependants.isEmpty()) {
            message = message + "The following plugin(s) won't work anymore :<br>";
            for (PluginDescriptor depPlug : dependants) {
                message = message + depPlug.getName() + " " + depPlug.getVersion() + "<br>";
            }
            message = message + "<br>";
        }
        if (ConfirmDialog.confirm(message = message + "Are you sure you want to remove selected plugin(s) ?</html>")) {
            for (PluginDescriptor plugin : toRemove) {
                PluginInstaller.desinstall(plugin, false, true);
            }
        }
        this.refreshTableData();
    }

    @Override
    protected void doAction2() {
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        for (PluginDescriptor plugin : selectedPlugins) {
            boolean doInstall;
            PluginOnlineState state = this.getPluginOnlineState(plugin);
            if (state != PluginOnlineState.HAS_INSTALL && state != PluginOnlineState.NEWER && state != PluginOnlineState.OLDER || !(doInstall = state == PluginOnlineState.OLDER ? ConfirmDialog.confirm("You'll replace your plugin by an older version !\nAre you sure you want to continue ?") : true)) continue;
            PluginInstaller.install(plugin, true);
        }
        this.refreshTableData();
    }

    @Override
    protected void repositoryChanged() {
        this.refreshPlugins();
    }

    @Override
    protected void reloadPlugins() {
        PluginRepositoryLoader.reload();
        this.pluginsChanged();
    }

    @Override
    protected String getStateValue(PluginDescriptor plugin) {
        switch (this.getPluginOnlineState(plugin).ordinal()) {
            case 1: {
                return "installing...";
            }
            case 2: {
                return "removing...";
            }
            case 7: {
                return "update available";
            }
            case 6: {
                return "outdated";
            }
            case 4: {
                return "installed";
            }
            case 5: {
                return "faulty";
            }
        }
        return "";
    }

    @Override
    protected List<PluginDescriptor> getPlugins() {
        if (!PluginRepositoryLoader.isLoaded()) {
            return new ArrayList<PluginDescriptor>();
        }
        Object selectedItem = this.repository.getSelectedItem();
        if (selectedItem != null) {
            return PluginRepositoryLoader.getPlugins((RepositoryPreferences.RepositoryInfo)selectedItem);
        }
        return PluginRepositoryLoader.getPlugins();
    }

    @Override
    protected void updateButtonsStateInternal() {
        boolean selected;
        super.updateButtonsStateInternal();
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        boolean bl = selected = selectedPlugins.size() > 0;
        if (PluginRepositoryLoader.isLoaded()) {
            this.refreshButton.setText("Reload list");
            this.refreshButton.setEnabled(true);
            this.repository.setEnabled(true);
        } else {
            this.refreshButton.setText("Reloading...");
            this.refreshButton.setEnabled(false);
            this.repository.setEnabled(false);
        }
        if (!selected) {
            this.action1Button.setEnabled(false);
            this.action2Button.setEnabled(false);
            return;
        }
        PluginOnlineState state = PluginOnlineState.NULL;
        for (PluginDescriptor plugin : selectedPlugins) {
            switch (this.getPluginOnlineState(plugin).ordinal()) {
                case 2: {
                    if (state != PluginOnlineState.NULL) break;
                    state = PluginOnlineState.REMOVING;
                    break;
                }
                case 4: 
                case 5: {
                    if (state != PluginOnlineState.NULL && state != PluginOnlineState.REMOVING) break;
                    state = PluginOnlineState.INSTALLED;
                }
            }
        }
        switch (state.ordinal()) {
            case 2: {
                this.action1Button.setText("Deleting...");
                this.action1Button.setEnabled(false);
                break;
            }
            case 4: {
                this.action1Button.setText("Delete");
                this.action1Button.setEnabled(true);
                break;
            }
            case 0: {
                this.action1Button.setText("Delete");
                this.action1Button.setEnabled(false);
            }
        }
        state = PluginOnlineState.NULL;
        for (PluginDescriptor plugin : selectedPlugins) {
            switch (this.getPluginOnlineState(plugin).ordinal()) {
                case 1: {
                    if (state != PluginOnlineState.NULL) break;
                    state = PluginOnlineState.INSTALLING;
                    break;
                }
                case 6: {
                    if (state != PluginOnlineState.NULL && state != PluginOnlineState.INSTALLING) break;
                    state = PluginOnlineState.OLDER;
                    break;
                }
                case 7: {
                    if (state != PluginOnlineState.NULL && state != PluginOnlineState.INSTALLING && state != PluginOnlineState.OLDER) break;
                    state = PluginOnlineState.NEWER;
                    break;
                }
                case 3: {
                    state = PluginOnlineState.HAS_INSTALL;
                }
            }
        }
        switch (state.ordinal()) {
            case 1: {
                this.action2Button.setText("Installing...");
                this.action2Button.setEnabled(false);
                break;
            }
            case 3: {
                this.action2Button.setText("Install");
                this.action2Button.setEnabled(true);
                break;
            }
            case 6: {
                this.action2Button.setText("Revert");
                this.action2Button.setEnabled(true);
                break;
            }
            case 7: {
                this.action2Button.setText("Update");
                this.action2Button.setEnabled(true);
                break;
            }
            case 0: {
                this.action2Button.setText("Install");
                this.action2Button.setEnabled(false);
            }
        }
    }

    @Override
    public void pluginRepositeryLoaderChanged(PluginDescriptor plugin) {
        if (plugin != null) {
            final int ind = this.getPluginModelIndex(plugin.getClassName());
            if (ind != -1) {
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PluginOnlinePreferencePanel.this.tableModel.fireTableRowsUpdated(ind, ind);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        } else {
            this.pluginsChanged();
        }
    }

    @Override
    public void pluginInstalled(PluginDescriptor plugin, boolean success) {
        this.refreshTableData();
    }

    @Override
    public void pluginRemoved(PluginDescriptor plugin, boolean success) {
        this.refreshTableData();
    }

    private static enum PluginOnlineState {
        NULL,
        INSTALLING,
        REMOVING,
        HAS_INSTALL,
        INSTALLED,
        INSTALLED_FAULTY,
        OLDER,
        NEWER;

    }
}

