/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.math.Interpolator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;

public class SmoothMover
implements ActionListener {
    protected double currentValue;
    protected SmoothMoveType type;
    protected int moveTime;
    protected final Timer timer;
    protected double destValue;
    protected double[] stepValues;
    protected long startTime;
    protected final ArrayList<SmoothMoverListener> listeners;

    public SmoothMover(double initValue, SmoothMoveType type) {
        this.currentValue = initValue;
        this.destValue = initValue;
        this.type = type;
        this.timer = new Timer(16, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.moveTime = 1000;
        this.stepValues = new double[0];
        this.listeners = new ArrayList();
    }

    public SmoothMover(double initValue) {
        this(initValue, SmoothMoveType.LINEAR);
    }

    public void moveTo(double value) {
        if (this.destValue != value) {
            this.destValue = value;
            this.start();
        }
    }

    public boolean isMoving() {
        return this.timer.isRunning();
    }

    protected void start() {
        int size = Math.max(this.moveTime / this.timer.getDelay(), 1);
        switch (this.type.ordinal()) {
            case 0: {
                this.stepValues = new double[2];
                this.stepValues[0] = this.currentValue;
                this.stepValues[1] = this.destValue;
                break;
            }
            case 1: {
                this.stepValues = Interpolator.doLinearInterpolation(this.currentValue, this.destValue, size);
                break;
            }
            case 2: {
                this.stepValues = Interpolator.doLogInterpolation(this.currentValue, this.destValue, size);
                break;
            }
            case 3: {
                this.stepValues = Interpolator.doExpInterpolation(this.currentValue, this.destValue, size);
            }
        }
        if (!this.isMoving()) {
            this.moveStarted();
            this.timer.start();
        } else {
            this.moveModified();
        }
    }

    public void stop() {
        if (this.isMoving()) {
            this.timer.stop();
            this.moveEnded();
        }
    }

    public void shutDown() {
        this.timer.stop();
        this.timer.removeActionListener(this);
        this.listeners.clear();
    }

    public int getUpdateDelay() {
        return this.timer.getDelay();
    }

    public void setUpdateDelay(int updateDelay) {
        this.timer.setDelay(updateDelay);
    }

    public SmoothMoveType getType() {
        return this.type;
    }

    public void setType(SmoothMoveType type) {
        this.type = type;
    }

    public int getMoveTime() {
        return this.moveTime;
    }

    public void setMoveTime(int moveTime) {
        this.moveTime = Math.max(moveTime, 1);
    }

    public void setValue(double value) {
        this.stop();
        this.destValue = value;
        this.setCurrentValue(value, 100);
    }

    public double getValue() {
        return this.currentValue;
    }

    public double getDestValue() {
        return this.destValue;
    }

    public void addListener(SmoothMoverListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SmoothMoverListener listener) {
        this.listeners.remove(listener);
    }

    protected void moveStarted() {
        this.startTime = System.currentTimeMillis();
        for (SmoothMoverListener listener : this.listeners) {
            listener.moveStarted(this, this.currentValue, this.destValue);
        }
    }

    protected void moveModified() {
        this.startTime = System.currentTimeMillis();
        for (SmoothMoverListener listener : this.listeners) {
            listener.moveModified(this, this.currentValue, this.destValue);
        }
    }

    protected void moveEnded() {
        for (SmoothMoverListener listener : this.listeners) {
            listener.moveEnded(this, this.currentValue);
        }
    }

    protected void updateCurrentValue() {
        int elapsedMsTime = (int)(System.currentTimeMillis() - this.startTime);
        if (this.type == SmoothMoveType.NONE || elapsedMsTime >= this.moveTime) {
            this.setCurrentValue(this.destValue, 100);
            this.stop();
        } else {
            int len = this.stepValues.length;
            int ind = Math.min(elapsedMsTime * len / this.moveTime, len - 2);
            this.setCurrentValue(this.stepValues[ind + 1], elapsedMsTime * 100 / this.moveTime);
        }
    }

    protected void setCurrentValue(double value, int pourcent) {
        if (this.currentValue != value) {
            this.currentValue = value;
            this.changed(value, pourcent);
        }
    }

    protected void changed(double newValue, int pourcent) {
        for (SmoothMoverListener listener : this.listeners) {
            listener.valueChanged(this, newValue, pourcent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isMoving()) {
            this.updateCurrentValue();
        }
    }

    public static enum SmoothMoveType {
        NONE,
        LINEAR,
        LOG,
        EXP;

    }

    public static interface SmoothMoverListener {
        public void moveStarted(SmoothMover var1, double var2, double var4);

        public void moveModified(SmoothMover var1, double var2, double var4);

        public void moveEnded(SmoothMover var1, double var2);

        public void valueChanged(SmoothMover var1, double var2, int var4);
    }

    public static class SmoothMoverAdapter
    implements SmoothMoverListener {
        @Override
        public void moveStarted(SmoothMover source, double start, double end) {
        }

        @Override
        public void moveModified(SmoothMover source, double start, double end) {
        }

        @Override
        public void moveEnded(SmoothMover source, double value) {
        }

        @Override
        public void valueChanged(SmoothMover source, double newValue, int pourcent) {
        }
    }
}

