/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.painter.Anchor3D;
import icy.type.point.Point3D;
import icy.util.EventUtil;
import java.awt.Color;
import java.awt.event.InputEvent;

public abstract class LineAnchor3D
extends Anchor3D {
    protected boolean fixedZ;

    public LineAnchor3D(Point3D position, Color color, Color selectedColor) {
        super(position.getX(), position.getY(), position.getZ(), color, selectedColor);
    }

    public boolean isFixedZ() {
        return this.fixedZ;
    }

    public void setFixedZ(boolean value) {
        this.fixedZ = value;
    }

    @Override
    protected boolean updateDrag(InputEvent e, double x, double y, double z) {
        if (this.startDragMousePosition == null) {
            return false;
        }
        Anchor3D anchor = this.getPreviousPoint();
        if (EventUtil.isShiftDown(e) && anchor != null && this.isFixedZ()) {
            Point3D pos = anchor.getPosition();
            double dx = x - pos.getX();
            double dy = y - pos.getY();
            double absDx = Math.abs(dx);
            double absDy = Math.abs(dy);
            double dist = absDx != 0.0 && absDy != 0.0 ? absDx / absDy : 0.0;
            if (dist > 0.5 && dist < 1.5) {
                if (absDx > absDy) {
                    dx = dx >= 0.0 ? absDy : -absDy;
                } else {
                    dy = dy >= 0.0 ? absDx : -absDx;
                }
            } else if (absDx > absDy) {
                dy = 0.0;
            } else {
                dx = 0.0;
            }
            this.setPosition(pos.getX() + dx, pos.getY() + dy, pos.getZ());
        } else {
            double dx = x - this.startDragMousePosition.getX();
            double dy = y - this.startDragMousePosition.getY();
            double dz = z - this.startDragMousePosition.getZ();
            this.setPosition(this.startDragPainterPosition.getX() + dx, this.startDragPainterPosition.getY() + dy, this.startDragPainterPosition.getZ() + dz);
        }
        return true;
    }

    protected abstract Anchor3D getPreviousPoint();
}

