/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import loci.common.services.ServiceException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.units.quantity.Time;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.Channel;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.ROI;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.joda.time.Instant;

public class MetaDataUtil {
    public static final String DEFAULT_CHANNEL_NAME = "ch ";

    public static OME getOME(ome.xml.meta.OMEXMLMetadata metaData) {
        OME result = (OME)((Object)metaData.getRoot());
        if (result == null) {
            metaData.createRoot();
            result = (OME)((Object)metaData.getRoot());
        }
        return result;
    }

    @Deprecated
    public static OME getOME(OMEXMLMetadataImpl metaData) {
        return MetaDataUtil.getOME((ome.xml.meta.OMEXMLMetadata)metaData);
    }

    public static int getNumSeries(ome.xml.meta.OMEXMLMetadata metaData) {
        return metaData.getImageCount();
    }

    @Deprecated
    public static int getNumSerie(OMEXMLMetadata metaData) {
        return MetaDataUtil.getNumSeries(metaData);
    }

    @Deprecated
    public static int getNumSerie(ome.xml.meta.OMEXMLMetadata metaData) {
        return MetaDataUtil.getNumSeries(metaData);
    }

    @Deprecated
    public static int getNumSerie(OMEXMLMetadataImpl metaData) {
        return MetaDataUtil.getNumSerie((ome.xml.meta.OMEXMLMetadata)metaData);
    }

    public static Image getSeries(ome.xml.meta.OMEXMLMetadata metaData, int index) {
        OME ome = MetaDataUtil.getOME(metaData);
        if (index < ome.sizeOfImageList()) {
            return ome.getImage(index);
        }
        return null;
    }

    @Deprecated
    public static Image getSerie(ome.xml.meta.OMEXMLMetadata metaData, int index) {
        return MetaDataUtil.getSeries(metaData, index);
    }

    @Deprecated
    public static Image getSerie(OMEXMLMetadataImpl metaData, int index) {
        return MetaDataUtil.getSeries(metaData, index);
    }

    public static Image ensureSeries(OME ome, int index) {
        while (ome.sizeOfImageList() <= index) {
            Image img = new Image();
            ome.addImage(img);
        }
        Image result = ome.getImage(index);
        if (result.getPixels() == null) {
            Pixels pix = new Pixels();
            pix.setDimensionOrder(DimensionOrder.XYCZT);
            result.setPixels(pix);
        }
        return result;
    }

    @Deprecated
    public static Image ensureSerie(OME ome, int index) {
        return MetaDataUtil.ensureSeries(ome, index);
    }

    public static void setNumSeries(ome.xml.meta.OMEXMLMetadata metaData, int num) {
        OME ome = MetaDataUtil.getOME(metaData);
        while (ome.sizeOfImageList() > num) {
            ome.removeImage(ome.getImage(ome.sizeOfImageList() - 1));
        }
        MetaDataUtil.ensureSeries(ome, num - 1);
    }

    @Deprecated
    public static void setNumSerie(ome.xml.meta.OMEXMLMetadata metaData, int num) {
        MetaDataUtil.setNumSeries(metaData, num);
    }

    @Deprecated
    public static void setNumSerie(OMEXMLMetadataImpl metaData, int num) {
        MetaDataUtil.setNumSerie((ome.xml.meta.OMEXMLMetadata)metaData, num);
    }

    public static Pixels getPixels(OME ome, int index) {
        if (ome != null && index < ome.sizeOfImageList()) {
            return ome.getImage(index).getPixels();
        }
        return null;
    }

    public static Pixels getPixels(ome.xml.meta.OMEXMLMetadata metaData, int index) {
        return MetaDataUtil.getPixels(MetaDataUtil.getOME(metaData), index);
    }

    @Deprecated
    public static Pixels getPixels(OMEXMLMetadataImpl metaData, int index) {
        return MetaDataUtil.getPixels((ome.xml.meta.OMEXMLMetadata)metaData, index);
    }

    public static int getPlaneIndex(Pixels pix, int t, int z, int c) {
        int spp;
        Channel channel;
        if (t < 0 || z < 0 || c < 0) {
            return 0;
        }
        if (t == 0 && z == 0 && c == 0) {
            return 0;
        }
        int sizeT = OMEUtil.getValue(pix.getSizeT(), 0);
        int sizeZ = OMEUtil.getValue(pix.getSizeZ(), 0);
        int sizeC = OMEUtil.getValue(pix.getSizeC(), 0);
        if (sizeT == 0 || sizeZ == 0 || sizeC == 0) {
            return 0;
        }
        int adjC = c;
        if (pix.sizeOfChannelList() > 0 && (channel = pix.getChannel(0)) != null && (spp = OMEUtil.getValue(channel.getSamplesPerPixel(), 0)) != 0 && spp == sizeC) {
            sizeC = 1;
            adjC = 0;
        }
        int len = pix.sizeOfPlaneList();
        for (int i = 0; i < len; ++i) {
            Plane plane = pix.getPlane(i);
            if (OMEUtil.getValue(plane.getTheT(), -1) != t || OMEUtil.getValue(plane.getTheZ(), -1) != z || OMEUtil.getValue(plane.getTheC(), -1) != c) continue;
            return i;
        }
        DimensionOrder dimOrder = pix.getDimensionOrder();
        if (dimOrder == null) {
            dimOrder = DimensionOrder.XYCZT;
        }
        return FormatTools.getIndex(dimOrder.getValue(), sizeZ, sizeC, sizeT, sizeZ * sizeC * sizeT, z, adjC, t);
    }

    public static Plane getPlane(Pixels pix, int index) {
        if (pix != null && index < pix.sizeOfPlaneList()) {
            return pix.getPlane(index);
        }
        return null;
    }

    public static Plane getPlane(Pixels pix, int t, int z, int c) {
        return MetaDataUtil.getPlane(pix, MetaDataUtil.getPlaneIndex(pix, t, z, c));
    }

    public static Plane ensurePlane(Pixels pix, int index) {
        while (pix.sizeOfPlaneList() <= index) {
            pix.addPlane(new Plane());
        }
        return pix.getPlane(index);
    }

    public static Plane ensurePlane(Pixels pix, int t, int z, int c) {
        return MetaDataUtil.ensurePlane(pix, MetaDataUtil.getPlaneIndex(pix, t, z, c));
    }

    public static boolean removePlane(Image img, int index) {
        Pixels pix = img.getPixels();
        if (pix == null) {
            return false;
        }
        int numPlane = pix.sizeOfPlaneList();
        if (numPlane <= 1 || index >= numPlane) {
            return false;
        }
        Plane plane = MetaDataUtil.getPlane(pix, index);
        pix.removePlane(plane);
        for (int i = 0; i < plane.sizeOfLinkedAnnotationList(); ++i) {
            img.unlinkAnnotation(plane.getLinkedAnnotation(i));
        }
        if (pix.sizeOfBinDataList() == numPlane) {
            pix.removeBinData(pix.getBinData(index));
        }
        if (pix.sizeOfTiffDataList() == numPlane) {
            pix.removeTiffData(pix.getTiffData(index));
        }
        return true;
    }

    public static boolean removePlane(Image img, int t, int z, int c) {
        Pixels pix = img.getPixels();
        if (pix == null) {
            return false;
        }
        return MetaDataUtil.removePlane(img, MetaDataUtil.getPlaneIndex(pix, t, z, c));
    }

    public static boolean removePlane(ome.xml.meta.OMEXMLMetadata metadata, int series, int t, int z, int c) {
        Image img = MetaDataUtil.getSeries(metadata, series);
        if (img == null) {
            return false;
        }
        return MetaDataUtil.removePlane(img, t, z, c);
    }

    @Deprecated
    public static boolean removePlane(OMEXMLMetadataImpl metadata, int series, int t, int z, int c) {
        return MetaDataUtil.removePlane((ome.xml.meta.OMEXMLMetadata)metadata, series, t, z, c);
    }

    public static void removePlanes(ome.xml.meta.OMEXMLMetadata metadata, int series, int posT, int posZ, int posC) {
        int maxC;
        int minC;
        int maxZ;
        int minZ;
        int maxT;
        int minT;
        if (posT < 0) {
            minT = 0;
            maxT = MetaDataUtil.getSizeT(metadata, series) - 1;
        } else {
            minT = posT;
            maxT = posT;
        }
        if (posZ < 0) {
            minZ = 0;
            maxZ = MetaDataUtil.getSizeZ(metadata, series) - 1;
        } else {
            minZ = posZ;
            maxZ = posZ;
        }
        if (posC < 0) {
            minC = 0;
            maxC = MetaDataUtil.getSizeC(metadata, series) - 1;
        } else {
            minC = posC;
            maxC = posC;
        }
        for (int t = minT; t <= maxT; ++t) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int c = minC; c <= maxC; ++c) {
                    MetaDataUtil.removePlane(metadata, 0, t, z, c);
                }
            }
        }
    }

    @Deprecated
    public static void removePlanes(OMEXMLMetadataImpl metadata, int series, int posT, int posZ, int posC) {
        MetaDataUtil.removePlanes((ome.xml.meta.OMEXMLMetadata)metadata, series, posT, posZ, posC);
    }

    public static DataType getDataType(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return DataType.getDataTypeFromPixelType(pix.getType());
        }
        return DataType.UBYTE;
    }

    @Deprecated
    public static DataType getDataType(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getDataType((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static int getSizeX(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getSizeX(), 0);
        }
        return 0;
    }

    @Deprecated
    public static int getSizeX(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getSizeX((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static int getSizeY(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getSizeY(), 0);
        }
        return 0;
    }

    @Deprecated
    public static int getSizeY(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getSizeY((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static int getSizeC(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getSizeC(), 0);
        }
        return 0;
    }

    @Deprecated
    public static int getSizeC(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getSizeC((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static int getSizeZ(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getSizeZ(), 0);
        }
        return 0;
    }

    @Deprecated
    public static int getSizeZ(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getSizeZ((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    private static int getSizeT(Pixels pix) {
        return OMEUtil.getValue(pix.getSizeT(), 0);
    }

    public static int getSizeT(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return MetaDataUtil.getSizeT(pix);
        }
        return 0;
    }

    @Deprecated
    public static int getSizeT(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getSizeT((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static long getDataSize(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        return MetaDataUtil.getDataSize(metaData, series, 0);
    }

    public static long getDataSize(ome.xml.meta.OMEXMLMetadata metaData, int series, int resolution) {
        return MetaDataUtil.getDataSize(metaData, series, resolution, MetaDataUtil.getSizeZ(metaData, series), MetaDataUtil.getSizeT(metaData, series));
    }

    public static long getDataSize(ome.xml.meta.OMEXMLMetadata metaData, int series, int resolution, int sizeZ, int sizeT) {
        return MetaDataUtil.getDataSize(metaData, series, resolution, sizeZ, sizeT, MetaDataUtil.getSizeC(metaData, series));
    }

    public static long getDataSize(ome.xml.meta.OMEXMLMetadata metaData, int series, int resolution, int sizeZ, int sizeT, int sizeC) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            long sizeXY = (long)OMEUtil.getValue(pix.getSizeX(), 0) * (long)OMEUtil.getValue(pix.getSizeY(), 0);
            if (resolution > 0) {
                sizeXY = (long)((double)sizeXY / Math.pow(4.0, resolution));
            }
            return sizeXY * (long)sizeC * (long)sizeZ * (long)sizeT * (long)DataType.getDataTypeFromPixelType(pix.getType()).getSize();
        }
        return 0L;
    }

    public static void setDataType(ome.xml.meta.OMEXMLMetadata metaData, int series, DataType dataType) {
        metaData.setPixelsType(dataType.toPixelType(), series);
    }

    @Deprecated
    public static void setDataType(OMEXMLMetadataImpl metaData, int series, DataType dataType) {
        MetaDataUtil.setDataType((ome.xml.meta.OMEXMLMetadata)metaData, series, dataType);
    }

    public static void setSizeX(ome.xml.meta.OMEXMLMetadata metaData, int series, int sizeX) {
        metaData.setPixelsSizeX(OMEUtil.getPositiveInteger(sizeX), series);
    }

    @Deprecated
    public static void setSizeX(OMEXMLMetadataImpl metaData, int series, int sizeX) {
        MetaDataUtil.setSizeX((ome.xml.meta.OMEXMLMetadata)metaData, series, sizeX);
    }

    public static void setSizeY(ome.xml.meta.OMEXMLMetadata metaData, int series, int sizeY) {
        metaData.setPixelsSizeY(OMEUtil.getPositiveInteger(sizeY), series);
    }

    @Deprecated
    public static void setSizeY(OMEXMLMetadataImpl metaData, int series, int sizeY) {
        MetaDataUtil.setSizeY((ome.xml.meta.OMEXMLMetadata)metaData, series, sizeY);
    }

    public static void setSizeC(ome.xml.meta.OMEXMLMetadata metaData, int series, int sizeC) {
        metaData.setPixelsSizeC(OMEUtil.getPositiveInteger(sizeC), series);
    }

    @Deprecated
    public static void setSizeC(OMEXMLMetadataImpl metaData, int series, int sizeC) {
        MetaDataUtil.setSizeC((ome.xml.meta.OMEXMLMetadata)metaData, series, sizeC);
    }

    public static void setSizeZ(ome.xml.meta.OMEXMLMetadata metaData, int series, int sizeZ) {
        metaData.setPixelsSizeZ(OMEUtil.getPositiveInteger(sizeZ), series);
    }

    @Deprecated
    public static void setSizeZ(OMEXMLMetadataImpl metaData, int series, int sizeZ) {
        MetaDataUtil.setSizeZ((ome.xml.meta.OMEXMLMetadata)metaData, series, sizeZ);
    }

    public static void setSizeT(ome.xml.meta.OMEXMLMetadata metaData, int series, int sizeT) {
        metaData.setPixelsSizeT(OMEUtil.getPositiveInteger(sizeT), series);
    }

    @Deprecated
    public static void setSizeT(OMEXMLMetadataImpl metaData, int series, int sizeT) {
        MetaDataUtil.setSizeT((ome.xml.meta.OMEXMLMetadata)metaData, series, sizeT);
    }

    public static String getImageID(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Image img = MetaDataUtil.getSeries(metaData, series);
        if (img != null) {
            return StringUtil.getValue(img.getID(), "");
        }
        return "";
    }

    @Deprecated
    public static String getImageID(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getImageID((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static void setImageID(ome.xml.meta.OMEXMLMetadata metaData, int series, String value) {
        metaData.setImageID(value, series);
    }

    @Deprecated
    public static void setImageID(OMEXMLMetadataImpl metaData, int series, String value) {
        MetaDataUtil.setImageID((ome.xml.meta.OMEXMLMetadata)metaData, series, value);
    }

    public static String getName(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Image img = MetaDataUtil.getSeries(metaData, series);
        if (img != null) {
            return StringUtil.getValue(img.getName(), "");
        }
        return "";
    }

    @Deprecated
    public static String getName(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getName((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static void setName(ome.xml.meta.OMEXMLMetadata metaData, int series, String value) {
        metaData.setImageName(value, series);
    }

    @Deprecated
    public static void setName(OMEXMLMetadataImpl metaData, int series, String value) {
        MetaDataUtil.setName((ome.xml.meta.OMEXMLMetadata)metaData, series, value);
    }

    public static double getPixelSizeX(ome.xml.meta.OMEXMLMetadata metaData, int series, double defaultValue) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getPhysicalSizeX(), defaultValue);
        }
        return defaultValue;
    }

    @Deprecated
    public static double getPixelSizeX(OMEXMLMetadataImpl metaData, int series, double defaultValue) {
        return MetaDataUtil.getPixelSizeX((ome.xml.meta.OMEXMLMetadata)metaData, series, defaultValue);
    }

    public static double getPixelSizeY(ome.xml.meta.OMEXMLMetadata metaData, int series, double defaultValue) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getPhysicalSizeY(), defaultValue);
        }
        return defaultValue;
    }

    @Deprecated
    public static double getPixelSizeY(OMEXMLMetadataImpl metaData, int series, double defaultValue) {
        return MetaDataUtil.getPixelSizeY((ome.xml.meta.OMEXMLMetadata)metaData, series, defaultValue);
    }

    public static double getPixelSizeZ(ome.xml.meta.OMEXMLMetadata metaData, int series, double defaultValue) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return OMEUtil.getValue(pix.getPhysicalSizeZ(), defaultValue);
        }
        return defaultValue;
    }

    @Deprecated
    public static double getPixelSizeZ(OMEXMLMetadataImpl metaData, int series, double defaultValue) {
        return MetaDataUtil.getPixelSizeZ((ome.xml.meta.OMEXMLMetadata)metaData, series, defaultValue);
    }

    public static double getTimeIntervalFromTimePositions(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return MetaDataUtil.computeTimeIntervalFromTimePosition(pix);
        }
        return 0.0;
    }

    @Deprecated
    public static double getTimeIntervalFromTimePositions(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getTimeIntervalFromTimePositions((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    private static double getTimeInterval(Pixels pix, double defaultValue) {
        Time timeInc = pix.getTimeIncrement();
        if (timeInc != null) {
            return OMEUtil.getValue(timeInc, defaultValue);
        }
        return defaultValue;
    }

    public static double getTimeInterval(ome.xml.meta.OMEXMLMetadata metaData, int series, double defaultValue) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return MetaDataUtil.getTimeInterval(pix, defaultValue);
        }
        return defaultValue;
    }

    @Deprecated
    public static double getTimeInterval(OMEXMLMetadataImpl metaData, int series, double defaultValue) {
        return MetaDataUtil.getTimeInterval((ome.xml.meta.OMEXMLMetadata)metaData, series, defaultValue);
    }

    public static void setPixelSizeX(ome.xml.meta.OMEXMLMetadata metaData, int series, double value) {
        metaData.setPixelsPhysicalSizeX(OMEUtil.getLength(value), series);
    }

    @Deprecated
    public static void setPixelSizeX(OMEXMLMetadataImpl metaData, int series, double value) {
        MetaDataUtil.setPixelSizeX((ome.xml.meta.OMEXMLMetadata)metaData, series, value);
    }

    public static void setPixelSizeY(ome.xml.meta.OMEXMLMetadata metaData, int series, double value) {
        metaData.setPixelsPhysicalSizeY(OMEUtil.getLength(value), series);
    }

    @Deprecated
    public static void setPixelSizeY(OMEXMLMetadataImpl metaData, int series, double value) {
        MetaDataUtil.setPixelSizeY((ome.xml.meta.OMEXMLMetadata)metaData, series, value);
    }

    public static void setPixelSizeZ(ome.xml.meta.OMEXMLMetadata metaData, int series, double value) {
        metaData.setPixelsPhysicalSizeZ(OMEUtil.getLength(value), series);
    }

    @Deprecated
    public static void setPixelSizeZ(OMEXMLMetadataImpl metaData, int series, double value) {
        MetaDataUtil.setPixelSizeZ((ome.xml.meta.OMEXMLMetadata)metaData, series, value);
    }

    public static void setTimeInterval(ome.xml.meta.OMEXMLMetadata metaData, int series, double value) {
        metaData.setPixelsTimeIncrement(OMEUtil.getTime(value), series);
    }

    @Deprecated
    public static void setTimeInterval(OMEXMLMetadataImpl metaData, int series, double value) {
        MetaDataUtil.setTimeInterval((ome.xml.meta.OMEXMLMetadata)metaData, series, value);
    }

    public static double getPositionX(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double defaultValue) {
        Plane plane;
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && (plane = MetaDataUtil.getPlane(pix, t, z, c)) != null) {
            return OMEUtil.getValue(plane.getPositionX(), defaultValue);
        }
        return defaultValue;
    }

    public static double getPositionY(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double defaultValue) {
        Plane plane;
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && (plane = MetaDataUtil.getPlane(pix, t, z, c)) != null) {
            return OMEUtil.getValue(plane.getPositionY(), defaultValue);
        }
        return defaultValue;
    }

    public static double getPositionZ(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double defaultValue) {
        Plane plane;
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && (plane = MetaDataUtil.getPlane(pix, t, z, c)) != null) {
            return OMEUtil.getValue(plane.getPositionZ(), defaultValue);
        }
        return defaultValue;
    }

    public static double getPositionT(ome.xml.meta.OMEXMLMetadata metaData, int series, long defaultValue) {
        return MetaDataUtil.getTimeStamp(metaData, series, defaultValue);
    }

    public static long getTimeStamp(ome.xml.meta.OMEXMLMetadata metaData, int series, long defaultValue) {
        Timestamp time;
        Image img = MetaDataUtil.getSeries(metaData, series);
        if (img != null && (time = img.getAcquisitionDate()) != null) {
            return time.asInstant().getMillis();
        }
        return defaultValue;
    }

    private static double getPositionTOffset(Pixels pix, int t, int z, int c, double defaultValue) {
        double result = -1.0;
        Plane plane = MetaDataUtil.getPlane(pix, t, z, c);
        if (plane != null) {
            result = OMEUtil.getValue(plane.getDeltaT(), -1.0);
        }
        if (result != -1.0) {
            return result;
        }
        result = MetaDataUtil.getTimeInterval(pix, -1.0);
        if (result != -1.0) {
            return result * (double)t;
        }
        return defaultValue;
    }

    public static double getPositionTOffset(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double defaultValue) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return MetaDataUtil.getPositionTOffset(pix, t, z, c, defaultValue);
        }
        return defaultValue;
    }

    @Deprecated
    public static double getPositionT(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double defaultValue) {
        return MetaDataUtil.getPositionTOffset(metaData, series, t, z, c, defaultValue);
    }

    @Deprecated
    public static double getTimePosition(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double defaultValue) {
        return MetaDataUtil.getPositionTOffset(metaData, series, t, z, c, defaultValue);
    }

    private static double computeTimeIntervalFromTimePosition(Pixels pix) {
        int sizeT = MetaDataUtil.getSizeT(pix);
        if (sizeT <= 1) {
            return 0.0;
        }
        double result = 0.0;
        double last = -1.0;
        int lastT = 0;
        int num = 0;
        for (int t = 0; t < sizeT; ++t) {
            double timePos;
            Plane plane = MetaDataUtil.getPlane(pix, t, 0, 0);
            if (plane == null || Double.isNaN(timePos = OMEUtil.getValue(plane.getDeltaT(), Double.NaN))) continue;
            if (last != -1.0) {
                result += (timePos - last) / (double)(t - lastT);
                ++num;
            }
            last = timePos;
            lastT = t;
        }
        if (num == 0) {
            return 0.0;
        }
        return result / (double)num;
    }

    public static void setPositionX(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double value) {
        Plane plane;
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && (plane = MetaDataUtil.ensurePlane(pix, t, z, c)) != null) {
            plane.setPositionX(OMEUtil.getLength(value));
        }
    }

    public static void setPositionY(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double value) {
        Plane plane;
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && (plane = MetaDataUtil.ensurePlane(pix, t, z, c)) != null) {
            plane.setPositionY(OMEUtil.getLength(value));
        }
    }

    public static void setPositionZ(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double value) {
        Plane plane;
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && (plane = MetaDataUtil.ensurePlane(pix, t, z, c)) != null) {
            plane.setPositionZ(OMEUtil.getLength(value));
        }
    }

    public static void setPositionT(ome.xml.meta.OMEXMLMetadata metaData, int series, long value) {
        MetaDataUtil.setTimeStamp(metaData, series, value);
    }

    public static void setTimeStamp(ome.xml.meta.OMEXMLMetadata metaData, int series, long value) {
        Image img = MetaDataUtil.getSeries(metaData, series);
        if (img != null) {
            img.setAcquisitionDate(new Timestamp(new Instant(value)));
        }
    }

    private static void setPositionTOffset(Pixels pix, int t, int z, int c, double value) {
        Plane plane = MetaDataUtil.getPlane(pix, t, z, c);
        if (plane != null) {
            plane.setDeltaT(OMEUtil.getTime(value));
        }
    }

    public static void setPositionTOffset(ome.xml.meta.OMEXMLMetadata metaData, int series, int t, int z, int c, double value) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            MetaDataUtil.setPositionTOffset(pix, t, z, c, value);
        }
    }

    public static String getDefaultChannelName(int channel) {
        return DEFAULT_CHANNEL_NAME + channel;
    }

    public static int getNumChannel(ome.xml.meta.OMEXMLMetadata metaData, int series) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return pix.sizeOfChannelList();
        }
        return 0;
    }

    @Deprecated
    public static int getNumChannel(OMEXMLMetadataImpl metaData, int series) {
        return MetaDataUtil.getNumChannel((ome.xml.meta.OMEXMLMetadata)metaData, series);
    }

    public static Channel getChannel(ome.xml.meta.OMEXMLMetadata metaData, int series, int index) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null && index < pix.sizeOfChannelList()) {
            return pix.getChannel(index);
        }
        return null;
    }

    @Deprecated
    public static Channel getChannel(OMEXMLMetadataImpl metaData, int series, int index) {
        return MetaDataUtil.getChannel((ome.xml.meta.OMEXMLMetadata)metaData, series, index);
    }

    public static Channel ensureChannel(ome.xml.meta.OMEXMLMetadata metaData, int series, int index) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            return MetaDataUtil.ensureChannel(pix, index);
        }
        return null;
    }

    @Deprecated
    public static Channel ensureChannel(OMEXMLMetadataImpl metaData, int series, int index) {
        return MetaDataUtil.ensureChannel((ome.xml.meta.OMEXMLMetadata)metaData, series, index);
    }

    public static Channel ensureChannel(Pixels pix, int index) {
        while (pix.sizeOfChannelList() <= index) {
            pix.addChannel(new Channel());
        }
        return pix.getChannel(index);
    }

    public static void removeChannel(ome.xml.meta.OMEXMLMetadata metaData, int series, int index) {
        Pixels pix = MetaDataUtil.getPixels(metaData, series);
        if (pix != null) {
            MetaDataUtil.removeChannel(pix, index);
        }
    }

    @Deprecated
    public static void removeChannel(OMEXMLMetadataImpl metaData, int series, int index) {
        MetaDataUtil.removeChannel((ome.xml.meta.OMEXMLMetadata)metaData, series, index);
    }

    public static void removeChannel(Pixels pix, int index) {
        if (pix.sizeOfChannelList() > index) {
            pix.removeChannel(pix.getChannel(index));
        }
    }

    public static void setNumChannel(ome.xml.meta.OMEXMLMetadata metaData, int series, int num) {
        OME ome = MetaDataUtil.getOME(metaData);
        MetaDataUtil.ensureSeries(ome, series);
        Image img = ome.getImage(series);
        Pixels pix = img.getPixels();
        if (pix == null) {
            pix = new Pixels();
            img.setPixels(pix);
        }
        while (pix.sizeOfChannelList() > num) {
            MetaDataUtil.removeChannel(pix, pix.sizeOfChannelList() - 1);
        }
        MetaDataUtil.ensureChannel(pix, num - 1);
    }

    @Deprecated
    public static void setNumChannel(OMEXMLMetadataImpl metaData, int series, int num) {
        MetaDataUtil.setNumChannel((ome.xml.meta.OMEXMLMetadata)metaData, series, num);
    }

    private static void prepareMetaChannelName(ome.xml.meta.OMEXMLMetadata metaData, int series, int channel) {
        for (int c = MetaDataUtil.getNumChannel(metaData, series); channel >= c; ++c) {
            metaData.setChannelName(MetaDataUtil.getDefaultChannelName(c), series, c);
        }
    }

    public static String getChannelName(ome.xml.meta.OMEXMLMetadata metaData, int series, int channel) {
        MetaDataUtil.prepareMetaChannelName(metaData, series, channel);
        String result = StringUtil.getValue(metaData.getChannelName(series, channel), MetaDataUtil.getDefaultChannelName(channel));
        String cleaned = XMLUtil.filterString(result);
        if (!cleaned.equals(result)) {
            MetaDataUtil.setChannelName(metaData, series, channel, cleaned);
        }
        return cleaned;
    }

    @Deprecated
    public static String getChannelName(OMEXMLMetadataImpl metaData, int series, int channel) {
        return MetaDataUtil.getChannelName((ome.xml.meta.OMEXMLMetadata)metaData, series, channel);
    }

    public static void setChannelName(ome.xml.meta.OMEXMLMetadata metaData, int series, int channel, String value) {
        MetaDataUtil.prepareMetaChannelName(metaData, series, channel - 1);
        metaData.setChannelName(value, series, channel);
    }

    @Deprecated
    public static void setChannelName(OMEXMLMetadataImpl metaData, int series, int channel, String value) {
        MetaDataUtil.setChannelName((ome.xml.meta.OMEXMLMetadata)metaData, series, channel, value);
    }

    public static Color getChannelColor(ome.xml.meta.OMEXMLMetadata metaData, int series, int channel) {
        MetaDataUtil.prepareMetaChannelName(metaData, series, channel);
        return OMEUtil.getJavaColor(metaData.getChannelColor(series, channel));
    }

    public static String getUserName(ome.xml.meta.OMEXMLMetadata metaData) {
        if (metaData.getExperimenterCount() > 0) {
            return metaData.getExperimenterUserName(0);
        }
        return "";
    }

    public static List<String> getUserNames(ome.xml.meta.OMEXMLMetadata metaData) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < metaData.getExperimenterCount(); ++i) {
            result.add(metaData.getExperimenterUserName(i));
        }
        return result;
    }

    public static boolean containsUserName(ome.xml.meta.OMEXMLMetadata metaData, String userName) {
        for (int i = 0; i < metaData.getExperimenterCount(); ++i) {
            if (!StringUtil.equals(metaData.getExperimenterUserName(i), userName)) continue;
            return true;
        }
        return false;
    }

    public static void setUserName(ome.xml.meta.OMEXMLMetadata metaData, String userName) {
        if (!MetaDataUtil.containsUserName(metaData, userName)) {
            int ind = metaData.getExperimenterCount();
            metaData.setExperimenterUserName(userName, ind);
            if (StringUtil.isEmpty(metaData.getExperimenterID(ind))) {
                metaData.setExperimenterID("Experimenter:" + ind, ind);
            }
        }
    }

    @Deprecated
    public static Color getChannelColor(OMEXMLMetadataImpl metaData, int series, int channel) {
        return MetaDataUtil.getChannelColor((ome.xml.meta.OMEXMLMetadata)metaData, series, channel);
    }

    public static ome.xml.meta.OMEXMLMetadata createMetadata(String name) {
        ome.xml.meta.OMEXMLMetadata result = OMEUtil.createOMEXMLMetadata();
        OME ome = MetaDataUtil.getOME(result);
        MetaDataUtil.ensureSeries(ome, 0);
        result.setImageID(MetadataTools.createLSID("Image", 0), 0);
        result.setImageName(name, 0);
        return result;
    }

    @Deprecated
    public static OMEXMLMetadataImpl createDefaultMetadata(String name) {
        return (OMEXMLMetadataImpl)MetaDataUtil.createMetadata(name);
    }

    @Deprecated
    public static ome.xml.meta.OMEXMLMetadata createOMEMetadata(MetadataRetrieve metadata, int series) {
        return OMEUtil.createOMEXMLMetadata((ome.xml.meta.MetadataRetrieve)metadata, series);
    }

    public static void setMetaData(ome.xml.meta.OMEXMLMetadata metadata, int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, boolean separateChannel) {
        OME ome = (OME)((Object)metadata.getRoot());
        if (ome == null) {
            metadata.createRoot();
            ome = (OME)((Object)metadata.getRoot());
        }
        MetaDataUtil.setNumSeries(metadata, 1);
        MetaDataUtil.cleanTiffData(ome.getImage(0));
        MetaDataUtil.cleanBinData(ome.getImage(0));
        if (StringUtil.isEmpty(metadata.getImageID(0))) {
            metadata.setImageID(MetadataTools.createLSID("Image", 0), 0);
        }
        if (StringUtil.isEmpty(metadata.getImageName(0))) {
            metadata.setImageName("Sample", 0);
        }
        if (StringUtil.isEmpty(metadata.getPixelsID(0))) {
            metadata.setPixelsID(MetadataTools.createLSID("Pixels", 0), 0);
        }
        metadata.setPixelsBigEndian(Boolean.TRUE, 0);
        metadata.setPixelsBinDataBigEndian(Boolean.TRUE, 0, 0);
        metadata.setPixelsDimensionOrder(DimensionOrder.XYCZT, 0);
        metadata.setPixelsType(dataType.toPixelType(), 0);
        metadata.setPixelsSizeX(OMEUtil.getPositiveInteger(sizeX), 0);
        metadata.setPixelsSizeY(OMEUtil.getPositiveInteger(sizeY), 0);
        metadata.setPixelsSizeC(OMEUtil.getPositiveInteger(sizeC), 0);
        metadata.setPixelsSizeZ(OMEUtil.getPositiveInteger(sizeZ), 0);
        metadata.setPixelsSizeT(OMEUtil.getPositiveInteger(sizeT), 0);
        MetaDataUtil.cleanPlanes(ome.getImage(0));
        double timeInterval = MetaDataUtil.getTimeInterval(metadata, 0, 0.0);
        if (timeInterval == 0.0 && (timeInterval = MetaDataUtil.getTimeIntervalFromTimePositions(metadata, 0)) != 0.0) {
            MetaDataUtil.setTimeInterval(metadata, 0, timeInterval);
        }
        if (separateChannel) {
            MetaDataUtil.setNumChannel(metadata, 0, sizeC);
            for (int c = 0; c < sizeC; ++c) {
                if (StringUtil.isEmpty(metadata.getChannelID(0, c))) {
                    metadata.setChannelID(MetadataTools.createLSID("Channel", 0, c), 0, c);
                }
                metadata.setChannelSamplesPerPixel(new PositiveInteger(1), 0, c);
            }
        } else {
            MetaDataUtil.setNumChannel(metadata, 0, 1);
            if (StringUtil.isEmpty(metadata.getChannelID(0, 0))) {
                metadata.setChannelID(MetadataTools.createLSID("Channel", 0, 0), 0, 0);
            }
            metadata.setChannelSamplesPerPixel(new PositiveInteger(sizeC), 0, 0);
        }
    }

    @Deprecated
    public static void setMetaData(OMEXMLMetadataImpl metadata, int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, boolean separateChannel) {
        MetaDataUtil.setMetaData((ome.xml.meta.OMEXMLMetadata)metadata, sizeX, sizeY, sizeC, sizeZ, sizeT, dataType, separateChannel);
    }

    public static ome.xml.meta.OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, boolean separateChannel) throws ServiceException {
        ome.xml.meta.OMEXMLMetadata result = MetaDataUtil.createMetadata("Sample");
        MetaDataUtil.setMetaData(result, sizeX, sizeY, sizeC, sizeZ, sizeT, dataType, separateChannel);
        return result;
    }

    public static ome.xml.meta.OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, DataType dataType, boolean separateChannel) throws ServiceException {
        return MetaDataUtil.generateMetaData(sizeX, sizeY, sizeC, 1, 1, dataType, separateChannel);
    }

    public static ome.xml.meta.OMEXMLMetadata generateMetaData(IcyBufferedImage image, boolean separateChannel) throws ServiceException {
        return MetaDataUtil.generateMetaData(image.getSizeX(), image.getSizeY(), image.getSizeC(), image.getDataType_(), separateChannel);
    }

    @Deprecated
    public static ome.xml.meta.OMEXMLMetadata generateMetaData(Sequence sequence, boolean useZ, boolean useT, boolean separateChannel) {
        return MetaDataUtil.generateMetaData(sequence, separateChannel);
    }

    @Deprecated
    public static ome.xml.meta.OMEXMLMetadata generateMetaData(Sequence sequence, int sizeZ, int sizeT, boolean separateChannel) {
        return MetaDataUtil.generateMetaData(sequence, separateChannel);
    }

    public static ome.xml.meta.OMEXMLMetadata generateMetaData(Sequence sequence, boolean separateChannel) {
        ome.xml.meta.OMEXMLMetadata result = OMEUtil.createOMEXMLMetadata((ome.xml.meta.MetadataRetrieve)sequence.getOMEXMLMetadata(), false);
        MetaDataUtil.setMetaData(result, sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeC(), sequence.getSizeZ(), sequence.getSizeT(), sequence.getDataType_(), separateChannel);
        return result;
    }

    public static void keepSingleSerie(ome.xml.meta.OMEXMLMetadata metaData, int num) {
        Instrument instr;
        ExperimenterGroup exprGroup;
        Experimenter expr;
        Experiment exp;
        AbstractOMEModelObject obj;
        int i;
        OME ome = MetaDataUtil.getOME(metaData);
        int numSeries = ome.sizeOfImageList();
        Image img = MetaDataUtil.getSeries(metaData, num);
        if (img == null) {
            return;
        }
        for (int i2 = numSeries - 1; i2 >= 0; --i2) {
            if (i2 == num) continue;
            ome.removeImage(ome.getImage(i2));
        }
        HashSet<AbstractOMEModelObject> toKeep = new HashSet<AbstractOMEModelObject>();
        toKeep.clear();
        for (i = 0; i < img.sizeOfLinkedDatasetList(); ++i) {
            toKeep.add(img.getLinkedDataset(i));
        }
        if (!toKeep.isEmpty()) {
            for (i = ome.sizeOfDatasetList() - 1; i >= 0; --i) {
                obj = ome.getDataset(i);
                if (toKeep.contains(obj)) continue;
                ome.removeDataset((Dataset)obj);
            }
        } else if (ome.sizeOfDatasetList() == numSeries) {
            for (i = numSeries - 1; i >= 0; --i) {
                if (i == num) continue;
                ome.removeDataset(ome.getDataset(i));
            }
        }
        toKeep.clear();
        for (i = 0; i < img.sizeOfLinkedROIList(); ++i) {
            toKeep.add(img.getLinkedROI(i));
        }
        if (!toKeep.isEmpty()) {
            for (i = ome.sizeOfROIList() - 1; i >= 0; --i) {
                obj = ome.getROI(i);
                if (toKeep.contains(obj)) continue;
                ome.removeROI((ROI)obj);
            }
        } else if (ome.sizeOfROIList() == numSeries) {
            for (i = numSeries - 1; i >= 0; --i) {
                if (i == num) continue;
                ome.removeROI(ome.getROI(i));
            }
        }
        if ((exp = img.getLinkedExperiment()) != null) {
            for (int i3 = ome.sizeOfExperimentList() - 1; i3 >= 0; --i3) {
                Experiment obj2 = ome.getExperiment(i3);
                if (obj2 == exp) continue;
                ome.removeExperiment(obj2);
            }
        } else if (ome.sizeOfExperimentList() == numSeries) {
            for (int i4 = numSeries - 1; i4 >= 0; --i4) {
                if (i4 == num) continue;
                ome.removeExperiment(ome.getExperiment(i4));
            }
        }
        if ((expr = img.getLinkedExperimenter()) != null) {
            for (int i5 = ome.sizeOfExperimenterList() - 1; i5 >= 0; --i5) {
                Experimenter obj3 = ome.getExperimenter(i5);
                if (obj3 == expr) continue;
                ome.removeExperimenter(obj3);
            }
        } else if (ome.sizeOfExperimenterList() == numSeries) {
            for (int i6 = numSeries - 1; i6 >= 0; --i6) {
                if (i6 == num) continue;
                ome.removeExperimenter(ome.getExperimenter(i6));
            }
        }
        if ((exprGroup = img.getLinkedExperimenterGroup()) != null) {
            for (int i7 = ome.sizeOfExperimenterGroupList() - 1; i7 >= 0; --i7) {
                ExperimenterGroup obj4 = ome.getExperimenterGroup(i7);
                if (obj4 == exprGroup) continue;
                ome.removeExperimenterGroup(obj4);
            }
        } else if (ome.sizeOfExperimenterGroupList() == numSeries) {
            for (int i8 = numSeries - 1; i8 >= 0; --i8) {
                if (i8 == num) continue;
                ome.removeExperimenterGroup(ome.getExperimenterGroup(i8));
            }
        }
        if ((instr = img.getLinkedInstrument()) != null) {
            for (int i9 = ome.sizeOfInstrumentList() - 1; i9 >= 0; --i9) {
                Instrument obj5 = ome.getInstrument(i9);
                if (obj5 == instr) continue;
                ome.removeInstrument(obj5);
            }
        } else if (ome.sizeOfInstrumentList() == numSeries) {
            for (int i10 = numSeries - 1; i10 >= 0; --i10) {
                if (i10 == num) continue;
                ome.removeInstrument(ome.getInstrument(i10));
            }
        }
        if (ome.sizeOfPlateList() == numSeries) {
            for (int i11 = numSeries - 1; i11 >= 0; --i11) {
                if (i11 == num) continue;
                ome.removePlate(ome.getPlate(i11));
            }
        }
        if (ome.sizeOfProjectList() == numSeries) {
            for (int i12 = numSeries - 1; i12 >= 0; --i12) {
                if (i12 == num) continue;
                ome.removeProject(ome.getProject(i12));
            }
        }
        if (ome.sizeOfScreenList() == numSeries) {
            for (int i13 = numSeries - 1; i13 >= 0; --i13) {
                if (i13 == num) continue;
                ome.removeScreen(ome.getScreen(i13));
            }
        }
    }

    public static void keepSinglePlane(Image img, int index) {
        int i;
        Pixels pix = img.getPixels();
        if (pix == null) {
            return;
        }
        int numPlane = pix.sizeOfPlaneList();
        Plane plane = MetaDataUtil.getPlane(pix, index);
        for (int i2 = numPlane - 1; i2 >= 0; --i2) {
            if (i2 == index) continue;
            pix.removePlane(pix.getPlane(i2));
        }
        HashSet<Annotation> toKeep = new HashSet<Annotation>();
        toKeep.clear();
        for (i = 0; i < plane.sizeOfLinkedAnnotationList(); ++i) {
            toKeep.add(plane.getLinkedAnnotation(i));
        }
        if (!toKeep.isEmpty()) {
            for (i = img.sizeOfLinkedAnnotationList() - 1; i >= 0; --i) {
                Annotation obj = img.getLinkedAnnotation(i);
                if (toKeep.contains(obj)) continue;
                img.unlinkAnnotation(obj);
            }
        } else if (img.sizeOfLinkedAnnotationList() == numPlane) {
            for (i = numPlane - 1; i >= 0; --i) {
                if (i == index) continue;
                img.unlinkAnnotation(img.getLinkedAnnotation(i));
            }
        }
        if (pix.sizeOfBinDataList() == numPlane) {
            for (i = numPlane - 1; i >= 0; --i) {
                if (i == index) continue;
                pix.removeBinData(pix.getBinData(i));
            }
        }
        if (pix.sizeOfTiffDataList() == numPlane) {
            for (i = numPlane - 1; i >= 0; --i) {
                if (i == index) continue;
                pix.removeTiffData(pix.getTiffData(i));
            }
        }
    }

    @Deprecated
    public static void keepSingleSerie(OMEXMLMetadataImpl metaData, int num) {
        MetaDataUtil.keepSingleSerie((ome.xml.meta.OMEXMLMetadata)metaData, num);
    }

    public static void keepPlanes(Image img, int posT, int posZ, int posC) {
        Pixels pix = img.getPixels();
        if (pix == null) {
            return;
        }
        int sizeT = OMEUtil.getValue(pix.getSizeT(), 0);
        int sizeZ = OMEUtil.getValue(pix.getSizeZ(), 0);
        int sizeC = OMEUtil.getValue(pix.getSizeC(), 0);
        for (int t = 0; t < sizeT; ++t) {
            boolean removeT = posT != -1 && posT != t;
            for (int z = 0; z < sizeZ; ++z) {
                boolean removeZ = posZ != -1 && posZ != z;
                for (int c = 0; c < sizeC; ++c) {
                    boolean removeC;
                    boolean bl = removeC = posC != -1 && posC != c;
                    if (!removeT && !removeZ && !removeC) continue;
                    MetaDataUtil.removePlane(img, t, z, c);
                }
            }
        }
        int numPlane = pix.sizeOfPlaneList();
        for (int i = 0; i < numPlane; ++i) {
            Plane plane = pix.getPlane(i);
            if (posT != -1) {
                plane.setTheT(OMEUtil.getNonNegativeInteger(0));
            }
            if (posZ != -1) {
                plane.setTheZ(OMEUtil.getNonNegativeInteger(0));
            }
            if (posC == -1) continue;
            plane.setTheC(OMEUtil.getNonNegativeInteger(0));
        }
    }

    public static void keepPlanes(ome.xml.meta.OMEXMLMetadata metadata, int series, int posT, int posZ, int posC) {
        Image img = MetaDataUtil.getSeries(metadata, series);
        if (img != null) {
            MetaDataUtil.keepPlanes(img, posT, posZ, posC);
        }
    }

    public static void cleanPlanes(Image img) {
        Pixels pix = img.getPixels();
        if (pix == null) {
            return;
        }
        int sizeT = OMEUtil.getValue(pix.getSizeT(), 0);
        int sizeZ = OMEUtil.getValue(pix.getSizeZ(), 0);
        int sizeC = OMEUtil.getValue(pix.getSizeC(), 0);
        if (sizeT < 1 || sizeZ < 1 || sizeC < 1) {
            return;
        }
        int allowedMaxPlaneIndex = MetaDataUtil.getPlaneIndex(pix, sizeT - 1, sizeZ - 1, sizeC - 1);
        int maxPlaneIndex = pix.sizeOfPlaneList() - 1;
        while (maxPlaneIndex > allowedMaxPlaneIndex) {
            MetaDataUtil.removePlane(img, maxPlaneIndex--);
        }
    }

    public static void cleanTiffData(Image img) {
        Pixels pix = img.getPixels();
        if (pix == null) {
            return;
        }
        while (pix.sizeOfTiffDataList() > 0) {
            pix.removeTiffData(pix.getTiffData(pix.sizeOfTiffDataList() - 1));
        }
    }

    public static void cleanBinData(Image img) {
        Pixels pix = img.getPixels();
        if (pix == null) {
            return;
        }
        while (pix.sizeOfBinDataList() > 0) {
            pix.removeBinData(pix.getBinData(pix.sizeOfBinDataList() - 1));
        }
    }

    public static void clean(ome.xml.meta.OMEXMLMetadata metaData) {
        OME ome = MetaDataUtil.getOME(metaData);
        StructuredAnnotations annotations = ome.getStructuredAnnotations();
        if (annotations != null) {
            for (int i = annotations.sizeOfXMLAnnotationList() - 1; i >= 0; --i) {
                XMLAnnotation xmlAnnotation = annotations.getXMLAnnotation(i);
                if (!MetaDataUtil.isEmpty(xmlAnnotation)) continue;
                annotations.removeXMLAnnotation(xmlAnnotation);
            }
        }
    }

    @Deprecated
    public static void clean(OMEXMLMetadataImpl metaData) {
        MetaDataUtil.clean((ome.xml.meta.OMEXMLMetadata)metaData);
    }

    public static boolean isEmpty(XMLAnnotation xmlAnnotation) {
        return StringUtil.isEmpty(xmlAnnotation.getDescription()) && StringUtil.isEmpty(xmlAnnotation.getValue());
    }
}

