/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.type.rectangle.Rectangle3D;
import java.awt.geom.Rectangle2D;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DStackShape;

public class ROI3DStackRectangle
extends ROI3DStackShape {
    public ROI3DStackRectangle() {
        super((Class<? extends ROI2DShape>)ROI2DRectangle.class);
        this.setName("3D rectangle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI3DStackRectangle(Rectangle3D rect) {
        this();
        if (rect.isInfiniteZ()) {
            throw new IllegalArgumentException("Cannot set infinite Z dimension on the 3D Stack Rectangle ROI.");
        }
        Rectangle2D rect2d = rect.toRectangle2D();
        this.beginUpdate();
        try {
            for (int z = (int)Math.floor(rect.getMinZ()); z <= (int)rect.getMaxZ(); ++z) {
                this.setSlice(z, new ROI2DRectangle(rect2d));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROI3DStackRectangle(Rectangle2D rect, int zMin, int zMax) {
        this();
        if (zMax < zMin) {
            throw new IllegalArgumentException("ROI3DStackRectangle: cannot create the ROI (zMax < zMin).");
        }
        this.beginUpdate();
        try {
            for (int z = zMin; z <= zMax; ++z) {
                this.setSlice(z, new ROI2DRectangle(rect));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public String getDefaultName() {
        return "Rectangle2D stack";
    }
}

