/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AReference;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Util;
import java.util.Map;

public abstract class ARef
extends AReference
implements IRef {
    protected volatile IFn validator = null;
    private volatile IPersistentMap watches = PersistentHashMap.EMPTY;

    public ARef() {
    }

    public ARef(IPersistentMap meta2) {
        super(meta2);
    }

    void validate(IFn vf, Object val2) {
        try {
            if (vf != null && !RT.booleanCast(vf.invoke(val2))) {
                throw new IllegalStateException("Invalid reference state");
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new IllegalStateException("Invalid reference state", e2);
        }
    }

    void validate(Object val2) {
        this.validate(this.validator, val2);
    }

    public void setValidator(IFn vf) {
        try {
            this.validate(vf, this.deref());
        }
        catch (Exception e2) {
            throw Util.runtimeException(e2);
        }
        this.validator = vf;
    }

    public IFn getValidator() {
        return this.validator;
    }

    public IPersistentMap getWatches() {
        return this.watches;
    }

    public synchronized IRef addWatch(Object key2, IFn callback) {
        this.watches = this.watches.assoc(key2, callback);
        return this;
    }

    public synchronized IRef removeWatch(Object key2) {
        try {
            this.watches = this.watches.without(key2);
        }
        catch (Exception e2) {
            throw Util.runtimeException(e2);
        }
        return this;
    }

    public void notifyWatches(Object oldval, Object newval) {
        IPersistentMap ws = this.watches;
        if (ws.count() > 0) {
            for (ISeq s = ws.seq(); s != null; s = s.next()) {
                Map.Entry e2 = (Map.Entry)s.first();
                IFn fn2 = (IFn)e2.getValue();
                try {
                    if (fn2 == null) continue;
                    fn2.invoke(e2.getKey(), this, oldval, newval);
                    continue;
                }
                catch (Exception e1) {
                    throw Util.runtimeException(e1);
                }
            }
        }
    }
}

