/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array3D;
import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array4D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;
    protected final int dim4;

    protected Array4D(int dim1, int dim2, int dim3, int dim4) {
        this.shape = new Shape(dim1, dim2, dim3, dim4);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.dim3 = dim3;
        this.dim4 = dim4;
    }

    protected Array4D(int[] dims) {
        this(new Shape(dims));
    }

    protected Array4D(Shape shape) {
        if (shape.rank() != 4) {
            throw new IllegalArgumentException("Bad number of dimensions for 4-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
        this.dim4 = shape.dimension(3);
    }

    @Override
    public final int getRank() {
        return 4;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    public final Array4D reshape(Shape shape) {
        if (this.number == (int)shape.number()) {
            return (Array4D)ArrayFactory.wrap(this.getData(), shape);
        }
        throw new IllegalArgumentException("The new shape is not commensurate with the old shape");
    }

    @Override
    public final Array4D movedims(int initpos, int finalpos) {
        int k;
        if (finalpos > 3 || initpos > 3) {
            throw new IllegalArgumentException("The permutation should not change the rank");
        }
        if (initpos == finalpos) {
            return this.copy();
        }
        int[] newdims = new int[4];
        if (initpos < finalpos) {
            for (k = 0; k < initpos; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
            for (k = initpos; k < finalpos; ++k) {
                newdims[k] = this.shape.dimension(k + 1);
            }
            newdims[finalpos] = this.shape.dimension(initpos);
            for (k = finalpos + 1; k < 4; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
        } else {
            for (k = 0; k < finalpos; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
            newdims[finalpos] = this.shape.dimension(initpos);
            for (k = finalpos + 1; k < initpos + 1; ++k) {
                newdims[k] = this.shape.dimension(k - 1);
            }
            for (k = initpos + 1; k < 4; ++k) {
                newdims[k] = this.shape.dimension(k);
            }
        }
        Array4D newArray = (Array4D)ArrayFactory.create(this.getType(), newdims);
        for (int n = 0; n < this.shape.dimension(initpos); ++n) {
            newArray.slice(n, finalpos).assign(this.slice(n, initpos));
        }
        return newArray;
    }

    @Override
    public abstract Array4D copy();

    public abstract Array3D slice(int var1);

    public abstract Array3D slice(int var1, int var2);

    public abstract Array4D view(Range var1, Range var2, Range var3, Range var4);

    public abstract Array4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int number, int offset, int stride1, int stride2, int stride3, int stride4, int dim1, int dim2, int dim3, int dim4) {
        int imax;
        int imin;
        int itmp = (dim1 - 1) * stride1;
        if (itmp >= 0) {
            imin = offset;
            imax = offset + itmp;
        } else {
            imin = offset + itmp;
            imax = offset;
        }
        itmp = (dim2 - 1) * stride2;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim3 - 1) * stride3;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        itmp = (dim4 - 1) * stride4;
        if (itmp >= 0) {
            imax += itmp;
        } else {
            imin += itmp;
        }
        if (imin < 0 || imax >= number) {
            throw new IndexOutOfBoundsException("4D view is not within available space");
        }
        int s1 = Math.abs(stride1);
        int s2 = Math.abs(stride2);
        int s3 = Math.abs(stride3);
        int s4 = Math.abs(stride4);
        if (s1 <= s2 && s2 <= s3 && s3 <= s4) {
            return 1;
        }
        if (s1 >= s2 && s2 >= s3 && s3 >= s4) {
            return 2;
        }
        return 0;
    }
}

