/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float2D;
import mitiv.array.Int1D;
import mitiv.array.IntArray;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatInt2D;
import mitiv.array.impl.StriddenInt2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int2D
extends Array2D
implements IntArray {
    protected Int2D(int dim1, int dim2) {
        super(dim1, dim2);
    }

    protected Int2D(int[] dims) {
        super(dims);
    }

    protected Int2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2);

    public abstract void set(int var1, int var2, int var3);

    @Override
    public void fill(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, value);
                }
            }
        }
    }

    @Override
    public void increment(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                }
            }
        }
    }

    @Override
    public void decrement(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                }
            }
        }
    }

    @Override
    public void scale(int value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                }
            }
        }
    }

    @Override
    public void map(IntFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, generator.nextInt());
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, generator.nextInt());
                }
            }
        }
    }

    @Override
    public void scan(IntScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                        continue;
                    }
                    scanner.initialize(this.get(i1, i2));
                    initialized = true;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                        continue;
                    }
                    scanner.initialize(this.get(i1, i2));
                    initialized = true;
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    int value = this.get(i1, i2);
                    if (value >= minValue) continue;
                    minValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    int value = this.get(i1, i2);
                    if (value >= minValue) continue;
                    minValue = value;
                }
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    int value = this.get(i1, i2);
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    int value = this.get(i1, i2);
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    int value = this.get(i1, i2);
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    if (skip) {
                        skip = false;
                        continue;
                    }
                    int value = this.get(i1, i2);
                    if (value < minValue) {
                        minValue = value;
                    }
                    if (value <= maxValue) continue;
                    maxValue = value;
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    totalValue += this.get(i1, i2);
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    totalValue += this.get(i1, i2);
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (byte)this.get(i1, i2);
                }
            }
        }
        return Byte2D.wrap(out, this.getShape());
    }

    @Override
    public Short2D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = (short)this.get(i1, i2);
                }
            }
        }
        return Short2D.wrap(out, this.getShape());
    }

    @Override
    public Int2D toInt() {
        return this;
    }

    @Override
    public Long2D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = this.get(i1, i2);
                }
            }
        }
        return Long2D.wrap(out, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = this.get(i1, i2);
                }
            }
        }
        return Float2D.wrap(out, this.getShape());
    }

    @Override
    public Double2D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            int[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    out[++i] = this.get(i1, i2);
                }
            }
        }
        return Double2D.wrap(out, this.getShape());
    }

    @Override
    public Int2D copy() {
        return new FlatInt2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int2D src = arr.getType() == 2 ? (Int2D)arr : (Int2D)arr.toInt();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    this.set(i1, i2, src.get(i1, i2));
                }
            }
        } else {
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, src.get(i1, i2));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, (int)src.get(++i));
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i2 = 0; i2 < this.dim2; ++i2) {
                for (int i1 = 0; i1 < this.dim1; ++i1) {
                    this.set(i1, i2, (int)src.get(++i));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int2D create() {
        return new FlatInt2D(this.getShape());
    }

    public static Int2D create(int dim1, int dim2) {
        return new FlatInt2D(dim1, dim2);
    }

    public static Int2D create(int[] dims) {
        return new FlatInt2D(dims);
    }

    public static Int2D create(Shape shape) {
        return new FlatInt2D(shape);
    }

    public static Int2D wrap(int[] data, int dim1, int dim2) {
        return new FlatInt2D(data, dim1, dim2);
    }

    public static Int2D wrap(int[] data, int[] dims) {
        return new FlatInt2D(data, dims);
    }

    public static Int2D wrap(int[] data, Shape shape) {
        return new FlatInt2D(data, shape);
    }

    public static Int2D wrap(int[] data, int offset, int stride1, int stride2, int dim1, int dim2) {
        return new StriddenInt2D(data, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public abstract Int1D slice(int var1);

    @Override
    public abstract Int1D slice(int var1, int var2);

    @Override
    public abstract Int2D view(Range var1, Range var2);

    @Override
    public abstract Int2D view(int[] var1, int[] var2);

    @Override
    public abstract Int1D as1D();
}

