/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.ConvexSetProjector;

public abstract class BoundProjector
extends ConvexSetProjector {
    protected BoundProjector(VectorSpace vsp) {
        super(vsp);
    }

    public void projectDirection(Vector x, Vector d, boolean ascent, Vector dp) {
        if (!(x.belongsTo(this.space) && d.belongsTo(this.space) && dp.belongsTo(this.space))) {
            throw new IncorrectSpaceException();
        }
        this._projectDirection(x, d, ascent, dp, null);
    }

    public void projectDirection(Vector x, Vector d, boolean ascent, Vector dp, double[] bnd) {
        if (!(x.belongsTo(this.space) && d.belongsTo(this.space) && dp.belongsTo(this.space))) {
            throw new IncorrectSpaceException();
        }
        if (bnd != null && bnd.length != 2) {
            throw new IllegalArgumentException("Bad array size for step bounds");
        }
        this._projectDirection(x, d, ascent, dp, bnd);
    }

    protected abstract void _projectDirection(Vector var1, Vector var2, boolean var3, Vector var4, double[] var5);

    public final float convertToFloat(double value) {
        if (value < -3.4028234663852886E38) {
            return Float.NEGATIVE_INFINITY;
        }
        if (value < -3.4028234663852886E38) {
            return Float.POSITIVE_INFINITY;
        }
        return (float)value;
    }

    public final void checkLowerBound(double lowerBound, boolean single) {
        if (Double.isNaN(lowerBound) || Double.isInfinite(lowerBound) && lowerBound != Double.NEGATIVE_INFINITY || single && this.convertToFloat(lowerBound) == Float.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("Invalid lower bound value");
        }
    }

    public final void checkUpperBound(double upperBound, boolean single) {
        if (Double.isNaN(upperBound) || Double.isInfinite(upperBound) && upperBound != Double.POSITIVE_INFINITY || single && this.convertToFloat(upperBound) == Float.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Invalid upper bound value");
        }
    }

    public final void checkBounds(double lowerBound, double upperBound, boolean single) {
        this.checkLowerBound(lowerBound, single);
        this.checkUpperBound(upperBound, single);
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException("Lower bound must be less or equal upper bound");
        }
    }

    public static final double min(double a, double b) {
        return a <= b ? a : b;
    }

    public static final double max(double a, double b) {
        return a >= b ? a : b;
    }

    public static final double clamp(double x, double xmin, double xmax) {
        if (x <= xmin) {
            return xmin;
        }
        if (x >= xmax) {
            return xmax;
        }
        return x;
    }

    public static final float min(float a, float b) {
        return a <= b ? a : b;
    }

    public static final float max(float a, float b) {
        return a >= b ? a : b;
    }

    public static final float clamp(float x, float xmin, float xmax) {
        if (x <= xmin) {
            return xmin;
        }
        if (x >= xmax) {
            return xmax;
        }
        return x;
    }
}

