/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.action.IcyAbstractAction;
import icy.gui.main.MainFrame;
import icy.main.Icy;
import icy.preferences.GeneralPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.swimmingPool.SwimmingPoolViewer;
import icy.util.ClassUtil;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WindowActions {
    public static IcyAbstractAction stayOnTopAction = new IcyAbstractAction("Stay on top", new IcyIcon(ResourceUtil.ICON_PIN), "Keep window on top", "Icy window always stays above other windows."){
        private static final long serialVersionUID = 389778521530821291L;

        @Override
        public boolean doAction(ActionEvent e) {
            boolean value = !Icy.getMainInterface().isAlwaysOnTop();
            Icy.getMainInterface().setAlwaysOnTop(value);
            GeneralPreferences.setAlwaysOnTop(value);
            return true;
        }
    };
    public static IcyAbstractAction swimmingPoolAction = new IcyAbstractAction("Swimming Pool Viewer", new IcyIcon(ResourceUtil.ICON_BOX), "Show the swimming pool", "Show and edit the swimming pool objects"){
        private static final long serialVersionUID = -2243906270795266643L;

        @Override
        public boolean doAction(ActionEvent e) {
            new SwimmingPoolViewer();
            return true;
        }
    };
    public static IcyAbstractAction gridTileAction = new IcyAbstractAction("Grid (Shift+G)", new IcyIcon("2x2_grid"), "Grid tile arrangement", "Reorganise all opened windows in grid tile.", 71, 1){
        private static final long serialVersionUID = 5529845883985655784L;

        @Override
        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
            if (mainFrame != null) {
                mainFrame.organizeTile(2);
                return true;
            }
            return false;
        }
    };
    public static IcyAbstractAction horizontalTileAction = new IcyAbstractAction("Horizontal (Shift+H)", new IcyIcon("tile_horizontal"), "Horizontal tile arrangement", "Reorganise all opened windows in horizontal tile.", 72, 1){
        private static final long serialVersionUID = 5752682613042198566L;

        @Override
        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
            if (mainFrame != null) {
                mainFrame.organizeTile(0);
                return true;
            }
            return false;
        }
    };
    public static IcyAbstractAction verticalTileAction = new IcyAbstractAction("Vertical (Shift+V)", new IcyIcon("tile_vertical"), "Vertical tile arrangement", "Reorganise all opened windows in vertical tile.", 86, 1){
        private static final long serialVersionUID = -3978957277869827951L;

        @Override
        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
            if (mainFrame != null) {
                mainFrame.organizeTile(1);
                return true;
            }
            return false;
        }
    };
    public static IcyAbstractAction cascadeAction = new IcyAbstractAction("Cascade", new IcyIcon("cascade"), "Cascade arrangement", "Reorganise all opened windows in cascade."){
        private static final long serialVersionUID = 5074922972421168033L;

        @Override
        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
            if (mainFrame != null) {
                mainFrame.organizeCascade();
                return true;
            }
            return false;
        }
    };

    public static List<IcyAbstractAction> getAllActions() {
        ArrayList<IcyAbstractAction> result = new ArrayList<IcyAbstractAction>();
        for (Field field : WindowActions.class.getFields()) {
            Class<?> type = field.getType();
            try {
                if (ClassUtil.isSubClass(type, IcyAbstractAction[].class)) {
                    result.addAll(Arrays.asList((IcyAbstractAction[])field.get(null)));
                    continue;
                }
                if (!ClassUtil.isSubClass(type, IcyAbstractAction.class)) continue;
                result.add((IcyAbstractAction)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

