/*
 * Decompiled with CFR 0.152.
 */
package icy.canvas;

import icy.action.CanvasActions;
import icy.action.GeneralActions;
import icy.action.RoiActions;
import icy.action.WindowActions;
import icy.canvas.CanvasLayerEvent;
import icy.canvas.CanvasLayerListener;
import icy.canvas.IcyCanvasEvent;
import icy.canvas.IcyCanvasListener;
import icy.canvas.Layer;
import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.common.listener.ProgressListener;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.MouseImageInfosPanel;
import icy.gui.viewer.TNavigationPanel;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.gui.viewer.ZNavigationPanel;
import icy.image.IcyBufferedImage;
import icy.image.colormodel.IcyColorModel;
import icy.image.lut.LUT;
import icy.image.lut.LUTEvent;
import icy.image.lut.LUTListener;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.painter.OverlayWrapper;
import icy.painter.Painter;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginCanvas;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.util.ClassUtil;
import icy.util.EventUtil;
import icy.util.OMEUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import ome.xml.meta.MetadataRetrieve;
import plugins.kernel.canvas.Canvas2DPlugin;
import plugins.kernel.canvas.VtkCanvasPlugin;

public abstract class IcyCanvas
extends JPanel
implements KeyListener,
ViewerListener,
SequenceListener,
LUTListener,
ChangeListener,
Layer.LayerListener {
    private static final long serialVersionUID = -8461229450296203011L;
    public static final String PROPERTY_LAYERS_VISIBLE = "layersVisible";
    protected final ZNavigationPanel zNav;
    protected final TNavigationPanel tNav;
    protected final MouseImageInfosPanel mouseInfPanel;
    protected JPanel panel;
    protected final Viewer viewer;
    protected boolean layersVisible;
    protected int syncId;
    protected final Overlay imageOverlay;
    protected final Layer imageLayer;
    protected final Map<Overlay, Layer> layers;
    protected List<Layer> orderedLayers;
    protected final UpdateEventHandler updater;
    protected final List<IcyCanvasListener> listeners;
    protected final List<CanvasLayerListener> layerListeners;
    protected int posX;
    protected int posY;
    protected int posZ;
    protected int posT;
    protected int posC;
    protected Point mousePos;
    protected LUT lut;
    protected boolean synchMaster;
    protected boolean orderedLayersOutdated;
    private Runnable guiUpdater;
    protected boolean isLoopingT;

    public static List<PluginDescriptor> getCanvasPlugins() {
        int ind;
        ArrayList<PluginDescriptor> result = PluginLoader.getPlugins(PluginCanvas.class);
        if (!Icy.isVtkLibraryLoaded() && (ind = PluginDescriptor.getIndex(result, VtkCanvasPlugin.class.getName())) != -1) {
            result.remove(ind);
        }
        Collections.sort(result, new Comparator<PluginDescriptor>(){

            @Override
            public int compare(PluginDescriptor o1, PluginDescriptor o2) {
                return Integer.valueOf(this.getOrder(o1)).compareTo(this.getOrder(o2));
            }

            int getOrder(PluginDescriptor p) {
                if (p.getClassName().equals(Canvas2DPlugin.class.getName())) {
                    return 0;
                }
                if (p.getClassName().equals(VtkCanvasPlugin.class.getName())) {
                    return 1;
                }
                return 10;
            }
        });
        return result;
    }

    public static List<String> getCanvasPluginNames() {
        List<PluginDescriptor> plugins = IcyCanvas.getCanvasPlugins();
        ArrayList<String> result = new ArrayList<String>();
        for (PluginDescriptor plugin : plugins) {
            result.add(plugin.getClassName());
        }
        return result;
    }

    public static String getPluginClassName(String canvasClassName) {
        for (PluginDescriptor plugin : IcyCanvas.getCanvasPlugins()) {
            String className = IcyCanvas.getCanvasClassName(plugin);
            if (!canvasClassName.equals(className)) continue;
            return plugin.getClassName();
        }
        return null;
    }

    public static String getCanvasClassName(PluginDescriptor plugin) {
        try {
            if (plugin != null) {
                PluginCanvas pluginCanvas = (PluginCanvas)((Object)plugin.getPluginClass().newInstance());
                return pluginCanvas.getCanvasClassName();
            }
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, true);
        }
        return null;
    }

    public static String getCanvasClassName(String pluginClassName) {
        return IcyCanvas.getCanvasClassName(PluginLoader.getPlugin(pluginClassName));
    }

    public static IcyCanvas create(String className, Viewer viewer) throws ClassCastException, Exception {
        Class<PluginCanvas> pluginCanvasClazz;
        Class<?> clazz = ClassUtil.findClass(className);
        try {
            pluginCanvasClazz = clazz.asSubclass(PluginCanvas.class);
        }
        catch (ClassCastException e0) {
            Class<IcyCanvas> canvasClazz = clazz.asSubclass(IcyCanvas.class);
            Constructor<IcyCanvas> constructor = canvasClazz.getConstructor(Viewer.class);
            return constructor.newInstance(viewer);
        }
        return pluginCanvasClazz.newInstance().createCanvas(viewer);
    }

    public static void addVisibleLayerToList(Layer layer, ArrayList<Layer> list) {
        if (layer != null && layer.isVisible()) {
            list.add(layer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyCanvas(Viewer viewer) {
        this.viewer = viewer;
        this.layersVisible = true;
        this.layers = new HashMap<Overlay, Layer>();
        this.orderedLayers = new ArrayList<Layer>();
        this.syncId = 0;
        this.synchMaster = false;
        this.orderedLayersOutdated = false;
        this.updater = new UpdateEventHandler(this, false);
        this.mousePos = new Point(0, 0);
        this.posX = -1;
        this.posY = -1;
        this.posZ = -1;
        this.posT = -1;
        this.posC = -1;
        this.panel = new JPanel();
        this.listeners = new ArrayList<IcyCanvasListener>();
        this.layerListeners = new ArrayList<CanvasLayerListener>();
        this.zNav = new ZNavigationPanel();
        this.zNav.addChangeListener(new javax.swing.event.ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IcyCanvas.this.setPositionZ(IcyCanvas.this.zNav.getValue());
            }
        });
        this.tNav = new TNavigationPanel();
        this.tNav.addChangeListener(new javax.swing.event.ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                IcyCanvas.this.setPositionT(IcyCanvas.this.tNav.getValue());
            }
        });
        this.tNav.addLoopingStateChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IcyCanvas.this.isLoopingT = IcyCanvas.this.tNav.isRepeat();
            }
        });
        this.isLoopingT = this.tNav.isRepeat();
        this.mouseInfPanel = new MouseImageInfosPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.zNav, "West");
        this.add((Component)GuiUtil.createPageBoxPanel(this.tNav, this.mouseInfPanel), "South");
        this.guiUpdater = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        IcyCanvas.this.updateZNav();
                        IcyCanvas.this.updateTNav();
                        int maxX = IcyCanvas.this.getMaxPositionX();
                        int curX = IcyCanvas.this.getPositionX();
                        if (curX != -1 && curX > maxX) {
                            IcyCanvas.this.setPositionX(maxX);
                        }
                        int maxY = IcyCanvas.this.getMaxPositionY();
                        int curY = IcyCanvas.this.getPositionY();
                        if (curY != -1 && curY > maxY) {
                            IcyCanvas.this.setPositionY(maxY);
                        }
                        int maxC = IcyCanvas.this.getMaxPositionC();
                        int curC = IcyCanvas.this.getPositionC();
                        if (curC != -1 && curC > maxC) {
                            IcyCanvas.this.setPositionC(maxC);
                        }
                        int maxZ = IcyCanvas.this.getMaxPositionZ();
                        int curZ = IcyCanvas.this.getPositionZ();
                        if (curZ != -1 && curZ > maxZ) {
                            IcyCanvas.this.setPositionZ(maxZ);
                        }
                        int maxT = IcyCanvas.this.getMaxPositionT();
                        int curT = IcyCanvas.this.getPositionT();
                        if (curT != -1 && curT > maxT) {
                            IcyCanvas.this.setPositionT(maxT);
                        }
                        IcyCanvas.this.mouseInfPanel.updateInfos(IcyCanvas.this);
                    }
                });
            }
        };
        this.imageOverlay = this.createImageOverlay();
        this.beginUpdate();
        try {
            this.imageLayer = this.addLayer(this.getImageOverlay());
            Sequence sequence = this.getSequence();
            if (sequence != null) {
                for (Overlay overlay : sequence.getOverlays()) {
                    this.addLayer(overlay);
                }
            } else {
                System.err.println("Sequence null when canvas created");
            }
        }
        finally {
            this.endUpdate();
        }
        viewer.addListener(this);
        Sequence seq = this.getSequence();
        if (seq != null) {
            seq.addListener(this);
        }
        this.lut = null;
        this.setLut(viewer.getLut(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Sequence seq;
        this.zNav.removeAllChangeListener();
        this.tNav.removeAllChangeListener();
        if (this.lut != null) {
            this.lut.removeListener(this);
        }
        if ((seq = this.getSequence()) != null) {
            seq.removeListener(this);
        }
        this.viewer.removeListener(this);
        this.beginUpdate();
        try {
            for (Layer layer : this.getLayers()) {
                this.removeLayer(layer);
            }
        }
        finally {
            this.endUpdate();
        }
        List<EventListener> list = this.orderedLayers;
        synchronized (list) {
            this.orderedLayers.clear();
        }
        list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
        list = this.layerListeners;
        synchronized (list) {
            this.layerListeners.clear();
        }
    }

    public abstract void refresh();

    protected Overlay createImageOverlay() {
        return new IcyCanvasImageOverlay();
    }

    public Overlay getImageOverlay() {
        return this.imageOverlay;
    }

    public Layer getImageLayer() {
        return this.imageLayer;
    }

    @Deprecated
    public boolean getDrawLayers() {
        return this.isLayersVisible();
    }

    @Deprecated
    public void setDrawLayers(boolean value) {
        this.setLayersVisible(value);
    }

    public boolean isLayersVisible() {
        return this.layersVisible;
    }

    public boolean isLoopingInT() {
        return this.isLoopingT;
    }

    public void setLayersVisible(boolean value) {
        if (this.layersVisible != value) {
            this.layersVisible = value;
            this.layersVisibleChanged();
            this.firePropertyChange(PROPERTY_LAYERS_VISIBLE, !value, value);
        }
    }

    protected void layersVisibleChanged() {
        Component comp = this.getViewComponent();
        if (comp != null) {
            comp.repaint();
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public Sequence getSequence() {
        return this.viewer.getSequence();
    }

    public abstract Component getViewComponent();

    public ZNavigationPanel getZNavigationPanel() {
        return this.zNav;
    }

    public TNavigationPanel getTNavigationPanel() {
        return this.tNav;
    }

    public MouseImageInfosPanel getMouseImageInfosPanel() {
        return this.mouseInfPanel;
    }

    public LUT getLut() {
        this.setLut(this.viewer.getLut(), true);
        return this.lut;
    }

    private void setLut(LUT lut, boolean event) {
        if (this.lut != lut) {
            if (this.lut != null) {
                this.lut.removeListener(this);
            }
            this.lut = lut;
            if (lut != null) {
                lut.addListener(this);
            }
            if (event) {
                this.lutChanged(new LUTEvent(lut, -1, LUTEvent.LUTEventType.COLORMAP_CHANGED));
            }
        }
    }

    @Deprecated
    public void addViewerToolbarComponents(JToolBar toolBar) {
    }

    public void customizeToolbar(JToolBar toolBar) {
        this.addViewerToolbarComponents(toolBar);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Layer> getLayers(boolean sorted) {
        if (sorted) {
            if (this.orderedLayersOutdated) {
                Map<Overlay, Layer> map = this.layers;
                synchronized (map) {
                    this.orderedLayers = new ArrayList<Layer>(this.layers.values());
                }
                try {
                    Collections.sort(this.orderedLayers);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.orderedLayersOutdated = false;
            }
            return new ArrayList<Layer>(this.orderedLayers);
        }
        Map<Overlay, Layer> map = this.layers;
        synchronized (map) {
            return new ArrayList<Layer>(this.layers.values());
        }
    }

    public List<Layer> getLayers() {
        return this.getLayers(true);
    }

    public List<Layer> getVisibleLayers(boolean sorted) {
        List<Layer> olayers = this.getLayers(sorted);
        ArrayList<Layer> result = new ArrayList<Layer>(olayers.size());
        for (Layer l : olayers) {
            if (!l.isVisible()) continue;
            result.add(l);
        }
        return result;
    }

    public ArrayList<Layer> getVisibleLayers() {
        return (ArrayList)this.getVisibleLayers(true);
    }

    @Deprecated
    public List<Layer> getOrderedLayersForEvent() {
        return this.getLayers();
    }

    @Deprecated
    public List<Layer> getVisibleOrderedLayersForEvent() {
        return this.getVisibleLayers();
    }

    @Deprecated
    public List<Painter> getLayersPainter() {
        ArrayList<Painter> result = new ArrayList<Painter>();
        for (Overlay overlay : this.getOverlays()) {
            if (overlay instanceof OverlayWrapper) {
                result.add(((OverlayWrapper)overlay).getPainter());
                continue;
            }
            result.add(overlay);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Overlay> getOverlays() {
        Map<Overlay, Layer> map = this.layers;
        synchronized (map) {
            return new HashSet<Overlay>(this.layers.keySet());
        }
    }

    public int getSyncId() {
        return this.syncId;
    }

    public boolean setSyncId(int id) {
        if (!this.isSynchronizationSupported()) {
            return false;
        }
        if (this.syncId != id) {
            this.syncId = id;
            this.updater.changed(new IcyCanvasEvent(this, IcyCanvasEvent.IcyCanvasEventType.SYNC_CHANGED));
        }
        return true;
    }

    public boolean isSynchronizationSupported() {
        return false;
    }

    public boolean isSynchronized() {
        return this.syncId > 0;
    }

    public boolean isSynchMaster() {
        return this.synchMaster;
    }

    @Deprecated
    public boolean isSynchHeader() {
        return this.isSynchMaster();
    }

    public boolean isSynchSlave() {
        if (this.isSynchronized()) {
            if (this.isSynchMaster()) {
                return false;
            }
            for (IcyCanvas cnv : this.getSynchronizedCanvas()) {
                if (!cnv.isSynchMaster()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSynchOnView() {
        return this.syncId == 1 || this.syncId == 2 || this.syncId == 3;
    }

    public boolean isSynchOnSlice() {
        return this.syncId == 1 || this.syncId == 2 || this.syncId == 4;
    }

    public boolean isSynchOnCursor() {
        return this.syncId > 0;
    }

    protected boolean getSynchMaster() {
        return this.getSynchMaster(this.getSynchronizedCanvas());
    }

    @Deprecated
    protected boolean getSynchHeader() {
        return this.getSynchMaster();
    }

    protected boolean getSynchMaster(List<IcyCanvas> canvasList) {
        for (IcyCanvas canvas : canvasList) {
            if (!canvas.isSynchMaster()) continue;
            return canvas == this;
        }
        this.synchMaster = true;
        return true;
    }

    @Deprecated
    protected boolean getSynchHeader(List<IcyCanvas> canvasList) {
        return this.getSynchMaster(canvasList);
    }

    protected void releaseSynchMaster() {
        this.synchMaster = false;
    }

    @Deprecated
    protected void releaseSynchHeader() {
        this.releaseSynchMaster();
    }

    private List<IcyCanvas> getSynchronizedCanvas() {
        ArrayList<IcyCanvas> result = new ArrayList<IcyCanvas>();
        if (this.isSynchronized()) {
            ArrayList<Viewer> viewers = Icy.getMainInterface().getViewers();
            for (int i = viewers.size() - 1; i >= 0; --i) {
                IcyCanvas cnv = ((Viewer)viewers.get(i)).getCanvas();
                if (cnv != this && cnv.getSyncId() == this.syncId) continue;
                viewers.remove(i);
            }
            for (Viewer v : viewers) {
                IcyCanvas cnv = v.getCanvas();
                if (!cnv.getClass().isInstance(this)) continue;
                result.add(cnv);
            }
        }
        return result;
    }

    protected void synchronizeCanvas(List<IcyCanvas> canvasList, IcyCanvasEvent event, boolean processAll) {
        block29: {
            IcyCanvasEvent.IcyCanvasEventType type = event.getType();
            DimensionId dim = event.getDim();
            if (this.isSynchOnSlice() && (processAll || type == IcyCanvasEvent.IcyCanvasEventType.POSITION_CHANGED)) {
                if (processAll || dim == DimensionId.NULL) {
                    int x = this.getPositionX();
                    int y = this.getPositionY();
                    int z = this.getPositionZ();
                    int t = this.getPositionT();
                    int c = this.getPositionC();
                    for (IcyCanvas cnv : canvasList) {
                        if (x != -1) {
                            cnv.setPositionX(x);
                        }
                        if (y != -1) {
                            cnv.setPositionY(y);
                        }
                        if (z != -1) {
                            cnv.setPositionZ(z);
                        }
                        if (t != -1) {
                            cnv.setPositionT(t);
                        }
                        if (c == -1) continue;
                        cnv.setPositionC(c);
                    }
                } else {
                    for (IcyCanvas cnv : canvasList) {
                        int pos = this.getPosition(dim);
                        if (pos == -1) continue;
                        cnv.setPosition(dim, pos);
                    }
                }
            }
            if (this.isSynchOnView()) {
                if (processAll || type == IcyCanvasEvent.IcyCanvasEventType.SCALE_CHANGED) {
                    if (processAll || dim == DimensionId.NULL) {
                        double sX = this.getScaleX();
                        double sY = this.getScaleY();
                        double sZ = this.getScaleZ();
                        double sT = this.getScaleT();
                        double sC = this.getScaleC();
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setScaleX(sX);
                            cnv.setScaleY(sY);
                            cnv.setScaleZ(sZ);
                            cnv.setScaleT(sT);
                            cnv.setScaleC(sC);
                        }
                    } else {
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setScale(dim, this.getScale(dim));
                        }
                    }
                }
                if (processAll || type == IcyCanvasEvent.IcyCanvasEventType.ROTATION_CHANGED) {
                    if (processAll || dim == DimensionId.NULL) {
                        double rotX = this.getRotationX();
                        double rotY = this.getRotationY();
                        double rotZ = this.getRotationZ();
                        double rotT = this.getRotationT();
                        double rotC = this.getRotationC();
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setRotationX(rotX);
                            cnv.setRotationY(rotY);
                            cnv.setRotationZ(rotZ);
                            cnv.setRotationT(rotT);
                            cnv.setRotationC(rotC);
                        }
                    } else {
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setRotation(dim, this.getRotation(dim));
                        }
                    }
                }
                if (processAll || type == IcyCanvasEvent.IcyCanvasEventType.OFFSET_CHANGED) {
                    if (processAll || dim == DimensionId.NULL) {
                        int offX = this.getOffsetX();
                        int offY = this.getOffsetY();
                        int offZ = this.getOffsetZ();
                        int offT = this.getOffsetT();
                        int offC = this.getOffsetC();
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setOffsetX(offX);
                            cnv.setOffsetY(offY);
                            cnv.setOffsetZ(offZ);
                            cnv.setOffsetT(offT);
                            cnv.setOffsetC(offC);
                        }
                    } else {
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setOffset(dim, this.getOffset(dim));
                        }
                    }
                }
            }
            if (!this.isSynchOnCursor() || !processAll && type != IcyCanvasEvent.IcyCanvasEventType.MOUSE_IMAGE_POSITION_CHANGED) break block29;
            if (processAll || dim == DimensionId.NULL) {
                double mipX = this.getMouseImagePosX();
                double mipY = this.getMouseImagePosY();
                double mipZ = this.getMouseImagePosZ();
                double mipT = this.getMouseImagePosT();
                double mipC = this.getMouseImagePosC();
                for (IcyCanvas cnv : canvasList) {
                    cnv.setMouseImagePosX(mipX);
                    cnv.setMouseImagePosY(mipY);
                    cnv.setMouseImagePosZ(mipZ);
                    cnv.setMouseImagePosT(mipT);
                    cnv.setMouseImagePosC(mipC);
                }
            } else {
                for (IcyCanvas cnv : canvasList) {
                    cnv.setMouseImagePos(dim, this.getMouseImagePos(dim));
                }
            }
        }
    }

    public int getPosition(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getPositionX();
            }
            case Y: {
                return this.getPositionY();
            }
            case Z: {
                return this.getPositionZ();
            }
            case T: {
                return this.getPositionT();
            }
            case C: {
                return this.getPositionC();
            }
        }
        return 0;
    }

    public int getPositionX() {
        return -1;
    }

    public int getPositionY() {
        return -1;
    }

    public int getPositionZ() {
        return this.posZ;
    }

    public int getPositionT() {
        return this.posT;
    }

    public int getPositionC() {
        return this.posC;
    }

    public Point5D.Integer getPosition5D() {
        return new Point5D.Integer(this.getPositionX(), this.getPositionY(), this.getPositionZ(), this.getPositionT(), this.getPositionC());
    }

    @Deprecated
    public int getZ() {
        return this.getPositionZ();
    }

    @Deprecated
    public int getT() {
        return this.getPositionT();
    }

    @Deprecated
    public int getC() {
        return this.getPositionC();
    }

    public double getMaxPosition(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getMaxPositionX();
            }
            case Y: {
                return this.getMaxPositionY();
            }
            case Z: {
                return this.getMaxPositionZ();
            }
            case T: {
                return this.getMaxPositionT();
            }
            case C: {
                return this.getMaxPositionC();
            }
        }
        return 0.0;
    }

    public int getMaxPositionX() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            return 0;
        }
        return Math.max(0, this.getImageSizeX() - 1);
    }

    public int getMaxPositionY() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            return 0;
        }
        return Math.max(0, this.getImageSizeY() - 1);
    }

    public int getMaxPositionZ() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            return 0;
        }
        return Math.max(0, this.getImageSizeZ() - 1);
    }

    public int getMaxPositionT() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            return 0;
        }
        return Math.max(0, this.getImageSizeT() - 1);
    }

    public int getMaxPositionC() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            return 0;
        }
        return Math.max(0, this.getImageSizeC() - 1);
    }

    public Point5D.Integer getMaxPosition5D() {
        return new Point5D.Integer(this.getMaxPositionX(), this.getMaxPositionY(), this.getMaxPositionZ(), this.getMaxPositionT(), this.getMaxPositionC());
    }

    @Deprecated
    public double getMax(DimensionId dim) {
        return this.getMaxPosition(dim);
    }

    @Deprecated
    public int getMaxX() {
        return this.getMaxPositionX();
    }

    @Deprecated
    public int getMaxY() {
        return this.getMaxPositionY();
    }

    @Deprecated
    public int getMaxZ() {
        return this.getMaxPositionZ();
    }

    @Deprecated
    public int getMaxT() {
        return this.getMaxPositionT();
    }

    @Deprecated
    public int getMaxC() {
        return this.getMaxPositionC();
    }

    public int getCanvasSize(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getCanvasSizeX();
            }
            case Y: {
                return this.getCanvasSizeY();
            }
            case Z: {
                return this.getCanvasSizeZ();
            }
            case T: {
                return this.getCanvasSizeT();
            }
            case C: {
                return this.getCanvasSizeC();
            }
        }
        return -1;
    }

    public int getCanvasSizeX() {
        Component comp = this.getViewComponent();
        int res = 0;
        if (comp != null && (res = comp.getWidth()) == 0) {
            res = comp.getPreferredSize().width;
        }
        return res;
    }

    public int getCanvasSizeY() {
        Component comp = this.getViewComponent();
        int res = 0;
        if (comp != null && (res = comp.getHeight()) == 0) {
            res = comp.getPreferredSize().height;
        }
        return res;
    }

    public int getCanvasSizeZ() {
        return 1;
    }

    public int getCanvasSizeT() {
        return 1;
    }

    public int getCanvasSizeC() {
        return 1;
    }

    public Point getMousePos() {
        return (Point)this.mousePos.clone();
    }

    public double getMouseImagePos(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getMouseImagePosX();
            }
            case Y: {
                return this.getMouseImagePosY();
            }
            case Z: {
                return this.getMouseImagePosZ();
            }
            case T: {
                return this.getMouseImagePosT();
            }
            case C: {
                return this.getMouseImagePosC();
            }
        }
        return 0.0;
    }

    public double getMouseImagePosX() {
        return this.getPositionX();
    }

    public double getMouseImagePosY() {
        return this.getPositionY();
    }

    public double getMouseImagePosZ() {
        return this.getPositionZ();
    }

    public double getMouseImagePosT() {
        return this.getPositionT();
    }

    public double getMouseImagePosC() {
        return this.getPositionC();
    }

    public Point5D.Double getMouseImagePos5D() {
        return new Point5D.Double(this.getMouseImagePosX(), this.getMouseImagePosY(), this.getMouseImagePosZ(), this.getMouseImagePosT(), this.getMouseImagePosC());
    }

    public int getOffset(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getOffsetX();
            }
            case Y: {
                return this.getOffsetY();
            }
            case Z: {
                return this.getOffsetZ();
            }
            case T: {
                return this.getOffsetT();
            }
            case C: {
                return this.getOffsetC();
            }
        }
        return 0;
    }

    public int getOffsetX() {
        return 0;
    }

    public int getOffsetY() {
        return 0;
    }

    public int getOffsetZ() {
        return 0;
    }

    public int getOffsetT() {
        return 0;
    }

    public int getOffsetC() {
        return 0;
    }

    public Point5D.Integer getOffset5D() {
        return new Point5D.Integer(this.getOffsetX(), this.getOffsetY(), this.getOffsetZ(), this.getOffsetT(), this.getOffsetC());
    }

    @Deprecated
    public int getImageOffsetX() {
        return 0;
    }

    @Deprecated
    public int getImageOffsetY() {
        return 0;
    }

    @Deprecated
    public int getImageOffsetZ() {
        return 0;
    }

    @Deprecated
    public int getImageOffsetT() {
        return 0;
    }

    @Deprecated
    public int getImageOffsetC() {
        return 0;
    }

    @Deprecated
    public int getCanvasOffsetX() {
        return 0;
    }

    @Deprecated
    public int getCanvasOffsetY() {
        return 0;
    }

    @Deprecated
    public int getCanvasOffsetZ() {
        return 0;
    }

    @Deprecated
    public int getCanvasOffsetT() {
        return 0;
    }

    @Deprecated
    public int getCanvasOffsetC() {
        return 0;
    }

    @Deprecated
    public double getScaleFactorX() {
        return this.getScaleX();
    }

    @Deprecated
    public double getScaleFactorY() {
        return this.getScaleY();
    }

    @Deprecated
    public double getScaleFactorZ() {
        return this.getScaleZ();
    }

    @Deprecated
    public double getScaleFactorT() {
        return this.getScaleT();
    }

    @Deprecated
    public double getScaleFactorC() {
        return this.getScaleC();
    }

    public double getScale(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getScaleX();
            }
            case Y: {
                return this.getScaleY();
            }
            case Z: {
                return this.getScaleZ();
            }
            case T: {
                return this.getScaleT();
            }
            case C: {
                return this.getScaleC();
            }
        }
        return 1.0;
    }

    public double getScaleX() {
        return 1.0;
    }

    public double getScaleY() {
        return 1.0;
    }

    public double getScaleZ() {
        return 1.0;
    }

    public double getScaleT() {
        return 1.0;
    }

    public double getScaleC() {
        return 1.0;
    }

    public double getRotation(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getRotationX();
            }
            case Y: {
                return this.getRotationY();
            }
            case Z: {
                return this.getRotationZ();
            }
            case T: {
                return this.getRotationT();
            }
            case C: {
                return this.getRotationC();
            }
        }
        return 1.0;
    }

    public double getRotationX() {
        return 0.0;
    }

    public double getRotationY() {
        return 0.0;
    }

    public double getRotationZ() {
        return 0.0;
    }

    public double getRotationT() {
        return 0.0;
    }

    public double getRotationC() {
        return 0.0;
    }

    public int getImageSize(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getImageSizeX();
            }
            case Y: {
                return this.getImageSizeY();
            }
            case Z: {
                return this.getImageSizeZ();
            }
            case T: {
                return this.getImageSizeT();
            }
            case C: {
                return this.getImageSizeC();
            }
        }
        return 0;
    }

    public int getImageSizeX() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return seq.getSizeX();
        }
        return 0;
    }

    public int getImageSizeY() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return seq.getSizeY();
        }
        return 0;
    }

    public int getImageSizeZ() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return seq.getSizeZ();
        }
        return 0;
    }

    public int getImageSizeT() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return seq.getSizeT();
        }
        return 0;
    }

    public int getImageSizeC() {
        Sequence seq = this.getSequence();
        if (seq != null) {
            return seq.getSizeC();
        }
        return 0;
    }

    @Deprecated
    public int getImageCanvasSize(DimensionId dim) {
        switch (dim) {
            case X: {
                return this.getImageCanvasSizeX();
            }
            case Y: {
                return this.getImageCanvasSizeY();
            }
            case Z: {
                return this.getImageCanvasSizeZ();
            }
            case T: {
                return this.getImageCanvasSizeT();
            }
            case C: {
                return this.getImageCanvasSizeC();
            }
        }
        return 0;
    }

    @Deprecated
    public int getImageCanvasSizeX() {
        return this.imageToCanvasDeltaX(this.getImageSizeX());
    }

    @Deprecated
    public int getImageCanvasSizeY() {
        return this.imageToCanvasDeltaY(this.getImageSizeY());
    }

    @Deprecated
    public int getImageCanvasSizeZ() {
        return this.imageToCanvasDeltaZ(this.getImageSizeZ());
    }

    @Deprecated
    public int getImageCanvasSizeT() {
        return this.imageToCanvasDeltaT(this.getImageSizeT());
    }

    @Deprecated
    public int getImageCanvasSizeC() {
        return this.imageToCanvasDeltaC(this.getImageSizeC());
    }

    public void setPosition(DimensionId dim, int value) {
        switch (dim) {
            case X: {
                this.setPositionX(value);
                break;
            }
            case Y: {
                this.setPositionY(value);
                break;
            }
            case Z: {
                this.setPositionZ(value);
                break;
            }
            case T: {
                this.setPositionT(value);
                break;
            }
            case C: {
                this.setPositionC(value);
            }
        }
    }

    @Deprecated
    public void setZ(int z) {
        this.setPositionZ(z);
    }

    @Deprecated
    public void setT(int t) {
        this.setPositionT(t);
    }

    @Deprecated
    public void setC(int c) {
        this.setPositionC(c);
    }

    public void setPositionX(int x) {
        int adjX = Math.max(-1, Math.min(x, this.getMaxPositionX()));
        if (this.getPositionX() != adjX) {
            this.setPositionXInternal(adjX);
        }
    }

    public void setPositionY(int y) {
        int adjY = Math.max(-1, Math.min(y, this.getMaxPositionY()));
        if (this.getPositionY() != adjY) {
            this.setPositionYInternal(adjY);
        }
    }

    public void setPositionZ(int z) {
        int adjZ = Math.max(-1, Math.min(z, this.getMaxPositionZ()));
        if (this.getPositionZ() != adjZ) {
            this.setPositionZInternal(adjZ);
        }
    }

    public void setPositionT(int t) {
        int adjT = Math.max(-1, Math.min(t, this.getMaxPositionT()));
        if (this.getPositionT() != adjT) {
            this.setPositionTInternal(adjT);
        }
    }

    public void setPositionC(int c) {
        int adjC = Math.max(-1, Math.min(c, this.getMaxPositionC()));
        if (this.getPositionC() != adjC) {
            this.setPositionCInternal(adjC);
        }
    }

    protected void setPositionXInternal(int x) {
        this.posX = x;
        this.positionChanged(DimensionId.X);
    }

    protected void setPositionYInternal(int y) {
        this.posY = y;
        this.positionChanged(DimensionId.Y);
    }

    protected void setPositionZInternal(int z) {
        this.posZ = z;
        this.positionChanged(DimensionId.Z);
    }

    protected void setPositionTInternal(int t) {
        this.posT = t;
        this.positionChanged(DimensionId.T);
    }

    protected void setPositionCInternal(int c) {
        this.posC = c;
        this.positionChanged(DimensionId.C);
    }

    public boolean setMousePos(int x, int y) {
        if (this.mousePos.x != x || this.mousePos.y != y) {
            this.mousePos.x = x;
            this.mousePos.y = y;
            return true;
        }
        return false;
    }

    public void setMousePos(Point point) {
        this.setMousePos(point.x, point.y);
    }

    public void setMouseImagePos(DimensionId dim, double value) {
        switch (dim) {
            case X: {
                this.setMouseImagePosX(value);
                break;
            }
            case Y: {
                this.setMouseImagePosY(value);
                break;
            }
            case Z: {
                this.setMouseImagePosZ(value);
                break;
            }
            case T: {
                this.setMouseImagePosT(value);
                break;
            }
            case C: {
                this.setMouseImagePosC(value);
            }
        }
    }

    public void setMouseImagePosX(double value) {
        if (this.getMouseImagePosX() != value) {
            this.setMouseImagePosXInternal(value);
        }
    }

    public void setMouseImagePosY(double value) {
        if (this.getMouseImagePosY() != value) {
            this.setMouseImagePosYInternal(value);
        }
    }

    public void setMouseImagePosZ(double value) {
        if (this.getMouseImagePosZ() != value) {
            this.setMouseImagePosZInternal(value);
        }
    }

    public void setMouseImagePosT(double value) {
        if (this.getMouseImagePosT() != value) {
            this.setMouseImagePosTInternal(value);
        }
    }

    public void setMouseImagePosC(double value) {
        if (this.getMouseImagePosC() != value) {
            this.setMouseImagePosCInternal(value);
        }
    }

    protected void setMouseImagePosXInternal(double value) {
        this.mouseImagePositionChanged(DimensionId.X);
    }

    protected void setMouseImagePosYInternal(double value) {
        this.mouseImagePositionChanged(DimensionId.Y);
    }

    protected void setMouseImagePosZInternal(double value) {
        this.mouseImagePositionChanged(DimensionId.Z);
    }

    protected void setMouseImagePosTInternal(double value) {
        this.mouseImagePositionChanged(DimensionId.T);
    }

    protected void setMouseImagePosCInternal(double value) {
        this.mouseImagePositionChanged(DimensionId.C);
    }

    public void setOffset(DimensionId dim, int value) {
        switch (dim) {
            case X: {
                this.setOffsetX(value);
                break;
            }
            case Y: {
                this.setOffsetY(value);
                break;
            }
            case Z: {
                this.setOffsetZ(value);
                break;
            }
            case T: {
                this.setOffsetT(value);
                break;
            }
            case C: {
                this.setOffsetC(value);
            }
        }
    }

    public void setOffsetX(int value) {
        if (this.getOffsetX() != value) {
            this.setOffsetXInternal(value);
        }
    }

    public void setOffsetY(int value) {
        if (this.getOffsetY() != value) {
            this.setOffsetYInternal(value);
        }
    }

    public void setOffsetZ(int value) {
        if (this.getOffsetZ() != value) {
            this.setOffsetZInternal(value);
        }
    }

    public void setOffsetT(int value) {
        if (this.getOffsetT() != value) {
            this.setOffsetTInternal(value);
        }
    }

    public void setOffsetC(int value) {
        if (this.getOffsetC() != value) {
            this.setOffsetCInternal(value);
        }
    }

    protected void setOffsetXInternal(int value) {
        this.offsetChanged(DimensionId.X);
    }

    protected void setOffsetYInternal(int value) {
        this.offsetChanged(DimensionId.Y);
    }

    protected void setOffsetZInternal(int value) {
        this.offsetChanged(DimensionId.Z);
    }

    protected void setOffsetTInternal(int value) {
        this.offsetChanged(DimensionId.T);
    }

    protected void setOffsetCInternal(int value) {
        this.offsetChanged(DimensionId.C);
    }

    public void setScale(DimensionId dim, double value) {
        switch (dim) {
            case X: {
                this.setScaleX(value);
                break;
            }
            case Y: {
                this.setScaleY(value);
                break;
            }
            case Z: {
                this.setScaleZ(value);
                break;
            }
            case T: {
                this.setScaleT(value);
                break;
            }
            case C: {
                this.setScaleC(value);
            }
        }
    }

    public void setScaleX(double value) {
        if (this.getScaleX() != value) {
            this.setScaleXInternal(value);
        }
    }

    public void setScaleY(double value) {
        if (this.getScaleY() != value) {
            this.setScaleYInternal(value);
        }
    }

    public void setScaleZ(double value) {
        if (this.getScaleZ() != value) {
            this.setScaleZInternal(value);
        }
    }

    public void setScaleT(double value) {
        if (this.getScaleT() != value) {
            this.setScaleTInternal(value);
        }
    }

    public void setScaleC(double value) {
        if (this.getScaleC() != value) {
            this.setScaleCInternal(value);
        }
    }

    protected void setScaleXInternal(double value) {
        this.scaleChanged(DimensionId.X);
    }

    protected void setScaleYInternal(double value) {
        this.scaleChanged(DimensionId.Y);
    }

    protected void setScaleZInternal(double value) {
        this.scaleChanged(DimensionId.Z);
    }

    protected void setScaleTInternal(double value) {
        this.scaleChanged(DimensionId.T);
    }

    protected void setScaleCInternal(double value) {
        this.scaleChanged(DimensionId.C);
    }

    public void setRotation(DimensionId dim, double value) {
        switch (dim) {
            case X: {
                this.setRotationX(value);
                break;
            }
            case Y: {
                this.setRotationY(value);
                break;
            }
            case Z: {
                this.setRotationZ(value);
                break;
            }
            case T: {
                this.setRotationT(value);
                break;
            }
            case C: {
                this.setRotationC(value);
            }
        }
    }

    public void setRotationX(double value) {
        if (this.getRotationX() != value) {
            this.setRotationXInternal(value);
        }
    }

    public void setRotationY(double value) {
        if (this.getRotationY() != value) {
            this.setRotationYInternal(value);
        }
    }

    public void setRotationZ(double value) {
        if (this.getRotationZ() != value) {
            this.setRotationZInternal(value);
        }
    }

    public void setRotationT(double value) {
        if (this.getRotationT() != value) {
            this.setRotationTInternal(value);
        }
    }

    public void setRotationC(double value) {
        if (this.getRotationC() != value) {
            this.setRotationCInternal(value);
        }
    }

    protected void setRotationXInternal(double value) {
        this.rotationChanged(DimensionId.X);
    }

    protected void setRotationYInternal(double value) {
        this.rotationChanged(DimensionId.Y);
    }

    protected void setRotationZInternal(double value) {
        this.rotationChanged(DimensionId.Z);
    }

    protected void setRotationTInternal(double value) {
        this.rotationChanged(DimensionId.T);
    }

    protected void setRotationCInternal(double value) {
        this.rotationChanged(DimensionId.C);
    }

    public void mouseImagePositionChanged(DimensionId dim) {
        this.updater.changed(new IcyCanvasEvent(this, IcyCanvasEvent.IcyCanvasEventType.MOUSE_IMAGE_POSITION_CHANGED, dim));
    }

    public void offsetChanged(DimensionId dim) {
        this.updater.changed(new IcyCanvasEvent(this, IcyCanvasEvent.IcyCanvasEventType.OFFSET_CHANGED, dim));
    }

    public void scaleChanged(DimensionId dim) {
        this.updater.changed(new IcyCanvasEvent(this, IcyCanvasEvent.IcyCanvasEventType.SCALE_CHANGED, dim));
    }

    public void rotationChanged(DimensionId dim) {
        this.updater.changed(new IcyCanvasEvent(this, IcyCanvasEvent.IcyCanvasEventType.ROTATION_CHANGED, dim));
    }

    public double canvasToImageDeltaX(int value) {
        return (double)value / this.getScaleX();
    }

    public double canvasToImageDeltaY(int value) {
        return (double)value / this.getScaleY();
    }

    public double canvasToImageDeltaZ(int value) {
        return (double)value / this.getScaleZ();
    }

    public double canvasToImageDeltaT(int value) {
        return (double)value / this.getScaleT();
    }

    public double canvasToImageDeltaC(int value) {
        return (double)value / this.getScaleC();
    }

    public double canvasToImageLogDeltaX(int value, double logFactor) {
        double scaleFactor = this.getScaleX();
        return (double)value / (scaleFactor / Math.pow(10.0, Math.log10(scaleFactor) / logFactor));
    }

    public double canvasToImageLogDeltaX(int value) {
        return this.canvasToImageLogDeltaX(value, 5.0);
    }

    public double canvasToImageLogDeltaY(int value, double logFactor) {
        double scaleFactor = this.getScaleY();
        return (double)value / (scaleFactor / Math.pow(10.0, Math.log10(scaleFactor) / logFactor));
    }

    public double canvasToImageLogDeltaY(int value) {
        return this.canvasToImageLogDeltaY(value, 5.0);
    }

    public double canvasToImageLogDeltaZ(int value, double logFactor) {
        double scaleFactor = this.getScaleZ();
        return (double)value / (scaleFactor / Math.pow(10.0, Math.log10(scaleFactor) / logFactor));
    }

    public double canvasToImageLogDeltaZ(int value) {
        return this.canvasToImageLogDeltaZ(value, 5.0);
    }

    @Deprecated
    public double canvasToImageX(int value) {
        return this.canvasToImageDeltaX(value - this.getOffsetX());
    }

    @Deprecated
    public double canvasToImageY(int value) {
        return this.canvasToImageDeltaY(value - this.getOffsetY());
    }

    @Deprecated
    public double canvasToImageZ(int value) {
        return this.canvasToImageDeltaZ(value - this.getOffsetZ());
    }

    @Deprecated
    public double canvasToImageT(int value) {
        return this.canvasToImageDeltaT(value - this.getOffsetT());
    }

    @Deprecated
    public double canvasToImageC(int value) {
        return this.canvasToImageDeltaC(value - this.getOffsetC());
    }

    public int imageToCanvasDeltaX(double value) {
        return (int)(value * this.getScaleX());
    }

    public int imageToCanvasDeltaY(double value) {
        return (int)(value * this.getScaleY());
    }

    public int imageToCanvasDeltaZ(double value) {
        return (int)(value * this.getScaleZ());
    }

    public int imageToCanvasDeltaT(double value) {
        return (int)(value * this.getScaleT());
    }

    public int imageToCanvasDeltaC(double value) {
        return (int)(value * this.getScaleC());
    }

    @Deprecated
    public int imageToCanvasX(double value) {
        return this.imageToCanvasDeltaX(value) + this.getOffsetX();
    }

    @Deprecated
    public int imageToCanvasY(double value) {
        return this.imageToCanvasDeltaY(value) + this.getOffsetY();
    }

    @Deprecated
    public int imageToCanvasZ(double value) {
        return this.imageToCanvasDeltaZ(value) + this.getOffsetZ();
    }

    @Deprecated
    public int imageToCanvasT(double value) {
        return this.imageToCanvasDeltaT(value) + this.getOffsetT();
    }

    @Deprecated
    public int imageToCanvasC(double value) {
        return this.imageToCanvasDeltaC(value) + this.getOffsetC();
    }

    public void mousePressed(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mousePressed(event, pt, this);
        }
    }

    public void mousePressed(MouseEvent event) {
        this.mousePressed(event, this.getMouseImagePos5D());
    }

    public void mouseReleased(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseReleased(event, pt, this);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.mouseReleased(event, this.getMouseImagePos5D());
    }

    public void mouseClick(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseClick(event, pt, this);
        }
    }

    public void mouseClick(MouseEvent event) {
        this.mouseClick(event, this.getMouseImagePos5D());
    }

    public void mouseMove(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseMove(event, pt, this);
        }
    }

    public void mouseMove(MouseEvent event) {
        this.mouseMove(event, this.getMouseImagePos5D());
    }

    public void mouseDrag(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseDrag(event, pt, this);
        }
    }

    public void mouseDrag(MouseEvent event) {
        this.mouseDrag(event, this.getMouseImagePos5D());
    }

    public void mouseEntered(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseEntered(event, pt, this);
        }
    }

    public void mouseEntered(MouseEvent event) {
        this.mouseEntered(event, this.getMouseImagePos5D());
    }

    public void mouseExited(MouseEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseExited(event, pt, this);
        }
    }

    public void mouseExited(MouseEvent event) {
        this.mouseExited(event, this.getMouseImagePos5D());
    }

    public void mouseWheelMoved(MouseWheelEvent event, Point5D.Double pt) {
        boolean globalVisible = this.isLayersVisible();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveMouseEventOnHidden()) continue;
            layer.getOverlay().mouseWheelMoved(event, pt, this);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        this.mouseWheelMoved(event, this.getMouseImagePos5D());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean globalVisible = this.isLayersVisible();
        Point5D.Double pt = this.getMouseImagePos5D();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveKeyEventOnHidden()) continue;
            layer.getOverlay().keyPressed(e, pt, this);
        }
        if (!e.isConsumed()) {
            switch (e.getKeyCode()) {
                case 48: {
                    if (EventUtil.isShiftDown(e, true)) {
                        if (!CanvasActions.globalDisableSyncAction.isEnabled()) break;
                        CanvasActions.globalDisableSyncAction.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isNoModifier(e) || !CanvasActions.disableSyncAction.isEnabled()) break;
                    CanvasActions.disableSyncAction.execute();
                    e.consume();
                    break;
                }
                case 49: {
                    if (EventUtil.isShiftDown(e, true)) {
                        if (!CanvasActions.globalSyncGroup1Action.isEnabled()) break;
                        CanvasActions.globalSyncGroup1Action.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isNoModifier(e) || !CanvasActions.syncGroup1Action.isEnabled()) break;
                    CanvasActions.syncGroup1Action.execute();
                    e.consume();
                    break;
                }
                case 50: {
                    if (EventUtil.isShiftDown(e, true)) {
                        if (!CanvasActions.globalSyncGroup2Action.isEnabled()) break;
                        CanvasActions.globalSyncGroup2Action.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isNoModifier(e) || !CanvasActions.syncGroup2Action.isEnabled()) break;
                    CanvasActions.syncGroup2Action.execute();
                    e.consume();
                    break;
                }
                case 51: {
                    if (EventUtil.isShiftDown(e, true)) {
                        if (!CanvasActions.globalSyncGroup3Action.isEnabled()) break;
                        CanvasActions.globalSyncGroup3Action.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isNoModifier(e) || !CanvasActions.syncGroup3Action.isEnabled()) break;
                    CanvasActions.syncGroup3Action.execute();
                    e.consume();
                    break;
                }
                case 52: {
                    if (EventUtil.isShiftDown(e, true)) {
                        if (!CanvasActions.globalSyncGroup4Action.isEnabled()) break;
                        CanvasActions.globalSyncGroup4Action.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isNoModifier(e) || !CanvasActions.syncGroup4Action.isEnabled()) break;
                    CanvasActions.syncGroup4Action.execute();
                    e.consume();
                    break;
                }
                case 71: {
                    if (!EventUtil.isShiftDown(e, true) || !WindowActions.gridTileAction.isEnabled()) break;
                    WindowActions.gridTileAction.execute();
                    e.consume();
                    break;
                }
                case 72: {
                    if (!EventUtil.isShiftDown(e, true) || !WindowActions.horizontalTileAction.isEnabled()) break;
                    WindowActions.horizontalTileAction.execute();
                    e.consume();
                    break;
                }
                case 65: {
                    if (!EventUtil.isMenuControlDown(e, true) || !RoiActions.selectAllAction.isEnabled()) break;
                    RoiActions.selectAllAction.execute();
                    e.consume();
                    break;
                }
                case 86: {
                    if (EventUtil.isShiftDown(e, true)) {
                        if (!WindowActions.verticalTileAction.isEnabled()) break;
                        WindowActions.verticalTileAction.execute();
                        e.consume();
                        break;
                    }
                    if (EventUtil.isMenuControlDown(e, true)) {
                        if (GeneralActions.pasteImageAction.isEnabled()) {
                            GeneralActions.pasteImageAction.execute();
                            e.consume();
                            break;
                        }
                        if (!RoiActions.pasteAction.isEnabled()) break;
                        RoiActions.pasteAction.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isAltDown(e, true) || !RoiActions.pasteLinkAction.isEnabled()) break;
                    RoiActions.pasteLinkAction.execute();
                    e.consume();
                    break;
                }
                case 67: {
                    if (EventUtil.isMenuControlDown(e, true)) {
                        if (RoiActions.copyAction.isEnabled()) {
                            RoiActions.copyAction.execute();
                            e.consume();
                            break;
                        }
                        if (!GeneralActions.copyImageAction.isEnabled()) break;
                        GeneralActions.copyImageAction.execute();
                        e.consume();
                        break;
                    }
                    if (!EventUtil.isAltDown(e, true) || !RoiActions.copyLinkAction.isEnabled()) break;
                    RoiActions.copyLinkAction.execute();
                    e.consume();
                    break;
                }
                case 76: {
                    if (!EventUtil.isShiftDown(e, true) || !CanvasActions.globalToggleLayersAction.isEnabled()) break;
                    CanvasActions.globalToggleLayersAction.execute();
                    e.consume();
                    break;
                }
                case 32: {
                    if (this.tNav.isPlaying()) {
                        this.tNav.stopPlay();
                    } else {
                        this.tNav.startPlay();
                    }
                    e.consume();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean globalVisible = this.isLayersVisible();
        Point5D.Double pt = this.getMouseImagePos5D();
        for (Layer layer : this.getLayers(true)) {
            if ((!globalVisible || !layer.isVisible()) && !layer.getReceiveKeyEventOnHidden()) continue;
            layer.getOverlay().keyReleased(e, pt, this);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public IcyBufferedImage getImage(int t, int z, int c) {
        if (t == -1 || z == -1) {
            return null;
        }
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            return sequence.getImage(t, z, c);
        }
        return null;
    }

    @Deprecated
    public IcyBufferedImage getImage(int t, int z) {
        return this.getImage(t, z, -1);
    }

    public IcyBufferedImage getCurrentImage() {
        return this.getImage(this.getPositionT(), this.getPositionZ(), this.getPositionC());
    }

    @Deprecated
    public final BufferedImage getRenderedImage(int t, int z, int c, int imageType, boolean canvasView) throws InterruptedException {
        return this.getRenderedImage(t, z, c, canvasView);
    }

    @Deprecated
    public final Sequence getRenderedSequence(int imageType, boolean canvasView) throws InterruptedException {
        return this.getRenderedSequence(canvasView, null);
    }

    public abstract BufferedImage getRenderedImage(int var1, int var2, int var3, boolean var4) throws InterruptedException;

    @Deprecated
    public BufferedImage getRenderedImage(int t, int z, int c) throws InterruptedException {
        return this.getRenderedImage(t, z, c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence getRenderedSequence(boolean canvasView, ProgressListener progressListener) throws InterruptedException {
        Sequence seqIn = this.getSequence();
        Sequence result = new Sequence();
        if (seqIn != null) {
            result.setMetaData(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)seqIn.getOMEXMLMetadata(), true));
            int t = this.getPositionT();
            int z = this.getPositionZ();
            int c = this.getPositionC();
            int sizeT = this.getImageSizeT();
            int sizeZ = this.getImageSizeZ();
            int sizeC = this.getImageSizeC();
            int pos = 0;
            int len = 1;
            if (t != -1) {
                len *= sizeT;
            }
            if (z != -1) {
                len *= sizeZ;
            }
            if (c != -1) {
                len *= sizeC;
            }
            result.beginUpdate();
            this.beginUpdate();
            try {
                if (t != -1) {
                    for (t = 0; t < sizeT; ++t) {
                        if (z != -1) {
                            for (z = 0; z < sizeZ; ++z) {
                                if (Thread.currentThread().isInterrupted()) {
                                    throw new InterruptedException("Canvas rendering interrupted..");
                                }
                                if (c != -1) {
                                    ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                                    for (c = 0; c < sizeC; ++c) {
                                        images.add(this.getRenderedImage(t, z, c, canvasView));
                                        ++pos;
                                        if (progressListener == null) continue;
                                        progressListener.notifyProgress(pos, len);
                                    }
                                    result.setImage(t, z, (BufferedImage)IcyBufferedImage.createFrom(images));
                                    continue;
                                }
                                result.setImage(t, z, this.getRenderedImage(t, z, -1, canvasView));
                                ++pos;
                                if (progressListener == null) continue;
                                progressListener.notifyProgress(pos, len);
                            }
                            continue;
                        }
                        result.setImage(t, 0, this.getRenderedImage(t, -1, -1, canvasView));
                        ++pos;
                        if (progressListener == null) continue;
                        progressListener.notifyProgress(pos, len);
                    }
                } else if (z != -1) {
                    for (z = 0; z < sizeZ; ++z) {
                        if (c != -1) {
                            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                            for (c = 0; c < sizeC; ++c) {
                                images.add(this.getRenderedImage(-1, z, c, canvasView));
                                ++pos;
                                if (progressListener == null) continue;
                                progressListener.notifyProgress(pos, len);
                            }
                            result.setImage(0, z, (BufferedImage)IcyBufferedImage.createFrom(images));
                            continue;
                        }
                        result.setImage(0, z, this.getRenderedImage(-1, z, -1, canvasView));
                        ++pos;
                        if (progressListener == null) continue;
                        progressListener.notifyProgress(pos, len);
                    }
                } else if (c != -1) {
                    ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
                    for (c = 0; c < sizeC; ++c) {
                        images.add(this.getRenderedImage(-1, -1, c, canvasView));
                        ++pos;
                        if (progressListener == null) continue;
                        progressListener.notifyProgress(pos, len);
                    }
                    result.setImage(0, 0, (BufferedImage)IcyBufferedImage.createFrom(images));
                } else {
                    result.setImage(0, 0, this.getRenderedImage(-1, -1, -1, canvasView));
                    ++pos;
                    if (progressListener != null) {
                        progressListener.notifyProgress(pos, len);
                    }
                }
                result.setPixelSizeX(seqIn.getPixelSizeX() / (canvasView ? this.getScaleX() : 1.0));
                result.setPixelSizeY(seqIn.getPixelSizeY() / (canvasView ? this.getScaleY() : 1.0));
                result.setPixelSizeZ(seqIn.getPixelSizeZ() / (canvasView ? this.getScaleZ() : 1.0));
            }
            finally {
                this.endUpdate();
                result.endUpdate();
            }
        }
        return result;
    }

    @Deprecated
    public Sequence getRenderedSequence(boolean canvasView) throws InterruptedException {
        return this.getRenderedSequence(canvasView, null);
    }

    @Deprecated
    public Sequence getRenderedSequence() throws InterruptedException {
        return this.getRenderedSequence(true, null);
    }

    public int getNumSelectedSamples() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            return 0;
        }
        int base_len = this.getImageSizeX() * this.getImageSizeY() * this.getImageSizeC();
        if (this.getPositionT() == -1) {
            if (this.getPositionZ() == -1) {
                return base_len * this.getImageSizeZ() * this.getImageSizeT();
            }
            return base_len * this.getImageSizeT();
        }
        if (this.getPositionZ() == -1) {
            return base_len * this.getImageSizeZ();
        }
        return base_len;
    }

    public int getFrameRate() {
        return this.tNav.getFrameRate();
    }

    public void setFrameRate(int fps) {
        this.tNav.setFrameRate(fps);
    }

    protected void updateZNav() {
        int maxZ = this.getMaxPositionZ();
        int z = this.getPositionZ();
        this.zNav.setMaximum(maxZ);
        if (z != -1) {
            this.zNav.setValue(z);
            this.zNav.setVisible(maxZ > 0);
        } else {
            this.zNav.setVisible(false);
        }
    }

    protected void updateTNav() {
        int maxT = this.getMaxPositionT();
        int t = this.getPositionT();
        this.tNav.setMaximum(maxT);
        if (t != -1) {
            this.tNav.setValue(t);
            this.tNav.setVisible(maxT > 0);
        } else {
            this.tNav.setVisible(false);
        }
    }

    @Deprecated
    public Layer getLayer(Painter painter) {
        for (Layer layer : this.getLayers(false)) {
            if (layer.getPainter() != painter) continue;
            return layer;
        }
        return null;
    }

    public Layer getLayer(Overlay overlay) {
        return this.layers.get(overlay);
    }

    public Layer getLayer(ROI roi) {
        return this.getLayer(roi.getOverlay());
    }

    @Deprecated
    public boolean hasLayer(Painter painter) {
        return this.getLayer(painter) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLayer(Overlay overlay) {
        Map<Overlay, Layer> map = this.layers;
        synchronized (map) {
            return this.layers.containsKey(overlay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLayer(Layer layer) {
        Overlay overlay = layer.getOverlay();
        if (overlay != null) {
            return this.hasLayer(overlay);
        }
        Map<Overlay, Layer> map = this.layers;
        synchronized (map) {
            return this.layers.containsValue(layer);
        }
    }

    @Deprecated
    public void addLayer(Painter painter) {
        if (!this.hasLayer(painter)) {
            this.addLayer(new Layer(painter));
        }
    }

    public Layer addLayer(Overlay overlay) {
        if (!this.hasLayer(overlay)) {
            return this.addLayer(new Layer(overlay));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layer addLayer(Layer layer) {
        if (layer != null) {
            layer.addListener(this);
            Map<Overlay, Layer> map = this.layers;
            synchronized (map) {
                this.layers.put(layer.getOverlay(), layer);
                if ("layer".equals(layer)) {
                    layer.setName("layer " + this.layers.size());
                }
            }
            this.layerAdded(layer);
        }
        return layer;
    }

    @Deprecated
    public void removeLayer(Painter painter) {
        this.removeLayer(this.getLayer(painter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLayer(Overlay overlay) {
        Layer layer;
        Map<Overlay, Layer> map = this.layers;
        synchronized (map) {
            layer = this.layers.remove(overlay);
        }
        if (layer != null) {
            layer.removeListener(this);
            this.layerRemoved(layer);
            return true;
        }
        return false;
    }

    public void removeLayer(Layer layer) {
        this.removeLayer(layer.getOverlay());
    }

    public boolean isVisible(Overlay overlay) {
        Layer layer = this.getLayer(overlay);
        if (layer != null) {
            return layer.isVisible();
        }
        return false;
    }

    @Deprecated
    public void addLayersListener(CanvasLayerListener listener) {
        this.addLayerListener(listener);
    }

    @Deprecated
    public void removeLayersListener(CanvasLayerListener listener) {
        this.removeLayerListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CanvasLayerListener> getLayerListeners() {
        List<CanvasLayerListener> list = this.layerListeners;
        synchronized (list) {
            return new ArrayList<CanvasLayerListener>(this.layerListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayerListener(CanvasLayerListener listener) {
        List<CanvasLayerListener> list = this.layerListeners;
        synchronized (list) {
            if (listener != null) {
                this.layerListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayerListener(CanvasLayerListener listener) {
        List<CanvasLayerListener> list = this.layerListeners;
        synchronized (list) {
            this.layerListeners.remove(listener);
        }
    }

    protected void fireLayerChangedEvent(CanvasLayerEvent event) {
        for (CanvasLayerListener listener : this.getLayerListeners()) {
            listener.canvasLayerChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IcyCanvasListener> getListeners() {
        List<IcyCanvasListener> list = this.listeners;
        synchronized (list) {
            return new ArrayList<IcyCanvasListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCanvasListener(IcyCanvasListener listener) {
        List<IcyCanvasListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCanvasListener(IcyCanvasListener listener) {
        List<IcyCanvasListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected void fireCanvasChangedEvent(IcyCanvasEvent event) {
        for (IcyCanvasListener listener : this.getListeners()) {
            listener.canvasChanged(event);
        }
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    protected void layerAdded(Layer layer) {
        this.updater.changed(new CanvasLayerEvent(layer, CanvasLayerEvent.LayersEventType.ADDED));
    }

    protected void layerRemoved(Layer layer) {
        this.updater.changed(new CanvasLayerEvent(layer, CanvasLayerEvent.LayersEventType.REMOVED));
    }

    @Override
    public void layerChanged(Layer layer, String propertyName) {
        this.updater.changed(new CanvasLayerEvent(layer, CanvasLayerEvent.LayersEventType.CHANGED, propertyName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed(IcyCanvasEvent event) {
        List<IcyCanvas> synchCanvasList;
        IcyCanvasEvent.IcyCanvasEventType eventType = event.getType();
        if (this.isSynchronized() && this.getSynchMaster(synchCanvasList = this.getSynchronizedCanvas())) {
            try {
                boolean synchAll = eventType == IcyCanvasEvent.IcyCanvasEventType.SYNC_CHANGED;
                this.synchronizeCanvas(synchCanvasList, event, synchAll);
            }
            finally {
                this.releaseSynchMaster();
            }
        }
        switch (eventType) {
            case POSITION_CHANGED: {
                int curZ = this.getPositionZ();
                int curT = this.getPositionT();
                int curC = this.getPositionC();
                switch (event.getDim()) {
                    case Z: {
                        if (curZ == -1) break;
                        this.zNav.setValue(curZ);
                        break;
                    }
                    case T: {
                        if (curT == -1) break;
                        this.tNav.setValue(curT);
                        break;
                    }
                    case C: {
                        int maxC = this.getMaxPositionC();
                        for (int c = 0; c <= maxC; ++c) {
                            this.getLut().getLutChannel(c).setEnabled(curC == -1 || curC == c);
                        }
                        break;
                    }
                    case NULL: {
                        if (curZ != -1) {
                            this.zNav.setValue(curZ);
                        }
                        if (curT == -1) break;
                        this.tNav.setValue(curT);
                    }
                }
                this.mouseInfPanel.updateInfos(this);
                break;
            }
            case MOUSE_IMAGE_POSITION_CHANGED: {
                this.mouseInfPanel.updateInfos(this);
            }
        }
        this.fireCanvasChangedEvent(event);
    }

    protected void layerChanged(CanvasLayerEvent event) {
        String property = event.getProperty();
        if (event.getType() != CanvasLayerEvent.LayersEventType.CHANGED || property == null || property == "priority") {
            this.orderedLayersOutdated = true;
        }
        this.fireLayerChangedEvent(event);
    }

    protected void positionChanged(DimensionId dim) {
        this.updater.changed(new IcyCanvasEvent(this, IcyCanvasEvent.IcyCanvasEventType.POSITION_CHANGED, dim));
    }

    @Override
    public void lutChanged(LUTEvent event) {
        int curC = this.getPositionC();
        if (curC != -1) {
            int channel = event.getComponent();
            if (channel != -1 && this.getLut().getLutChannel(channel).isEnabled()) {
                this.setPositionC(channel);
            } else {
                this.getLut().getLutChannel(curC).setEnabled(true);
            }
        }
        this.lutChanged(event.getComponent());
    }

    protected void lutChanged(int component) {
    }

    protected void sequenceMetaChanged(String metadataName) {
    }

    protected void sequenceTypeChanged() {
    }

    protected void sequenceComponentBoundsChanged(IcyColorModel colorModel, int component) {
    }

    protected void sequenceColorMapChanged(IcyColorModel colorModel, int component) {
    }

    protected void sequenceDataChanged(IcyBufferedImage image, SequenceEvent.SequenceEventType type) {
        ThreadUtil.runSingle(this.guiUpdater);
    }

    @Deprecated
    protected void sequencePainterChanged(Painter painter, SequenceEvent.SequenceEventType type) {
    }

    protected void sequenceOverlayChanged(Overlay overlay, SequenceEvent.SequenceEventType type) {
        switch (type) {
            case ADDED: {
                this.addLayer(overlay);
                break;
            }
            case REMOVED: {
                this.removeLayer(overlay);
                break;
            }
        }
    }

    protected void sequenceROIChanged(ROI roi, SequenceEvent.SequenceEventType type) {
    }

    @Override
    public void viewerChanged(ViewerEvent event) {
        switch (event.getType()) {
            case POSITION_CHANGED: {
                break;
            }
            case LUT_CHANGED: {
                this.setLut(this.viewer.getLut(), true);
                break;
            }
        }
    }

    @Override
    public void viewerClosed(Viewer viewer) {
    }

    @Override
    public final void sequenceChanged(SequenceEvent event) {
        switch (event.getSourceType()) {
            case SEQUENCE_META: {
                this.sequenceMetaChanged((String)event.getSource());
                break;
            }
            case SEQUENCE_TYPE: {
                this.sequenceTypeChanged();
                break;
            }
            case SEQUENCE_COMPONENTBOUNDS: {
                this.sequenceComponentBoundsChanged((IcyColorModel)event.getSource(), event.getParam());
                break;
            }
            case SEQUENCE_COLORMAP: {
                this.sequenceColorMapChanged((IcyColorModel)event.getSource(), event.getParam());
                break;
            }
            case SEQUENCE_DATA: {
                this.sequenceDataChanged((IcyBufferedImage)event.getSource(), event.getType());
                break;
            }
            case SEQUENCE_OVERLAY: {
                Overlay overlay = (Overlay)event.getSource();
                this.sequenceOverlayChanged(overlay, event.getType());
                Painter painter = overlay instanceof OverlayWrapper ? ((OverlayWrapper)overlay).getPainter() : overlay;
                this.sequencePainterChanged(painter, event.getType());
                break;
            }
            case SEQUENCE_ROI: {
                this.sequenceROIChanged((ROI)event.getSource(), event.getType());
            }
        }
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
    }

    @Override
    public void onChanged(CollapsibleEvent event) {
        if (event instanceof CanvasLayerEvent) {
            this.layerChanged((CanvasLayerEvent)event);
        }
        if (event instanceof IcyCanvasEvent) {
            this.changed((IcyCanvasEvent)event);
        }
    }

    protected class IcyCanvasImageOverlay
    extends Overlay {
        public IcyCanvasImageOverlay() {
            super(IcyCanvas.this.getSequence() == null ? "Image" : IcyCanvas.this.getSequence().getName(), Overlay.OverlayPriority.IMAGE_NORMAL);
            this.canBeRemoved = false;
            this.readOnly = false;
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (g != null) {
                g.drawImage(IcyCanvas.this.getCurrentImage(), null, 0, 0);
            }
        }
    }
}

