/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CheckTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1274171822668858593L;
    boolean defaultSelected;

    public CheckTabbedPane(int tabPlacement, boolean defaultSelected) {
        super(tabPlacement);
        this.defaultSelected = defaultSelected;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelected;
    }

    public void setDefaultSelected(boolean defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
    }

    public boolean isTabChecked(int index) {
        return ((CheckTabComponent)this.getTabComponentAt(index)).isSelected();
    }

    public void setTabChecked(int index, boolean value) {
        ((CheckTabComponent)this.getTabComponentAt(index)).setSelected(value);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        ((CheckTabComponent)this.getTabComponentAt(index)).setIcon(icon);
    }

    @Override
    public void setDisabledIconAt(int index, Icon disabledIcon) {
        super.setDisabledIconAt(index, disabledIcon);
        ((CheckTabComponent)this.getTabComponentAt(index)).setDisabledIcon(disabledIcon);
    }

    @Override
    public void setBackgroundAt(int index, Color background) {
        super.setBackgroundAt(index, background);
        ((CheckTabComponent)this.getTabComponentAt(index)).setBackgroundAll(background);
    }

    @Override
    public void setForegroundAt(int index, Color foreground) {
        super.setForegroundAt(index, foreground);
        ((CheckTabComponent)this.getTabComponentAt(index)).setForegroundAll(foreground);
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        ((CheckTabComponent)this.getTabComponentAt(index)).setTitle(title);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(index, new CheckTabComponent(title, icon));
    }

    private class CheckTabComponent
    extends JPanel {
        private static final long serialVersionUID = 4841789742300589373L;
        private final JCheckBox checkBox;
        private final JLabel label;

        public CheckTabComponent(String title, Icon icon) {
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
            this.checkBox = new JCheckBox(null, null, CheckTabbedPane.this.defaultSelected);
            this.checkBox.setBorder(BorderFactory.createEmptyBorder());
            this.checkBox.setFocusable(false);
            this.checkBox.setToolTipText("enable / disable");
            this.checkBox.setOpaque(false);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    CheckTabbedPane.this.fireStateChanged();
                }
            });
            this.label = new JLabel(" " + title, icon, 0);
            this.label.setOpaque(false);
            this.add(this.checkBox);
            this.add(this.label);
            this.validate();
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean value) {
            this.checkBox.setSelected(value);
        }

        public void setTitle(String title) {
            this.label.setText(" " + title);
        }

        public void setIcon(Icon icon) {
            this.label.setIcon(icon);
        }

        public void setDisabledIcon(Icon disabledIcon) {
            this.label.setDisabledIcon(disabledIcon);
        }

        public void setBackgroundAll(Color background) {
            this.checkBox.setBackground(background);
            this.label.setBackground(background);
        }

        public void setForegroundAll(Color foreground) {
            this.checkBox.setForeground(foreground);
            this.label.setForeground(foreground);
        }
    }
}

