/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu;

import icy.action.GeneralActions;
import icy.action.PreferencesActions;
import icy.action.WindowActions;
import icy.gui.component.button.IcyCommandButton;
import icy.gui.component.button.IcyCommandMenuButton;
import icy.gui.component.button.IcyCommandToggleButton;
import icy.gui.component.button.IcyCommandToggleMenuButton;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.TaskFrame;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.main.MainFrame;
import icy.gui.menu.ApplicationMenu;
import icy.gui.menu.ImageJTask;
import icy.gui.menu.PluginMenuItem;
import icy.gui.menu.ROITask;
import icy.gui.menu.SequenceOperationTask;
import icy.gui.menu.ToolRibbonTask;
import icy.gui.menu.search.SearchBar;
import icy.gui.plugin.PluginCommandButton;
import icy.gui.util.LookAndFeelUtil;
import icy.gui.util.RibbonUtil;
import icy.gui.viewer.Viewer;
import icy.imagej.ImageJWrapper;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.preferences.GeneralPreferences;
import icy.preferences.WorkspaceLocalPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.thread.ThreadUtil;
import icy.workspace.Workspace;
import icy.workspace.WorkspaceInstaller;
import icy.workspace.WorkspaceLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizeSequencingPolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizeSequencingPolicy;

public class MainRibbon
implements PluginLoader.PluginLoaderListener,
ActiveSequenceListener {
    public static final String TASK_PLUGINS = "Plugins";
    public static final String BAND_SETUP = "Setup";
    public static final String BAND_NEW = "New";
    public static final String BAND_OTHERS = "Others";
    private final ArrayList<Workspace> workspaces;
    private Workspace systemWorkspace;
    SearchBar searchBar;
    Workspace.TaskDefinition.BandDefinition setupPluginsBandDef;
    Workspace.TaskDefinition.BandDefinition newPluginsBandDef;
    Workspace.TaskDefinition.BandDefinition othersPluginsBandDef;
    private final JRibbon ribbon;
    private final ApplicationMenu applicationMenu;
    private final SequenceOperationTask sequenceOperationTask;
    private final ToolRibbonTask roiTask;
    private final ImageJTask ijTask;
    private final JRibbonBand setupPluginsBand;
    private final JRibbonBand newPluginsBand;
    final JMenu othersPluginsMenu;
    CommandToggleButtonGroup multiWindowGroup;
    IcyCommandToggleButton multiWindowButton;

    public MainRibbon(JRibbon ribbon) {
        this.ribbon = ribbon;
        this.workspaces = new ArrayList();
        this.othersPluginsMenu = new JMenu(TASK_PLUGINS);
        this.applicationMenu = new ApplicationMenu();
        ribbon.setApplicationMenu((RibbonApplicationMenu)this.applicationMenu);
        RichTooltip toolTip = new RichTooltip("ICY Application menu", "Load, close and save Sequence from there.");
        ribbon.setApplicationMenuRichTooltip(toolTip);
        this.buidlTaskBar();
        this.sequenceOperationTask = new SequenceOperationTask();
        this.roiTask = new ToolRibbonTask();
        this.ijTask = new ImageJTask();
        ribbon.addTask((RibbonTask)this.sequenceOperationTask);
        ribbon.addTask((RibbonTask)this.roiTask);
        ribbon.addTask((RibbonTask)this.ijTask);
        this.loadWorkspaces();
        this.setupPluginsBandDef = this.systemWorkspace.findBand(TASK_PLUGINS, BAND_SETUP);
        this.newPluginsBandDef = this.systemWorkspace.findBand(TASK_PLUGINS, BAND_NEW);
        this.othersPluginsBandDef = this.systemWorkspace.findBand(TASK_PLUGINS, BAND_OTHERS);
        this.buildWorkspaces();
        RibbonTask pluginTask = RibbonUtil.getTask(ribbon, TASK_PLUGINS);
        this.setupPluginsBand = RibbonUtil.getBand(pluginTask, BAND_SETUP);
        this.newPluginsBand = RibbonUtil.getBand(pluginTask, BAND_NEW);
        this.buildSetupPluginBand();
        PluginLoader.addListener(this);
        Icy.getMainInterface().addActiveSequenceListener(this);
    }

    public void init() {
        this.ijTask.init();
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        mainFrame.addPropertyChangeListener("detachedMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainRibbon.this.multiWindowGroup.setSelected((JCommandToggleButton)MainRibbon.this.multiWindowButton, Icy.getMainInterface().isDetachedMode());
            }
        });
    }

    public ROITask getROIRibbonTask() {
        return this.roiTask;
    }

    @Deprecated
    public ToolRibbonTask getToolRibbon() {
        return this.roiTask;
    }

    public SequenceOperationTask getSequenceOperationTask() {
        return this.sequenceOperationTask;
    }

    public ImageJTask getImageJTask() {
        return this.ijTask;
    }

    public ImageJWrapper getImageJ() {
        return this.ijTask.getImageJ();
    }

    public SearchBar getSearchBar() {
        return this.searchBar;
    }

    private void loadWorkspaces() {
        ArrayList<String> workspacesName = WorkspaceLocalPreferences.getActivesWorkspace();
        WorkspaceLoader.waitWhileLoading();
        this.workspaces.clear();
        for (String name : workspacesName) {
            Workspace ws = WorkspaceLoader.getWorkspace(name);
            if (ws == null) {
                System.err.println("Workspace " + name + " not found !");
                continue;
            }
            if (this.isInConflict(ws, true)) {
                System.err.println("Workspace '" + name + "' is discarded (conflict detected)");
                continue;
            }
            this.workspaces.add(ws);
        }
        workspacesName.clear();
        for (Workspace ws : this.workspaces) {
            workspacesName.add(ws.getName());
        }
        WorkspaceLocalPreferences.setActivesWorkspace(workspacesName);
        this.systemWorkspace = new Workspace("sys");
        this.systemWorkspace.setDescription("System workspace");
        this.systemWorkspace.addBand(TASK_PLUGINS, BAND_SETUP);
        this.systemWorkspace.addBand(TASK_PLUGINS, BAND_NEW);
        this.systemWorkspace.addBand(TASK_PLUGINS, BAND_OTHERS);
        this.workspaces.add(this.systemWorkspace);
    }

    private boolean isInConflict(Workspace ws, boolean showAsError) {
        for (Workspace.TaskDefinition task : ws.getTasks()) {
            for (Workspace.TaskDefinition.BandDefinition band : task.getBands()) {
                if (this.findBand(task.getName(), band.getName()) == null) continue;
                if (showAsError) {
                    System.err.println("Duplicated band : " + task.getName() + "/" + band.getName());
                }
                return true;
            }
        }
        return false;
    }

    private List<Workspace.TaskDefinition> getTasks() {
        ArrayList<Workspace.TaskDefinition> result = new ArrayList<Workspace.TaskDefinition>();
        for (Workspace ws : this.workspaces) {
            for (Workspace.TaskDefinition task : ws.getTasks()) {
                if (Workspace.contains(result, task)) continue;
                result.add(task);
            }
        }
        return result;
    }

    private List<Workspace.TaskDefinition.BandDefinition> getBands(String taskName) {
        ArrayList<Workspace.TaskDefinition.BandDefinition> result = new ArrayList<Workspace.TaskDefinition.BandDefinition>();
        for (Workspace ws : this.workspaces) {
            for (Workspace.TaskDefinition task : ws.getTasks()) {
                if (!task.getName().equals(taskName)) continue;
                for (Workspace.TaskDefinition.BandDefinition band : task.getBands()) {
                    if (Workspace.contains(result, band)) continue;
                    result.add(band);
                }
            }
        }
        return result;
    }

    private Workspace.TaskDefinition.BandDefinition findBand(String taskName, String bandName) {
        for (Workspace ws : this.workspaces) {
            Workspace.TaskDefinition.BandDefinition band;
            Workspace.TaskDefinition task = ws.findTask(taskName);
            if (task == null || (band = task.findBand(bandName)) == null) continue;
            return band;
        }
        return null;
    }

    private ArrayList<Workspace.TaskDefinition.BandDefinition.ItemDefinition> getAllItems() {
        ArrayList<Workspace.TaskDefinition.BandDefinition.ItemDefinition> result = new ArrayList<Workspace.TaskDefinition.BandDefinition.ItemDefinition>();
        for (Workspace workspace : this.workspaces) {
            result.addAll(workspace.getAllItems());
        }
        return result;
    }

    Workspace.TaskDefinition.BandDefinition.ItemDefinition findItem(String className) {
        for (Workspace workspace : this.workspaces) {
            Workspace.TaskDefinition.BandDefinition.ItemDefinition item = workspace.findItem(className);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    void addItem(String className) {
        this.addItem(PluginLoader.getPlugin(className));
    }

    void addItem(PluginDescriptor plugin) {
        if (plugin != null && plugin.isActionable()) {
            IcyCommandButton pluginButton = PluginCommandButton.createButton(plugin);
            this.newPluginsBandDef.addItem(plugin.getClassName(), RibbonElementPriority.TOP);
            this.systemWorkspace.save();
            this.newPluginsBand.addCommandButton((AbstractCommandButton)pluginButton, RibbonElementPriority.TOP);
        }
    }

    void updateItem(String className) {
        this.updateItem(PluginLoader.getPlugin(className), this.findItem(className));
    }

    void updateItem(PluginDescriptor plugin, Workspace.TaskDefinition.BandDefinition.ItemDefinition item) {
        if (plugin != null && plugin.isActionable()) {
            if (item != null) {
                AbstractCommandButton button = RibbonUtil.findButton(RibbonUtil.getBand(RibbonUtil.getTask(this.ribbon, item.getTaskName()), item.getBandName()), item.getClassName());
                if (button != null) {
                    PluginCommandButton.setButton(button, plugin);
                }
            } else {
                Workspace workspace = WorkspaceInstaller.getCurrentInstallingWorkspace();
                if (workspace == null || workspace.findItem(plugin.getClassName()) == null) {
                    this.addItem(plugin);
                }
            }
        }
    }

    void removeItem(String className) {
        this.removeItem(this.findItem(className));
    }

    void removeItem(Workspace.TaskDefinition.BandDefinition.ItemDefinition item) {
        if (item != null) {
            RibbonUtil.removeButton(RibbonUtil.getBand(RibbonUtil.getTask(this.ribbon, item.getTaskName()), item.getBandName()), item.getClassName());
            item.remove();
            this.systemWorkspace.save();
        }
    }

    private void buildSetupPluginBand() {
        this.setupPluginsBand.addCommandButton((AbstractCommandButton)new IcyCommandButton(PreferencesActions.onlinePluginPreferencesAction), RibbonElementPriority.TOP);
        RibbonUtil.setFixedResizePolicies(this.setupPluginsBand);
    }

    private JRibbonBand[] createRibbonBands(Workspace.TaskDefinition task) {
        List<Workspace.TaskDefinition.BandDefinition> bands = this.getBands(task.getName());
        int size = bands.size();
        JRibbonBand[] result = new JRibbonBand[size];
        for (int i = 0; i < size; ++i) {
            Workspace.TaskDefinition.BandDefinition band = bands.get(i);
            result[i] = new JRibbonBand(band.getName(), (ResizableIcon)new IcyIcon(ResourceUtil.ICON_DOC));
            RibbonUtil.setRestrictiveResizePolicies(result[i]);
        }
        return result;
    }

    private RibbonTask createRibbonTask(Workspace.TaskDefinition task) {
        RibbonTask result;
        String name = task.getName();
        RibbonTask ribbonTask = RibbonUtil.getTask(this.ribbon, name);
        if (ribbonTask != null) {
            System.out.println("Ribbon task " + name + " already exists...");
            return ribbonTask;
        }
        try {
            result = new RibbonTask(name, (AbstractRibbonBand[])this.createRibbonBands(task));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        result.setResizeSequencingPolicy((RibbonBandResizeSequencingPolicy)new CoreRibbonResizeSequencingPolicies.RoundRobin(result));
        return result;
    }

    private void buildWorkspaces() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(false);
        for (Workspace.TaskDefinition task : this.getTasks()) {
            RibbonTask ribbonTask = this.createRibbonTask(task);
            if (ribbonTask == null) continue;
            for (Workspace.TaskDefinition.BandDefinition band : this.getBands(task.getName())) {
                JRibbonBand ribbonBand = RibbonUtil.getBand(ribbonTask, band.getName());
                if (ribbonBand == null) continue;
                if (band == this.othersPluginsBandDef) {
                    final IcyCommandButton btn = new IcyCommandButton("Other Plugins", new IcyIcon(ResourceUtil.ICON_COG));
                    btn.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                    btn.setPopupRichTooltip(new RichTooltip("Other plugins", "You can find here all plugins which are not associated to a workspace"));
                    btn.setPopupCallback(new PopupPanelCallback(){

                        public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                            JPopupMenu popupMenu = MainRibbon.this.othersPluginsMenu.getPopupMenu();
                            popupMenu.show((Component)((Object)btn), 0, btn.getHeight());
                            return null;
                        }
                    });
                    ribbonBand.addCommandButton((AbstractCommandButton)btn, RibbonElementPriority.TOP);
                    this.refreshOthersPluginsList();
                    RibbonUtil.setFixedResizePolicies(ribbonBand);
                    continue;
                }
                for (Workspace.TaskDefinition.BandDefinition.ItemDefinition item : band.getItems()) {
                    if (item.isSeparator()) {
                        ribbonBand.startGroup();
                        continue;
                    }
                    String className = item.getClassName();
                    PluginDescriptor plugin = PluginDescriptor.getPlugin(plugins, className);
                    if (plugin == null || !plugin.isActionable()) continue;
                    ribbonBand.addCommandButton((AbstractCommandButton)PluginCommandButton.createButton(plugin), item.getPriority());
                }
                RibbonUtil.setRestrictiveResizePolicies(ribbonBand);
            }
            if (ribbonTask.getBandCount() <= 0) continue;
            this.ribbon.addTask(ribbonTask);
        }
    }

    public void cleanWorkspaces() {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(false);
        for (Workspace.TaskDefinition.BandDefinition.ItemDefinition item : this.getAllItems()) {
            String className;
            PluginDescriptor plugin;
            if (item.isSeparator() || (plugin = PluginDescriptor.getPlugin(plugins, className = item.getClassName())) != null) continue;
            item.remove();
        }
        this.saveWorkspaces();
    }

    void refreshOthersPluginsList() {
        ArrayList<PluginDescriptor> othersPlugins = new ArrayList<PluginDescriptor>();
        for (PluginDescriptor plugin : PluginLoader.getActionablePlugins()) {
            String className = plugin.getClassName();
            Workspace.TaskDefinition.BandDefinition.ItemDefinition item = this.findItem(className);
            if (item != null && item.getBandDefinition() != this.othersPluginsBandDef) continue;
            othersPlugins.add(plugin);
        }
        this.builOthersPluginsMenu(othersPlugins);
        this.othersPluginsBandDef.clear();
        for (PluginDescriptor plugin : othersPlugins) {
            this.othersPluginsBandDef.addItem(plugin.getClassName());
        }
        this.systemWorkspace.save();
    }

    private void builOthersPluginsMenu(ArrayList<PluginDescriptor> plugins) {
        this.othersPluginsMenu.removeAll();
        for (PluginDescriptor pluginDescriptor : plugins) {
            String pluginEntry = pluginDescriptor.getSimplePackageName();
            JMenu menuToPutPlugin = this.othersPluginsMenu;
            while (pluginEntry != null) {
                String pluginDir;
                int index = pluginEntry.indexOf(".");
                if (index != -1) {
                    pluginDir = pluginEntry.substring(0, index);
                    pluginEntry = pluginEntry.substring(index + 1);
                } else {
                    pluginDir = pluginEntry;
                    pluginEntry = null;
                }
                boolean menuExist = false;
                for (Component component : menuToPutPlugin.getMenuComponents()) {
                    JMenu menu;
                    if (!(component instanceof JMenu) || !(menu = (JMenu)component).getText().equals(pluginDir)) continue;
                    menuToPutPlugin = menu;
                    menuExist = true;
                    break;
                }
                if (menuExist) continue;
                JMenu menu = new JMenu(pluginDir);
                menuToPutPlugin.add(menu);
                menuToPutPlugin = menu;
            }
            menuToPutPlugin.add(new PluginMenuItem(pluginDescriptor));
        }
        if (plugins.isEmpty()) {
            this.othersPluginsMenu.add(new JMenuItem("No plugins"));
        }
        this.othersPluginsMenu.validate();
    }

    void saveWorkspaces() {
        for (Workspace workspace : this.workspaces) {
            workspace.save();
        }
    }

    private void buidlTaskBar() {
        this.ribbon.addTaskbarComponent((Component)((Object)new IcyCommandButton(PreferencesActions.preferencesAction)));
        this.ribbon.addTaskbarComponent((Component)((Object)new IcyCommandButton(PreferencesActions.onlinePluginPreferencesAction)));
        this.ribbon.addTaskbarComponent((Component)new JSeparator(1));
        this.multiWindowGroup = new CommandToggleButtonGroup();
        this.multiWindowButton = new IcyCommandToggleButton(GeneralActions.detachedModeAction);
        this.ribbon.addTaskbarComponent((Component)((Object)this.multiWindowButton));
        this.multiWindowGroup.add((JCommandToggleButton)this.multiWindowButton);
        this.multiWindowGroup.setSelected((JCommandToggleButton)this.multiWindowButton, GeneralPreferences.getMultiWindowMode());
        IcyCommandButton windowsButton = new IcyCommandButton(new IcyIcon("app_window"));
        windowsButton.setPopupRichTooltip(new RichTooltip("Windows", "Show specific windows and general windows setting..."));
        windowsButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        windowsButton.setPopupCallback(new PopupPanelCallback(){

            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JCommandPopupMenu result = new JCommandPopupMenu();
                CommandToggleButtonGroup aotGroup = new CommandToggleButtonGroup();
                IcyCommandToggleMenuButton aotButton = new IcyCommandToggleMenuButton(WindowActions.stayOnTopAction);
                result.addMenuButton((JCommandToggleMenuButton)aotButton);
                aotGroup.add((JCommandToggleButton)aotButton);
                aotGroup.setSelected((JCommandToggleButton)aotButton, GeneralPreferences.getAlwaysOnTop());
                result.addMenuSeparator();
                IcyCommandMenuButton lafButton = new IcyCommandMenuButton("Appearance", new IcyIcon(ResourceUtil.ICON_SMILEY_HAPPY));
                lafButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                lafButton.setPopupRichTooltip(new RichTooltip("Look and feel", "Change appearance of the interface"));
                lafButton.setPopupCallback(new PopupPanelCallback(){

                    public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                        return LookAndFeelUtil.getLookAndFeelMenu();
                    }
                });
                result.addMenuButton((JCommandMenuButton)lafButton);
                result.addMenuSeparator();
                IcyCommandMenuButton spButton = new IcyCommandMenuButton(WindowActions.swimmingPoolAction);
                result.addMenuButton((JCommandMenuButton)spButton);
                result.addMenuSeparator();
                IcyCommandMenuButton tileButton = new IcyCommandMenuButton("Tile", new IcyIcon("2x2_grid"));
                tileButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                tileButton.setPopupCallback(new PopupPanelCallback(){

                    public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                        JCommandPopupMenu result = new JCommandPopupMenu();
                        result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(WindowActions.gridTileAction));
                        result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(WindowActions.horizontalTileAction));
                        result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(WindowActions.verticalTileAction));
                        return result;
                    }
                });
                result.addMenuButton((JCommandMenuButton)tileButton);
                result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(WindowActions.cascadeAction));
                result.addMenuSeparator();
                final ArrayList<Viewer> allViewers = Icy.getMainInterface().getViewers();
                IcyCommandMenuButton sequencesButton = new IcyCommandMenuButton("Opened sequences", new IcyIcon(ResourceUtil.ICON_PICTURE));
                sequencesButton.setPopupRichTooltip(new RichTooltip("Opened sequences", "Show the selected sequence"));
                sequencesButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                sequencesButton.setPopupCallback(new PopupPanelCallback(){

                    public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                        JCommandPopupMenu result = new JCommandPopupMenu();
                        Iterator iterator = allViewers.iterator();
                        while (iterator.hasNext()) {
                            Viewer viewer;
                            final Viewer v = viewer = (Viewer)iterator.next();
                            IcyCommandMenuButton seqButton = new IcyCommandMenuButton(viewer.getTitle());
                            seqButton.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ThreadUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (v.isMinimized()) {
                                                v.setMinimized(false);
                                            }
                                            v.requestFocus();
                                            v.toFront();
                                        }
                                    });
                                }
                            });
                            result.addMenuButton((JCommandMenuButton)seqButton);
                        }
                        return result;
                    }
                });
                sequencesButton.setEnabled(allViewers.size() > 0);
                result.addMenuButton((JCommandMenuButton)sequencesButton);
                final ArrayList<IcyFrame> allFrames = IcyFrame.getAllFrames();
                IcyCommandMenuButton framesButton = new IcyCommandMenuButton("Opened frames", new IcyIcon(ResourceUtil.ICON_WINDOW));
                framesButton.setPopupRichTooltip(new RichTooltip("Opened frames", "Show all frames"));
                framesButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                framesButton.setPopupCallback(new PopupPanelCallback(){

                    public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                        JCommandPopupMenu result = new JCommandPopupMenu();
                        for (IcyFrame frame : allFrames) {
                            if (frame instanceof Viewer || frame instanceof TaskFrame || !frame.isVisible()) continue;
                            final IcyFrame f = frame;
                            IcyCommandMenuButton frameButton = new IcyCommandMenuButton(frame.getTitle());
                            frameButton.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ThreadUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (f.isMinimized()) {
                                                f.setMinimized(false);
                                            }
                                            f.requestFocus();
                                            f.toFront();
                                        }
                                    });
                                }
                            });
                            result.addMenuButton((JCommandMenuButton)frameButton);
                        }
                        return result;
                    }
                });
                boolean hasVisibleFrame = false;
                for (IcyFrame frame : allFrames) {
                    if (frame instanceof Viewer || frame instanceof TaskFrame || !frame.isVisible()) continue;
                    hasVisibleFrame = true;
                }
                framesButton.setEnabled(hasVisibleFrame);
                result.addMenuButton((JCommandMenuButton)framesButton);
                return result;
            }
        });
        this.ribbon.addTaskbarComponent((Component)((Object)windowsButton));
        this.ribbon.addTaskbarComponent((Component)new JSeparator(1));
        this.searchBar = new SearchBar();
        this.searchBar.setColumns(14);
        this.ribbon.addTaskbarComponent((Component)this.searchBar);
        IcyCommandButton helpAndInfoButton = new IcyCommandButton(new IcyIcon(ResourceUtil.ICON_INFO));
        helpAndInfoButton.setPopupRichTooltip(new RichTooltip("General help and information", "Help, Updates and Informations about Icy."));
        helpAndInfoButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        helpAndInfoButton.setPopupCallback(new PopupPanelCallback(){

            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JCommandPopupMenu result = new JCommandPopupMenu();
                result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(GeneralActions.onlineHelpAction));
                result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(GeneralActions.websiteAction));
                result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(GeneralActions.checkUpdateAction));
                result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(GeneralActions.changeLogAction));
                result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(GeneralActions.aboutAction));
                return result;
            }
        });
        this.ribbon.addTaskbarComponent((Component)((Object)helpAndInfoButton));
    }

    private void checkPluginsMenuCoherence() {
        final ArrayList<PluginDescriptor> plugins = PluginLoader.getActionablePlugins();
        final ArrayList<Workspace.TaskDefinition.BandDefinition.ItemDefinition> items = this.getAllItems();
        final PluginDescriptor.PluginClassNameSorter pluginsSorter = PluginDescriptor.PluginClassNameSorter.instance;
        Collections.sort(plugins, pluginsSorter);
        final PluginDescriptor keyPlugin = new PluginDescriptor();
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Workspace.TaskDefinition.BandDefinition.ItemDefinition item : items) {
                    if (item.isSeparator() || item.getBandDefinition() == MainRibbon.this.othersPluginsBandDef) continue;
                    keyPlugin.getIdent().setClassName(item.getClassName());
                    if (Collections.binarySearch(plugins, keyPlugin, pluginsSorter) >= 0) continue;
                    MainRibbon.this.removeItem(item);
                }
                for (PluginDescriptor plugin : plugins) {
                    MainRibbon.this.updateItem(plugin, MainRibbon.this.findItem(plugin.getClassName()));
                }
                MainRibbon.this.refreshOthersPluginsList();
            }
        });
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        this.checkPluginsMenuCoherence();
    }

    @Override
    public void sequenceActivated(Sequence sequence) {
        this.sequenceOperationTask.onSequenceChange();
        this.roiTask.onSequenceActivationChange();
        this.ijTask.onSequenceActivationChange();
        this.applicationMenu.onSequenceActivationChange();
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
        SequenceEvent.SequenceEventSourceType type = event.getSourceType();
        if (type == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA || type == SequenceEvent.SequenceEventSourceType.SEQUENCE_TYPE) {
            this.sequenceOperationTask.onSequenceChange();
        }
        if (type == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI) {
            this.sequenceOperationTask.onSequenceChange();
            this.roiTask.onSequenceChange();
        }
    }
}

