/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.viewer;

import icy.gui.component.IcySlider;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ZNavigationPanel
extends JPanel {
    private static final long serialVersionUID = -1839748578015800706L;
    final IcySlider slider = new IcySlider(1);
    final JLabel topLabel;
    final JLabel bottomLabel;

    public ZNavigationPanel() {
        this.slider.setFocusable(false);
        this.slider.setMaximum(0);
        this.slider.setMinimum(0);
        this.slider.setToolTipText("Move cursor to navigate in Z dimension");
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ThreadUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZNavigationPanel.this.topLabel.setText(Integer.toString(ZNavigationPanel.this.slider.getMaximum()));
                        ZNavigationPanel.this.bottomLabel.setText(Integer.toString(ZNavigationPanel.this.slider.getValue()));
                        ZNavigationPanel.this.validate();
                    }
                });
            }
        });
        ComponentUtil.setFixedWidth(this.slider, 22);
        this.topLabel = new JLabel("000");
        this.topLabel.setToolTipText("Z sequence size");
        this.bottomLabel = new JLabel("000");
        this.bottomLabel.setToolTipText("Z position");
        JLabel zLabel = GuiUtil.createBoldLabel("Z");
        this.setBorder(BorderFactory.createTitledBorder("").getBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)GuiUtil.createCenteredLabel(this.topLabel), "North");
        this.add((Component)this.slider, "Center");
        this.add((Component)GuiUtil.createPageBoxPanel(GuiUtil.createCenteredLabel(this.bottomLabel), Box.createVerticalStrut(8), GuiUtil.createCenteredLabel(zLabel)), "South");
        this.validate();
    }

    public void setPaintLabels(boolean b) {
        this.slider.setPaintLabels(b);
    }

    public void setPaintTicks(boolean b) {
        this.slider.setPaintTicks(b);
    }

    public void addChangeListener(ChangeListener l) {
        this.slider.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.slider.removeChangeListener(l);
    }

    public void removeAllChangeListener() {
        for (ChangeListener l : (ChangeListener[])this.slider.getListeners(ChangeListener.class)) {
            this.slider.removeChangeListener(l);
        }
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
    }

    public int getMinimum() {
        return this.slider.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.slider.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.slider.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.slider.setMaximum(maximum);
    }

    public boolean getPaintTicks() {
        return this.slider.getPaintTicks();
    }

    public boolean getPaintTrack() {
        return this.slider.getPaintTrack();
    }

    public void setPaintTrack(boolean b) {
        this.slider.setPaintTrack(b);
    }

    public boolean getPaintLabels() {
        return this.slider.getPaintLabels();
    }
}

