/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.common.CollapsibleEvent;
import icy.painter.Overlay;
import icy.util.StringUtil;

public class OverlayEvent
implements CollapsibleEvent {
    private final Overlay source;
    private final OverlayEventType type;
    private String propertyName;

    public OverlayEvent(Overlay source, OverlayEventType type, String propertyName) {
        this.source = source;
        this.type = type;
        this.propertyName = propertyName;
    }

    public OverlayEvent(Overlay source, OverlayEventType type) {
        this(source, type, null);
    }

    public Overlay getSource() {
        return this.source;
    }

    public OverlayEventType getType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        return this.equals(event);
    }

    @Override
    public int hashCode() {
        int res = this.source.hashCode() ^ this.type.hashCode();
        if (this.type == OverlayEventType.PROPERTY_CHANGED && this.propertyName != null) {
            res ^= this.propertyName.hashCode();
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OverlayEvent) {
            OverlayEvent e = (OverlayEvent)obj;
            return e.getSource() == this.source && e.getType() == this.type && (this.type != OverlayEventType.PROPERTY_CHANGED || StringUtil.equals(e.getPropertyName(), this.propertyName));
        }
        return super.equals(obj);
    }

    public static enum OverlayEventType {
        PAINTER_CHANGED,
        PROPERTY_CHANGED;

    }
}

