/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.roi.ROI;
import icy.roi.edit.AbstractROIsEdit;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.util.List;
import java.util.Set;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class PositionROIsEdit
extends AbstractROIsEdit {
    List<Point5D> previousPositions;
    List<Point5D> newPositions;

    public PositionROIsEdit(List<? extends ROI> rois, List<Point5D> previousPositions, List<Point5D> newPositions, boolean mergeable) {
        super(rois, rois.size() > 1 ? "ROIs position changed" : "ROI position changed");
        if (rois.size() != previousPositions.size()) {
            throw new IllegalArgumentException("ROI list and old values list size do not match (" + rois.size() + " != " + previousPositions.size() + ")");
        }
        if (rois.size() != newPositions.size()) {
            throw new IllegalArgumentException("ROI list and new values list size do not match (" + rois.size() + " != " + newPositions.size() + ")");
        }
        this.previousPositions = previousPositions;
        this.newPositions = newPositions;
        this.setMergeable(mergeable);
    }

    public PositionROIsEdit(List<? extends ROI> rois, List<Point5D> previousPositions, List<Point5D> newPositions) {
        this(rois, previousPositions, newPositions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Set<Sequence> sequences = this.getSequences();
        for (Sequence sequence : sequences) {
            sequence.beginUpdate();
        }
        try {
            int ind = 0;
            for (ROI rOI : this.getROIs()) {
                rOI.setPosition5D(this.previousPositions.get(ind++));
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Set<Sequence> sequences = this.getSequences();
        for (Sequence sequence : sequences) {
            sequence.beginUpdate();
        }
        try {
            int ind = 0;
            for (ROI rOI : this.getROIs()) {
                rOI.setPosition5D(this.newPositions.get(ind++));
            }
        }
        finally {
            for (Sequence sequence : sequences) {
                sequence.endUpdate();
            }
        }
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        PositionROIsEdit posEdit;
        if (!this.isMergeable()) {
            return false;
        }
        if (edit instanceof PositionROIsEdit && (posEdit = (PositionROIsEdit)edit).getROIs().equals(this.getROIs())) {
            this.newPositions = posEdit.newPositions;
            return true;
        }
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.previousPositions = null;
        this.newPositions = null;
    }
}

