/*
 * Decompiled with CFR 0.152.
 */
package icy.system.thread;

import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.InstanceProcessor;
import icy.system.thread.Processor;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class ThreadUtil {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final Processor bgProcessor;
    private static final InstanceProcessor[] instanceProcessors;
    private static final InstanceProcessor[] bgInstanceProcessors;

    public static void shutdown() {
        bgProcessor.shutdown();
        for (int i = 0; i < instanceProcessors.length; ++i) {
            instanceProcessors[i].shutdown();
            bgInstanceProcessors[i].shutdown();
        }
    }

    public static boolean isShutdownAndTerminated() {
        for (int i = 0; i < instanceProcessors.length; ++i) {
            if (!instanceProcessors[i].isTerminated()) {
                return false;
            }
            if (bgInstanceProcessors[i].isTerminated()) continue;
            return false;
        }
        return bgProcessor.isTerminated();
    }

    public static boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public static void invoke(Runnable runnable, boolean wait) {
        if (wait) {
            ThreadUtil.invokeNow(runnable);
        } else {
            ThreadUtil.invokeLater(runnable);
        }
    }

    @Deprecated
    public static void invokeAndWait(Runnable runnable) {
        ThreadUtil.invokeNow(runnable);
    }

    public static void invokeNow(Runnable runnable) {
        if (ThreadUtil.isEventDispatchThread()) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException(t, true);
            }
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException e) {
                IcyExceptionHandler.handleException(e.getTargetException(), true);
            }
            catch (InterruptedException e) {
                System.err.println("ThreadUtil.invokeNow(...) error :");
                IcyExceptionHandler.showErrorMessage(e, true);
            }
        }
    }

    public static void invokeLater(Runnable runnable) {
        ThreadUtil.invokeLater(runnable, false);
    }

    public static void invokeLater(Runnable runnable, boolean forceLater) {
        CaughtRunnable r = new CaughtRunnable(runnable);
        if (!forceLater && ThreadUtil.isEventDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public static <T> T invokeNow(Callable<T> callable) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            return callable.call();
        }
        FutureTask<T> task = new FutureTask<T>(callable);
        try {
            EventQueue.invokeAndWait(task);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw new Exception(e.getTargetException());
        }
        try {
            return task.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new Exception(e.getCause());
        }
    }

    public static <T> Future<T> invokeLater(Callable<T> callable, boolean forceLater) {
        FutureTask<T> task = new FutureTask<T>(callable);
        ThreadUtil.invokeLater(task, forceLater);
        return task;
    }

    private static InstanceProcessor getInstanceProcessor(Runnable runnable) {
        return instanceProcessors[runnable.hashCode() % instanceProcessors.length];
    }

    private static InstanceProcessor getInstanceProcessor(Callable<?> callable) {
        return instanceProcessors[callable.hashCode() % instanceProcessors.length];
    }

    private static InstanceProcessor getBgInstanceProcessor(Runnable runnable) {
        return bgInstanceProcessors[runnable.hashCode() % bgInstanceProcessors.length];
    }

    private static InstanceProcessor getBgInstanceProcessor(Callable<?> callable) {
        return bgInstanceProcessors[callable.hashCode() % bgInstanceProcessors.length];
    }

    @Deprecated
    public static boolean bgRun(Runnable runnable, boolean onEDT) {
        return bgProcessor.submit(runnable, onEDT) != null;
    }

    @Deprecated
    public static void bgRunWait(Runnable runnable) {
        while (!ThreadUtil.bgRun(runnable)) {
            ThreadUtil.sleep(1);
        }
    }

    public static boolean bgRun(Runnable runnable) {
        return bgProcessor.submit(true, runnable) != null;
    }

    @Deprecated
    public static <T> Future<T> bgRun(Callable<T> callable, boolean onEDT) {
        return bgProcessor.submit(callable, onEDT);
    }

    public static <T> Future<T> bgRun(Callable<T> callable) {
        return bgProcessor.submit(callable);
    }

    @Deprecated
    public static boolean bgRunSingle(Runnable runnable, boolean onEDT) {
        InstanceProcessor processor = ThreadUtil.getInstanceProcessor(runnable);
        return processor.submit(runnable, onEDT) != null;
    }

    @Deprecated
    public static <T> Future<T> bgRunSingle(Callable<T> callable, boolean onEDT) {
        InstanceProcessor processor = ThreadUtil.getInstanceProcessor(callable);
        return processor.submit(callable, onEDT);
    }

    public static boolean bgRunSingle(Runnable runnable) {
        InstanceProcessor processor = ThreadUtil.getBgInstanceProcessor(runnable);
        return processor.submit(true, runnable) != null;
    }

    public static <T> Future<T> bgRunSingle(Callable<T> callable) {
        InstanceProcessor processor = ThreadUtil.getBgInstanceProcessor(callable);
        return ((Processor)processor).submit(callable);
    }

    public static boolean runSingle(Runnable runnable) {
        InstanceProcessor processor = ThreadUtil.getInstanceProcessor(runnable);
        return processor.submit(true, runnable) != null;
    }

    public static <T> Future<T> runSingle(Callable<T> callable) {
        InstanceProcessor processor = ThreadUtil.getInstanceProcessor(callable);
        return ((Processor)processor).submit(callable);
    }

    public static boolean hasWaitingBgTask(Runnable runnable) {
        return bgProcessor.getWaitingTasksCount(runnable) > 0;
    }

    public static boolean hasWaitingBgTask(Callable<?> callable) {
        return bgProcessor.getWaitingTasksCount(callable) > 0;
    }

    public static boolean hasWaitingBgSingleTask(Runnable runnable) {
        InstanceProcessor processor = ThreadUtil.getBgInstanceProcessor(runnable);
        return processor.hasWaitingTasks(runnable);
    }

    public static boolean hasWaitingBgSingleTask(Callable<?> callable) {
        InstanceProcessor processor = ThreadUtil.getBgInstanceProcessor(callable);
        return processor.hasWaitingTasks(callable);
    }

    public static boolean hasWaitingSingleTask(Runnable runnable) {
        InstanceProcessor processor = ThreadUtil.getInstanceProcessor(runnable);
        return processor.hasWaitingTasks(runnable);
    }

    public static boolean hasWaitingSingleTask(Callable<?> callable) {
        InstanceProcessor processor = ThreadUtil.getInstanceProcessor(callable);
        return processor.hasWaitingTasks(callable);
    }

    public static int getActiveBgTaskCount() {
        return bgProcessor.getActiveCount();
    }

    public static ExecutorService createThreadPool(String name) {
        Processor result = new Processor(SystemUtil.getNumberOfCPUs());
        result.setThreadName(name);
        return result;
    }

    public static void sleep(long milli) {
        try {
            Thread.sleep(milli);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(int milli) {
        try {
            Thread.sleep(milli);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        int wantedThread;
        if (SystemUtil.is32bits()) {
            wantedThread = SystemUtil.getNumberOfCPUs();
            wantedThread = Math.max(wantedThread, 2);
            bgProcessor = new Processor(Math.min(wantedThread, 8));
            instanceProcessors = new InstanceProcessor[Math.min(wantedThread, 4)];
            bgInstanceProcessors = new InstanceProcessor[Math.min(wantedThread, 4)];
        } else {
            wantedThread = SystemUtil.getNumberOfCPUs();
            wantedThread = Math.max(wantedThread, 4);
            bgProcessor = new Processor(Math.min(wantedThread, 16));
            instanceProcessors = new InstanceProcessor[Math.min(wantedThread, 8)];
            bgInstanceProcessors = new InstanceProcessor[Math.min(wantedThread, 8)];
        }
        bgProcessor.setPriority(1);
        bgProcessor.setThreadName("Background processor");
        bgProcessor.setKeepAliveTime(3L, TimeUnit.SECONDS);
        for (int i = 0; i < instanceProcessors.length; ++i) {
            ThreadUtil.instanceProcessors[i] = new InstanceProcessor(5);
            instanceProcessors[i].setThreadName("Background instance processor");
            instanceProcessors[i].setKeepAliveTime(3L, TimeUnit.SECONDS);
            ThreadUtil.bgInstanceProcessors[i] = new InstanceProcessor(1);
            bgInstanceProcessors[i].setThreadName("Background instance processor (low priority)");
            bgInstanceProcessors[i].setKeepAliveTime(3L, TimeUnit.SECONDS);
        }
    }

    public static class CaughtRunnable
    implements Runnable {
        private final Runnable runnable;

        public CaughtRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException(t, true);
            }
        }
    }
}

