/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.CurveLinkX;

final class ChainEndX {
    CurveLinkX head;
    CurveLinkX tail;
    ChainEndX partner;
    int etag;

    public ChainEndX(CurveLinkX first, ChainEndX partner) {
        this.head = first;
        this.tail = first;
        this.partner = partner;
        this.etag = first.getEdgeTag();
    }

    public CurveLinkX getChain() {
        return this.head;
    }

    public void setOtherEnd(ChainEndX partner) {
        this.partner = partner;
    }

    public ChainEndX getPartner() {
        return this.partner;
    }

    public CurveLinkX linkTo(ChainEndX that) {
        ChainEndX otherexit;
        ChainEndX exit;
        ChainEndX enter;
        if (this.etag == 0 || that.etag == 0) {
            throw new InternalError("ChainEnd linked more than once!");
        }
        if (this.etag == that.etag) {
            throw new InternalError("Linking chains of the same type!");
        }
        if (this.etag == 1) {
            enter = this;
            exit = that;
        } else {
            enter = that;
            exit = this;
        }
        this.etag = 0;
        that.etag = 0;
        enter.tail.setNext(exit.head);
        enter.tail = exit.tail;
        if (this.partner == that) {
            return enter.head;
        }
        ChainEndX otherenter = exit.partner;
        otherenter.partner = otherexit = enter.partner;
        otherexit.partner = otherenter;
        if (enter.head.getYTop() < otherenter.head.getYTop()) {
            enter.tail.setNext(otherenter.head);
            otherenter.head = enter.head;
        } else {
            otherexit.tail.setNext(enter.head);
            otherexit.tail = enter.tail;
        }
        return null;
    }

    public void addLink(CurveLinkX newlink) {
        if (this.etag == 1) {
            this.tail.setNext(newlink);
            this.tail = newlink;
        } else {
            newlink.setNext(this.head);
            this.head = newlink;
        }
    }

    public double getX() {
        if (this.etag == 1) {
            return this.tail.getXBot();
        }
        return this.head.getXBot();
    }
}

